/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.Streams;
import com.google.common.eventbus.Subscribe;
import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import com.google.common.html.HtmlEscapers;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.checklist.TransposedChecklistSynthesizer;
import com.scythebill.birdlist.model.io.HtmlResponseWriter;
import com.scythebill.birdlist.model.io.PartialIO;
import com.scythebill.birdlist.model.query.SightingComparators;
import com.scythebill.birdlist.model.query.SightingPredicates;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.Locations;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.SightingTaxons;
import com.scythebill.birdlist.model.sighting.Trip;
import com.scythebill.birdlist.model.sighting.VisitInfo;
import com.scythebill.birdlist.model.sighting.VisitInfoKey;
import com.scythebill.birdlist.model.sighting.edits.RecentEdits;
import com.scythebill.birdlist.model.taxa.MappedTaxonomy;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.taxa.names.LocalNames;
import com.scythebill.birdlist.model.taxa.names.NamesPreferences;
import com.scythebill.birdlist.model.user.User;
import com.scythebill.birdlist.model.util.ResolvedComparator;
import com.scythebill.birdlist.ui.actions.ReturnAction;
import com.scythebill.birdlist.ui.app.NavigableFrame;
import com.scythebill.birdlist.ui.app.Titled;
import com.scythebill.birdlist.ui.components.OkCancelPanel;
import com.scythebill.birdlist.ui.events.DefaultUserStore;
import com.scythebill.birdlist.ui.events.EventBusRegistrar;
import com.scythebill.birdlist.ui.events.TaxonomyChangedEvent;
import com.scythebill.birdlist.ui.events.TaxonomyStore;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.guice.Clements;
import com.scythebill.birdlist.ui.guice.InitialRun;
import com.scythebill.birdlist.ui.imports.AutoGeocodeLocations;
import com.scythebill.birdlist.ui.imports.AvisysImporter;
import com.scythebill.birdlist.ui.imports.BirdBrainImporter;
import com.scythebill.birdlist.ui.imports.BirdLasserImporter;
import com.scythebill.birdlist.ui.imports.BirdTrackImporter;
import com.scythebill.birdlist.ui.imports.BirdaImporter;
import com.scythebill.birdlist.ui.imports.BirdbaseImporter;
import com.scythebill.birdlist.ui.imports.BirdersDiary;
import com.scythebill.birdlist.ui.imports.CsvSightingsImporter;
import com.scythebill.birdlist.ui.imports.EBird;
import com.scythebill.birdlist.ui.imports.FinishedImport;
import com.scythebill.birdlist.ui.imports.HbwImporter;
import com.scythebill.birdlist.ui.imports.INaturalistImporter;
import com.scythebill.birdlist.ui.imports.ImportChooseUsersPanel;
import com.scythebill.birdlist.ui.imports.ImportException;
import com.scythebill.birdlist.ui.imports.ImportFlickrPanel;
import com.scythebill.birdlist.ui.imports.ImportPreferences;
import com.scythebill.birdlist.ui.imports.ImportResolveLocationsPanel;
import com.scythebill.birdlist.ui.imports.ImportResolveTaxaPanel;
import com.scythebill.birdlist.ui.imports.Observado;
import com.scythebill.birdlist.ui.imports.OrnithoImporter;
import com.scythebill.birdlist.ui.imports.ParsedLocationIds;
import com.scythebill.birdlist.ui.imports.ScythebillImporter;
import com.scythebill.birdlist.ui.imports.SightingsImporter;
import com.scythebill.birdlist.ui.imports.TaxonImporter;
import com.scythebill.birdlist.ui.imports.WildlifeRecorderImporter;
import com.scythebill.birdlist.ui.imports.WildlifeRecorderMdbImporter;
import com.scythebill.birdlist.ui.imports.WingsImporter;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.FilePreferences;
import com.scythebill.birdlist.ui.panels.ShrinkToFit;
import com.scythebill.birdlist.ui.panels.reports.QueryPreferences;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.FileDialogs;
import com.scythebill.birdlist.ui.util.ScanSeenTaxa;
import com.scythebill.birdlist.ui.util.UIUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.joda.time.DateTimeFieldType;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.GJChronology;

public class ImportMenuPanel
extends JPanel
implements FontManager.FontsUpdatedListener,
ShrinkToFit,
Titled {
    private static final Logger logger = Logger.getLogger(ImportMenuPanel.class.getName());
    private JButton returnButton;
    private JButton importAvisys;
    private JButton importBirdbase;
    private JButton importBirdersDiary;
    private JButton importBirdBrain;
    private JButton importBirdTrack;
    private JButton importBirdLasser;
    private JButton importBirda;
    private JButton importEbird;
    private JButton importFlickr;
    private JButton importHbwAlive;
    private JButton importINaturalist;
    private JButton importScythebill;
    private JButton importObservationOrg;
    private JButton importOrnitho;
    private JButton importWildlifeRecorder;
    private JButton importWings;
    private final FontManager fontManager;
    private final ReportSet reportSet;
    private final FileDialogs fileDialogs;
    private final Taxonomy clements;
    private final Provider<ImportResolveTaxaPanel> resolveTaxaPanelProvider;
    private final Provider<ImportResolveLocationsPanel> resolveLocationsPanelProvider;
    private final Provider<ImportChooseUsersPanel> chooseUsersPanelProvider;
    private final Provider<AutoGeocodeLocations> autoGeocodeLocationsProvider;
    private final Provider<ImportFlickrPanel> importFlickrPanelProvider;
    private final NavigableFrame navigableFrame;
    private final Action importCompleteAction;
    private final ReturnAction returnAction;
    private final TaxonomyStore taxonomyStore;
    private final Alerts alerts;
    private final Checklists checklists;
    private final TransposedChecklistSynthesizer transposedChecklistsSynthesizer;
    private final boolean initialRun;
    private final PredefinedLocations predefinedLocations;
    private RecentEdits recentEdits;
    private JPanel centerBox;
    private JLabel importLabel;
    private JLabel avisysLabel;
    private JLabel ebirdLabel;
    private JLabel flickrLabel;
    private JLabel hbwAliveLabel;
    private JLabel iNaturalistLabel;
    private JLabel scythebillLabel;
    private JLabel observationOrgLabel;
    private JLabel emptyLabel;
    private JLabel birdbaseLabel;
    private JLabel birdBrainLabel;
    private JLabel birdTrackLabel;
    private JLabel birdersDiaryLabel;
    private JLabel birdLasserLabel;
    private JLabel birdaLabel;
    private JLabel ornithoLabel;
    private JLabel wildlifeRecorderLabel;
    private JLabel wingsLabel;
    private final DefaultUserStore defaultUserStore;
    private final ImportPreferences importPreferences;
    private JLabel importMenuLabel;
    private JComboBox<Object> importMenuComboBox;
    private final QueryPreferences queryPreferences;
    private final ListeningScheduledExecutorService executorService;
    private final NamesPreferences namesPreferences;
    private Set<String> locationsBeforeImport;
    private Set<String> tripsBeforeImport;
    private Boolean hadUserSet;
    private final EBird ebird;
    private static final double FALSE_POSITIVES = 1.0E-4;

    @Inject
    public ImportMenuPanel(@FinishedImport Action importCompleteAction, ReturnAction returnAction, NavigableFrame navigableFrame, FontManager fontManager, ReportSet reportSet, @InitialRun boolean initialRun, FileDialogs fileDialogs, TaxonomyStore taxonomyStore, @Clements Taxonomy clements, Provider<ImportResolveTaxaPanel> resolveTaxaPanelProvider, Provider<ImportResolveLocationsPanel> resolveLocationsPanelProvider, Provider<ImportChooseUsersPanel> chooseUsersPanelProvider, Provider<AutoGeocodeLocations> autoGeocodeLocationsProvider, Provider<ImportFlickrPanel> importFlickrPanelProvider, DefaultUserStore defaultUserStore, EBird ebird, ImportPreferences importPreferences, Checklists checklists, TransposedChecklistSynthesizer transposedChecklistsSynthesizer, PredefinedLocations predefinedLocations, EventBusRegistrar eventBusRegistrar, QueryPreferences queryPreferences, NamesPreferences namesPreferences, ListeningScheduledExecutorService executorService, Alerts alerts) {
        this.returnAction = returnAction;
        this.fontManager = fontManager;
        this.reportSet = reportSet;
        this.initialRun = initialRun;
        this.fileDialogs = fileDialogs;
        this.taxonomyStore = taxonomyStore;
        this.clements = clements;
        this.navigableFrame = navigableFrame;
        this.importCompleteAction = importCompleteAction;
        this.resolveTaxaPanelProvider = resolveTaxaPanelProvider;
        this.resolveLocationsPanelProvider = resolveLocationsPanelProvider;
        this.chooseUsersPanelProvider = chooseUsersPanelProvider;
        this.autoGeocodeLocationsProvider = autoGeocodeLocationsProvider;
        this.importFlickrPanelProvider = importFlickrPanelProvider;
        this.defaultUserStore = defaultUserStore;
        this.ebird = ebird;
        this.importPreferences = importPreferences;
        this.checklists = checklists;
        this.transposedChecklistsSynthesizer = transposedChecklistsSynthesizer;
        this.predefinedLocations = predefinedLocations;
        this.queryPreferences = queryPreferences;
        this.namesPreferences = namesPreferences;
        this.executorService = executorService;
        this.alerts = alerts;
        this.initGUI();
        this.returnButton.setAction(returnAction);
        this.importAvisys.addActionListener(e -> this.doImportAvisys());
        this.importBirdbase.addActionListener(e -> this.doImportBirdbase());
        this.importBirdBrain.addActionListener(e -> this.doImportBirdBrain());
        this.importBirdTrack.addActionListener(e -> this.doImportBirdTrack());
        this.importBirdersDiary.addActionListener(e -> this.doImportBirdersDiary());
        this.importBirdLasser.addActionListener(e -> this.doImportBirdLasser());
        this.importBirda.addActionListener(e -> this.doImportBirda());
        this.importEbird.addActionListener(e -> this.doImportEBird());
        this.importFlickr.addActionListener(e -> this.doImportFlickr());
        this.importHbwAlive.addActionListener(e -> this.doImportHbwAlive());
        this.importINaturalist.addActionListener(e -> this.doImportINaturalist());
        this.importScythebill.addActionListener(e -> this.doImportScythebill());
        this.importObservationOrg.addActionListener(e -> this.doImportObservationOrg());
        this.importOrnitho.addActionListener(e -> this.doImportOrnitho());
        this.importWildlifeRecorder.addActionListener(e -> this.doImportWildlifeRecorder());
        this.importWings.addActionListener(e -> this.doImportWings());
        this.importMenuComboBox.addActionListener(e -> {
            Object o = this.importMenuComboBox.getSelectedItem();
            if (o instanceof ImportPreferences.ImportType) {
                this.doImport((ImportPreferences.ImportType)((Object)((Object)o)));
                this.importMenuComboBox.setSelectedIndex(0);
            }
        });
        this.updateUiForTaxonomy();
        eventBusRegistrar.registerWhenInHierarchy(this);
    }

    @Inject(optional=true)
    void setRecentEdits(RecentEdits recentEdits) {
        this.recentEdits = recentEdits;
    }

    private void initGUI() {
        this.setLayout(new BoxLayout(this, 3));
        this.centerBox = new JPanel();
        this.add(this.centerBox);
        this.importLabel = new JLabel();
        this.importLabel.putClientProperty("birdlist.plainLabel", true);
        this.importMenuComboBox = new JComboBox();
        this.importAvisys = new JButton();
        this.importAvisys.setText(Messages.getFormattedMessage(Messages.Name.IMPORT_FROM_FORMAT, "Avisys"));
        this.importAvisys.putClientProperty("Quaqua.Button.style", "bevel");
        this.importBirdbase = new JButton();
        this.importBirdbase.setText(Messages.getFormattedMessage(Messages.Name.IMPORT_FROM_FORMAT, "Birdbase"));
        this.importBirdbase.putClientProperty("Quaqua.Button.style", "bevel");
        this.importBirdBrain = new JButton();
        this.importBirdBrain.setText(Messages.getFormattedMessage(Messages.Name.IMPORT_FROM_FORMAT, "Bird Brain"));
        this.importBirdBrain.putClientProperty("Quaqua.Button.style", "bevel");
        this.importBirdTrack = new JButton();
        this.importBirdTrack.setText(Messages.getFormattedMessage(Messages.Name.IMPORT_FROM_FORMAT, "BirdTrack"));
        this.importBirdTrack.putClientProperty("Quaqua.Button.style", "bevel");
        this.importBirdersDiary = new JButton();
        this.importBirdersDiary.setText(Messages.getFormattedMessage(Messages.Name.IMPORT_FROM_FORMAT, "Birder's Diary"));
        this.importBirdersDiary.putClientProperty("Quaqua.Button.style", "bevel");
        this.importBirdLasser = new JButton();
        this.importBirdLasser.setText(Messages.getFormattedMessage(Messages.Name.IMPORT_FROM_FORMAT, "BirdLasser"));
        this.importBirdLasser.putClientProperty("Quaqua.Button.style", "bevel");
        this.importBirda = new JButton();
        this.importBirda.setText(Messages.getFormattedMessage(Messages.Name.IMPORT_FROM_FORMAT, "Birda"));
        this.importBirda.putClientProperty("Quaqua.Button.style", "bevel");
        this.importEbird = new JButton();
        this.importEbird.setText(Messages.getFormattedMessage(Messages.Name.IMPORT_FROM_FORMAT, "eBird"));
        this.importEbird.putClientProperty("Quaqua.Button.style", "bevel");
        this.importFlickr = new JButton();
        this.importFlickr.setText(Messages.getFormattedMessage(Messages.Name.IMPORT_FROM_FORMAT, "Flickr"));
        this.importFlickr.putClientProperty("Quaqua.Button.style", "bevel");
        this.importHbwAlive = new JButton();
        this.importHbwAlive.setText(Messages.getFormattedMessage(Messages.Name.IMPORT_FROM_FORMAT, "HBW Alive"));
        this.importHbwAlive.putClientProperty("Quaqua.Button.style", "bevel");
        this.importINaturalist = new JButton();
        this.importINaturalist.setText(Messages.getFormattedMessage(Messages.Name.IMPORT_FROM_FORMAT, "iNaturalist"));
        this.importINaturalist.putClientProperty("Quaqua.Button.style", "bevel");
        this.importScythebill = new JButton();
        this.importScythebill.setText(Messages.getFormattedMessage(Messages.Name.IMPORT_FROM_FORMAT, "Scythebill"));
        this.importScythebill.putClientProperty("Quaqua.Button.style", "bevel");
        this.importObservationOrg = new JButton();
        this.importObservationOrg.setText(Messages.getFormattedMessage(Messages.Name.IMPORT_FROM_FORMAT, "Observation.org"));
        this.importObservationOrg.putClientProperty("Quaqua.Button.style", "bevel");
        this.importOrnitho = new JButton();
        this.importOrnitho.setText(Messages.getFormattedMessage(Messages.Name.IMPORT_FROM_FORMAT, "Ornitho"));
        this.importOrnitho.putClientProperty("Quaqua.Button.style", "bevel");
        this.importWildlifeRecorder = new JButton();
        this.importWildlifeRecorder.setText(Messages.getFormattedMessage(Messages.Name.IMPORT_FROM_FORMAT, "Wildlife Recorder"));
        this.importWildlifeRecorder.putClientProperty("Quaqua.Button.style", "bevel");
        this.importWings = new JButton();
        this.importWings.setText(Messages.getFormattedMessage(Messages.Name.IMPORT_FROM_FORMAT, "Wings"));
        this.importWings.putClientProperty("Quaqua.Button.style", "bevel");
        this.returnButton = new JButton();
        this.returnButton.putClientProperty("Quaqua.Button.style", "bevel");
        this.avisysLabel = new JLabel(Messages.getFormattedMessage(Messages.Name.CSV_EXPORT_FROM_FORMAT, "Sighting Record Listing"));
        this.avisysLabel.putClientProperty("birdlist.plainLabel", true);
        this.birdbaseLabel = new JLabel(Messages.getFormattedMessage(Messages.Name.CSV_EXPORT_FROM_FORMAT, "Birdbase"));
        this.birdbaseLabel.putClientProperty("birdlist.plainLabel", true);
        this.birdTrackLabel = new JLabel(Messages.getFormattedMessage(Messages.Name.XLSX_EXPORT_FROM_FORMAT, "BirdTrack"));
        this.birdTrackLabel.putClientProperty("birdlist.plainLabel", true);
        this.birdBrainLabel = new JLabel(Messages.getFormattedMessage(Messages.Name.CSV_EXPORT_FROM_FORMAT, "Bird Brain"));
        this.birdBrainLabel.putClientProperty("birdlist.plainLabel", true);
        this.birdersDiaryLabel = new JLabel(Messages.getFormattedMessage(Messages.Name.CSV_EXPORT_FROM_FORMAT, "Birder's Diary"));
        this.birdersDiaryLabel.putClientProperty("birdlist.plainLabel", true);
        this.birdLasserLabel = new JLabel(Messages.getFormattedMessage(Messages.Name.CSV_EXPORT_FROM_FORMAT, "BirdLasser"));
        this.birdLasserLabel.putClientProperty("birdlist.plainLabel", true);
        this.birdaLabel = new JLabel(Messages.getFormattedMessage(Messages.Name.CSV_EXPORT_FROM_FORMAT, "Birda"));
        this.birdaLabel.putClientProperty("birdlist.plainLabel", true);
        this.ebirdLabel = new JLabel(Messages.getFormattedMessage(Messages.Name.CSV_OR_ZIP_EXPORT_FROM_FORMAT, "eBird"));
        this.ebirdLabel.putClientProperty("birdlist.plainLabel", true);
        this.flickrLabel = new JLabel(Messages.getFormattedMessage(Messages.Name.FLICKR_ALBUM, "Flickr"));
        this.flickrLabel.putClientProperty("birdlist.plainLabel", true);
        this.hbwAliveLabel = new JLabel(Messages.getFormattedMessage(Messages.Name.XLS_EXPORT_FROM_FORMAT, "HBW Alive"));
        this.hbwAliveLabel.putClientProperty("birdlist.plainLabel", true);
        this.iNaturalistLabel = new JLabel(Messages.getFormattedMessage(Messages.Name.CSV_EXPORT_FROM_FORMAT, "iNaturalist"));
        this.iNaturalistLabel.putClientProperty("birdlist.plainLabel", true);
        this.scythebillLabel = new JLabel(Messages.getFormattedMessage(Messages.Name.CSV_EXPORT_FROM_FORMAT, "Scythebill"));
        this.scythebillLabel.putClientProperty("birdlist.plainLabel", true);
        this.observationOrgLabel = new JLabel(Messages.getFormattedMessage(Messages.Name.CSV_EXPORT_FROM_FORMAT, "Observation.org/Waarnemingen"));
        this.observationOrgLabel.putClientProperty("birdlist.plainLabel", true);
        this.ornithoLabel = new JLabel(Messages.getFormattedMessage(Messages.Name.TXT_EXPORT_FROM_FORMAT, "Ornitho"));
        this.ornithoLabel.putClientProperty("birdlist.plainLabel", true);
        this.wildlifeRecorderLabel = new JLabel(Messages.getFormattedMessage(Messages.Name.MDB_OR_CSV_EXPORT_FROM_FORMAT, "Wildlife Recorder"));
        this.wildlifeRecorderLabel.putClientProperty("birdlist.plainLabel", true);
        this.wingsLabel = new JLabel(Messages.getFormattedMessage(Messages.Name.XML_EXPORTS_FROM_FORMAT, "Wings"));
        this.wingsLabel.putClientProperty("birdlist.plainLabel", true);
        this.importMenuLabel = new JLabel(Messages.getMessage(Messages.Name.OTHER_KINDS_OF_EXPORTS));
        this.importMenuLabel.putClientProperty("birdlist.plainLabel", true);
        this.emptyLabel = new JLabel();
        this.fontManager.applyTo(this);
    }

    private void doImport(ImportPreferences.ImportType importType) {
        switch (importType) {
            case AVISYS: {
                this.doImportAvisys();
                break;
            }
            case BIRDBASE: {
                this.doImportBirdbase();
                break;
            }
            case BIRD_BRAIN: {
                this.doImportBirdBrain();
                break;
            }
            case BIRD_TRACK: {
                this.doImportBirdTrack();
                break;
            }
            case BIRDERS_DIARY: {
                this.doImportBirdersDiary();
                break;
            }
            case BIRDLASSER: {
                this.doImportBirdLasser();
                break;
            }
            case BIRDA: {
                this.doImportBirda();
                break;
            }
            case EBIRD: {
                this.doImportEBird();
                break;
            }
            case FLICKR: {
                this.doImportFlickr();
                break;
            }
            case HBW_ALIVE: {
                this.doImportHbwAlive();
                break;
            }
            case INATURALIST: {
                this.doImportINaturalist();
                break;
            }
            case OBSERVADO: {
                this.doImportObservationOrg();
                break;
            }
            case ORNITHO: {
                this.doImportOrnitho();
                break;
            }
            case SCYTHEBILL: {
                this.doImportScythebill();
                break;
            }
            case WILDLIFE_RECORDER: {
                this.doImportWildlifeRecorder();
                break;
            }
            case WINGS: {
                this.doImportWings();
                break;
            }
            default: {
                throw new IllegalStateException("Unimplemented import type " + importType);
            }
        }
    }

    private void doImportAvisys() {
        FileNameExtensionFilter fileFilter = new FileNameExtensionFilter(Messages.getMessage(Messages.Name.AVISYS_EXPORT_TYPES), "csv", "txt");
        File openFile = this.fileDialogs.openFile(UIUtils.findFrame(this), Messages.getFormattedMessage(Messages.Name.OPEN_EXPORT_FORMAT, "Avisys"), fileFilter, FilePreferences.FileType.OTHER);
        if (openFile != null) {
            AvisysImporter importer = new AvisysImporter(this.reportSet, this.taxonomyStore.isBirdTaxonomy() ? this.taxonomyStore.getClements() : this.taxonomyStore.getTaxonomy(), this.checklists, this.transposedChecklistsSynthesizer, this.predefinedLocations, openFile);
            int showYesNo = this.alerts.showYesNo((Object)this, Messages.Name.FIELD_NOTES_FILE_TITLE, Messages.Name.FIELD_NOTES_FILE_MESSAGE, new Object[0]);
            if (showYesNo == 0) {
                FileNameExtensionFilter fieldNotesFilter = new FileNameExtensionFilter(Messages.getMessage(Messages.Name.FIELD_NOTES_FILE_TYPE), "txt");
                File fieldNotesFile = this.fileDialogs.openFile(UIUtils.findFrame(this), Messages.getMessage(Messages.Name.OPEN_FIELD_NOTES_FILE), fieldNotesFilter, FilePreferences.FileType.OTHER);
                if (fieldNotesFile == null) {
                    return;
                }
                importer.attachFieldNotes(fieldNotesFile);
            }
            this.doImport(importer, this.importCompleteAction, ImportPreferences.ImportType.AVISYS);
        }
    }

    private void doImportBirdbase() {
        File openFile = this.fileDialogs.openFile(UIUtils.findFrame(this), Messages.getFormattedMessage(Messages.Name.OPEN_EXPORT_FORMAT, "Birdbase"), null, FilePreferences.FileType.OTHER);
        if (openFile != null) {
            BirdbaseImporter importer = new BirdbaseImporter(this.reportSet, this.taxonomyStore.isBirdTaxonomy() ? this.taxonomyStore.getClements() : this.taxonomyStore.getTaxonomy(), this.checklists, this.predefinedLocations, this.transposedChecklistsSynthesizer, openFile);
            this.doImport(importer, this.importCompleteAction, ImportPreferences.ImportType.BIRDBASE);
        }
    }

    private void doImportBirdBrain() {
        FileNameExtensionFilter fileFilter = new FileNameExtensionFilter(Messages.getFormattedMessage(Messages.Name.CSV_EXPORT_TYPE, "Bird Brain"), "csv");
        File openFile = this.fileDialogs.openFile(UIUtils.findFrame(this), Messages.getFormattedMessage(Messages.Name.OPEN_EXPORT_FORMAT, "Bird Brain"), fileFilter, FilePreferences.FileType.OTHER);
        if (openFile != null) {
            BirdBrainImporter importer = new BirdBrainImporter(this.reportSet, this.taxonomyStore.getClements(), this.checklists, this.predefinedLocations, openFile);
            this.doImport(importer, this.importCompleteAction, ImportPreferences.ImportType.BIRD_BRAIN);
        }
    }

    private void doImportBirdTrack() {
        FileNameExtensionFilter fileFilter = new FileNameExtensionFilter(Messages.getFormattedMessage(Messages.Name.XLSX_EXPORT_TYPE, "BirdTrack"), "xlsx");
        File openFile = this.fileDialogs.openFile(UIUtils.findFrame(this), Messages.getFormattedMessage(Messages.Name.OPEN_EXPORT_FORMAT, "BirdTrack"), fileFilter, FilePreferences.FileType.OTHER);
        if (openFile != null) {
            BirdTrackImporter importer = new BirdTrackImporter(this.reportSet, this.taxonomyStore.getIoc(), this.checklists, this.predefinedLocations, openFile);
            this.doImport(importer, this.importCompleteAction, ImportPreferences.ImportType.BIRD_TRACK);
        }
    }

    private void doImportBirdersDiary() {
        FileNameExtensionFilter fileFilter = new FileNameExtensionFilter(Messages.getFormattedMessage(Messages.Name.CSV_EXPORT_TYPE, "Birder's Diary"), "csv");
        File openFile = this.fileDialogs.openFile(UIUtils.findFrame(this), Messages.getFormattedMessage(Messages.Name.OPEN_EXPORT_FORMAT, "Birder's Diary"), fileFilter, FilePreferences.FileType.OTHER);
        if (openFile != null) {
            this.doImport(BirdersDiary.chooseImporter(openFile, this.reportSet, this.taxonomyStore.getTaxonomy(), this.checklists, this.predefinedLocations), this.importCompleteAction, ImportPreferences.ImportType.BIRDERS_DIARY);
        }
    }

    private void doImportBirdLasser() {
        FileNameExtensionFilter fileFilter = new FileNameExtensionFilter(Messages.getFormattedMessage(Messages.Name.CSV_EXPORT_TYPE, "BirdLasser"), "csv");
        File openFile = this.fileDialogs.openFile(UIUtils.findFrame(this), Messages.getFormattedMessage(Messages.Name.OPEN_EXPORT_FORMAT, "BirdLasser"), fileFilter, FilePreferences.FileType.OTHER);
        if (openFile != null) {
            BirdLasserImporter importer = new BirdLasserImporter(this.reportSet, this.taxonomyStore.getIoc(), this.checklists, this.predefinedLocations, openFile);
            this.doImport(importer, this.importCompleteAction, ImportPreferences.ImportType.BIRDLASSER);
        }
    }

    private void doImportBirda() {
        FileNameExtensionFilter fileFilter = new FileNameExtensionFilter(Messages.getFormattedMessage(Messages.Name.CSV_EXPORT_TYPE, "Birda"), "csv");
        File openFile = this.fileDialogs.openFile(UIUtils.findFrame(this), Messages.getFormattedMessage(Messages.Name.OPEN_EXPORT_FORMAT, "Birda"), fileFilter, FilePreferences.FileType.OTHER);
        if (openFile != null) {
            BirdaImporter importer = new BirdaImporter(this.reportSet, this.taxonomyStore.isBirdTaxonomy() ? this.taxonomyStore.getTaxonomy() : this.taxonomyStore.getClements(), this.checklists, this.predefinedLocations, openFile);
            this.doImport(importer, this.importCompleteAction, ImportPreferences.ImportType.BIRDA);
        }
    }

    public void importEBirdFile(File file, Action finishedAction) {
        CsvSightingsImporter importer = this.ebird.chooseImporter(file, this.reportSet, this.clements, this.checklists, this.predefinedLocations);
        this.doImport(importer, finishedAction, ImportPreferences.ImportType.EBIRD);
    }

    private void doImportEBird() {
        FileNameExtensionFilter fileFilter = new FileNameExtensionFilter(Messages.getFormattedMessage(Messages.Name.CSV_OR_ZIP_EXPORT_TYPE, "eBird"), "csv", "zip");
        File openFile = this.fileDialogs.openFile(UIUtils.findFrame(this), Messages.getFormattedMessage(Messages.Name.OPEN_EXPORT_FORMAT, "eBird"), fileFilter, FilePreferences.FileType.OTHER);
        if (openFile != null) {
            CsvSightingsImporter importer = this.ebird.chooseImporter(openFile, this.reportSet, this.taxonomyStore.isBirdTaxonomy() ? this.taxonomyStore.getClements() : this.taxonomyStore.getTaxonomy(), this.checklists, this.predefinedLocations);
            this.doImport(importer, this.importCompleteAction, ImportPreferences.ImportType.EBIRD);
        }
    }

    private void doImportFlickr() {
        ImportFlickrPanel importFlickrPanel = this.importFlickrPanelProvider.get();
        if (this.navigableFrame.navigateTo(importFlickrPanel)) {
            importFlickrPanel.start(importer -> this.doImport(importer, this.importCompleteAction, ImportPreferences.ImportType.FLICKR));
        }
    }

    private void doImportHbwAlive() {
        FileNameExtensionFilter fileFilter = new FileNameExtensionFilter(Messages.getFormattedMessage(Messages.Name.XLS_EXPORT_TYPE, "HBW Alive"), "xls", "xlsx");
        File openFile = this.fileDialogs.openFile(UIUtils.findFrame(this), Messages.getFormattedMessage(Messages.Name.OPEN_EXPORT_FORMAT, "HBW Alive"), fileFilter, FilePreferences.FileType.OTHER);
        if (openFile != null) {
            HbwImporter importer = new HbwImporter(this.reportSet, this.taxonomyStore.getClements(), this.checklists, this.predefinedLocations, openFile);
            this.doImport(importer, this.importCompleteAction, ImportPreferences.ImportType.HBW_ALIVE);
        }
    }

    private void doImportINaturalist() {
        FileNameExtensionFilter fileFilter = new FileNameExtensionFilter(Messages.getFormattedMessage(Messages.Name.CSV_EXPORT_TYPE, "iNaturalist"), "csv");
        File openFile = this.fileDialogs.openFile(UIUtils.findFrame(this), Messages.getFormattedMessage(Messages.Name.OPEN_EXPORT_FORMAT, "iNaturalist"), fileFilter, FilePreferences.FileType.OTHER);
        if (openFile != null) {
            INaturalistImporter importer;
            Set<String> classes;
            Taxonomy taxonomy = this.taxonomyStore.getTaxonomy();
            if (taxonomy.isBuiltIn()) {
                taxonomy = this.taxonomyStore.getClements();
            }
            if ((classes = (importer = new INaturalistImporter(this.reportSet, taxonomy, this.checklists, this.predefinedLocations, openFile)).findAllClasses(openFile)).isEmpty()) {
                importer.chooseClass(taxonomy.getRoot().getName());
            } else if (classes.size() == 1) {
                importer.chooseClass(classes.iterator().next());
            } else if (classes.contains(taxonomy.getRoot().getName())) {
                importer.chooseClass(taxonomy.getRoot().getName());
            } else {
                JComboBox<String> classCombobox = new JComboBox<String>(classes.toArray(new String[classes.size()]));
                classCombobox.setMaximumRowCount(classes.size());
                this.fontManager.applyTo(classCombobox);
                if (JOptionPane.showConfirmDialog(this, new Object[]{this.alerts.getFormattedDialogMessage(Messages.Name.CHOOSE_A_TAXONOMIC_CLASS_TITLE, Messages.Name.CHOOSE_A_TAXONOMIC_CLASS_FORMATTED_MESSAGE, taxonomy.getName()), classCombobox}, "", 2, 1, this.alerts.getAlertIcon()) != 0) {
                    return;
                }
                importer.chooseClass((String)classCombobox.getSelectedItem());
            }
            this.doImport(importer, this.importCompleteAction, ImportPreferences.ImportType.INATURALIST);
        }
    }

    private void doImportScythebill() {
        FileNameExtensionFilter fileFilter = new FileNameExtensionFilter(Messages.getFormattedMessage(Messages.Name.CSV_EXPORT_TYPE, "Scythebill"), "csv");
        File openFile = this.fileDialogs.openFile(UIUtils.findFrame(this), Messages.getFormattedMessage(Messages.Name.OPEN_EXPORT_FORMAT, "Scythebill"), fileFilter, FilePreferences.FileType.OTHER);
        if (openFile != null) {
            ScythebillImporter importer = new ScythebillImporter(this.reportSet, this.taxonomyStore.getTaxonomy(), this.checklists, this.predefinedLocations, openFile);
            this.doImport(importer, this.importCompleteAction, ImportPreferences.ImportType.SCYTHEBILL);
        }
    }

    private void doImportObservationOrg() {
        FileNameExtensionFilter fileFilter = new FileNameExtensionFilter(Messages.getFormattedMessage(Messages.Name.CSV_EXPORT_TYPE, "Observation.org"), "csv");
        File openFile = this.fileDialogs.openFile(UIUtils.findFrame(this), Messages.getFormattedMessage(Messages.Name.OPEN_EXPORT_FORMAT, "Observation.org"), fileFilter, FilePreferences.FileType.OTHER);
        if (openFile != null) {
            SightingsImporter<?> importer = Observado.newImporter(this.reportSet, this.taxonomyStore.isBirdTaxonomy() ? this.taxonomyStore.getIoc() : this.taxonomyStore.getTaxonomy(), this.checklists, this.predefinedLocations, openFile);
            this.doImport(importer, this.importCompleteAction, ImportPreferences.ImportType.OBSERVADO);
        }
    }

    private void doImportOrnitho() {
        FileNameExtensionFilter fileFilter = new FileNameExtensionFilter(Messages.getFormattedMessage(Messages.Name.TXT_EXPORT_TYPE, "Ornitho"), "txt");
        File openFile = this.fileDialogs.openFile(UIUtils.findFrame(this), Messages.getFormattedMessage(Messages.Name.OPEN_EXPORT_FORMAT, "Ornitho"), fileFilter, FilePreferences.FileType.OTHER);
        if (openFile != null) {
            OrnithoImporter importer = new OrnithoImporter(this.reportSet, this.taxonomyStore.getIoc(), this.checklists, this.predefinedLocations, openFile);
            this.doImport(importer, this.importCompleteAction, ImportPreferences.ImportType.ORNITHO);
        }
    }

    private void doImportWildlifeRecorder() {
        FileNameExtensionFilter fileFilter = new FileNameExtensionFilter(Messages.getFormattedMessage(Messages.Name.CSV_OR_MDB_EXPORT_TYPE, "Wildlife Recorder"), "csv", "mdb");
        File openFile = this.fileDialogs.openFile(UIUtils.findFrame(this), Messages.getFormattedMessage(Messages.Name.OPEN_EXPORT_FORMAT, "Wildlife Recorder"), fileFilter, FilePreferences.FileType.OTHER);
        if (openFile != null) {
            if (openFile.getName().endsWith(".mdb")) {
                this.doImport(new WildlifeRecorderMdbImporter(this.reportSet, this.taxonomyStore.getTaxonomy(), this.checklists, this.predefinedLocations, openFile), this.importCompleteAction, ImportPreferences.ImportType.WILDLIFE_RECORDER);
            } else {
                File locationsFile = null;
                int showYesNo = this.alerts.showYesNo((Object)this, Messages.Name.WR_LOCATION_EXPORTS_FILE_TITLE, Messages.Name.WR_LOCATION_EXPORTS_FILE_MESSAGE, new Object[0]);
                if (showYesNo == 0) {
                    FileNameExtensionFilter locationsFilter = new FileNameExtensionFilter(Messages.getFormattedMessage(Messages.Name.CSV_EXPORT_TYPE, "Wildlife Recorder Locations"), "csv");
                    locationsFile = this.fileDialogs.openFile(UIUtils.findFrame(this), Messages.getMessage(Messages.Name.OPEN_FIELD_NOTES_FILE), locationsFilter, FilePreferences.FileType.OTHER);
                    if (locationsFile == null) {
                        return;
                    }
                }
                WildlifeRecorderImporter importer = new WildlifeRecorderImporter(this.reportSet, this.taxonomyStore.getTaxonomy(), this.checklists, this.predefinedLocations, openFile, locationsFile);
                this.doImport(importer, this.importCompleteAction, ImportPreferences.ImportType.WILDLIFE_RECORDER);
            }
        }
    }

    private void doImportWings() {
        FileNameExtensionFilter fileFilter = new FileNameExtensionFilter(Messages.getFormattedMessage(Messages.Name.XML_EXPORT_TYPE, "Wings"), "xml");
        File[] files = this.fileDialogs.openFiles(UIUtils.findFrame(this), Messages.getMessage(Messages.Name.OPEN_WINGS_FILES), fileFilter, FilePreferences.FileType.OTHER);
        if (files == null || files.length == 0) {
            return;
        }
        WingsImporter importer = new WingsImporter(this.reportSet, this.taxonomyStore.getIoc(), this.checklists, this.predefinedLocations, Arrays.asList(files));
        this.doImport(importer, this.importCompleteAction, ImportPreferences.ImportType.WINGS);
    }

    private void doImport(final SightingsImporter<?> importer, final Action finishedAction, final ImportPreferences.ImportType importType) {
        this.importPreferences.addRecentlyUsedImport(importType);
        this.locationsBeforeImport = null;
        this.tripsBeforeImport = null;
        this.hadUserSet = null;
        Runnable task = importer.longRunningTask();
        if (task == null) {
            this.beginImport(importer, finishedAction, importType);
        } else {
            this.setCursor(Cursor.getPredefinedCursor(3));
            ListenableFuture future = Futures.withTimeout(this.executorService.submit(task), 10L, TimeUnit.SECONDS, this.executorService);
            Futures.addCallback(future, new FutureCallback<Object>(){

                @Override
                public void onFailure(Throwable t) {
                    logger.log(Level.WARNING, "Could not complete long running import task", t);
                    this.done();
                }

                @Override
                public void onSuccess(Object o) {
                    this.done();
                }

                private void done() {
                    SwingUtilities.invokeLater(() -> {
                        ImportMenuPanel.this.setCursor(Cursor.getDefaultCursor());
                        ImportMenuPanel.this.beginImport(importer, finishedAction, importType);
                    });
                }
            }, this.executorService);
        }
    }

    private void beginImport(SightingsImporter<?> importer, Action finishedAction, ImportPreferences.ImportType importType) {
        try {
            Optional<String> initialCheck = importer.initialCheck();
            if (initialCheck.isPresent()) {
                String initialCheckMessage = String.format(initialCheck.get(), HtmlResponseWriter.htmlEscape(importer.importFileName()));
                this.alerts.showError((Object)this, Messages.Name.FAILED_IMPORT_TITLE, Messages.Name.FAILED_IMPORT_FORMAT, initialCheckMessage);
                return;
            }
            if (importer.isMassExport()) {
                ReadablePartial nullDate = PartialIO.fromString("1900-01-01");
                Function<Sighting, ReadablePartial> dateAsPartialMapping = s -> {
                    ReadablePartial date = s.getStoredDateAsPartial();
                    return date == null ? nullDate : date;
                };
                Set existingDates = Streams.stream(this.reportSet.getSightings(importer.getTaxonomy())).filter(this::doesNotHavePrivateLocation).map(dateAsPartialMapping).filter(p -> p != null).collect(Collectors.toCollection(LinkedHashSet::new));
                Comparator dateComparator = SightingComparators::comparePartials;
                Collection<ReadablePartial> datesFromImport = importer.getAllDates();
                TreeSet newDates = datesFromImport.stream().filter(p -> p != null).collect(Collectors.toCollection(() -> new TreeSet(dateComparator)));
                int newDatesCountPriorToRemovingExisting = newDates.size();
                newDates.removeAll(existingDates);
                int newDatesCountAfterRemovingExisting = newDates.size();
                if (newDatesCountAfterRemovingExisting > 0 && newDatesCountAfterRemovingExisting < newDatesCountPriorToRemovingExisting) {
                    ReadablePartial first = (ReadablePartial)newDates.first();
                    ReadablePartial last = (ReadablePartial)newDates.last();
                    if (this.alerts.showYesNo((Object)this, Messages.Name.IMPORT_ONLY_NEW_DATES_TITLE, Messages.Name.IMPORT_ONLY_NEW_DATES_FORMAT, newDatesCountAfterRemovingExisting, PartialIO.toShortUserString(first, Locale.getDefault()), PartialIO.toShortUserString(last, Locale.getDefault())) == 0) {
                        importer.onlyImportDatesIn(newDates);
                    }
                } else if (newDatesCountAfterRemovingExisting == 0 && this.alerts.showYesNo((Object)this, Messages.Name.IMPORT_DATES_ARE_ENTIRELY_DUPLICATED_TITLE, Messages.Name.IMPORT_DATES_ARE_ENTIRELY_DUPLICATED_MESSAGE, new Object[0]) != 0) {
                    return;
                }
            }
            this.parseTaxaAndLocations(importer, finishedAction, importType);
        }
        catch (ImportException e) {
            this.alerts.showError((Object)this, Messages.getMessage(Messages.Name.FAILED_IMPORT_TITLE), e.getMessage(), new Object[0]);
            logger.log(Level.WARNING, "Failed import", e);
            this.finishFailedOrCanceledImport();
        }
        catch (Exception e) {
            this.alerts.showError((Object)this, (Throwable)e, Messages.Name.FAILED_IMPORT_TITLE, Messages.Name.IMPORTING_UNSUCCESSFUL_MESSAGE, HtmlEscapers.htmlEscaper().escape(importer.importFileName()));
            logger.log(Level.WARNING, "Failed import", e);
            this.finishFailedOrCanceledImport();
        }
    }

    private void parseTaxaAndLocations(SightingsImporter<?> importer, Action finishedAction, ImportPreferences.ImportType importType) throws IOException {
        importer.beforeParseTaxonomyIds();
        Map<Object, TaxonImporter.ToBeDecided> allTbdIds = importer.parseTaxonomyIds();
        this.locationsBeforeImport = new LinkedHashSet<String>();
        Locations.visitLocations(this.reportSet.getLocations(), l -> this.locationsBeforeImport.add(l.getId()));
        this.tripsBeforeImport = new LinkedHashSet<String>();
        this.reportSet.getTrips().allTrips().forEach(t -> this.tripsBeforeImport.add(t.id()));
        ParsedLocationIds parsedLocationIds = importer.parseLocationIds();
        this.hadUserSet = this.reportSet.getUserSet() != null;
        this.resolveImportedTaxa(importer, allTbdIds, parsedLocationIds, finishedAction, importType);
    }

    private void resolveImportedTaxa(SightingsImporter<?> importer, Map<Object, TaxonImporter.ToBeDecided> allTbdIds, ParsedLocationIds parsedLocationIds, Action finishedAction, ImportPreferences.ImportType importType) {
        try {
            int showYesNo;
            NamesPreferences.AvailableLocale currentLocale;
            NamesPreferences.AvailableLocale bestLocale;
            Multimap<NamesPreferences.AvailableLocale, String> possibleTranslations;
            Set commonNames;
            LocalNames localNames;
            Set<NamesPreferences.AvailableLocale> availableLocales;
            Map<Object, TaxonImporter.ToBeDecided> validTbdIds = Maps.filterValues(allTbdIds, tbd -> !tbd.shouldIgnore() && (!Strings.isNullOrEmpty(tbd.commonName) || !Strings.isNullOrEmpty(tbd.scientificName)));
            importer.setIgnoredTaxonIds(allTbdIds.entrySet().stream().filter(entry -> ((TaxonImporter.ToBeDecided)entry.getValue()).shouldIgnore()).map(entry -> entry.getKey()).collect(ImmutableSet.toImmutableSet()));
            if (!(validTbdIds.isEmpty() || (availableLocales = (localNames = importer.getTaxonomy().getLocalNames()).availableLocales(importer.getTaxonomy())).isEmpty() || (commonNames = (Set)validTbdIds.values().stream().filter(tbd -> tbd.commonName != null).map(tbd -> tbd.commonName).collect(ImmutableSet.toImmutableSet())).isEmpty() || (possibleTranslations = localNames.possibleTranslations(availableLocales, commonNames)).isEmpty() || (bestLocale = possibleTranslations.keySet().stream().max(Comparator.comparing(locale -> possibleTranslations.get((NamesPreferences.AvailableLocale)locale).size())).get()) == (currentLocale = localNames.currentLocale(importer.getTaxonomy())) || (showYesNo = this.alerts.showYesNo((Object)this, Messages.Name.USE_DIFFERENT_INTERNATIONAL_NAMES_TITLE, Messages.Name.USE_DIFFERENT_INTERNATIONAL_NAMES_FORMAT, currentLocale, possibleTranslations.get(bestLocale).size(), bestLocale)) != 0)) {
                localNames.setLocale(importer.getTaxonomy(), bestLocale);
                allTbdIds = importer.parseTaxonomyIds();
                validTbdIds = Maps.filterValues(allTbdIds, tbd -> !tbd.shouldIgnore());
            }
            if (!validTbdIds.isEmpty()) {
                int successfullyParsedTaxa = importer.successfullyResolvedTaxa();
                if (successfullyParsedTaxa * 10 < validTbdIds.size()) {
                    int showYesNo2;
                    String name;
                    Taxonomy taxonomy = importer.getTaxonomy();
                    TaxonImporter.ToBeDecided singleToBeDecided = validTbdIds.values().iterator().next();
                    String string = name = singleToBeDecided.commonName == null ? singleToBeDecided.scientificName : singleToBeDecided.commonName;
                    if (successfullyParsedTaxa == 0 ? (showYesNo2 = this.alerts.showYesNo((Object)this, Messages.Name.RIGHT_TAXONOMY_TITLE, Messages.Name.RIGHT_TAXONOMY_FORMAT_NO_TAXA, validTbdIds.size(), name, taxonomy.getName())) != 0 : successfullyParsedTaxa * 10 < validTbdIds.size() && importer.expectTaxonSuccess() && (showYesNo = this.alerts.showYesNo((Object)this, Messages.Name.RIGHT_TAXONOMY_TITLE, Messages.Name.RIGHT_TAXONOMY_FORMAT_FEW_TAXA, successfullyParsedTaxa, validTbdIds.size(), name, taxonomy.getName())) != 0) {
                        return;
                    }
                }
                ImportResolveTaxaPanel importResolveTaxaPanel = this.resolveTaxaPanelProvider.get();
                importResolveTaxaPanel.start(validTbdIds, importer, () -> this.resolveImportedLocations(importer, parsedLocationIds, finishedAction));
                this.navigableFrame.navigateTo(importResolveTaxaPanel);
            } else {
                this.resolveImportedLocations(importer, parsedLocationIds, finishedAction);
            }
        }
        catch (ImportException e) {
            this.alerts.showError((Object)this, Messages.getMessage(Messages.Name.FAILED_IMPORT_TITLE), e.getMessage(), new Object[0]);
            logger.log(Level.WARNING, "Failed import", e);
            this.finishFailedOrCanceledImport();
        }
        catch (Exception e) {
            this.alerts.showError((Object)this, (Throwable)e, Messages.Name.FAILED_IMPORT_TITLE, Messages.Name.IMPORTING_UNSUCCESSFUL_MESSAGE, HtmlEscapers.htmlEscaper().escape(importer.importFileName()));
            logger.log(Level.WARNING, "Failed import", e);
            this.finishFailedOrCanceledImport();
        }
    }

    private void resolveImportedLocations(SightingsImporter<?> importer, ParsedLocationIds parsedLocationIds, Action finishedAction) {
        try {
            ImmutableMap<Object, ParsedLocationIds.ToBeDecided> toBeResolvedNames = parsedLocationIds.toBeResolvedNames();
            if (toBeResolvedNames.isEmpty()) {
                this.parseSightings(importer, finishedAction);
            } else {
                AutoGeocodeLocations autoGeocodeLocations = this.autoGeocodeLocationsProvider.get();
                ListenableFuture<Void> autoGeocodeCompleted = autoGeocodeLocations.autoGeocodeLocations(parsedLocationIds, this.reportSet);
                this.navigableFrame.setCursor(Cursor.getPredefinedCursor(3));
                autoGeocodeCompleted.addListener(() -> SwingUtilities.invokeLater(() -> {
                    this.navigableFrame.setCursor(Cursor.getDefaultCursor());
                    ImmutableMap<Object, ParsedLocationIds.ToBeDecided> toBeResolvedNames2 = parsedLocationIds.toBeResolvedNames();
                    if (toBeResolvedNames2.isEmpty()) {
                        this.parseSightings(importer, finishedAction);
                    } else {
                        ImportResolveLocationsPanel importResolveLocationsPanel = this.resolveLocationsPanelProvider.get();
                        importResolveLocationsPanel.start(this.reportSet, toBeResolvedNames2, parsedLocationIds, () -> this.parseSightings(importer, finishedAction));
                        this.navigableFrame.navigateTo(importResolveLocationsPanel);
                    }
                }), MoreExecutors.directExecutor());
            }
        }
        catch (ImportException e) {
            this.alerts.showError((Object)this, Messages.getMessage(Messages.Name.FAILED_IMPORT_TITLE), e.getMessage(), new Object[0]);
            logger.log(Level.WARNING, "Failed import", e);
            this.finishFailedOrCanceledImport();
        }
        catch (Exception e) {
            this.alerts.showError((Object)this, (Throwable)e, Messages.Name.FAILED_IMPORT_TITLE, Messages.Name.IMPORTING_UNSUCCESSFUL_MESSAGE, HtmlEscapers.htmlEscaper().escape(importer.importFileName()));
            logger.log(Level.WARNING, "Failed import", e);
            this.finishFailedOrCanceledImport();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseSightings(SightingsImporter<?> importer, Action finishedAction) {
        try {
            List<Sighting> imports;
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                imports = importer.parseSightings();
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
            if (imports.isEmpty()) {
                this.alerts.showError((Object)this, Messages.Name.FAILED_IMPORT_TITLE, Messages.Name.IMPORTING_EMPTY_RESULT_MESSAGE, HtmlResponseWriter.htmlEscape(importer.importFileName()));
                return;
            }
            if (this.reportSet.getUserSet() != null && !importer.importContainedUserInformation()) {
                ImportChooseUsersPanel importChooseUsersPanel = this.chooseUsersPanelProvider.get();
                importChooseUsersPanel.chooseUsers(users -> {
                    if (!users.isEmpty()) {
                        for (Sighting sighting : imports) {
                            sighting.getSightingInfo().setUsers((Collection<User>)users);
                        }
                        this.checkDuplicates(importer, finishedAction, imports);
                    }
                });
                this.navigableFrame.navigateTo(importChooseUsersPanel);
            } else {
                this.checkDuplicates(importer, finishedAction, imports);
            }
        }
        catch (ImportException e) {
            this.alerts.showError((Object)this, Messages.getMessage(Messages.Name.FAILED_IMPORT_TITLE), e.getMessage(), new Object[0]);
            logger.log(Level.WARNING, "Failed import", e);
            this.finishFailedOrCanceledImport();
        }
        catch (Exception e) {
            this.alerts.showError((Object)this, (Throwable)e, Messages.Name.FAILED_IMPORT_TITLE, Messages.Name.IMPORTING_UNSUCCESSFUL_MESSAGE, HtmlEscapers.htmlEscaper().escape(importer.importFileName()));
            logger.log(Level.WARNING, "Failed import", e);
            this.finishFailedOrCanceledImport();
        }
    }

    private boolean doesNotHavePrivateLocation(Sighting sighting) {
        if (sighting.getLocationId() == null) {
            return true;
        }
        return !this.reportSet.getLocations().getLocation(sighting.getLocationId()).isPrivate();
    }

    private void checkDuplicates(SightingsImporter<?> importer, Action finishedAction, List<Sighting> imports) {
        if (this.reportSet.getUserSet() == null) {
            this.checkDuplicatesWithoutUsers(importer, finishedAction, imports);
        } else {
            this.checkDuplicatesWithUsers(importer, finishedAction, imports);
        }
    }

    private void checkDuplicatesWithoutUsers(SightingsImporter<?> importer, Action finishedAction, List<Sighting> imports) {
        int countDuplicates = this.countDuplicates(imports, SightingFunnel.INSTANCE);
        int droppedDuplicates = 0;
        List<Sighting> sightingsToRemove = ImmutableList.of();
        if (countDuplicates > 0 && (double)countDuplicates > 2.0 * ((double)imports.size() * 1.0E-4)) {
            if (countDuplicates == imports.size()) {
                Object[] options = new Object[]{Messages.getMessage(Messages.Name.IMPORT_ANYWAY), Messages.getMessage(Messages.Name.OVERWRITE_DUPLICATES), Messages.getMessage(Messages.Name.CANCEL_BUTTON)};
                String message = Messages.getFormattedMessage(Messages.Name.ALL_SIGHTINGS_DUPLICATES, imports.size());
                int chosenOption = this.alerts.showWithOptions((Object)this, Messages.getMessage(Messages.Name.DUPLICATE_IMPORTS_QUESTION), message, options);
                if (chosenOption == 2 || chosenOption < 0) {
                    this.finishFailedOrCanceledImport();
                    return;
                }
                if (chosenOption == 1) {
                    sightingsToRemove = this.findExistingDuplicates(imports, DuplicateSightingKey::forSighting);
                    this.alerts.showMessage((Object)this, Messages.Name.SIGHTINGS_OVERWRITTEN_TITLE, Messages.Name.SIGHTINGS_OVERWRITTEN_FORMAT, sightingsToRemove.size());
                }
            } else {
                Object[] options = new Object[]{Messages.getMessage(Messages.Name.IMPORT_ALL), Messages.getMessage(Messages.Name.DROP_DUPLICATES), Messages.getMessage(Messages.Name.OVERWRITE_DUPLICATES), Messages.getMessage(Messages.Name.CANCEL_BUTTON)};
                String message = Messages.getFormattedMessage(Messages.Name.SOME_SIGHTINGS_DUPLICATES, imports.size(), countDuplicates);
                int chosenOption = this.alerts.showWithOptions((Object)this, Messages.getMessage(Messages.Name.DUPLICATE_IMPORTS_QUESTION), message, options);
                if (chosenOption == 3 || chosenOption < 0) {
                    this.finishFailedOrCanceledImport();
                    return;
                }
                if (chosenOption == 1) {
                    List<Sighting> removedDuplicates = this.dropDuplicates(importer, imports, DuplicateSightingKey::forSighting);
                    droppedDuplicates = imports.size() - removedDuplicates.size();
                    if (droppedDuplicates > 0) {
                        this.alerts.showMessage((Object)this, Messages.Name.DUPLICATES_DROPPED_TITLE, Messages.Name.DUPLICATES_DROPPED_FORMAT, droppedDuplicates);
                        imports = removedDuplicates;
                    }
                } else if (chosenOption == 2) {
                    sightingsToRemove = this.findExistingDuplicates(imports, DuplicateSightingKey::forSighting);
                    this.alerts.showMessage((Object)this, Messages.Name.SIGHTINGS_OVERWRITTEN_TITLE, Messages.Name.SIGHTINGS_OVERWRITTEN_FORMAT, sightingsToRemove.size());
                }
            }
        }
        this.finishImport(importer, finishedAction, droppedDuplicates, imports, sightingsToRemove);
    }

    private void checkDuplicatesWithUsers(SightingsImporter<?> importer, Action finishedAction, List<Sighting> imports) {
        List<Sighting> sightingsToRemove;
        int droppedDuplicates;
        Function<Sighting, DuplicateSightingKey> duplicateSightingKeyStrategy;
        boolean areThereDuplicates;
        Preconditions.checkState(this.reportSet.getUserSet() != null);
        int countDuplicates = this.countDuplicates(imports, SightingFunnel.INSTANCE);
        boolean bl = areThereDuplicates = (double)countDuplicates > 2.0 * ((double)imports.size() * 1.0E-4);
        if (!areThereDuplicates) {
            this.finishImport(importer, finishedAction, 0, imports, ImmutableList.of());
            return;
        }
        UserOverlapStats userOverlapStats = this.getUserOverlapStats(imports, DuplicateSightingKey::forSighting);
        if (userOverlapStats.actuallyNoDuplicates()) {
            this.finishImport(importer, finishedAction, 0, imports, ImmutableList.of());
            return;
        }
        if (userOverlapStats.existingUsersAreTheSameOrSuperset()) {
            this.checkDuplicatesWithoutUsers(importer, finishedAction, imports);
            return;
        }
        UserOverlapStats userOverlapStatsWithLocation = this.getUserOverlapStats(imports, DuplicateSightingKey::forSightingWithLocation);
        if (userOverlapStatsWithLocation.totalOverlap() != userOverlapStats.totalOverlap()) {
            float ratio = (float)userOverlapStatsWithLocation.totalOverlap() / (float)userOverlapStats.totalOverlap();
            Messages.Name name = userOverlapStatsWithLocation.totalOverlap() == 0 ? Messages.Name.ALL_SIGHTINGS_HAVE_DIFFERENT_LOCATIONS : ((double)ratio < 0.1 ? Messages.Name.A_FEW_SIGHTINGS_HAVE_DIFFERENT_LOCATIONS : ((double)ratio < 0.5 ? Messages.Name.MANY_SIGHTINGS_HAVE_DIFFERENT_LOCATIONS : ((double)ratio < 0.95 ? Messages.Name.MOST_SIGHTINGS_HAVE_DIFFERENT_LOCATIONS : Messages.Name.NEARLY_ALL_SIGHTINGS_HAVE_DIFFERENT_LOCATIONS)));
            int chosenOption = this.alerts.showWithOptions((Object)this, Messages.Name.IMPORTED_LOCATIONS_DIFFER, name, Messages.getMessage(Messages.Name.SEPARATE_SIGHTINGS), Messages.getMessage(Messages.Name.MERGE_SIGHTINGS), Messages.getMessage(Messages.Name.CANCEL_BUTTON));
            if (chosenOption == 2 || chosenOption < 0) {
                this.finishFailedOrCanceledImport();
                return;
            }
            if (chosenOption == 0) {
                if (userOverlapStatsWithLocation.actuallyNoDuplicates()) {
                    this.finishImport(importer, finishedAction, 0, imports, ImmutableList.of());
                    return;
                }
                if (userOverlapStatsWithLocation.existingUsersAreTheSameOrSuperset()) {
                    List<Sighting> remainingImports = this.dropDuplicates(importer, imports, DuplicateSightingKey::forSightingWithLocation);
                    this.finishImport(importer, finishedAction, imports.size() - remainingImports.size(), remainingImports, ImmutableList.of());
                    return;
                }
                duplicateSightingKeyStrategy = DuplicateSightingKey::forSightingWithLocation;
            } else {
                duplicateSightingKeyStrategy = DuplicateSightingKey::forSighting;
            }
        } else {
            duplicateSightingKeyStrategy = DuplicateSightingKey::forSighting;
        }
        int chosenOption = this.alerts.showWithOptions((Object)this, Messages.Name.IMPORTED_OBSERVERS_DIFFER_TITLE, Messages.Name.IMPORTED_OBSERVERS_DIFFER_MESSAGE, Messages.getMessage(Messages.Name.MERGE_USERS), Messages.getMessage(Messages.Name.PREFER_IMPORT), Messages.getMessage(Messages.Name.PREFER_EXISTING), Messages.getMessage(Messages.Name.CANCEL_BUTTON));
        if (chosenOption == 3 || chosenOption < 0) {
            this.finishFailedOrCanceledImport();
            return;
        }
        if (chosenOption == 0) {
            droppedDuplicates = 0;
            ModifiedImportsAndSightingsToRemove mergedObservers = this.mergeObservers(imports, duplicateSightingKeyStrategy);
            imports = mergedObservers.modifiedImports;
            sightingsToRemove = mergedObservers.sightingsToRemove;
        } else if (chosenOption == 1) {
            sightingsToRemove = this.findExistingDuplicates(imports, duplicateSightingKeyStrategy);
            droppedDuplicates = 0;
        } else {
            List<Sighting> remainingImports = this.dropDuplicates(importer, imports, duplicateSightingKeyStrategy);
            droppedDuplicates = imports.size() - remainingImports.size();
            imports = remainingImports;
            sightingsToRemove = ImmutableList.of();
        }
        this.finishImport(importer, finishedAction, droppedDuplicates, imports, sightingsToRemove);
    }

    private void finishImport(SightingsImporter<?> importer, Action finishedAction, int droppedDuplicates, final List<Sighting> finalImports, final List<Sighting> finalSightingsToRemove) {
        Object message;
        Set<Object> spToResolve;
        Taxonomy taxonomy;
        this.reportSet.mutator().adding(finalImports).removing(finalSightingsToRemove).mutate();
        Map<VisitInfoKey, VisitInfo> visitInfoMap = importer.getAccumulatedVisitInfoMap();
        for (Map.Entry<VisitInfoKey, VisitInfo> entry : visitInfoMap.entrySet()) {
            this.reportSet.putVisitInfo(entry.getKey(), entry.getValue());
        }
        this.cleanUnneededLocationsAndTrips();
        if (this.reportSet.getUserSet() != null && this.hadUserSet != null && !this.hadUserSet.booleanValue()) {
            this.defaultUserStore.userSetChanged();
        }
        if (this.recentEdits != null) {
            Set<VisitInfoKey> allVisitInfoKeys = this.extractVisitInfoKeys(finalImports);
            Set<Trip> allTrips = this.extractTrips(finalImports);
            this.recentEdits.add(Sets.union(allVisitInfoKeys, allTrips));
        }
        if ((taxonomy = this.taxonomyStore.getTaxonomy()) instanceof MappedTaxonomy) {
            spToResolve = Sets.newLinkedHashSet();
            for (SightingTaxon taxon : importer.getSpToResolve()) {
                if (taxon.resolve(taxonomy).getType() != SightingTaxon.Type.SP) continue;
                spToResolve.add(taxon);
            }
        } else {
            spToResolve = importer.getSpToResolve();
        }
        if (!spToResolve.isEmpty() && finishedAction == this.importCompleteAction) {
            this.reportSet.setSpsToResolve(ImmutableSet.copyOf(spToResolve), null);
            if (!this.initialRun && taxonomy.isBuiltIn()) {
                finishedAction = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ImportMenuPanel.this.navigableFrame.navigateTo("resolveTaxa");
                    }
                };
            }
        }
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ImportMenuPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    ImportMenuPanel.this.reportSet.mutator().removing(finalImports).adding(finalSightingsToRemove).mutate();
                    ImportMenuPanel.this.finishFailedOrCanceledImport();
                }
                finally {
                    ImportMenuPanel.this.setCursor(Cursor.getDefaultCursor());
                }
                ImportMenuPanel.this.returnAction.actionPerformed(event);
            }
        };
        if (importer.getFailedSightingsCount() > 0) {
            File failedLinesFile = importer.writeFailedLines();
            int success = importer.getSightingsFoundCount() - importer.getFailedSightingsCount() - droppedDuplicates;
            message = failedLinesFile != null ? this.alerts.getFormattedDialogMessageUnscaled(Messages.Name.IMPORT_PARTIALLY_SUCCESSFUL_TITLE, Messages.Name.IMPORT_PARTIALLY_SUCCESSFUL_WITH_FAILED_SIGHTINGS_FORMAT, success, importer.getSightingsFoundCount() - droppedDuplicates, failedLinesFile.getName()) : this.alerts.getFormattedDialogMessageUnscaled(Messages.Name.IMPORT_PARTIALLY_SUCCESSFUL_TITLE, Messages.Name.IMPORT_PARTIALLY_SUCCESSFUL_FORMAT, success, importer.getSightingsFoundCount() - droppedDuplicates);
        } else {
            message = importer.getSightingsFoundCount() == droppedDuplicates ? this.alerts.getFormattedDialogMessageUnscaled(Messages.Name.ALL_DUPLICATES_TITLE, Messages.Name.ALL_DUPLICATES_FORMAT, HtmlEscapers.htmlEscaper().escape(importer.importFileName())) : this.alerts.getFormattedDialogMessageUnscaled(Messages.Name.IMPORT_SUCCEEDED_TITLE, Messages.Name.IMPORT_SUCCEEDED_FORMAT, importer.getSightingsFoundCount() - droppedDuplicates, HtmlEscapers.htmlEscaper().escape(importer.importFileName()));
        }
        if (importer.getSightingsMergedCount() > 0) {
            message = (String)message + "<br><br>" + Messages.getFormattedMessage(Messages.Name.IMPORT_SIGHTINGS_MERGED, importer.getSightingsMergedCount());
        }
        if (importer.getSightingsEBirdSpuhsDroppedCount() > 0) {
            message = (String)message + "<br><br>" + Messages.getFormattedMessage(Messages.Name.IMPORT_EBIRD_SPUHS_DROPPED, importer.getSightingsEBirdSpuhsDroppedCount());
        }
        ImportScanner importScanner = new ImportScanner();
        JScrollPane scrollPane = importScanner.scanForNewSighting(finalImports, importer.getTaxonomy());
        Box box = new Box(3);
        JLabel label = new JLabel((String)message);
        label.setAlignmentX(0.0f);
        box.add(label);
        box.add(Box.createVerticalStrut(this.fontManager.scale(15)));
        scrollPane.setAlignmentX(0.0f);
        box.add(scrollPane);
        OkCancelPanel messagePanel = new OkCancelPanel(finishedAction, cancelAction, box, null);
        messagePanel.setMinimumSize(this.fontManager.scale(new Dimension(400, 300)));
        messagePanel.focusOnOk();
        this.navigableFrame.navigateTo(messagePanel);
    }

    private void finishFailedOrCanceledImport() {
        this.cleanUnneededLocationsAndTrips();
        if (this.reportSet.getUserSet() != null && this.hadUserSet != null && !this.hadUserSet.booleanValue()) {
            this.reportSet.clearUserSet();
            this.defaultUserStore.setUser(null);
            this.defaultUserStore.userSetChanged();
        }
    }

    private void cleanUnneededLocationsAndTrips() {
        if (this.locationsBeforeImport == null) {
            return;
        }
        Set locationsWithSightings = this.reportSet.getSightings().stream().filter(s -> s.getLocationId() != null).map(Sighting::getLocationId).collect(Collectors.toSet());
        Set tripsWithSightings = this.reportSet.getSightings().stream().filter(s -> s.getTrip() != null).map(s -> s.getTrip().id()).collect(Collectors.toSet());
        block0: while (true) {
            ArrayList locationsToDelete = new ArrayList();
            Locations.visitLocations(this.reportSet.getLocations(), l -> {
                if (this.locationsBeforeImport.contains(l.getId()) || locationsWithSightings.contains(l.getId()) || l.isBuiltInLocation() || !l.contents().isEmpty()) {
                    return;
                }
                locationsToDelete.add(l);
            });
            if (locationsToDelete.isEmpty()) break;
            Iterator<Object> iterator = locationsToDelete.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                Location locationToDelete = (Location)iterator.next();
                this.reportSet.deleteLocation(locationToDelete);
            }
            break;
        }
        ArrayList<Trip> tripsToDelete = new ArrayList<Trip>();
        for (Trip trip : this.reportSet.getTrips().allTrips()) {
            if (this.tripsBeforeImport.contains(trip.id()) || tripsWithSightings.contains(trip.id())) continue;
            tripsToDelete.add(trip);
        }
        this.reportSet.deleteTrips(tripsToDelete, null);
    }

    private Set<VisitInfoKey> extractVisitInfoKeys(List<Sighting> imports) {
        LinkedHashSet<VisitInfoKey> visitInfoKeys = Sets.newLinkedHashSet();
        for (Sighting sighting : imports) {
            VisitInfoKey visitInfoKey = VisitInfoKey.forSighting(sighting);
            if (visitInfoKey == null) continue;
            visitInfoKeys.add(visitInfoKey);
        }
        return visitInfoKeys;
    }

    private Set<Trip> extractTrips(List<Sighting> imports) {
        LinkedHashSet<Trip> trips = Sets.newLinkedHashSet();
        for (Sighting sighting : imports) {
            if (sighting.getTrip() == null) continue;
            trips.add(sighting.getTrip());
        }
        return trips;
    }

    private int countDuplicates(List<Sighting> imports, SightingFunnel sightingFunnel) {
        if (this.reportSet.getSightings().isEmpty()) {
            return 0;
        }
        BloomFilter<Sighting> filter = BloomFilter.create(sightingFunnel, this.reportSet.getSightings().size() + imports.size(), 1.0E-4);
        for (Sighting sighting : this.reportSet.getSightings()) {
            filter.put(sighting);
        }
        int count = 0;
        for (Sighting importedSighting : imports) {
            if (!filter.mightContain(importedSighting)) continue;
            ++count;
        }
        return count;
    }

    private List<Sighting> dropDuplicates(SightingsImporter<?> importer, List<Sighting> imports, Function<Sighting, DuplicateSightingKey> duplicateStrategy) {
        HashSet<DuplicateSightingKey> importedDateAndTimeKeys = Sets.newHashSet();
        for (Sighting importedSighting : imports) {
            DuplicateSightingKey dateAndTimeKey = duplicateStrategy.apply(importedSighting);
            if (dateAndTimeKey == null) continue;
            importedDateAndTimeKeys.add(dateAndTimeKey);
        }
        Taxonomy taxonomy = importer.getTaxonomy();
        Function<Object, Object> taxonMapper = taxonomy instanceof MappedTaxonomy ? taxon -> taxon.resolve(taxonomy).getSightingTaxon() : Function.identity();
        HashMultimap<DuplicateSightingKey, SightingTaxon> existingSightings = HashMultimap.create();
        for (Sighting sighting : this.reportSet.getSightings(taxonomy)) {
            DuplicateSightingKey dateAndTimeKey = duplicateStrategy.apply(sighting);
            if (dateAndTimeKey == null || !importedDateAndTimeKeys.contains(dateAndTimeKey)) continue;
            existingSightings.put(dateAndTimeKey, (SightingTaxon)taxonMapper.apply(sighting.getTaxon()));
        }
        ArrayList<Sighting> notDuplicates = new ArrayList<Sighting>(imports.size());
        for (Sighting importedSighting : imports) {
            DuplicateSightingKey dateAndTimeKey = duplicateStrategy.apply(importedSighting);
            if (dateAndTimeKey == null) {
                notDuplicates.add(importedSighting);
                continue;
            }
            if (existingSightings.containsEntry(dateAndTimeKey, taxonMapper.apply(importedSighting.getTaxon()))) continue;
            notDuplicates.add(importedSighting);
        }
        return notDuplicates;
    }

    private List<Sighting> findExistingDuplicates(List<Sighting> imports, Function<Sighting, DuplicateSightingKey> duplicateStrategy) {
        HashSet<DuplicateSightingKey> importedDateAndTimeKeys = Sets.newHashSet();
        HashMultimap<DuplicateSightingKey, SightingTaxon> importedSightings = HashMultimap.create();
        for (Sighting importedSighting : imports) {
            DuplicateSightingKey dateAndTimeKey = duplicateStrategy.apply(importedSighting);
            if (dateAndTimeKey == null) continue;
            importedDateAndTimeKeys.add(dateAndTimeKey);
            importedSightings.put(dateAndTimeKey, importedSighting.getTaxon());
        }
        ArrayList<Sighting> existingDuplicates = new ArrayList<Sighting>(imports.size());
        for (Sighting sighting : this.reportSet.getSightings()) {
            DuplicateSightingKey dateAndTimeKey = duplicateStrategy.apply(sighting);
            if (!importedSightings.containsEntry(dateAndTimeKey, sighting.getTaxon())) continue;
            existingDuplicates.add(sighting);
        }
        return existingDuplicates;
    }

    private UserOverlapStats getUserOverlapStats(List<Sighting> imports, Function<Sighting, DuplicateSightingKey> keyCreator) {
        HashSet<DuplicateSightingKey> importedDateAndTimeKeys = Sets.newHashSet();
        for (Sighting sighting : imports) {
            DuplicateSightingKey dateAndTimeKey = keyCreator.apply(sighting);
            if (dateAndTimeKey == null) continue;
            importedDateAndTimeKeys.add(dateAndTimeKey);
        }
        HashBasedTable existingSightings = HashBasedTable.create();
        for (Sighting sighting : this.reportSet.getSightings()) {
            DuplicateSightingKey dateAndTimeKey = keyCreator.apply(sighting);
            if (dateAndTimeKey == null || !importedDateAndTimeKeys.contains(dateAndTimeKey)) continue;
            existingSightings.put(dateAndTimeKey, sighting.getTaxon(), sighting);
        }
        UserOverlapStats userOverlapStats = new UserOverlapStats();
        for (Sighting importedSighting : imports) {
            ImmutableSet<User> importedUsers;
            Sighting existingSighting;
            DuplicateSightingKey dateAndTimeKey = keyCreator.apply(importedSighting);
            if (dateAndTimeKey == null || (existingSighting = (Sighting)existingSightings.get(dateAndTimeKey, importedSighting.getTaxon())) == null) continue;
            ImmutableSet<User> existingUsers = existingSighting.getSightingInfo().getUsers();
            if (existingUsers.equals(importedUsers = importedSighting.getSightingInfo().getUsers())) {
                ++userOverlapStats.sameUsers;
                continue;
            }
            if (existingUsers.containsAll(importedUsers)) {
                ++userOverlapStats.existingIsSuperset;
                continue;
            }
            if (importedUsers.containsAll(existingUsers)) {
                ++userOverlapStats.existingIsSubset;
                continue;
            }
            ++userOverlapStats.differentUsers;
        }
        return userOverlapStats;
    }

    private ModifiedImportsAndSightingsToRemove mergeObservers(List<Sighting> imports, Function<Sighting, DuplicateSightingKey> duplicateStrategy) {
        HashSet<DuplicateSightingKey> importedDateAndTimeKeys = Sets.newHashSet();
        for (Sighting sighting : imports) {
            DuplicateSightingKey dateAndTimeKey = duplicateStrategy.apply(sighting);
            if (dateAndTimeKey == null) continue;
            importedDateAndTimeKeys.add(dateAndTimeKey);
        }
        HashBasedTable existingSightings = HashBasedTable.create();
        for (Sighting sighting : this.reportSet.getSightings()) {
            DuplicateSightingKey dateAndTimeKey = duplicateStrategy.apply(sighting);
            if (dateAndTimeKey == null || !importedDateAndTimeKeys.contains(dateAndTimeKey)) continue;
            existingSightings.put(dateAndTimeKey, sighting.getTaxon(), sighting);
        }
        ModifiedImportsAndSightingsToRemove modifiedImportsAndSightingsToRemove = new ModifiedImportsAndSightingsToRemove();
        modifiedImportsAndSightingsToRemove.modifiedImports = new ArrayList<Sighting>(imports.size());
        modifiedImportsAndSightingsToRemove.sightingsToRemove = new ArrayList<Sighting>(imports.size());
        for (Sighting importedSighting : imports) {
            DuplicateSightingKey dateAndTimeKey = duplicateStrategy.apply(importedSighting);
            if (dateAndTimeKey == null) {
                modifiedImportsAndSightingsToRemove.modifiedImports.add(importedSighting);
                continue;
            }
            Sighting sighting = (Sighting)existingSightings.get(dateAndTimeKey, importedSighting.getTaxon());
            if (sighting == null) {
                modifiedImportsAndSightingsToRemove.modifiedImports.add(importedSighting);
                continue;
            }
            if (sighting.getSightingInfo().getUsers().equals(importedSighting.getSightingInfo().getUsers())) continue;
            Sighting.Builder mergedSighting = sighting.asBuilder();
            mergedSighting.getSightingInfo().setUsers(Sets.union(sighting.getSightingInfo().getUsers(), importedSighting.getSightingInfo().getUsers()));
            modifiedImportsAndSightingsToRemove.modifiedImports.add(mergedSighting.build());
            modifiedImportsAndSightingsToRemove.sightingsToRemove.add(sighting);
        }
        return modifiedImportsAndSightingsToRemove;
    }

    @Override
    public void fontsUpdated(FontManager fontManager) {
        this.centerBox.setPreferredSize(fontManager.scale(new Dimension(700, 520)));
        this.centerBox.setMinimumSize(this.centerBox.getPreferredSize());
        this.centerBox.setBorder(new EmptyBorder(fontManager.scale(20), fontManager.scale(60), fontManager.scale(20), fontManager.scale(60)));
        GroupLayout layout = new GroupLayout(this.centerBox);
        this.centerBox.setLayout(layout);
        List<ImportPreferences.ImportType> usedImportTypes = this.preferredImportTypes();
        ArrayList<JButton> buttons = new ArrayList<JButton>();
        GroupLayout.ParallelGroup horizontalImportLabels = layout.createParallelGroup();
        GroupLayout.ParallelGroup horizontalImportButtons = layout.createParallelGroup();
        GroupLayout.SequentialGroup verticalGroup = layout.createSequentialGroup();
        verticalGroup.addComponent(this.importLabel).addGap(this.reportSet.getSightings().isEmpty() ? 0 : fontManager.scale(24));
        for (ImportPreferences.ImportType importType : usedImportTypes) {
            JLabel label;
            JButton button = switch (importType) {
                case ImportPreferences.ImportType.AVISYS -> {
                    label = this.avisysLabel;
                    yield this.importAvisys;
                }
                case ImportPreferences.ImportType.BIRDBASE -> {
                    label = this.birdbaseLabel;
                    yield this.importBirdbase;
                }
                case ImportPreferences.ImportType.BIRD_BRAIN -> {
                    label = this.birdBrainLabel;
                    yield this.importBirdBrain;
                }
                case ImportPreferences.ImportType.BIRD_TRACK -> {
                    label = this.birdTrackLabel;
                    yield this.importBirdTrack;
                }
                case ImportPreferences.ImportType.BIRDERS_DIARY -> {
                    label = this.birdersDiaryLabel;
                    yield this.importBirdersDiary;
                }
                case ImportPreferences.ImportType.BIRDLASSER -> {
                    label = this.birdLasserLabel;
                    yield this.importBirdLasser;
                }
                case ImportPreferences.ImportType.BIRDA -> {
                    label = this.birdaLabel;
                    yield this.importBirda;
                }
                case ImportPreferences.ImportType.EBIRD -> {
                    label = this.ebirdLabel;
                    yield this.importEbird;
                }
                case ImportPreferences.ImportType.FLICKR -> {
                    label = this.flickrLabel;
                    yield this.importFlickr;
                }
                case ImportPreferences.ImportType.HBW_ALIVE -> {
                    label = this.hbwAliveLabel;
                    yield this.importHbwAlive;
                }
                case ImportPreferences.ImportType.INATURALIST -> {
                    label = this.iNaturalistLabel;
                    yield this.importINaturalist;
                }
                case ImportPreferences.ImportType.OBSERVADO -> {
                    label = this.observationOrgLabel;
                    yield this.importObservationOrg;
                }
                case ImportPreferences.ImportType.ORNITHO -> {
                    label = this.ornithoLabel;
                    yield this.importOrnitho;
                }
                case ImportPreferences.ImportType.SCYTHEBILL -> {
                    label = this.scythebillLabel;
                    yield this.importScythebill;
                }
                case ImportPreferences.ImportType.WILDLIFE_RECORDER -> {
                    label = this.wildlifeRecorderLabel;
                    yield this.importWildlifeRecorder;
                }
                case ImportPreferences.ImportType.WINGS -> {
                    label = this.wingsLabel;
                    yield this.importWings;
                }
                default -> throw new IllegalStateException("No UI added for type " + importType);
            };
            horizontalImportButtons.addComponent(button, GroupLayout.Alignment.LEADING, -2, fontManager.scale(224), -2);
            horizontalImportLabels.addComponent(label);
            verticalGroup.addGroup(layout.createBaselineGroup(false, false).addComponent(button, GroupLayout.Alignment.BASELINE, -2, fontManager.scale(52), -2).addComponent(label, GroupLayout.Alignment.BASELINE, -2, -2, -2));
            verticalGroup.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED);
            buttons.add(button);
        }
        horizontalImportButtons.addComponent(this.importMenuComboBox);
        horizontalImportLabels.addComponent(this.importMenuLabel);
        verticalGroup.addGroup(layout.createBaselineGroup(false, false).addComponent(this.importMenuComboBox, -2, -2, -2).addComponent(this.importMenuLabel));
        verticalGroup.addGap(24);
        horizontalImportButtons.addComponent(this.returnButton, GroupLayout.Alignment.LEADING, -2, fontManager.scale(224), -2);
        horizontalImportLabels.addComponent(this.emptyLabel);
        buttons.add(this.returnButton);
        verticalGroup.addGroup(layout.createBaselineGroup(false, false).addComponent(this.returnButton, GroupLayout.Alignment.BASELINE, -2, fontManager.scale(52), -2).addComponent(this.emptyLabel)).addContainerGap(82, 82);
        layout.setHorizontalGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup().addComponent(this.importLabel).addGroup(layout.createSequentialGroup().addGroup(horizontalImportButtons).addGap(63).addGroup(horizontalImportLabels))).addContainerGap(67, 67));
        layout.setVerticalGroup(verticalGroup);
        layout.linkSize(buttons.toArray(new JComponent[buttons.size()]));
        layout.linkSize(0, this.importMenuComboBox, (Component)buttons.get(0));
    }

    private List<ImportPreferences.ImportType> preferredImportTypes() {
        List usedImportTypes = this.importPreferences.recentlyUsedImports().stream().limit(4L).collect(Collectors.toCollection(ArrayList::new));
        if ((long)usedImportTypes.size() < 4L && !usedImportTypes.contains((Object)ImportPreferences.ImportType.EBIRD)) {
            usedImportTypes.add(ImportPreferences.ImportType.EBIRD);
        }
        if ((long)usedImportTypes.size() < 4L && !usedImportTypes.contains((Object)ImportPreferences.ImportType.SCYTHEBILL)) {
            usedImportTypes.add(ImportPreferences.ImportType.SCYTHEBILL);
        }
        return usedImportTypes;
    }

    @Subscribe
    public void taxonomyChanged(TaxonomyChangedEvent event) {
        this.updateUiForTaxonomy();
    }

    private void updateUiForTaxonomy() {
        List<ImportPreferences.ImportType> importTypes;
        this.enableTaxonomy(this.importAvisys, ImportPreferences.ImportType.AVISYS);
        this.enableTaxonomy(this.importBirdBrain, ImportPreferences.ImportType.BIRD_BRAIN);
        this.enableTaxonomy(this.importBirdLasser, ImportPreferences.ImportType.BIRDLASSER);
        this.enableTaxonomy(this.importBirdTrack, ImportPreferences.ImportType.BIRD_TRACK);
        this.enableTaxonomy(this.importBirdbase, ImportPreferences.ImportType.BIRDBASE);
        this.enableTaxonomy(this.importBirda, ImportPreferences.ImportType.BIRDA);
        this.enableTaxonomy(this.importBirdersDiary, ImportPreferences.ImportType.BIRDERS_DIARY);
        this.enableTaxonomy(this.importEbird, ImportPreferences.ImportType.EBIRD);
        this.enableTaxonomy(this.importFlickr, ImportPreferences.ImportType.FLICKR);
        this.enableTaxonomy(this.importHbwAlive, ImportPreferences.ImportType.HBW_ALIVE);
        this.enableTaxonomy(this.importINaturalist, ImportPreferences.ImportType.INATURALIST);
        this.enableTaxonomy(this.importObservationOrg, ImportPreferences.ImportType.OBSERVADO);
        this.enableTaxonomy(this.importOrnitho, ImportPreferences.ImportType.ORNITHO);
        this.enableTaxonomy(this.importScythebill, ImportPreferences.ImportType.SCYTHEBILL);
        this.enableTaxonomy(this.importWildlifeRecorder, ImportPreferences.ImportType.WILDLIFE_RECORDER);
        this.enableTaxonomy(this.importWings, ImportPreferences.ImportType.WINGS);
        ArrayList<Object> comboBoxItems = new ArrayList<Object>();
        comboBoxItems.add(Messages.getMessage(Messages.Name.IMPORT_FROM));
        if (this.taxonomyStore.isBirdTaxonomy()) {
            importTypes = Lists.newArrayList(ImportPreferences.ImportType.values());
            if (!this.reportSet.getSightings().isEmpty()) {
                this.importLabel.setText("<html>" + Messages.getMessage(Messages.Name.CHOOSE_AN_IMPORT_FORMAT));
            }
        } else {
            importTypes = Arrays.stream(ImportPreferences.ImportType.values()).filter(ImportPreferences.ImportType::supportsNonAvianTaxa).collect(Collectors.toCollection(ArrayList::new));
            if (!this.reportSet.getSightings().isEmpty()) {
                this.importLabel.setText("<html>" + Messages.getMessage(Messages.Name.CHOOSE_AN_IMPORT_FORMAT_ONLY_NON_BIRD));
            } else {
                this.importLabel.setText("<html>" + Messages.getMessage(Messages.Name.CHOOSE_AN_IMPORT_FORMAT_ONLY_NON_BIRD_EMPTY_FILE));
            }
        }
        importTypes.removeAll(this.preferredImportTypes());
        comboBoxItems.addAll(importTypes);
        this.importMenuComboBox.setModel(new DefaultComboBoxModel<Object>(comboBoxItems.toArray()));
        this.importMenuComboBox.setMaximumRowCount(comboBoxItems.size());
        this.importMenuComboBox.setVisible(!importTypes.isEmpty());
        this.importMenuLabel.setVisible(!importTypes.isEmpty());
    }

    private void enableTaxonomy(JButton importButton, ImportPreferences.ImportType importType) {
        importButton.setEnabled(importType.supportsNonAvianTaxa() || this.taxonomyStore.isBirdTaxonomy());
    }

    @Override
    public String getTitle() {
        return Messages.getMessage(Messages.Name.IMPORT_SIGHTINGS);
    }

    private static enum SightingFunnel implements Funnel<Sighting>
    {
        INSTANCE;


        @Override
        public void funnel(Sighting from, PrimitiveSink into) {
            ReadablePartial dateAsPartial = from.getStartDateAsPartial();
            if (dateAsPartial != null) {
                this.funnelField(dateAsPartial, DateTimeFieldType.dayOfMonth(), into);
                this.funnelField(dateAsPartial, DateTimeFieldType.monthOfYear(), into);
                this.funnelField(dateAsPartial, DateTimeFieldType.year(), into);
            } else {
                into.putInt(-1);
                into.putInt(-1);
                into.putInt(-1);
            }
            LocalTime time = from.getStoredTimeAsPartial();
            if (time != null) {
                this.funnelField(time, DateTimeFieldType.hourOfDay(), into);
                this.funnelField(time, DateTimeFieldType.minuteOfHour(), into);
            } else {
                into.putInt(-1);
                into.putInt(-1);
            }
            into.putUnencodedChars(from.getTaxonomy().getId());
            into.putInt(from.getTaxon().getType().ordinal());
            for (String id : from.getTaxon().getIds()) {
                into.putUnencodedChars(id);
            }
        }

        private void funnelField(ReadablePartial partial, DateTimeFieldType fieldType, PrimitiveSink into) {
            if (partial.isSupported(fieldType)) {
                into.putInt(partial.get(fieldType));
            } else {
                into.putInt(-1);
            }
        }
    }

    static class UserOverlapStats {
        int sameUsers;
        int existingIsSuperset;
        int existingIsSubset;
        int differentUsers;

        UserOverlapStats() {
        }

        public boolean actuallyNoDuplicates() {
            return this.totalOverlap() == 0;
        }

        public boolean existingUsersAreTheSameOrSuperset() {
            return this.existingIsSubset == 0 && this.differentUsers == 0;
        }

        public int totalOverlap() {
            return this.sameUsers + this.existingIsSuperset + this.existingIsSubset + this.differentUsers;
        }
    }

    static class ModifiedImportsAndSightingsToRemove {
        List<Sighting> modifiedImports;
        List<Sighting> sightingsToRemove;

        ModifiedImportsAndSightingsToRemove() {
        }
    }

    class ImportScanner {
        private OptionalInt year;
        private Location countyLocation;
        private Location stateLocation;
        private Location countryLocation;
        private JEditorPane newText = new JEditorPane("text/html", "");
        private JScrollPane newScrollPane = new JScrollPane(this.newText);
        private Location siteLocation;

        ImportScanner() {
            this.newScrollPane.setVisible(false);
            this.newText.setEditable(false);
            this.newText.putClientProperty("JEditorPane.honorDisplayProperties", true);
        }

        JScrollPane scanForNewSighting(List<Sighting> finalImports, Taxonomy taxonomy) {
            if (!finalImports.isEmpty()) {
                Location rootLocation;
                ImmutableSet locations = finalImports.stream().filter(s -> s.getLocationId() != null).map(Sighting::getLocationId).collect(ImmutableSet.toImmutableSet());
                if (locations.isEmpty()) {
                    rootLocation = null;
                } else {
                    String locationId;
                    Location location;
                    LocationSet locationSet = ImportMenuPanel.this.reportSet.getLocations();
                    rootLocation = locationSet.getLocation((String)locations.iterator().next());
                    Iterator iterator = Iterables.skip(locations, 1).iterator();
                    while (iterator.hasNext() && (rootLocation = Locations.getCommonAncestor(rootLocation, location = locationSet.getLocation(locationId = (String)iterator.next()))) != null) {
                    }
                }
                ArrayList<Location> locationsToScan = new ArrayList<Location>();
                this.countryLocation = null;
                this.stateLocation = null;
                this.countyLocation = null;
                Location perhapsInterestingLocation = rootLocation;
                if (rootLocation != null && rootLocation.getId() != null && rootLocation.getType() != Location.Type.country && rootLocation.getType() != Location.Type.state && rootLocation.getType() != Location.Type.county) {
                    locationsToScan.add(rootLocation);
                    this.siteLocation = rootLocation;
                    perhapsInterestingLocation = rootLocation.getParent();
                }
                while (perhapsInterestingLocation != null) {
                    if (perhapsInterestingLocation.getType() != null) {
                        switch (perhapsInterestingLocation.getType()) {
                            case country: {
                                if (this.countryLocation != null) break;
                                this.countryLocation = perhapsInterestingLocation;
                                locationsToScan.add(perhapsInterestingLocation);
                                break;
                            }
                            case state: {
                                if (this.stateLocation != null) break;
                                this.stateLocation = perhapsInterestingLocation;
                                locationsToScan.add(perhapsInterestingLocation);
                                break;
                            }
                            case county: {
                                if (this.countyLocation != null) break;
                                this.countyLocation = perhapsInterestingLocation;
                                locationsToScan.add(perhapsInterestingLocation);
                                break;
                            }
                        }
                    }
                    perhapsInterestingLocation = perhapsInterestingLocation.getParent();
                }
                locationsToScan.add(null);
                this.year = OptionalInt.of(LocalDate.now(GJChronology.getInstance()).getYear());
                ImmutableSet<Sighting> importedSightingSet = ImmutableSet.copyOf(finalImports);
                Predicate<Sighting> sightingsToInclude = Predicates.and(s -> !importedSightingSet.contains(s), ImportMenuPanel.this.queryPreferences.getCountablePredicate(taxonomy, false, null));
                LinkedHashSet<User> users = new LinkedHashSet<User>();
                for (Sighting sighting : finalImports) {
                    if (!sighting.hasSightingInfo()) continue;
                    users.addAll(sighting.getSightingInfo().getUsers());
                }
                ImmutableSet<User> immutableUsers = ImmutableSet.copyOf(users);
                if (!users.isEmpty()) {
                    sightingsToInclude = Predicates.and(sightingsToInclude, SightingPredicates.includesAnyOfUsers(immutableUsers));
                }
                ScanSeenTaxa.start(ImportMenuPanel.this.reportSet, taxonomy, ImportMenuPanel.this.executorService, scanSeenTaxa -> this.showScanResults((ScanSeenTaxa)scanSeenTaxa, finalImports, taxonomy), locationsToScan, sightingsToInclude, new ScanSeenTaxa.Options().setYearToScan(this.year).setUsers(immutableUsers));
            }
            return this.newScrollPane;
        }

        private void showScanResults(ScanSeenTaxa scannedSeenTaxa, List<Sighting> finalImports, Taxonomy taxonomy) {
            ResolvedComparator resolvedComparator = new ResolvedComparator();
            SortedSetMultimap<NewFor, SightingTaxon.Resolved> scanResults = Multimaps.newSortedSetMultimap(new TreeMap(), () -> new TreeSet<SightingTaxon.Resolved>(resolvedComparator));
            Set<String> siteSeenTaxa = null;
            if (this.siteLocation != null && scannedSeenTaxa.getVisitCount(this.siteLocation) >= 3) {
                siteSeenTaxa = scannedSeenTaxa.getSeenTaxa(taxonomy, this.siteLocation);
            }
            Set<String> countySeenTaxa = this.countyLocation == null ? null : scannedSeenTaxa.getSeenTaxa(taxonomy, this.countyLocation);
            Set<String> stateSeenTaxa = this.stateLocation == null ? null : scannedSeenTaxa.getSeenTaxa(taxonomy, this.stateLocation);
            Set<String> countrySeenTaxa = this.countryLocation == null ? null : scannedSeenTaxa.getSeenTaxa(taxonomy, this.countryLocation);
            Set<String> worldSeenTaxa = scannedSeenTaxa.getSeenTaxa(taxonomy, null);
            Set<String> yearSeenTaxa = !this.year.isPresent() ? null : scannedSeenTaxa.getYearTaxa(taxonomy, this.year.getAsInt());
            Predicate<Sighting> countable = ImportMenuPanel.this.queryPreferences.getCountablePredicate(taxonomy, false, null);
            for (Sighting sighting : finalImports) {
                SightingTaxon.Resolved resolved;
                if (!countable.apply(sighting) || (resolved = sighting.getTaxon().resolve(taxonomy)).getType() != SightingTaxon.Type.SINGLE && resolved.getType() != SightingTaxon.Type.SINGLE_WITH_SECONDARY_SUBSPECIES) continue;
                String taxonId = resolved.getSmallestTaxonType() != Taxon.Type.species ? resolved.getParentOfAtLeastType(Taxon.Type.species).getId() : resolved.getSightingTaxon().getId();
                if (worldSeenTaxa != null && !worldSeenTaxa.contains(taxonId)) {
                    scanResults.put(NewFor.world, SightingTaxons.newResolved(taxonomy.getTaxon(taxonId)));
                } else if (countrySeenTaxa != null && !countrySeenTaxa.contains(taxonId)) {
                    scanResults.put(NewFor.country, SightingTaxons.newResolved(taxonomy.getTaxon(taxonId)));
                } else if (stateSeenTaxa != null && !stateSeenTaxa.contains(taxonId)) {
                    scanResults.put(NewFor.state, SightingTaxons.newResolved(taxonomy.getTaxon(taxonId)));
                } else if (countySeenTaxa != null && !countySeenTaxa.contains(taxonId)) {
                    scanResults.put(NewFor.county, SightingTaxons.newResolved(taxonomy.getTaxon(taxonId)));
                } else if (siteSeenTaxa != null && !siteSeenTaxa.contains(taxonId)) {
                    scanResults.put(NewFor.site, SightingTaxons.newResolved(taxonomy.getTaxon(taxonId)));
                }
                if (yearSeenTaxa == null || yearSeenTaxa.contains(taxonId) || !this.year.isPresent() || sighting.getEndDateAsPartial() == null || !sighting.getEndDateAsPartial().isSupported(DateTimeFieldType.year()) || sighting.getEndDateAsPartial().get(DateTimeFieldType.year()) != this.year.getAsInt()) continue;
                scanResults.put(NewFor.year, SightingTaxons.newResolved(taxonomy.getTaxon(taxonId)));
            }
            if (!scanResults.isEmpty()) {
                if (!scanResults.get(NewFor.site).isEmpty()) {
                    scanResults.putAll(NewFor.site, scanResults.get(NewFor.county));
                    scanResults.putAll(NewFor.site, scanResults.get(NewFor.state));
                    scanResults.putAll(NewFor.site, scanResults.get(NewFor.country));
                    scanResults.putAll(NewFor.site, scanResults.get(NewFor.world));
                }
                if (!scanResults.get(NewFor.county).isEmpty()) {
                    scanResults.putAll(NewFor.county, scanResults.get(NewFor.state));
                    scanResults.putAll(NewFor.county, scanResults.get(NewFor.country));
                    scanResults.putAll(NewFor.county, scanResults.get(NewFor.world));
                }
                if (!scanResults.get(NewFor.state).isEmpty()) {
                    scanResults.putAll(NewFor.state, scanResults.get(NewFor.country));
                    scanResults.putAll(NewFor.state, scanResults.get(NewFor.world));
                }
                if (!scanResults.get(NewFor.country).isEmpty()) {
                    scanResults.putAll(NewFor.country, scanResults.get(NewFor.world));
                }
                StringBuilder text = new StringBuilder();
                text.append(this.newForText(scanResults, NewFor.world));
                text.append(this.newForText(scanResults, NewFor.country));
                text.append(this.newForText(scanResults, NewFor.state));
                text.append(this.newForText(scanResults, NewFor.county));
                text.append(this.newForText(scanResults, NewFor.site));
                text.append(this.newForText(scanResults, NewFor.year));
                this.newText.setText(text.toString());
                this.newScrollPane.setVisible(true);
                this.newScrollPane.getParent().revalidate();
            }
        }

        private String newForText(Multimap<NewFor, SightingTaxon.Resolved> scanResults, NewFor newFor) {
            Collection<SightingTaxon.Resolved> newForSpecies = scanResults.get(newFor);
            if (newForSpecies.isEmpty()) {
                return "";
            }
            Function<SightingTaxon.Resolved, String> toString = switch (ImportMenuPanel.this.namesPreferences.scientificOrCommon) {
                case NamesPreferences.ScientificOrCommon.COMMON_FIRST, NamesPreferences.ScientificOrCommon.COMMON_ONLY -> SightingTaxon.Resolved::getCommonName;
                case NamesPreferences.ScientificOrCommon.SCIENTIFIC_FIRST, NamesPreferences.ScientificOrCommon.SCIENTIFIC_ONLY -> SightingTaxon.Resolved::getName;
                default -> throw new AssertionError((Object)("Unexpected scientificOrCommon: " + ImportMenuPanel.this.namesPreferences.scientificOrCommon));
            };
            StringBuilder text = new StringBuilder();
            if (newForSpecies.size() > 30) {
                Messages.Name format;
                text.append(Messages.getFormattedMessage(format, newForSpecies.size(), switch (newFor) {
                    case NewFor.world -> {
                        format = Messages.Name.IMPORT_NEW_FOR_WORLD_SPECIES_COUNT;
                        yield "";
                    }
                    case NewFor.country -> {
                        format = Messages.Name.IMPORT_NEW_FOR_LOCATION_SPECIES_COUNT;
                        yield this.countryLocation.getDisplayName();
                    }
                    case NewFor.state -> {
                        format = Messages.Name.IMPORT_NEW_FOR_LOCATION_SPECIES_COUNT;
                        yield this.stateLocation.getDisplayName();
                    }
                    case NewFor.county -> {
                        format = Messages.Name.IMPORT_NEW_FOR_LOCATION_SPECIES_COUNT;
                        yield this.countyLocation.getDisplayName();
                    }
                    case NewFor.site -> {
                        format = Messages.Name.IMPORT_NEW_FOR_LOCATION_SPECIES_COUNT;
                        yield this.siteLocation.getDisplayName();
                    }
                    case NewFor.year -> {
                        format = Messages.Name.IMPORT_NEW_FOR_YEAR_SPECIES_COUNT;
                        yield "";
                    }
                    default -> throw new AssertionError((Object)("Unexpected newFor " + newFor));
                }));
            } else if (newForSpecies.size() == 1) {
                Messages.Name format;
                text.append(Messages.getFormattedMessage(format, toString.apply(newForSpecies.iterator().next()), switch (newFor) {
                    case NewFor.world -> {
                        format = Messages.Name.IMPORT_NEW_FOR_WORLD_SPECIES_NAME;
                        yield "";
                    }
                    case NewFor.country -> {
                        format = Messages.Name.IMPORT_NEW_FOR_LOCATION_SPECIES_NAME;
                        yield this.countryLocation.getDisplayName();
                    }
                    case NewFor.state -> {
                        format = Messages.Name.IMPORT_NEW_FOR_LOCATION_SPECIES_NAME;
                        yield this.stateLocation.getDisplayName();
                    }
                    case NewFor.county -> {
                        format = Messages.Name.IMPORT_NEW_FOR_LOCATION_SPECIES_NAME;
                        yield this.countyLocation.getDisplayName();
                    }
                    case NewFor.site -> {
                        format = Messages.Name.IMPORT_NEW_FOR_LOCATION_SPECIES_NAME;
                        yield this.siteLocation.getDisplayName();
                    }
                    case NewFor.year -> {
                        format = Messages.Name.IMPORT_NEW_FOR_YEAR_SPECIES_NAME;
                        yield "";
                    }
                    default -> throw new AssertionError((Object)("Unexpected newFor " + newFor));
                }));
            } else {
                Messages.Name format;
                text.append(Messages.getFormattedMessage(format, newForSpecies.size(), newForSpecies.stream().map(toString).collect(Collectors.joining(", ")), switch (newFor) {
                    case NewFor.world -> {
                        format = Messages.Name.IMPORT_NEW_FOR_WORLD_SPECIES_COUNT_AND_NAMES;
                        yield "";
                    }
                    case NewFor.country -> {
                        format = Messages.Name.IMPORT_NEW_FOR_LOCATION_SPECIES_COUNT_AND_NAMES;
                        yield this.countryLocation.getDisplayName();
                    }
                    case NewFor.state -> {
                        format = Messages.Name.IMPORT_NEW_FOR_LOCATION_SPECIES_COUNT_AND_NAMES;
                        yield this.stateLocation.getDisplayName();
                    }
                    case NewFor.county -> {
                        format = Messages.Name.IMPORT_NEW_FOR_LOCATION_SPECIES_COUNT_AND_NAMES;
                        yield this.countyLocation.getDisplayName();
                    }
                    case NewFor.site -> {
                        format = Messages.Name.IMPORT_NEW_FOR_LOCATION_SPECIES_COUNT_AND_NAMES;
                        yield this.siteLocation.getDisplayName();
                    }
                    case NewFor.year -> {
                        format = Messages.Name.IMPORT_NEW_FOR_YEAR_SPECIES_COUNT_AND_NAMES;
                        yield "";
                    }
                    default -> throw new AssertionError((Object)("Unexpected newFor " + newFor));
                }));
            }
            text.append("<p>");
            return text.toString();
        }
    }

    static final class DuplicateSightingKey {
        private final ReadablePartial date;
        private final LocalTime startTime;
        private final String taxonomyId;
        private final int hashCode;
        private final String locationId;

        private DuplicateSightingKey(ReadablePartial date, LocalTime startTime, String taxonomyId, String locationId) {
            this.taxonomyId = taxonomyId;
            this.date = Preconditions.checkNotNull(date);
            this.startTime = startTime;
            this.locationId = locationId;
            this.hashCode = (date.hashCode() * 31 + (startTime == null ? 0 : startTime.hashCode()) * 31 + (locationId == null ? 0 : locationId.hashCode())) * 31 + taxonomyId.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DuplicateSightingKey)) {
                return false;
            }
            DuplicateSightingKey that = (DuplicateSightingKey)obj;
            return this.hashCode == that.hashCode && this.date.equals(that.date) && this.taxonomyId.equals(that.taxonomyId) && Objects.equal(this.locationId, that.locationId) && Objects.equal(this.startTime, that.startTime);
        }

        static DuplicateSightingKey forSighting(Sighting sighting) {
            if (sighting.getStartDateAsPartial() == null) {
                return null;
            }
            return new DuplicateSightingKey(sighting.getStartDateAsPartial(), sighting.getStoredTimeAsPartial(), sighting.getTaxonomy().getId(), null);
        }

        static DuplicateSightingKey forSightingWithLocation(Sighting sighting) {
            if (sighting.getStartDateAsPartial() == null) {
                return null;
            }
            return new DuplicateSightingKey(sighting.getStartDateAsPartial(), sighting.getStoredTimeAsPartial(), sighting.getTaxonomy().getId(), sighting.getLocationId());
        }
    }

    static enum NewFor {
        world,
        country,
        state,
        county,
        site,
        year;

    }
}

