/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.CharMatcher;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.ui.actions.ReturnAction;
import com.scythebill.birdlist.ui.components.ErrorLabel;
import com.scythebill.birdlist.ui.components.IndexerPanel;
import com.scythebill.birdlist.ui.components.NewLocationDialog;
import com.scythebill.birdlist.ui.components.PossiblyRequiredLabel;
import com.scythebill.birdlist.ui.components.ProgressSpinner;
import com.scythebill.birdlist.ui.components.WherePanel;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.imports.SightingsImporter;
import com.scythebill.birdlist.ui.imports.flickr.FlickrApiException;
import com.scythebill.birdlist.ui.imports.flickr.FlickrImporterFactory;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.LocationScorer;
import com.scythebill.birdlist.ui.util.OpenMapUrl;
import java.awt.Dimension;
import java.io.InterruptedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class ImportFlickrPanel
extends JPanel
implements FontManager.FontsUpdatedListener {
    private final FlickrImporterFactory flickrImporterFactory;
    private final ReportSet reportSet;
    private final NewLocationDialog newLocationDialog;
    private final PredefinedLocations predefinedLocations;
    private final ListeningExecutorService executorService;
    private final Alerts alerts;
    private JLabel topLabel;
    private JButton cancel;
    private JButton startImport;
    private JSeparator separator;
    private PossiblyRequiredLabel albumLabel;
    private JTextField albumField;
    private WherePanel wherePanel;
    private ImportReady importReadyCallback;
    private ProgressSpinner progressSpinner;
    private ErrorLabel urlErrorLabel;
    private final OpenMapUrl openMapUrl;
    private final LocationScorer locationScorer;
    private static final Pattern FLICKR_ALBUM_OR_PHOTOS_PATTERN = Pattern.compile("https://www.flickr.com/photos/.*/[0-9]+");

    @Inject
    public ImportFlickrPanel(FlickrImporterFactory flickrImporterFactory, ReturnAction returnAction, ReportSet reportSet, NewLocationDialog newLocationDialog, PredefinedLocations predefinedLocations, OpenMapUrl openMapUrl, Alerts alerts, ListeningExecutorService executorService, FontManager fontManager, LocationScorer locationScorer) {
        this.flickrImporterFactory = flickrImporterFactory;
        this.reportSet = reportSet;
        this.newLocationDialog = newLocationDialog;
        this.predefinedLocations = predefinedLocations;
        this.openMapUrl = openMapUrl;
        this.alerts = alerts;
        this.executorService = executorService;
        this.locationScorer = locationScorer;
        this.initGUI(fontManager);
        fontManager.applyTo(this);
        this.albumField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                ImportFlickrPanel.this.validateFields();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ImportFlickrPanel.this.validateFields();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ImportFlickrPanel.this.validateFields();
            }
        });
        this.cancel.addActionListener(returnAction);
        this.validateFields();
    }

    private void validateFields() {
        this.urlErrorLabel.setText("");
        String albumUrl = CharMatcher.whitespace().trimFrom(this.albumField.getText());
        if (albumUrl.isEmpty()) {
            this.startImport.setEnabled(false);
        } else if (!FLICKR_ALBUM_OR_PHOTOS_PATTERN.matcher(albumUrl).matches()) {
            this.startImport.setEnabled(false);
            this.urlErrorLabel.setText(Messages.getMessage(Messages.Name.NOT_A_VALID_FLICKR_ALBUM_URL));
        } else {
            try {
                new URI(albumUrl);
                this.startImport.setEnabled(true);
            }
            catch (URISyntaxException e) {
                this.startImport.setEnabled(false);
                this.urlErrorLabel.setText(Messages.getMessage(Messages.Name.NOT_A_VALID_FLICKR_ALBUM_URL));
            }
        }
    }

    private void initGUI(FontManager fontManager) {
        this.topLabel = new JLabel("<html>" + Messages.getMessage(Messages.Name.FLICKR_IMPORT_INSTRUCTIONS));
        this.topLabel.putClientProperty("birdlist.plainLabel", true);
        this.albumLabel = new PossiblyRequiredLabel(Messages.getMessage(Messages.Name.FLICKR_ALBUM_URL_LABEL));
        this.albumLabel.setRequired(true);
        this.albumField = new JTextField(50);
        this.urlErrorLabel = new ErrorLabel();
        this.wherePanel = new WherePanel(this.reportSet, this.newLocationDialog, this.predefinedLocations, this.openMapUrl, this.locationScorer, "(None)");
        this.wherePanel.setWhereLayoutStrategy(IndexerPanel.LayoutStrategy.BELOW);
        this.cancel = new JButton();
        this.cancel.setText(Messages.getMessage(Messages.Name.CANCEL_IMPORT));
        this.separator = new JSeparator();
        this.progressSpinner = new ProgressSpinner();
        this.startImport = new JButton();
        this.startImport.setText(Messages.getMessage(Messages.Name.START_BUTTON));
        this.startImport.addActionListener(e -> this.tryStart());
    }

    public void start(ImportReady importReadyCallback) {
        this.importReadyCallback = importReadyCallback;
    }

    private void tryStart() {
        String albumUrl = CharMatcher.whitespace().trimFrom(this.albumField.getText());
        this.progressSpinner.start();
        Future future = this.executorService.submit(() -> this.flickrImporterFactory.newFlickrImporter(albumUrl, this.wherePanel.getWhere()));
        Futures.addCallback(future, new FutureCallback<SightingsImporter<?>>(){

            @Override
            public void onFailure(Throwable t) {
                SwingUtilities.invokeLater(() -> {
                    ImportFlickrPanel.this.progressSpinner.stop();
                    if (t instanceof FlickrApiException && ((FlickrApiException)t).getCode() == 1) {
                        ImportFlickrPanel.this.alerts.showError((Object)ImportFlickrPanel.this, Messages.Name.FLICKR_ALBUM_LOAD_FAILED_TITLE, Messages.Name.FLICKR_ALBUM_LOAD_FAILED_MESSAGE, new Object[0]);
                    } else if (t instanceof InterruptedIOException) {
                        ImportFlickrPanel.this.alerts.showError((Object)ImportFlickrPanel.this, Messages.Name.FLICKR_ALBUM_LOAD_FAILED_TITLE, Messages.Name.FLICKR_ALBUM_LOAD_TIMEOUT_MESSAGE, new Object[0]);
                    } else {
                        ImportFlickrPanel.this.alerts.showError((Object)ImportFlickrPanel.this, t, Messages.Name.FLICKR_ALBUM_LOAD_FAILED_TITLE, Messages.Name.FLICKR_ALBUM_LOAD_FAILED_UNEXPECTED_MESSAGE, new Object[0]);
                    }
                });
            }

            @Override
            public void onSuccess(SightingsImporter<?> importer) {
                SwingUtilities.invokeLater(() -> {
                    ImportFlickrPanel.this.progressSpinner.stop();
                    ImportFlickrPanel.this.importReadyCallback.importReady(importer);
                });
            }
        }, this.executorService);
    }

    @Override
    public void fontsUpdated(FontManager fontManager) {
        this.setPreferredSize(fontManager.scale(new Dimension(900, 600)));
        int spinnerSize = fontManager.scale(30);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.topLabel).addComponent(this.albumLabel).addGroup(layout.createSequentialGroup().addComponent(this.albumField, -2, -2, -2).addComponent(this.progressSpinner, spinnerSize, spinnerSize, spinnerSize)).addComponent(this.urlErrorLabel).addComponent(this.wherePanel).addComponent(this.separator).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.cancel).addGap(0, fontManager.scale(75), Short.MAX_VALUE).addComponent(this.startImport)));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.topLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.albumLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createBaselineGroup(false, false).addComponent(this.albumField, -2, -2, -2).addComponent(this.progressSpinner, spinnerSize, spinnerSize, spinnerSize)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.urlErrorLabel).addGap(fontManager.scale(30)).addComponent(this.wherePanel).addGap(18, 18, Short.MAX_VALUE).addComponent(this.separator, -2, -2, -2).addGroup(layout.createBaselineGroup(false, false).addComponent(this.cancel).addComponent(this.startImport)));
        layout.linkSize(this.cancel, this.startImport);
    }

    public static interface ImportReady {
        public void importReady(SightingsImporter<?> var1);
    }
}

