/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.edits.ChosenUsers;
import com.scythebill.birdlist.model.user.User;
import com.scythebill.birdlist.model.user.UserSet;
import com.scythebill.birdlist.ui.actions.ReturnAction;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.UserChipsUi;
import com.scythebill.birdlist.ui.panels.UserDialog;
import com.scythebill.birdlist.ui.prefs.ReportSetPreference;
import java.util.function.Consumer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;

class ImportChooseUsersPanel
extends JPanel
implements FontManager.FontsUpdatedListener {
    private JButton cancel;
    private JButton ok;
    private JButton newUser;
    private JLabel topLabel;
    private UserSet userSet;
    private UserChipsUi userChipsUi;
    private JSeparator separator;
    private Consumer<ImmutableSet<User>> resultsConsumer;
    private final ReportSetPreference<ChosenUsers> chosenUsersPreference;
    private final UserDialog userDialog;

    @Inject
    public ImportChooseUsersPanel(ReturnAction returnAction, ReportSet reportSet, ReportSetPreference<ChosenUsers> chosenUsersPreference, UserDialog userDialog, FontManager fontManager) {
        this.userDialog = userDialog;
        this.userSet = Preconditions.checkNotNull(reportSet.getUserSet());
        this.chosenUsersPreference = chosenUsersPreference;
        this.initGUI(fontManager);
        fontManager.applyTo(this);
        this.newUser.addActionListener(e -> this.newUser());
        this.cancel.addActionListener(returnAction);
        this.ok.addActionListener(e -> {
            ImmutableSet<User> users = ImmutableSet.copyOf(this.userChipsUi.userChips.getChips());
            ((ChosenUsers)chosenUsersPreference.get()).setUsers(users);
            chosenUsersPreference.save(false);
            this.resultsConsumer.accept(users);
        });
    }

    public void chooseUsers(Consumer<ImmutableSet<User>> results) {
        this.resultsConsumer = results;
    }

    private void newUser() {
        this.userDialog.showUserDialog(this, Messages.getMessage(Messages.Name.NEW_USER), this.userSet, null, userBuilder -> {
            User user = this.userSet.addUser(userBuilder);
            this.userChipsUi.userChips.addChip(user);
        });
    }

    private void initGUI(FontManager fontManager) {
        this.topLabel = new JLabel("<html>" + Messages.getMessage(Messages.Name.NEW_USER_IMPORT_HELP_MESSAGE));
        this.topLabel.putClientProperty("birdlist.plainLabel", true);
        this.userChipsUi = new UserChipsUi(this.userSet, fontManager);
        this.userChipsUi.userChips.addAllChips(this.chosenUsersPreference.get().getUsers(this.userSet));
        this.separator = new JSeparator();
        this.cancel = new JButton();
        this.cancel.setText(Messages.getMessage(Messages.Name.CANCEL_IMPORT));
        this.ok = new JButton();
        this.ok.setText(Messages.getMessage(Messages.Name.OK_BUTTON));
        this.newUser = new JButton();
        this.newUser.setText(Messages.getMessage(Messages.Name.NEW_OBSERVER));
    }

    @Override
    public void fontsUpdated(FontManager fontManager) {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.topLabel).addGroup(layout.createSequentialGroup().addComponent(this.userChipsUi.userLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.userChipsUi.userIndexer).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.userChipsUi.addUserButton)).addComponent(this.userChipsUi.userChipsScrollPane, fontManager.scale(400), fontManager.scale(400), fontManager.scale(400)).addComponent(this.newUser, -2, -2, -2).addComponent(this.separator).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.cancel).addGap(0, fontManager.scale(75), Short.MAX_VALUE).addComponent(this.ok)));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.topLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createBaselineGroup(false, false).addComponent(this.userChipsUi.userLabel, -2, -2, -2).addComponent(this.userChipsUi.userIndexer, -2, -2, -2).addComponent(this.userChipsUi.addUserButton, -2, -2, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.userChipsUi.userChipsScrollPane, fontManager.scale(80), -2, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.newUser).addGap(18).addComponent(this.separator).addGroup(layout.createBaselineGroup(false, false).addComponent(this.cancel).addComponent(this.ok)));
        layout.linkSize(this.cancel, this.ok, this.newUser);
    }
}

