/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.io.CsvImportLines;
import com.scythebill.birdlist.model.io.ImportLines;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.Photo;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingInfo;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.imports.ComputedMappings;
import com.scythebill.birdlist.ui.imports.CsvSightingsImporter;
import com.scythebill.birdlist.ui.imports.DateFromStringFieldMapper;
import com.scythebill.birdlist.ui.imports.DescriptionFieldMapper;
import com.scythebill.birdlist.ui.imports.FieldMapper;
import com.scythebill.birdlist.ui.imports.FieldTaxonImporter;
import com.scythebill.birdlist.ui.imports.ImportException;
import com.scythebill.birdlist.ui.imports.ImportedLocation;
import com.scythebill.birdlist.ui.imports.LineExtractor;
import com.scythebill.birdlist.ui.imports.LineExtractors;
import com.scythebill.birdlist.ui.imports.RowExtractor;
import com.scythebill.birdlist.ui.imports.SightingsImporter;
import com.scythebill.birdlist.ui.imports.TaxonImporter;
import com.scythebill.birdlist.ui.messages.Messages;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class INaturalistImporter
extends CsvSightingsImporter {
    private static final Logger logger = Logger.getLogger(INaturalistImporter.class.getName());
    private LineExtractor<String> locationIdExtractor;
    private LineExtractor<String> taxonomyIdExtractor;
    private LineExtractor<String> commonNameExtractor;
    private LineExtractor<String> scientificExtractor;
    private LineExtractor<String> subspeciesExtractor;
    private LineExtractor<String> countryExtractor;
    private LineExtractor<String> stateExtractor;
    private LineExtractor<String> countyExtractor;
    private LineExtractor<String> locationExtractor;
    private LineExtractor<String> latitudeExtractor;
    private LineExtractor<String> longitudeExtractor;
    private LineExtractor<String> classExtractor;
    private String chosenClass = "Mammalia";

    public INaturalistImporter(ReportSet reportSet, Taxonomy taxonomy, Checklists checklists, PredefinedLocations predefinedLocations, File file) {
        super(reportSet, taxonomy, checklists, predefinedLocations, file, file);
    }

    protected LineExtractor<? extends Object> taxonomyIdExtractor() {
        return this.taxonomyIdExtractor;
    }

    @Override
    protected TaxonImporter<String[]> newTaxonImporter(Taxonomy taxonomy) {
        return new FieldTaxonImporter<String[]>(taxonomy, this.commonNameExtractor, this.scientificExtractor, this.subspeciesExtractor);
    }

    @Override
    protected void parseLocationIds(LocationSet locations, PredefinedLocations predefinedLocations) throws IOException {
        try (ImportLines lines = CsvImportLines.fromFile(this.locationsFile, this.getCharset());){
            Object[] line;
            this.computeMappings(lines);
            while ((line = lines.nextLine()) != null) {
                try {
                    String id = (String)this.locationIdExtractor.extract((String)line);
                    if (this.locationIds.hasBeenParsed(id)) continue;
                    ImportedLocation imported = new ImportedLocation();
                    imported.state = (String)this.stateExtractor.extract((String)line);
                    imported.county = (String)this.countyExtractor.extract((String)line);
                    imported.country = (String)this.countryExtractor.extract((String)line);
                    String location = (String)this.locationExtractor.extract((String)line);
                    if (!Strings.isNullOrEmpty(location)) {
                        int commaIndex = location.indexOf(44);
                        if (commaIndex > 0) {
                            location = location.substring(0, commaIndex);
                        }
                        imported.locationNames.add(location);
                    }
                    imported.latitude = Strings.emptyToNull((String)this.latitudeExtractor.extract((String)line));
                    imported.longitude = Strings.emptyToNull((String)this.longitudeExtractor.extract((String)line));
                    String locationId = imported.addToLocationSet(this.reportSet, locations, this.locationShortcuts, predefinedLocations);
                    this.locationIds.put((Object)id, locationId);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Failed to import location " + Joiner.on(',').join(line), e);
                }
            }
        }
    }

    @Override
    protected ComputedMappings<String[]> computeMappings(ImportLines lines) throws IOException {
        String[] header = lines.nextLine();
        LinkedHashMap<String, Integer> headersByIndex = new LinkedHashMap<String, Integer>();
        for (int i = 0; i < header.length; ++i) {
            headersByIndex.put(CharMatcher.whitespace().removeFrom(header[i]).toLowerCase(), i);
        }
        ArrayList mappers = Lists.newArrayList();
        Integer commonIndex = (Integer)headersByIndex.get("common_name");
        Integer sciIndex = (Integer)headersByIndex.get("taxon_species_name");
        Integer sspIndex = (Integer)headersByIndex.get("taxon_subspecies_name");
        int dateIndex = this.getRequiredHeader(headersByIndex, "observed_on");
        Integer photosIndex = (Integer)headersByIndex.get("image_url");
        Integer descriptionIndex = (Integer)headersByIndex.get("description");
        int countryIndex = this.getRequiredHeader(headersByIndex, "place_country_name");
        Integer stateIndex = (Integer)headersByIndex.get("place_state_name");
        Integer placeAdmin1Index = (Integer)headersByIndex.get("place_admin1_name");
        Integer countyIndex = (Integer)headersByIndex.get("place_county_name");
        Integer placeAdmin2Index = (Integer)headersByIndex.get("place_admin2_name");
        Integer latitudeIndex = (Integer)headersByIndex.get("latitude");
        Integer privateLatitudeIndex = (Integer)headersByIndex.get("private_latitude");
        Integer longitudeIndex = (Integer)headersByIndex.get("longitude");
        Integer privateLongitudeIndex = (Integer)headersByIndex.get("private_longitude");
        Integer captiveCultivatedIndex = (Integer)headersByIndex.get("captive_cultivated");
        int classIndex = this.getRequiredHeader(headersByIndex, "taxon_class_name");
        Integer placeGuessIndex = (Integer)headersByIndex.get("place_guess");
        Integer privatePlaceGuessIndex = (Integer)headersByIndex.get("private_place_guess");
        if (commonIndex == null && sciIndex == null) {
            throw new ImportException(Messages.getMessage(Messages.Name.SCYTHEBILL_IMPORT_NEITHER_SCIENTIFIC_NOR_COMMON));
        }
        this.commonNameExtractor = commonIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(commonIndex);
        this.scientificExtractor = sciIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(sciIndex);
        LineExtractor rawSspExtractor = sspIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(sspIndex);
        this.subspeciesExtractor = line -> {
            String s = (String)rawSspExtractor.extract(line);
            if (!Strings.isNullOrEmpty(s)) {
                int lastSpace = s.lastIndexOf(32);
                if (lastSpace > 0) {
                    return s.substring(lastSpace + 1);
                }
                return s;
            }
            return null;
        };
        this.taxonomyIdExtractor = LineExtractors.joined(Joiner.on('|').useForNull(""), ImmutableList.of(this.commonNameExtractor, this.scientificExtractor, this.subspeciesExtractor));
        this.classExtractor = LineExtractors.stringFromIndex(classIndex);
        this.countryExtractor = LineExtractors.stringFromIndex(countryIndex);
        this.stateExtractor = LineExtractors.firstNonEmpty(stateIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(stateIndex), placeAdmin1Index == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(placeAdmin1Index));
        this.countyExtractor = LineExtractors.firstNonEmpty(countyIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(countyIndex), placeAdmin2Index == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(placeAdmin2Index));
        this.locationExtractor = LineExtractors.firstNonEmpty(privatePlaceGuessIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(privatePlaceGuessIndex), placeGuessIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(placeGuessIndex));
        ArrayList<RowExtractor<String[], String>> allLocationExtractors = Lists.newArrayList();
        allLocationExtractors.add(this.countryExtractor);
        allLocationExtractors.add(this.stateExtractor);
        allLocationExtractors.add(this.countyExtractor);
        allLocationExtractors.add(this.locationExtractor);
        this.locationIdExtractor = LineExtractors.joined(Joiner.on('|').useForNull(""), allLocationExtractors);
        this.latitudeExtractor = LineExtractors.firstNonEmpty(privateLatitudeIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(privateLatitudeIndex), latitudeIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(latitudeIndex));
        this.longitudeExtractor = LineExtractors.firstNonEmpty(privateLongitudeIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(privateLongitudeIndex), longitudeIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(longitudeIndex));
        if (descriptionIndex != null) {
            mappers.add(new DescriptionFieldMapper(LineExtractors.stringFromIndex(descriptionIndex)));
        }
        if (photosIndex != null) {
            mappers.add(new PhotosMapper(LineExtractors.stringFromIndex(photosIndex)));
        }
        if (captiveCultivatedIndex != null) {
            final LineExtractor<String> captiveCultivatedExtractor = LineExtractors.stringFromIndex(captiveCultivatedIndex);
            mappers.add(new FieldMapper<String[]>(){

                @Override
                public void map(String[] line, Sighting.Builder sighting) {
                    String captiveCultivated = (String)captiveCultivatedExtractor.extract(line);
                    if (captiveCultivated != null && "true".equalsIgnoreCase(captiveCultivated)) {
                        sighting.getSightingInfo().setSightingStatus(SightingInfo.SightingStatus.DOMESTIC);
                    }
                }
            });
        }
        mappers.add(new DateFromStringFieldMapper("yy-MM-dd", LineExtractors.stringFromIndex(dateIndex)));
        return new ComputedMappings<String[]>(new SightingsImporter.TaxonFieldMapper(this.taxonomyIdExtractor), new SightingsImporter.LocationMapper(this.locationIdExtractor), mappers);
    }

    @Override
    protected String[] getHeaderRow(ImportLines lines) throws IOException {
        return lines.nextLine();
    }

    @Override
    protected boolean skipLine(String[] line) {
        if (!this.chosenClass.equals(this.classExtractor.extract((String)line))) {
            return true;
        }
        return Strings.isNullOrEmpty((String)this.scientificExtractor.extract((String)line));
    }

    public Set<String> findAllClasses(File sightingsFile) {
        if (this.getTaxonomy().isBuiltIn()) {
            return ImmutableSet.of("Aves");
        }
        try {
            ImportLines lines = CsvImportLines.fromFile(sightingsFile, this.getCharset());
            this.computeMappings(lines);
            TreeSet<String> classes = new TreeSet<String>();
            while (true) {
                String[] line;
                if ((line = lines.nextLine()) == null) {
                    if (classes.contains("Aves") && classes.size() > 1) {
                        classes.remove("Aves");
                    }
                    return classes;
                }
                String className = (String)this.classExtractor.extract((String)line);
                if (Strings.isNullOrEmpty(className)) continue;
                classes.add(className);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void chooseClass(String className) {
        this.chosenClass = className;
    }

    static class PhotosMapper
    implements FieldMapper<String[]> {
        private final LineExtractor<String> extractor;

        PhotosMapper(LineExtractor<String> extractor) {
            this.extractor = extractor;
        }

        @Override
        public void map(String[] line, Sighting.Builder sighting) {
            String photoString = Strings.emptyToNull((String)this.extractor.extract((String)line));
            if (photoString != null) {
                try {
                    URI uri = new URI(photoString);
                    sighting.getSightingInfo().setPhotos(ImmutableList.of(new Photo(uri)));
                    sighting.getSightingInfo().setPhotographed(true);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        }
    }
}

