/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multisets;
import com.google.common.io.Files;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.io.ImportLines;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.Locations;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingInfo;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.imports.ComputedMappings;
import com.scythebill.birdlist.ui.imports.CountFieldMapper;
import com.scythebill.birdlist.ui.imports.CsvSightingsImporter;
import com.scythebill.birdlist.ui.imports.DateFromStringFieldMapper;
import com.scythebill.birdlist.ui.imports.DescriptionFieldMapper;
import com.scythebill.birdlist.ui.imports.FieldMapper;
import com.scythebill.birdlist.ui.imports.FieldTaxonImporter;
import com.scythebill.birdlist.ui.imports.HbwImportLines;
import com.scythebill.birdlist.ui.imports.HeardOnlyFieldMapper;
import com.scythebill.birdlist.ui.imports.ImportedLocation;
import com.scythebill.birdlist.ui.imports.LineExtractor;
import com.scythebill.birdlist.ui.imports.LineExtractors;
import com.scythebill.birdlist.ui.imports.LocationShortcuts;
import com.scythebill.birdlist.ui.imports.ParsedLocationIds;
import com.scythebill.birdlist.ui.imports.SightingsImporter;
import com.scythebill.birdlist.ui.imports.TaxonImporter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.chrono.GJChronology;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

class HbwImporter
extends CsvSightingsImporter {
    private LineExtractor<String> taxonomyIdExtractor;
    private LineExtractor<String> commonNameExtractor;
    private LineExtractor<String> scientificExtractor;
    private LineExtractor<String> subspeciesExtractor;
    private LineExtractor<String> territoryExtractor;
    private LineExtractor<String> birdlistExtractor;
    private LineExtractor<String> longitudeExtractor;
    private LineExtractor<String> latitudeExtractor;
    private LineExtractor<String> locationIdExtractor;
    private LineExtractor<String> dateExtractor;
    private FieldMapper<String[]> dateMapper;
    private static final Pattern PAREN_WITH_DATE_PATTERN = Pattern.compile("^(.+) \\(\\d\\d \\w\\w\\w \\d\\d\\d\\d\\)$");
    private static final Pattern PAREN_WITH_DATE_AND_TIME_PATTERN = Pattern.compile("^(.+) \\(\\d\\d \\w\\w\\w \\d\\d\\d\\d \\d\\d:\\d\\d\\)$");
    private static final ImmutableMap<String, String> NAME_TO_COUNTRY_AND_STATE_CODE = ImmutableMap.builder().put("Andaman and Nicobar", "IN-AN").put("Ascension Island", "SH-AC").put("Bali", "ID-NU-Bali").put("Bioko", "GQ-I").put("Bismarck Archipelago", "PG--Bismarck Archipelago").put("Borneo", "MY-12").put("Chagos Archipelago (British Indian Ocean Territory)", "IO--Chagos Archipelago").put("China (Northern)", "CN").put("China (Southern)", "CN").put("Comoro Islands", "KM").put("Congo Republic", "CG").put("Crozet Islands", "TF--Crozet Islands").put("Falkland (Malvinas) Islands", "FK").put("Federated States Micronesia", "FM").put("Galapagos Islands", "EC-W").put("Georgia (USA)", "US-GA").put("Hawaiian Islands", "US-HI").put("Java", "ID-JW").put("Johnston Island", "UM-67").put("Kalimantan", "ID-KM").put("Kerguelen Islands", "TF--Kerguelen Islands").put("Lesser Sundas", "ID-NU").put("Madeira Islands", "PT-30").put("Maldive Islands", "MV").put("Maluku Islands", "ID-MA").put("Mexico (Northern)", "MX").put("Mexico (Southern)", "MX").put("Netherlands Antilles", "BQ").put("New Guinea", "PG").put("North Solomons", "PG-NSA").put("Papua New Guinea (mainland)", "PG").put("Peninsular Malaysia", "MY").put("Prince Edward Islands", "CA-PE").put("Republic of Macedonia", "MK").put("Rodrigues", "MU-RO").put("Sabah", "MY-12").put("Saint Helena Island", "SH-SH").put("Saint Pierre and Miquelon", "PM").put("Sarawak", "MY-13").put("Solomon Archipelago", "SB").put("Solomon Islands (country)", "SB").put("South Georgia", "GS--South Georgia").put("South Sandwich Islands", "GS--South Sandwich Islands").put("St. Paul and Amsterdam Islands", "TF--St. Paul and Amsterdam Islands").put("Sulawesi", "ID-SL").put("Sumatra", "ID-SM").put("Svalbard Islands and Jan Mayen", "SJ").put("Timor-Leste", "TL").put("Tristan da Cunha Archipelago", "SH-TA").put("United States Virgin Islands", "VI").put("USA (United States)", "US").put("Virgin Islands", "VG").put("Wake Island", "UM-79").put("Washington DC", "US-DC").put("Washington State", "US-WA").put("West Papua (Indonesia)", "ID-IJ").put("West Timor", "ID-MA-West Timor").put("Yukon", "CA-YT").put("Zaire (Democratic Republic of the Congo)", "CD").build();

    protected HbwImporter(ReportSet reportSet, Taxonomy taxonomy, Checklists checklists, PredefinedLocations predefinedLocations, File file) {
        super(reportSet, taxonomy, checklists, predefinedLocations, file, file);
    }

    protected LineExtractor<? extends Object> taxonomyIdExtractor() {
        return this.taxonomyIdExtractor;
    }

    @Override
    protected TaxonImporter<String[]> newTaxonImporter(Taxonomy taxonomy) {
        return new FieldTaxonImporter<String[]>(taxonomy, this.commonNameExtractor, this.scientificExtractor, this.subspeciesExtractor);
    }

    @Override
    protected ComputedMappings<String[]> computeMappings(ImportLines lines) throws IOException {
        String[] header = lines.nextLine();
        HashMap<String, Integer> headersByIndex = Maps.newHashMap();
        CharMatcher trimmer = CharMatcher.whitespace().or(CharMatcher.is('-'));
        Function<String, String> transform = s -> trimmer.removeFrom((CharSequence)s).toLowerCase();
        for (int i = 0; i < header.length; ++i) {
            headersByIndex.put(transform.apply(header[i]), i);
        }
        ArrayList mappers = Lists.newArrayList();
        int commonIndex = this.getRequiredHeader(headersByIndex, "Common Name", transform);
        int sciIndex = this.getRequiredHeader(headersByIndex, "Scientific Name", transform);
        Integer sspIndex = (Integer)headersByIndex.get("ssp");
        Integer territoryIndex = (Integer)headersByIndex.get("territory");
        Integer birdlistIndex = (Integer)headersByIndex.get("birdlist");
        int dateIndex = this.getRequiredHeader(headersByIndex, "Date", transform);
        Integer latitudeIndex = (Integer)headersByIndex.get("latitude");
        Integer longitudeIndex = (Integer)headersByIndex.get("longitude");
        Integer heardOnlyIndex = (Integer)headersByIndex.get("heardonly");
        Integer photoIndex = (Integer)headersByIndex.get("photo");
        Integer videoIndex = (Integer)headersByIndex.get("video");
        Integer escapedIndex = (Integer)headersByIndex.get("escaped");
        Integer captiveIndex = (Integer)headersByIndex.get("captive");
        Integer countIndex = (Integer)headersByIndex.get("#");
        Integer notesIndex = (Integer)headersByIndex.get("notes");
        this.commonNameExtractor = LineExtractors.stringFromIndex(commonIndex);
        this.scientificExtractor = LineExtractors.stringFromIndex(sciIndex);
        this.subspeciesExtractor = sspIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(sspIndex);
        this.taxonomyIdExtractor = LineExtractors.joined(Joiner.on('|').useForNull(""), ImmutableList.of(this.commonNameExtractor, this.scientificExtractor, this.subspeciesExtractor));
        this.territoryExtractor = territoryIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(territoryIndex);
        this.birdlistExtractor = birdlistIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(birdlistIndex);
        this.locationIdExtractor = LineExtractors.joined(Joiner.on('|').useForNull(""), this.territoryExtractor, this.birdlistExtractor);
        this.dateExtractor = LineExtractors.stringFromIndex(dateIndex);
        mappers.add(new DelayedDateMapper());
        this.latitudeExtractor = latitudeIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(latitudeIndex);
        LineExtractor<Object> lineExtractor = this.longitudeExtractor = longitudeIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(longitudeIndex);
        if (notesIndex != null) {
            mappers.add(new DescriptionFieldMapper(LineExtractors.stringFromIndex(notesIndex)));
        }
        if (heardOnlyIndex != null) {
            mappers.add(new HeardOnlyFieldMapper(LineExtractors.booleanFromIndex(heardOnlyIndex)));
        }
        if (photoIndex != null || videoIndex != null) {
            final LineExtractor<Boolean> photoExtractor = photoIndex == null ? LineExtractors.constant(false) : LineExtractors.booleanFromIndex(photoIndex);
            final LineExtractor<Boolean> videoExtractor = videoIndex == null ? LineExtractors.constant(false) : LineExtractors.booleanFromIndex(videoIndex);
            mappers.add(new FieldMapper<String[]>(){

                @Override
                public void map(String[] line, Sighting.Builder sighting) {
                    boolean photo = (Boolean)photoExtractor.extract(line);
                    boolean video = (Boolean)videoExtractor.extract(line);
                    if (photo || video) {
                        sighting.getSightingInfo().setPhotographed(true);
                    }
                }
            });
        }
        if (escapedIndex != null || captiveIndex != null) {
            final LineExtractor<Boolean> escapedExtractor = escapedIndex == null ? LineExtractors.constant(false) : LineExtractors.booleanFromIndex(escapedIndex);
            final LineExtractor<Boolean> captiveExtractor = captiveIndex == null ? LineExtractors.constant(false) : LineExtractors.booleanFromIndex(captiveIndex);
            mappers.add(new FieldMapper<String[]>(){

                @Override
                public void map(String[] line, Sighting.Builder sighting) {
                    boolean escaped = (Boolean)escapedExtractor.extract(line);
                    boolean captive = (Boolean)captiveExtractor.extract(line);
                    if (escaped) {
                        sighting.getSightingInfo().setSightingStatus(SightingInfo.SightingStatus.INTRODUCED_NOT_ESTABLISHED);
                    } else if (captive) {
                        sighting.getSightingInfo().setSightingStatus(SightingInfo.SightingStatus.DOMESTIC);
                    }
                }
            });
        }
        if (countIndex != null) {
            mappers.add(new CountFieldMapper(LineExtractors.stringFromIndex(countIndex)));
        }
        return new ComputedMappings<String[]>(new SightingsImporter.TaxonFieldMapper(this.taxonomyIdExtractor), new SightingsImporter.LocationMapper(this.locationIdExtractor), mappers);
    }

    @Override
    protected void computeExtendedMappings() throws IOException {
        if (this.dateMapper != null) {
            return;
        }
        LinkedHashMap<String, DateTimeFormatter> patternToFormatter = new LinkedHashMap<String, DateTimeFormatter>();
        for (String pattern : ImmutableList.of("dd/MM/yy", "MM/dd/yy")) {
            patternToFormatter.put(pattern, DateTimeFormat.forPattern(pattern).withChronology(GJChronology.getInstance()).withPivotYear(2000));
        }
        try (ImportLines lines = this.importLines(this.sightingsFile);){
            String[] nextLine;
            HashMultiset<String> successfulPatterns = HashMultiset.create();
            while ((nextLine = lines.nextLine()) != null) {
                String date = (String)this.dateExtractor.extract((String)nextLine);
                if (Strings.isNullOrEmpty(date)) continue;
                for (Map.Entry entry : patternToFormatter.entrySet()) {
                    try {
                        ((DateTimeFormatter)entry.getValue()).parseLocalDate(date);
                        successfulPatterns.add((String)entry.getKey());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
            String bestPattern = (String)Multisets.copyHighestCountFirst(successfulPatterns).iterator().next();
            this.dateMapper = new DateFromStringFieldMapper<String[]>(bestPattern, this.dateExtractor);
        }
    }

    static String maybeRemoveDateOrDateAndTime(String birdlistId) {
        if (Strings.isNullOrEmpty(birdlistId)) {
            return birdlistId;
        }
        Matcher dateMatcher = PAREN_WITH_DATE_PATTERN.matcher(birdlistId);
        if (dateMatcher.matches()) {
            return dateMatcher.group(1);
        }
        Matcher dateAndTimeMatcher = PAREN_WITH_DATE_AND_TIME_PATTERN.matcher(birdlistId);
        if (dateAndTimeMatcher.matches()) {
            return dateAndTimeMatcher.group(1);
        }
        return birdlistId;
    }

    @Override
    protected void parseLocationIds(LocationSet locations, PredefinedLocations predefinedLocations) throws IOException {
        try (ImportLines lines = this.importLines(this.locationsFile);){
            String[] line;
            this.computeMappings(lines);
            while ((line = lines.nextLine()) != null) {
                String locationId;
                String id;
                if (this.skipLine(line) || this.locationIds.hasBeenParsed(id = (String)this.locationIdExtractor.extract((String)line))) continue;
                String territory = (String)this.territoryExtractor.extract((String)line);
                String birdlist = HbwImporter.maybeRemoveDateOrDateAndTime((String)this.birdlistExtractor.extract((String)line));
                if (territory == null) {
                    if (Strings.isNullOrEmpty(birdlist)) {
                        String fileName = this.locationsFile.getName();
                        int period = fileName.lastIndexOf(46);
                        if (period >= 0) {
                            fileName = fileName.substring(0, period);
                        }
                        if (fileName.endsWith(" HBW")) {
                            fileName = fileName.substring(0, fileName.length() - 4);
                        }
                        birdlist = fileName;
                    }
                    ImportedLocation importedLocation = new ImportedLocation();
                    importedLocation.locationNames.add(birdlist);
                    importedLocation.latitude = (String)this.latitudeExtractor.extract((String)line);
                    importedLocation.longitude = (String)this.longitudeExtractor.extract((String)line);
                    locationId = importedLocation.tryAddToLocationSetWithLatLong(this.reportSet, locations, this.locationShortcuts, predefinedLocations);
                    if (locationId != null) {
                        this.locationIds.put((Object)id, locationId);
                        continue;
                    }
                    this.locationIds.addToBeResolvedLocationName(id, new ParsedLocationIds.ToBeDecided(birdlist, importedLocation.getLatLong()));
                    continue;
                }
                ImportedLocation imported = HbwImporter.importedLocation(this.locationShortcuts, territory);
                if (imported == null) {
                    Collection<Location> anyLocations = this.locationShortcuts.getAnyLocationFromName(territory);
                    if (!anyLocations.isEmpty()) {
                        Location parentLocation = anyLocations.iterator().next();
                        parentLocation = Locations.normalizeLocation(parentLocation, locations);
                        locations.ensureAdded(parentLocation);
                        Location location = parentLocation;
                        if (!Strings.isNullOrEmpty(birdlist)) {
                            for (String sublocation : Splitter.on("--").split(birdlist)) {
                                if (sublocation.equals(territory)) continue;
                                Location childLocation = parentLocation.getContent(sublocation);
                                if (childLocation == null) {
                                    childLocation = Location.builder().setParent(parentLocation).setName(sublocation).build();
                                    locations.ensureAdded(childLocation);
                                }
                                location = childLocation;
                            }
                        }
                        this.locationIds.put((Object)id, location.getId());
                        continue;
                    }
                    imported = new ImportedLocation();
                    imported.country = territory;
                }
                if (!Strings.isNullOrEmpty(birdlist)) {
                    for (String sublocation : Splitter.on("--").split(birdlist)) {
                        if (sublocation.equals(territory)) continue;
                        imported.locationNames.add(sublocation);
                    }
                }
                imported.longitude = Strings.emptyToNull((String)this.longitudeExtractor.extract((String)line));
                imported.latitude = Strings.emptyToNull((String)this.latitudeExtractor.extract((String)line));
                locationId = imported.addToLocationSet(this.reportSet, locations, this.locationShortcuts, predefinedLocations);
                this.locationIds.put((Object)id, locationId);
            }
        }
    }

    @Override
    protected ImportLines importLines(File file) throws IOException {
        if (file.getName().endsWith(".xlsx")) {
            return HbwImportLines.importHbwXlsx(Files.asByteSource(file));
        }
        return HbwImportLines.importHbwXls(Files.asByteSource(file));
    }

    static ImportedLocation importedLocation(LocationShortcuts locationShortcuts, String territory) {
        if (territory == null) {
            return null;
        }
        if (locationShortcuts.getCountryInexactMatch(territory, null, null) != null) {
            ImportedLocation imported = new ImportedLocation();
            imported.country = territory;
            return imported;
        }
        if (locationShortcuts.getStateByName("US", territory) != null) {
            ImportedLocation imported = new ImportedLocation();
            imported.countryCode = "US";
            return imported;
        }
        if (locationShortcuts.getStateByName("CA", territory) != null) {
            ImportedLocation imported = new ImportedLocation();
            imported.countryCode = "CA";
            return imported;
        }
        if ("Russia (Eastern)".equals(territory)) {
            ImportedLocation imported = new ImportedLocation();
            imported.region = "Asia";
            imported.countryCode = "RU";
            return imported;
        }
        if ("Russia (Western)".equals(territory)) {
            ImportedLocation imported = new ImportedLocation();
            imported.region = "Europe";
            imported.countryCode = "RU";
            return imported;
        }
        if (NAME_TO_COUNTRY_AND_STATE_CODE.containsKey(territory)) {
            List<String> countryAndStateCode = Splitter.on('-').splitToList(NAME_TO_COUNTRY_AND_STATE_CODE.get(territory));
            ImportedLocation imported = new ImportedLocation();
            imported.countryCode = countryAndStateCode.get(0);
            if (countryAndStateCode.size() > 1) {
                imported.stateCode = Strings.emptyToNull(countryAndStateCode.get(1));
            }
            if (countryAndStateCode.size() > 2) {
                imported.locationNames.add(countryAndStateCode.get(2));
            }
            return imported;
        }
        return null;
    }

    class DelayedDateMapper
    implements FieldMapper<String[]> {
        DelayedDateMapper() {
        }

        @Override
        public void map(String[] line, Sighting.Builder sighting) {
            HbwImporter.this.dateMapper.map(line, sighting);
        }
    }
}

