/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.Strings;
import com.google.common.io.ByteSource;
import com.google.common.io.Files;
import com.scythebill.birdlist.model.io.ImportLines;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class HbwImportLines {
    HbwImportLines() {
    }

    public static void main(String[] args) throws Exception {
        try (ImportLines importLines = HbwImportLines.importHbwXls(Files.asByteSource(new File("/Users/awiner/Downloads/HBW_Alive-sightings-20190225.xls")));){
            String[] line;
            while ((line = importLines.nextLine()) != null) {
                System.out.println(importLines.lineNumber() + ": " + Arrays.asList(line));
            }
        }
    }

    public static ImportLines importHbwXls(ByteSource byteSource) throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        InputStream inputStream = byteSource.openBufferedStream();
        try {
            InputSource source = new InputSource(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            Document document = factory.newDocumentBuilder().parse(source);
            HbwXlsImportLines hbwXlsImportLines = new HbwXlsImportLines(document);
            return hbwXlsImportLines;
        }
        catch (SAXException e) {
            throw new IOException("Unexpected file contents", e);
        }
        catch (ParserConfigurationException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    public static ImportLines importHbwXlsx(ByteSource byteSource) throws IOException {
        try (InputStream inputStream = byteSource.openBufferedStream();){
            HbwXlsxImportLines hbwXlsxImportLines;
            XSSFWorkbook workbook = new XSSFWorkbook(byteSource.openStream());
            try {
                XSSFSheet sheet = workbook.getSheetAt(0);
                hbwXlsxImportLines = new HbwXlsxImportLines(sheet);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        workbook.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (SAXParseException e) {
                    throw new IOException("Could not parse HBW XSLX file", e);
                }
            }
            workbook.close();
            return hbwXlsxImportLines;
        }
    }

    static class HbwXlsImportLines
    implements ImportLines {
        private int rowNum;
        private final List<String[]> lines;
        private final boolean trim;

        HbwXlsImportLines(Document document) throws SAXParseException {
            this.lines = this.parseDocument(document);
            this.rowNum = 0;
            this.trim = true;
        }

        public HbwXlsImportLines(List<String[]> lines, boolean trim) {
            this.lines = lines;
            this.rowNum = 0;
            this.trim = trim;
        }

        private List<String[]> parseDocument(Document document) throws SAXParseException {
            ArrayList<String[]> lines = new ArrayList<String[]>();
            NodeList rowElements = document.getElementsByTagName("tr");
            for (int i = 0; i < rowElements.getLength(); ++i) {
                Node node = rowElements.item(i);
                lines.add(this.parseRow(node));
            }
            return lines;
        }

        private String[] parseRow(Node node) throws SAXParseException {
            ArrayList<String> text = new ArrayList<String>();
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 1) continue;
                text.add(this.getTextContent(child));
            }
            return text.toArray(new String[text.size()]);
        }

        private String getTextContent(Node child) {
            String textContent = child.getTextContent();
            if (this.trim) {
                textContent = textContent.trim();
            }
            return textContent;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public String[] nextLine() throws IOException {
            if (this.rowNum >= this.lines.size()) {
                return null;
            }
            return this.lines.get(this.rowNum++);
        }

        @Override
        public int lineNumber() {
            return this.rowNum;
        }

        @Override
        public ImportLines withoutTrimming() {
            return new HbwXlsImportLines(this.lines, false);
        }
    }

    static class HbwXlsxImportLines
    implements ImportLines {
        private int rowNum;
        private final boolean trim;
        private final DataFormatter df = new DataFormatter();
        private XSSFSheet sheet;

        HbwXlsxImportLines(XSSFSheet sheet) throws SAXParseException {
            this(sheet, true);
        }

        public HbwXlsxImportLines(XSSFSheet sheet, boolean trim) {
            this.sheet = sheet;
            this.rowNum = sheet.getFirstRowNum();
            this.trim = trim;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public String[] nextLine() throws IOException {
            XSSFRow row;
            if (this.rowNum > this.sheet.getLastRowNum()) {
                return null;
            }
            if ((row = this.sheet.getRow(this.rowNum++)) == null) {
                return null;
            }
            String[] line = new String[row.getLastCellNum() - row.getFirstCellNum()];
            for (int i = row.getFirstCellNum(); i < row.getLastCellNum(); ++i) {
                XSSFCell cell = row.getCell(i);
                if (cell == null) continue;
                String cellValue = this.df.formatCellValue(cell);
                if (this.trim) {
                    cellValue = cellValue.trim();
                }
                line[i - row.getFirstCellNum()] = cellValue;
            }
            for (String cell : line) {
                if (Strings.isNullOrEmpty(cell)) continue;
                return line;
            }
            return null;
        }

        @Override
        public int lineNumber() {
            return this.rowNum;
        }

        @Override
        public ImportLines withoutTrimming() {
            return new HbwXlsxImportLines(this.sheet, false);
        }
    }
}

