/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.imports.RowExtractor;
import com.scythebill.birdlist.ui.imports.RowExtractors;
import com.scythebill.birdlist.ui.imports.TaxonImporter;
import com.scythebill.birdlist.ui.imports.TaxonPossibilities;
import com.scythebill.birdlist.ui.imports.TaxonResolver;
import javax.annotation.Nullable;

public class FieldTaxonImporter<T>
extends TaxonImporter<T> {
    private final RowExtractor<T, String> commonNameExtractor;
    private final RowExtractor<T, String> sciNameExtractor;
    private final RowExtractor<T, String> subspecies;
    private final RowExtractor<T, String> commonOrSciNameExtractor;
    private final TaxonResolver taxonResolver;

    public FieldTaxonImporter(Taxonomy taxonomy, RowExtractor<T, String> commonOrSciNameExtractor) {
        this.commonOrSciNameExtractor = commonOrSciNameExtractor;
        this.sciNameExtractor = null;
        this.commonNameExtractor = null;
        this.subspecies = null;
        this.taxonResolver = new TaxonResolver(taxonomy);
    }

    public FieldTaxonImporter(Taxonomy taxonomy, RowExtractor<T, String> commonName, RowExtractor<T, String> sciName) {
        this(taxonomy, commonName, new JustGenusAndSpecies<T>(sciName), new SubspeciesIfPresent<T>(sciName));
    }

    public FieldTaxonImporter(TaxonResolver taxonResolver, RowExtractor<T, String> commonName, RowExtractor<T, String> sciName) {
        this(taxonResolver, commonName, new JustGenusAndSpecies<T>(sciName), new SubspeciesIfPresent<T>(sciName));
    }

    public FieldTaxonImporter(Taxonomy taxonomy, RowExtractor<T, String> commonName, @Nullable RowExtractor<T, String> sciName, @Nullable RowExtractor<T, String> subspecies) {
        this(new TaxonResolver(taxonomy), commonName, sciName, subspecies);
    }

    public FieldTaxonImporter(TaxonResolver taxonResolver, RowExtractor<T, String> commonName, @Nullable RowExtractor<T, String> sciName, @Nullable RowExtractor<T, String> subspecies) {
        this.taxonResolver = Preconditions.checkNotNull(taxonResolver);
        this.commonNameExtractor = Preconditions.checkNotNull(commonName);
        if (sciName == null) {
            sciName = RowExtractors.alwaysNull();
        }
        this.sciNameExtractor = sciName;
        if (subspecies == null) {
            subspecies = RowExtractors.alwaysNull();
        }
        this.subspecies = subspecies;
        this.commonOrSciNameExtractor = null;
    }

    @Override
    public TaxonImporter.ToBeDecided decideLater(T line) {
        TaxonImporter.ToBeDecided toBeDecided = new TaxonImporter.ToBeDecided();
        if (this.commonOrSciNameExtractor != null) {
            toBeDecided.commonName = this.commonOrSciNameExtractor.extract(line);
        } else {
            String commonName = this.commonNameExtractor.extract(line);
            String sciName = this.sciNameExtractor.extract(line);
            String subspeciesName = this.subspecies.extract(line);
            toBeDecided.commonName = Strings.emptyToNull(commonName);
            toBeDecided.scientificName = Strings.emptyToNull(sciName);
            toBeDecided.subspecies = Strings.emptyToNull(subspeciesName);
        }
        return toBeDecided;
    }

    @Override
    public TaxonPossibilities map(T line) {
        if (this.commonOrSciNameExtractor != null) {
            String commonOrSci = Strings.emptyToNull(this.commonOrSciNameExtractor.extract(line));
            if (commonOrSci == null) {
                return null;
            }
            return this.taxonResolver.mapUnknown(commonOrSci);
        }
        String commonName = Strings.emptyToNull(this.commonNameExtractor.extract(line));
        String subspeciesName = this.subspecies.extract(line);
        String sciName = Strings.emptyToNull(this.sciNameExtractor.extract(line));
        return this.taxonResolver.map(commonName, sciName, subspeciesName);
    }

    static class JustGenusAndSpecies<T>
    implements RowExtractor<T, String> {
        private final RowExtractor<T, String> sciName;

        JustGenusAndSpecies(RowExtractor<T, String> sciName) {
            this.sciName = Preconditions.checkNotNull(sciName);
        }

        @Override
        public String extract(T line) {
            String sci = this.sciName.extract(line);
            return TaxonImporter.justGenusAndSpecies(sci);
        }
    }

    static class SubspeciesIfPresent<T>
    implements RowExtractor<T, String> {
        private final RowExtractor<T, String> sciName;

        SubspeciesIfPresent(RowExtractor<T, String> sciName) {
            this.sciName = Preconditions.checkNotNull(sciName);
        }

        @Override
        public String extract(T line) {
            String sci = this.sciName.extract(line);
            return TaxonImporter.subspeciesIfPresent(sci);
        }
    }
}

