/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.io.CsvImportLines;
import com.scythebill.birdlist.model.io.ImportLines;
import com.scythebill.birdlist.model.sighting.Area;
import com.scythebill.birdlist.model.sighting.Distance;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.Photo;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.VisitInfo;
import com.scythebill.birdlist.model.sighting.VisitInfoKey;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.imports.BreedingBirdCodeFieldMapper;
import com.scythebill.birdlist.ui.imports.ComputedMappings;
import com.scythebill.birdlist.ui.imports.CountFieldMapper;
import com.scythebill.birdlist.ui.imports.CsvSightingsImporter;
import com.scythebill.birdlist.ui.imports.DescriptionFieldMapper;
import com.scythebill.birdlist.ui.imports.EBird;
import com.scythebill.birdlist.ui.imports.FieldMapper;
import com.scythebill.birdlist.ui.imports.FieldTaxonImporter;
import com.scythebill.birdlist.ui.imports.ImportedLocation;
import com.scythebill.birdlist.ui.imports.LineExtractor;
import com.scythebill.birdlist.ui.imports.LineExtractors;
import com.scythebill.birdlist.ui.imports.MultiFormatDateFromStringLineExtractor;
import com.scythebill.birdlist.ui.imports.OnlyIncludeRowsMatchingDates;
import com.scythebill.birdlist.ui.imports.SightingsImporter;
import com.scythebill.birdlist.ui.imports.TaxonImporter;
import com.scythebill.birdlist.ui.imports.TaxonResolver;
import com.scythebill.birdlist.ui.imports.TimeMapper;
import com.scythebill.birdlist.ui.messages.Messages;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.joda.time.Duration;
import org.joda.time.ReadablePartial;

public class EBirdMyDataImporter
extends CsvSightingsImporter {
    private static final Logger logger = Logger.getLogger(EBirdMyDataImporter.class.getName());
    private LineExtractor<String> locationIdExtractor;
    private LineExtractor<String> taxonomyIdExtractor;
    private Map<VisitInfoKey, VisitInfo> visitInfoMap;
    private LineExtractor<String> observationTypeExtractor;
    private LineExtractor<Integer> durationExtractor;
    private LineExtractor<Float> distanceKmExtractor;
    private LineExtractor<Float> areaHectaresExtractor;
    private LineExtractor<Integer> partySizeExtractor;
    private LineExtractor<Boolean> completeExtractor;
    private LineExtractor<String> visitCommentsExtractor;
    private LineExtractor<String> commonExtractor;
    private LineExtractor<String> scientificExtractor;
    private LineExtractor<String> countryAndStateExtractor;
    private LineExtractor<String> countyExtractor;
    private LineExtractor<String> locationExtractor;
    private LineExtractor<String> latitudeExtractor;
    private LineExtractor<String> longitudeExtractor;
    private LineExtractor<ReadablePartial> dateExtractor;
    private ImmutableSet<ReadablePartial> onlyImportDatesIn;

    public EBirdMyDataImporter(ReportSet reportSet, Taxonomy taxonomy, Checklists checklists, PredefinedLocations predefinedLocations, File file) {
        super(reportSet, taxonomy, checklists, predefinedLocations, file, file);
    }

    protected LineExtractor<? extends Object> taxonomyIdExtractor() {
        return this.taxonomyIdExtractor;
    }

    @Override
    protected TaxonImporter<String[]> newTaxonImporter(Taxonomy taxonomy) {
        TaxonResolver taxonResolver = new TaxonResolver(taxonomy);
        taxonResolver.setMaximumNameDistance(1);
        return new FieldTaxonImporter<String[]>(taxonResolver, this.commonExtractor, new JustBinomial(this.scientificExtractor), new AfterBinomial(this.scientificExtractor));
    }

    static boolean hasSubspecies(String s) {
        return CharMatcher.whitespace().countIn(s) > 1 && !s.contains(" x ");
    }

    static int secondSpace(CharSequence s) {
        int first = CharMatcher.whitespace().indexIn(s);
        if (first < 0) {
            return first;
        }
        return CharMatcher.whitespace().indexIn(s, first + 1);
    }

    @Override
    protected void parseLocationIds(LocationSet locations, PredefinedLocations predefinedLocations) throws IOException {
        try (ImportLines lines = CsvImportLines.fromFile(this.locationsFile, this.getCharset());){
            String[] line;
            this.computeMappings(lines);
            while ((line = lines.nextLine()) != null) {
                String id = (String)this.locationIdExtractor.extract((String)line);
                if (this.locationIds.hasBeenParsed(id)) continue;
                ImportedLocation imported = new ImportedLocation();
                ArrayList<String> countryAndState = Lists.newArrayList(Splitter.on('-').split((CharSequence)this.countryAndStateExtractor.extract((String)line)));
                if (countryAndState.size() != 2) {
                    throw new IllegalArgumentException("Doesn't look like an EBird file.  Location contains " + line[5]);
                }
                imported.countryCode = (String)countryAndState.get(0);
                imported.stateCode = (String)countryAndState.get(1);
                imported.county = Strings.emptyToNull((String)this.countyExtractor.extract((String)line));
                imported.locationNames.add(Strings.emptyToNull((String)this.locationExtractor.extract((String)line)));
                imported.latitude = Strings.emptyToNull((String)this.latitudeExtractor.extract((String)line));
                imported.longitude = Strings.emptyToNull((String)this.longitudeExtractor.extract((String)line));
                String locationId = imported.addToLocationSet(this.reportSet, locations, this.locationShortcuts, predefinedLocations);
                this.locationIds.put((Object)id, locationId);
            }
        }
    }

    @Override
    protected ComputedMappings<String[]> computeMappings(ImportLines lines) throws IOException {
        String[] header = lines.nextLine();
        HashMap<String, Integer> headersByIndex = Maps.newHashMap();
        for (int i = 0; i < header.length; ++i) {
            headersByIndex.put(header[i].toLowerCase(), i);
        }
        Integer timeIndex = (Integer)headersByIndex.get("time");
        Integer breedingCodeIndex = (Integer)headersByIndex.get("breeding code");
        Integer speciesCommentsIndex = (Integer)headersByIndex.get("species comments");
        Integer mlCatalogNumbersIndex = (Integer)headersByIndex.get("ml catalog numbers");
        if (speciesCommentsIndex == null) {
            speciesCommentsIndex = (Integer)headersByIndex.get("observation details");
        }
        Integer countIndex = (Integer)headersByIndex.get("count");
        int dateIndex = this.getRequiredHeader(headersByIndex, "Date");
        int countryAndStateIndex = this.getRequiredHeader(headersByIndex, "State/Province");
        int countyIndex = this.getRequiredHeader(headersByIndex, "County");
        int locationIndex = this.getRequiredHeader(headersByIndex, "Location");
        this.countryAndStateExtractor = LineExtractors.stringFromIndex(countryAndStateIndex);
        this.countyExtractor = LineExtractors.stringFromIndex(countyIndex);
        this.locationExtractor = LineExtractors.stringFromIndex(locationIndex);
        LineExtractor<String> joined = LineExtractors.joined(Joiner.on('|').useForNull(""), this.countryAndStateExtractor, this.countyExtractor, this.locationExtractor);
        this.locationIdExtractor = joined;
        Integer latitudeIndex = (Integer)headersByIndex.get("latitude");
        Integer longitudeIndex = (Integer)headersByIndex.get("longitude");
        this.latitudeExtractor = latitudeIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(latitudeIndex);
        this.longitudeExtractor = longitudeIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(longitudeIndex);
        int commonIndex = this.getRequiredHeader(headersByIndex, "Common Name");
        this.commonExtractor = LineExtractors.stringFromIndex(commonIndex);
        int sciIndex = this.getRequiredHeader(headersByIndex, "Scientific Name");
        this.scientificExtractor = LineExtractors.stringFromIndex(sciIndex);
        this.taxonomyIdExtractor = LineExtractors.joined(Joiner.on('|').useForNull(""), this.commonExtractor, this.scientificExtractor);
        this.dateExtractor = new MultiFormatDateFromStringLineExtractor(LineExtractors.stringFromIndex(dateIndex), "yy-MM-dd", "yy/MM/dd");
        ArrayList mappers = Lists.newArrayList();
        mappers.add(new FieldMapper<String[]>(){

            @Override
            public void map(String[] row, Sighting.Builder sighting) {
                ReadablePartial date = (ReadablePartial)EBirdMyDataImporter.this.dateExtractor.extract((ReadablePartial)row);
                if (date != null) {
                    sighting.setDate(date);
                }
            }
        });
        if (countIndex != null) {
            mappers.add(new CountFieldMapper(LineExtractors.stringFromIndex(4)));
        }
        if (speciesCommentsIndex != null) {
            mappers.add(new DescriptionFieldMapper(LineExtractors.stringFromIndex(speciesCommentsIndex)));
        }
        if (timeIndex != null) {
            mappers.add(new TimeMapper(LineExtractors.stringFromIndex(timeIndex)));
        }
        if (breedingCodeIndex != null) {
            mappers.add(new BreedingBirdCodeFieldMapper(LineExtractors.stringFromIndex(breedingCodeIndex)));
        }
        if (mlCatalogNumbersIndex != null) {
            mappers.add(new MLCatalogNumbersFieldMapper(LineExtractors.stringFromIndex(mlCatalogNumbersIndex)));
        }
        int observationTypeIndex = this.getRequiredHeader(headersByIndex, "Protocol");
        Integer durationIndexAsMinutes = (Integer)headersByIndex.get("duration (min)");
        Integer durationIndexAsHours = (Integer)headersByIndex.get("duration (hrs)");
        Integer completeIndex = (Integer)headersByIndex.get("all obs reported");
        Integer distanceKmIndex = (Integer)headersByIndex.get("distance traveled (km)");
        Integer areaHectaresIndex = (Integer)headersByIndex.get("area covered (ha)");
        Integer partySizeIndex = (Integer)headersByIndex.get("number of observers");
        Integer visitCommentsIndex = (Integer)headersByIndex.get("checklist comments");
        this.visitInfoMap = Maps.newHashMap();
        this.observationTypeExtractor = LineExtractors.stringFromIndex(observationTypeIndex);
        if (durationIndexAsHours != null) {
            final LineExtractor<Float> durationInHours = LineExtractors.floatFromIndex(durationIndexAsHours);
            this.durationExtractor = new LineExtractor<Integer>(){

                @Override
                public Integer extract(String[] line) {
                    Float extracted = (Float)durationInHours.extract(line);
                    if (extracted == null) {
                        return null;
                    }
                    return (int)(extracted.floatValue() * 60.0f);
                }
            };
        } else {
            this.durationExtractor = durationIndexAsMinutes != null ? LineExtractors.intFromIndex(durationIndexAsMinutes) : LineExtractors.alwaysNull();
        }
        this.distanceKmExtractor = distanceKmIndex != null ? LineExtractors.floatFromIndex(distanceKmIndex) : LineExtractors.alwaysNull();
        this.areaHectaresExtractor = areaHectaresIndex != null ? LineExtractors.floatFromIndex(areaHectaresIndex) : LineExtractors.alwaysNull();
        this.partySizeExtractor = this.partySizeExtractor != null ? LineExtractors.intFromIndex(partySizeIndex) : LineExtractors.alwaysNull();
        this.completeExtractor = completeIndex == null ? LineExtractors.constant(false) : LineExtractors.booleanFromIndex(completeIndex);
        this.visitCommentsExtractor = visitCommentsIndex != null ? LineExtractors.stringFromIndex(visitCommentsIndex) : LineExtractors.alwaysNull();
        return new ComputedMappings<String[]>(new SightingsImporter.TaxonFieldMapper(this.taxonomyIdExtractor), new SightingsImporter.LocationMapper(this.locationIdExtractor), mappers);
    }

    @Override
    protected void lookForVisitInfo(ReportSet reportSet, String[] line, Sighting newSighting, VisitInfoKey visitInfoKey) {
        VisitInfo visitInfo;
        String visitComments;
        Integer partySize;
        Float hectares;
        Float kms;
        VisitInfo.Builder builder = VisitInfo.builder();
        builder.withObservationType(EBird.observationType((String)this.observationTypeExtractor.extract((String)line)));
        Integer duration = (Integer)this.durationExtractor.extract((Integer)line);
        if (duration != null && duration > 0) {
            builder.withDuration(Duration.standardMinutes(duration.intValue()));
        }
        if ((kms = (Float)this.distanceKmExtractor.extract((Float)line)) != null && kms.floatValue() > 0.0f) {
            builder.withDistance(Distance.inKilometers(kms.floatValue()));
        }
        if ((hectares = (Float)this.areaHectaresExtractor.extract((Float)line)) != null && hectares.floatValue() > 0.0f) {
            builder.withArea(Area.inHectares(hectares.floatValue()));
        }
        if ((partySize = (Integer)this.partySizeExtractor.extract((Integer)line)) != null && partySize > 0) {
            builder.withPartySize(partySize);
        }
        if (((Boolean)this.completeExtractor.extract((Boolean)line)).booleanValue()) {
            builder.withCompleteChecklist(true);
        }
        if (!Strings.isNullOrEmpty(visitComments = (String)this.visitCommentsExtractor.extract((String)line))) {
            builder.withComments(visitComments);
        }
        try {
            visitInfo = builder.build();
        }
        catch (IllegalStateException e) {
            builder.withObservationType(VisitInfo.ObservationType.HISTORICAL);
            visitInfo = builder.build();
        }
        if (visitInfo.hasData()) {
            this.visitInfoMap.put(visitInfoKey, visitInfo);
        }
    }

    @Override
    public Map<VisitInfoKey, VisitInfo> getAccumulatedVisitInfoMap() {
        return this.visitInfoMap;
    }

    @Override
    public boolean isMassExport() {
        return true;
    }

    @Override
    public Collection<ReadablePartial> getAllDates() throws IOException {
        try (ImportLines lines = this.importLines(this.locationsFile);){
            String[] line;
            this.computeMappings(lines);
            LinkedHashSet<ReadablePartial> allDates = new LinkedHashSet<ReadablePartial>();
            while ((line = lines.nextLine()) != null) {
                ReadablePartial date = (ReadablePartial)this.dateExtractor.extract((ReadablePartial)line);
                if (date == null) continue;
                allDates.add(date);
            }
            LinkedHashSet<ReadablePartial> linkedHashSet = allDates;
            return linkedHashSet;
        }
    }

    @Override
    public void onlyImportDatesIn(Set<ReadablePartial> newDates) {
        this.onlyImportDatesIn = ImmutableSet.copyOf(newDates);
    }

    @Override
    protected String getFailedParseFormat(boolean allDateFailures) {
        if (allDateFailures) {
            return Messages.getMessage(Messages.Name.EBIRD_DATES_DID_NOT_PARSE);
        }
        return super.getFailedParseFormat(allDateFailures);
    }

    @Override
    protected ImportLines importLines(File file) throws IOException {
        ImportLines importLines = super.importLines(file);
        if (this.onlyImportDatesIn == null) {
            return importLines;
        }
        return new OnlyIncludeRowsMatchingDates(importLines, this.onlyImportDatesIn, this.dateExtractor);
    }

    static class JustBinomial
    implements LineExtractor<String> {
        private LineExtractor<String> stringFromIndex;

        public JustBinomial(LineExtractor<String> stringFromIndex) {
            this.stringFromIndex = stringFromIndex;
        }

        @Override
        public String extract(String[] line) {
            String text = (String)this.stringFromIndex.extract((String)line);
            if (EBirdMyDataImporter.hasSubspecies(text)) {
                int secondSpace = EBirdMyDataImporter.secondSpace(text);
                text = text.substring(0, secondSpace);
            }
            return text;
        }
    }

    static class AfterBinomial
    implements LineExtractor<String> {
        private LineExtractor<String> stringFromIndex;

        public AfterBinomial(LineExtractor<String> stringFromIndex) {
            this.stringFromIndex = stringFromIndex;
        }

        @Override
        public String extract(String[] line) {
            String text = (String)this.stringFromIndex.extract((String)line);
            if (EBirdMyDataImporter.hasSubspecies(text)) {
                int secondSpace = EBirdMyDataImporter.secondSpace(text);
                return text.substring(secondSpace + 1);
            }
            return null;
        }
    }

    static class MLCatalogNumbersFieldMapper
    implements FieldMapper<String[]> {
        private static final String MACAULAY_LIBRARY_URL_FORMAT = "https://macaulaylibrary.org/asset/%s";
        private static final Splitter CATALOG_NUMBERS_SPLITTER = Splitter.on(CharMatcher.whitespace());
        private final LineExtractor<String> extractor;

        public MLCatalogNumbersFieldMapper(LineExtractor<String> extractor) {
            this.extractor = extractor;
        }

        @Override
        public void map(String[] line, Sighting.Builder sighting) {
            String catalogNumbers = (String)this.extractor.extract((String)line);
            if (!Strings.isNullOrEmpty(catalogNumbers)) {
                ArrayList<Photo> photos = new ArrayList<Photo>();
                for (String catalogNumber : CATALOG_NUMBERS_SPLITTER.split(catalogNumbers)) {
                    String catalogUri = String.format(MACAULAY_LIBRARY_URL_FORMAT, catalogNumber);
                    try {
                        URI uri = new URI(String.format(MACAULAY_LIBRARY_URL_FORMAT, catalogNumber));
                        photos.add(new Photo(uri));
                    }
                    catch (URISyntaxException e) {
                        logger.warning("Invalid library URI: " + catalogUri);
                    }
                }
                if (!photos.isEmpty()) {
                    sighting.getSightingInfo().setPhotographed(true);
                }
                sighting.getSightingInfo().setPhotos(photos);
            }
        }
    }
}

