/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.io.CsvImportLines;
import com.scythebill.birdlist.model.io.ImportLines;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.imports.ComputedMappings;
import com.scythebill.birdlist.ui.imports.CountFieldMapper;
import com.scythebill.birdlist.ui.imports.CsvSightingsImporter;
import com.scythebill.birdlist.ui.imports.EBird;
import com.scythebill.birdlist.ui.imports.FieldTaxonImporter;
import com.scythebill.birdlist.ui.imports.ImportedLocation;
import com.scythebill.birdlist.ui.imports.LineExtractor;
import com.scythebill.birdlist.ui.imports.LineExtractors;
import com.scythebill.birdlist.ui.imports.MultiFormatDateFromStringFieldMapper;
import com.scythebill.birdlist.ui.imports.SightingsImporter;
import com.scythebill.birdlist.ui.imports.TaxonImporter;
import com.scythebill.birdlist.ui.imports.TaxonResolver;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;

public class EBirdLifeListImporter
extends CsvSightingsImporter {
    private final LineExtractor<String> locationIdExtractor = LineExtractors.joined(Joiner.on('|').useForNull(""), LineExtractors.stringFromIndex(3), LineExtractors.stringFromIndex(4));
    private final LineExtractor<String> taxonomyIdExtractor = LineExtractors.stringFromIndex(1);

    public EBirdLifeListImporter(ReportSet reportSet, Taxonomy taxonomy, Checklists checklists, PredefinedLocations predefinedLocations, File file) {
        super(reportSet, taxonomy, checklists, predefinedLocations, file, file);
    }

    protected LineExtractor<? extends Object> taxonomyIdExtractor() {
        return this.taxonomyIdExtractor;
    }

    @Override
    protected TaxonImporter<String[]> newTaxonImporter(Taxonomy taxonomy) {
        TaxonResolver taxonResolver = new TaxonResolver(taxonomy);
        taxonResolver.setMaximumNameDistance(1);
        return new FieldTaxonImporter<String[]>(taxonResolver, new EBird.CommonNameExtractor(LineExtractors.stringFromIndex(1), taxonResolver), new EBird.ScientificNameExtractor(LineExtractors.stringFromIndex(1), taxonResolver));
    }

    @Override
    protected void parseLocationIds(LocationSet locations, PredefinedLocations predefinedLocations) throws IOException {
        try (ImportLines lines = CsvImportLines.fromFile(this.locationsFile, this.getCharset());){
            String[] line;
            this.computeMappings(lines);
            while ((line = lines.nextLine()) != null) {
                String id = (String)this.locationIdExtractor.extract((String)line);
                if (this.locationIds.hasBeenParsed(id)) continue;
                ImportedLocation imported = new ImportedLocation();
                ArrayList<String> countryAndState = Lists.newArrayList(Splitter.on('-').split(line[4]));
                if (countryAndState.size() != 2) {
                    throw new IllegalArgumentException("Doesn't look like an EBird file.  Location contains " + line[5]);
                }
                imported.countryCode = (String)countryAndState.get(0);
                imported.stateCode = (String)countryAndState.get(1);
                if (!Strings.isNullOrEmpty(line[3])) {
                    EBird.NameAndLatLong nameAndLatLong = EBird.extractLatLongFromName(line[3]);
                    imported.locationNames.add(nameAndLatLong.name);
                    if (nameAndLatLong.latLong != null) {
                        imported.latitude = nameAndLatLong.latLong.latitudeAsCanonicalString();
                        imported.longitude = nameAndLatLong.latLong.longitudeAsCanonicalString();
                    }
                }
                String locationId = imported.addToLocationSet(this.reportSet, locations, this.locationShortcuts, predefinedLocations);
                this.locationIds.put((Object)id, locationId);
            }
        }
    }

    @Override
    protected ComputedMappings<String[]> computeMappings(ImportLines lines) throws IOException {
        lines.nextLine();
        ArrayList mappers = Lists.newArrayList();
        mappers.add(new MultiFormatDateFromStringFieldMapper(LineExtractors.stringFromIndex(5), Locale.US, "dd MMM yy", "dd-MMM-yy"));
        mappers.add(new CountFieldMapper(LineExtractors.stringFromIndex(2)));
        return new ComputedMappings<String[]>(new SightingsImporter.TaxonFieldMapper(this.taxonomyIdExtractor), new SightingsImporter.LocationMapper(this.locationIdExtractor), mappers);
    }
}

