/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.io.CsvImportLines;
import com.scythebill.birdlist.model.io.ImportLines;
import com.scythebill.birdlist.model.sighting.Area;
import com.scythebill.birdlist.model.sighting.Distance;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.VisitInfo;
import com.scythebill.birdlist.model.sighting.VisitInfoKey;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.imports.ComputedMappings;
import com.scythebill.birdlist.ui.imports.CountFieldMapper;
import com.scythebill.birdlist.ui.imports.CsvSightingsImporter;
import com.scythebill.birdlist.ui.imports.DescriptionFieldMapper;
import com.scythebill.birdlist.ui.imports.FieldTaxonImporter;
import com.scythebill.birdlist.ui.imports.ImportedLocation;
import com.scythebill.birdlist.ui.imports.LineExtractor;
import com.scythebill.birdlist.ui.imports.LineExtractors;
import com.scythebill.birdlist.ui.imports.MultiFormatDateFromStringFieldMapper;
import com.scythebill.birdlist.ui.imports.MultiFormatDateFromStringLineExtractor;
import com.scythebill.birdlist.ui.imports.ParsedLocationIds;
import com.scythebill.birdlist.ui.imports.SightingsImporter;
import com.scythebill.birdlist.ui.imports.TaxonImporter;
import com.scythebill.birdlist.ui.imports.TimeMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import org.joda.time.Duration;
import org.joda.time.ReadablePartial;

public class EBirdImportImporter
extends CsvSightingsImporter {
    private final LineExtractor<String> locationIdExtractor = LineExtractors.joined(Joiner.on('|').useForNull(""), LineExtractors.stringFromIndex(5), LineExtractors.stringFromIndex(10), LineExtractors.stringFromIndex(11), new WithinBracesIfCountryIsEmpty(LineExtractors.stringFromIndex(4), LineExtractors.stringFromIndex(11)));
    private final LineExtractor<String> taxonomyIdExtractor = LineExtractors.joined(Joiner.on('|').useForNull(""), LineExtractors.stringFromIndex(0), LineExtractors.stringFromIndex(1), LineExtractors.stringFromIndex(2));
    private LineExtractor<String> protocolExtractor;
    private LineExtractor<Integer> partySizeExtractor;
    private LineExtractor<Integer> durationExtractor;
    private LineExtractor<Boolean> completeExtractor;
    private LineExtractor<Float> distanceExtractor;
    private LineExtractor<Float> areaExtractor;
    private LineExtractor<String> visitCommentsExtractor;
    private Map<VisitInfoKey, VisitInfo> visitInfoMap;
    private LineExtractor<ReadablePartial> dateExtractor;

    public EBirdImportImporter(ReportSet reportSet, Taxonomy taxonomy, Checklists checklists, PredefinedLocations predefinedLocations, File file) {
        super(reportSet, taxonomy, checklists, predefinedLocations, file, file);
    }

    protected LineExtractor<? extends Object> taxonomyIdExtractor() {
        return this.taxonomyIdExtractor;
    }

    @Override
    protected TaxonImporter<String[]> newTaxonImporter(Taxonomy taxonomy) {
        LineExtractor<String> commonNameExtractor = LineExtractors.stringFromIndex(0);
        LineExtractor<String> speciesNameExtractor = LineExtractors.stringFromIndex(2);
        return new FieldTaxonImporter<String[]>(taxonomy, commonNameExtractor, LineExtractors.joined(Joiner.on(' ').useForNull(""), LineExtractors.stringFromIndex(1), line -> this.dropSubspeciesInSpeciesName((String)speciesNameExtractor.extract((String)line))), line -> {
            String ssp = this.lookForSubspeciesInCommonName((String)commonNameExtractor.extract((String)line));
            if (ssp != null) {
                return ssp;
            }
            ssp = this.lookForSubspeciesInSpeciesName((String)speciesNameExtractor.extract((String)line));
            return ssp;
        });
    }

    private String lookForSubspeciesInCommonName(String commonName) {
        if (commonName == null) {
            return null;
        }
        int lastRightParen = commonName.lastIndexOf(41);
        int lastRightBrace = commonName.lastIndexOf(93);
        if (lastRightParen >= 0 && lastRightParen > lastRightBrace) {
            int firstLeftParen = commonName.lastIndexOf(40, lastRightParen);
            if (firstLeftParen < 0) {
                return null;
            }
            return commonName.substring(firstLeftParen + 1, lastRightParen);
        }
        if (lastRightBrace >= 0) {
            int firstLeftBrace = commonName.lastIndexOf(91, lastRightBrace);
            if (firstLeftBrace < 0) {
                return null;
            }
            return commonName.substring(firstLeftBrace + 1, lastRightBrace);
        }
        return null;
    }

    private String lookForSubspeciesInSpeciesName(String sciName) {
        if (sciName == null) {
            return null;
        }
        int lastSpace = sciName.lastIndexOf(32);
        if (lastSpace < 0) {
            return null;
        }
        return sciName.substring(lastSpace + 1);
    }

    private String dropSubspeciesInSpeciesName(String sciName) {
        if (sciName == null) {
            return null;
        }
        int lastSpace = sciName.lastIndexOf(32);
        if (lastSpace < 0) {
            return sciName;
        }
        return sciName.substring(0, lastSpace);
    }

    @Override
    protected void parseLocationIds(LocationSet locations, PredefinedLocations predefinedLocations) throws IOException {
        try (ImportLines lines = CsvImportLines.fromFile(this.locationsFile, this.getCharset());){
            String[] line;
            this.computeMappings(lines);
            while ((line = lines.nextLine()) != null) {
                String withinBraces;
                String id = (String)this.locationIdExtractor.extract((String)line);
                if (this.locationIds.hasBeenParsed(id)) continue;
                ImportedLocation imported = new ImportedLocation();
                imported.stateCode = Strings.emptyToNull(line[10]);
                imported.countryCode = Strings.emptyToNull(line[11]);
                imported.latitude = Strings.emptyToNull(line[6]);
                imported.longitude = Strings.emptyToNull(line[7]);
                String location = Strings.emptyToNull(line[5]);
                if (imported.countryCode == null) {
                    Location country = this.locationShortcuts.getCountryExactMatch(location, null, null);
                    if (country != null) {
                        if (country.getEbirdCode() != null) {
                            imported.countryCode = country.getEbirdCode();
                        } else {
                            imported.country = country.getModelName();
                        }
                    } else {
                        Location state = this.locationShortcuts.getStateByName("US", location);
                        if (state != null) {
                            imported.countryCode = "US";
                            imported.state = state.getModelName();
                        } else {
                            state = this.locationShortcuts.getStateByName("CA", location);
                            if (state != null) {
                                imported.countryCode = "CA";
                                imported.state = state.getModelName();
                            }
                        }
                    }
                    if (imported.country == null && imported.countryCode == null) {
                        imported.locationNames.add(location);
                    }
                } else {
                    imported.locationNames.add(location);
                }
                if (Strings.isNullOrEmpty(line[11]) && (withinBraces = Strings.emptyToNull(WithinBracesIfCountryIsEmpty.withinBrace(line[4]))) != null) {
                    imported.locationNames.add(withinBraces);
                }
                if (imported.country == null && imported.countryCode == null && !imported.locationNames.isEmpty()) {
                    this.locationIds.addToBeResolvedLocationName(id, new ParsedLocationIds.ToBeDecided(Joiner.on(", ").join(imported.locationNames)));
                    continue;
                }
                String locationId = imported.addToLocationSet(this.reportSet, locations, this.locationShortcuts, predefinedLocations);
                this.locationIds.put((Object)id, locationId);
            }
        }
    }

    @Override
    protected ComputedMappings<String[]> computeMappings(ImportLines lines) throws IOException {
        ArrayList mappers = Lists.newArrayList();
        this.dateExtractor = new MultiFormatDateFromStringLineExtractor(LineExtractors.stringFromIndex(8), "MM/dd/yyyy", "MM-dd-yy");
        mappers.add(new MultiFormatDateFromStringFieldMapper(LineExtractors.stringFromIndex(8), "MM/dd/yyyy", "MM-dd-yy"));
        mappers.add(new CountFieldMapper(LineExtractors.stringFromIndex(3)));
        mappers.add(new DescriptionFieldMapper(LineExtractors.stringFromIndex(4)));
        mappers.add(new TimeMapper(LineExtractors.stringFromIndex(9)));
        this.visitInfoMap = Maps.newHashMap();
        this.protocolExtractor = LineExtractors.stringFromIndex(12);
        this.partySizeExtractor = LineExtractors.intFromIndex(13);
        this.durationExtractor = LineExtractors.intFromIndex(14);
        this.completeExtractor = LineExtractors.booleanFromIndex(15);
        this.distanceExtractor = LineExtractors.floatFromIndex(16);
        this.areaExtractor = LineExtractors.floatFromIndex(17);
        this.visitCommentsExtractor = LineExtractors.stringFromIndex(18);
        return new ComputedMappings<String[]>(new SightingsImporter.TaxonFieldMapper(this.taxonomyIdExtractor), new SightingsImporter.LocationMapper(this.locationIdExtractor), mappers);
    }

    @Override
    protected void lookForVisitInfo(ReportSet reportSet, String[] line, Sighting newSighting, VisitInfoKey visitInfoKey) {
        VisitInfo visitInfo;
        String visitComments;
        Integer partySize;
        Float area;
        Float distance;
        Integer duration;
        VisitInfo.Builder builder = VisitInfo.builder();
        VisitInfo.ObservationType observationType = VisitInfo.ObservationType.fromEBirdId((String)this.protocolExtractor.extract((String)line));
        if (observationType == null) {
            observationType = VisitInfo.ObservationType.HISTORICAL;
        }
        if ((duration = (Integer)this.durationExtractor.extract((Integer)line)) != null) {
            builder.withDuration(Duration.standardMinutes(duration.intValue()));
        }
        if ((distance = (Float)this.distanceExtractor.extract((Float)line)) != null) {
            builder.withDistance(Distance.inMiles(distance.floatValue()));
        }
        if ((area = (Float)this.areaExtractor.extract((Float)line)) != null) {
            builder.withArea(Area.inAcres(area.floatValue()));
        }
        if ((partySize = (Integer)this.partySizeExtractor.extract((Integer)line)) != null && partySize > 0) {
            builder.withPartySize(partySize);
        }
        if (!Strings.isNullOrEmpty(visitComments = (String)this.visitCommentsExtractor.extract((String)line))) {
            builder.withComments(visitComments);
        }
        if (((Boolean)this.completeExtractor.extract((Boolean)line)).booleanValue()) {
            builder.withCompleteChecklist(true);
        }
        try {
            visitInfo = builder.build();
        }
        catch (IllegalStateException e) {
            builder.withObservationType(VisitInfo.ObservationType.HISTORICAL);
            visitInfo = builder.build();
        }
        if (visitInfo.hasData()) {
            this.visitInfoMap.put(visitInfoKey, visitInfo);
        }
    }

    @Override
    public Map<VisitInfoKey, VisitInfo> getAccumulatedVisitInfoMap() {
        return this.visitInfoMap;
    }

    @Override
    public boolean isMassExport() {
        return true;
    }

    @Override
    public Collection<ReadablePartial> getAllDates() throws IOException {
        try (ImportLines lines = this.importLines(this.locationsFile);){
            String[] line;
            this.computeMappings(lines);
            LinkedHashSet<ReadablePartial> allDates = new LinkedHashSet<ReadablePartial>();
            while ((line = lines.nextLine()) != null) {
                ReadablePartial date = (ReadablePartial)this.dateExtractor.extract((ReadablePartial)line);
                if (date == null) continue;
                allDates.add(date);
            }
            LinkedHashSet<ReadablePartial> linkedHashSet = allDates;
            return linkedHashSet;
        }
    }

    static class WithinBracesIfCountryIsEmpty
    implements LineExtractor<String> {
        private final LineExtractor<String> extractor;
        private final LineExtractor<String> countryExtractor;

        WithinBracesIfCountryIsEmpty(LineExtractor<String> extractor, LineExtractor<String> countryExtractor) {
            this.extractor = extractor;
            this.countryExtractor = countryExtractor;
        }

        @Override
        public String extract(String[] line) {
            String country = (String)this.countryExtractor.extract((String)line);
            if (!Strings.isNullOrEmpty(country)) {
                return null;
            }
            String extracted = (String)this.extractor.extract((String)line);
            return WithinBracesIfCountryIsEmpty.withinBrace(extracted);
        }

        static String withinBrace(String extracted) {
            if (extracted == null) {
                return null;
            }
            int openBrace = extracted.indexOf(91);
            if (openBrace < 0) {
                return "";
            }
            int closeBrace = extracted.indexOf(93, openBrace + 1);
            if (closeBrace < 0) {
                return "";
            }
            return extracted.substring(openBrace + 1, closeBrace);
        }
    }
}

