/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Resources;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.io.CsvImportLines;
import com.scythebill.birdlist.model.io.ImportLines;
import com.scythebill.birdlist.model.sighting.Area;
import com.scythebill.birdlist.model.sighting.Distance;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.VisitInfo;
import com.scythebill.birdlist.model.sighting.VisitInfoKey;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.imports.ComputedMappings;
import com.scythebill.birdlist.ui.imports.CountFieldMapper;
import com.scythebill.birdlist.ui.imports.CsvSightingsImporter;
import com.scythebill.birdlist.ui.imports.DescriptionFieldMapper;
import com.scythebill.birdlist.ui.imports.EBird;
import com.scythebill.birdlist.ui.imports.EBirdChecklistApi;
import com.scythebill.birdlist.ui.imports.FieldTaxonImporter;
import com.scythebill.birdlist.ui.imports.ImportException;
import com.scythebill.birdlist.ui.imports.ImportedLocation;
import com.scythebill.birdlist.ui.imports.LineExtractor;
import com.scythebill.birdlist.ui.imports.LineExtractors;
import com.scythebill.birdlist.ui.imports.MultiFormatDateFromStringFieldMapper;
import com.scythebill.birdlist.ui.imports.ParsedLocationIds;
import com.scythebill.birdlist.ui.imports.SightingsImporter;
import com.scythebill.birdlist.ui.imports.TaxonImporter;
import com.scythebill.birdlist.ui.imports.TaxonResolver;
import com.scythebill.birdlist.ui.imports.TimeMapper;
import com.scythebill.birdlist.ui.messages.Messages;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.Duration;
import org.joda.time.chrono.GJChronology;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class EBirdChecklistImporter
extends CsvSightingsImporter {
    private static final Logger logger = Logger.getLogger(EBirdChecklistImporter.class.getName());
    private LineExtractor<String> nameExtractor;
    private LineExtractor<String> locationIdExtractor;
    private Map<VisitInfoKey, VisitInfo> visitInfoMap;
    private LineExtractor<String> observationTypeExtractor;
    private LineExtractor<String> durationExtractor;
    private LineExtractor<String> distanceExtractor;
    private LineExtractor<String> areaExtractor;
    private LineExtractor<Integer> partySizeExtractor;
    private LineExtractor<Boolean> completeExtractor;
    private final EBirdChecklistApi ebirdChecklistApi;
    private volatile String countryCode;
    private volatile String stateCode;
    private volatile String countyName;
    private static final Pattern CHECKLIST_PATTERN = Pattern.compile("(S[0-9]+).*");
    private static final ImmutableMultimap<String, String> HEADER_NAMES;

    public EBirdChecklistImporter(ReportSet reportSet, Taxonomy taxonomy, Checklists checklists, PredefinedLocations predefinedLocations, File file, EBirdChecklistApi ebirdChecklistApi) {
        super(reportSet, taxonomy, checklists, predefinedLocations, file, file);
        this.ebirdChecklistApi = ebirdChecklistApi;
    }

    protected LineExtractor<? extends Object> taxonomyIdExtractor() {
        return this.nameExtractor;
    }

    @Override
    protected TaxonImporter<String[]> newTaxonImporter(Taxonomy taxonomy) {
        TaxonResolver taxonResolver = new TaxonResolver(taxonomy);
        taxonResolver.setMaximumNameDistance(1);
        return new FieldTaxonImporter<String[]>(taxonResolver, new EBird.CommonNameExtractor(this.nameExtractor, taxonResolver), new EBird.ScientificNameExtractor(this.nameExtractor, taxonResolver));
    }

    @Override
    public Runnable longRunningTask() {
        return new Runnable(){

            @Override
            public void run() {
                Matcher matcher = CHECKLIST_PATTERN.matcher(EBirdChecklistImporter.this.locationsFile.getName());
                if (matcher.matches()) {
                    try {
                        EBirdChecklistApi.ChecklistInfo checklistInfo = EBirdChecklistImporter.this.ebirdChecklistApi.resolveChecklist(matcher.group(1));
                        if (checklistInfo.countryCode != null) {
                            EBirdChecklistImporter.this.countryCode = checklistInfo.countryCode;
                        }
                        if (checklistInfo.stateCode != null) {
                            EBirdChecklistImporter.this.stateCode = checklistInfo.stateCode;
                        }
                        if (checklistInfo.countyName != null) {
                            EBirdChecklistImporter.this.countyName = checklistInfo.countyName;
                        }
                    }
                    catch (IOException e) {
                        logger.log(Level.WARNING, "Could not load checklist information from eBird", e);
                    }
                }
            }
        };
    }

    @Override
    protected void parseLocationIds(LocationSet locations, PredefinedLocations predefinedLocations) throws IOException {
        try (ImportLines lines = CsvImportLines.fromFile(this.locationsFile, this.getCharset());){
            String[] line;
            this.computeMappings(lines);
            while ((line = lines.nextLine()) != null) {
                String id = (String)this.locationIdExtractor.extract((String)line);
                if (this.locationIds.hasBeenParsed(id)) continue;
                EBird.NameAndLatLong nameAndLatLong = EBird.extractLatLongFromName(id);
                if (this.countryCode != null) {
                    importedLocation = new ImportedLocation();
                    importedLocation.countryCode = this.countryCode;
                    importedLocation.stateCode = this.stateCode;
                    importedLocation.county = this.countyName;
                    importedLocation.locationNames.add(nameAndLatLong.name);
                    if (nameAndLatLong.latLong != null) {
                        importedLocation.latitude = nameAndLatLong.latLong.latitude();
                        importedLocation.longitude = nameAndLatLong.latLong.longitude();
                    }
                    if ((locationId = importedLocation.addToLocationSet(this.reportSet, locations, this.locationShortcuts, predefinedLocations)) != null) {
                        this.locationIds.put((Object)id, locationId);
                        continue;
                    }
                } else if (nameAndLatLong.latLong != null && !Strings.isNullOrEmpty(nameAndLatLong.name)) {
                    importedLocation = new ImportedLocation();
                    importedLocation.locationNames.add(nameAndLatLong.name);
                    importedLocation.latitude = nameAndLatLong.latLong.latitude();
                    importedLocation.longitude = nameAndLatLong.latLong.longitude();
                    locationId = importedLocation.tryAddToLocationSetWithLatLong(this.reportSet, locations, this.locationShortcuts, predefinedLocations);
                    if (locationId != null) {
                        this.locationIds.put((Object)id, locationId);
                        continue;
                    }
                }
                this.locationIds.addToBeResolvedLocationName(id, new ParsedLocationIds.ToBeDecided(nameAndLatLong.name, nameAndLatLong.latLong));
            }
        }
    }

    private int getRequiredLocalizedHeader(Map<String, Integer> headersByIndex, String name) {
        for (String localizedName : HEADER_NAMES.get((Object)name)) {
            Integer index = headersByIndex.get(localizedName);
            if (index == null) continue;
            return index;
        }
        throw new ImportException(Messages.getFormattedMessage(Messages.Name.IMPORT_REQUIRED_HEADER_MISSING_FORMAT, name));
    }

    static boolean matchesLocalizedHeader(String englishName, String headerEntry) {
        return ((ImmutableCollection)HEADER_NAMES.get((Object)englishName)).contains(headerEntry);
    }

    @Override
    protected ComputedMappings<String[]> computeMappings(ImportLines lines) throws IOException {
        String[] header = lines.nextLine();
        HashMap<String, Integer> headersByIndex = Maps.newHashMap();
        for (int i = 0; i < header.length; ++i) {
            headersByIndex.put(header[i], i);
        }
        int speciesIndex = this.getRequiredLocalizedHeader(headersByIndex, "Species");
        int countIndex = this.getRequiredLocalizedHeader(headersByIndex, "Count");
        int locationIndex = this.getRequiredLocalizedHeader(headersByIndex, "Location");
        int dateIndex = this.getRequiredLocalizedHeader(headersByIndex, "Observation date");
        int startTimeIndex = this.getRequiredLocalizedHeader(headersByIndex, "Start Time");
        Integer commentIndex = (Integer)headersByIndex.get("Comments");
        if (commentIndex == null) {
            commentIndex = this.getRequiredLocalizedHeader(headersByIndex, "Details");
        }
        ArrayList mappers = Lists.newArrayList();
        this.nameExtractor = LineExtractors.stringFromIndex(speciesIndex);
        this.locationIdExtractor = LineExtractors.stringFromIndex(locationIndex);
        ArrayList<DateTimeFormatter> formatters = new ArrayList<DateTimeFormatter>();
        for (Locale locale : ImmutableSet.of(Locale.getDefault(), Locale.US)) {
            for (String pattern : new String[]{"dd MMM, yy", "MMM dd, yy", "dd MMM yy", "dd-MMM-yy", "dd/MM/yy", "MM dd, yy", "yy MMM dd", "dd.MM.yyyy", "dd.MMM.yyyy", "dd/MMM/yy", "yyyy-MM-dd"}) {
                formatters.add(DateTimeFormat.forPattern(pattern).withPivotYear(2000).withLocale(locale).withChronology(GJChronology.getInstance()));
            }
        }
        mappers.add(new MultiFormatDateFromStringFieldMapper(LineExtractors.stringFromIndex(dateIndex), () -> formatters));
        mappers.add(new TimeMapper(LineExtractors.stringFromIndex(startTimeIndex)));
        mappers.add(new CountFieldMapper(LineExtractors.stringFromIndex(countIndex)));
        mappers.add(new DescriptionFieldMapper(LineExtractors.stringFromIndex(commentIndex)));
        int observationTypeIndex = this.getRequiredLocalizedHeader(headersByIndex, "Observation type");
        int durationIndex = this.getRequiredLocalizedHeader(headersByIndex, "Duration");
        int distanceIndex = this.getRequiredLocalizedHeader(headersByIndex, "Distance");
        int areaIndex = this.getRequiredLocalizedHeader(headersByIndex, "Area");
        int partySizeIndex = this.getRequiredLocalizedHeader(headersByIndex, "Party Size");
        int completeIndex = this.getRequiredLocalizedHeader(headersByIndex, "Complete Checklist");
        this.visitInfoMap = Maps.newHashMap();
        this.observationTypeExtractor = LineExtractors.stringFromIndex(observationTypeIndex);
        this.durationExtractor = LineExtractors.stringFromIndex(durationIndex);
        this.distanceExtractor = LineExtractors.stringFromIndex(distanceIndex);
        this.areaExtractor = LineExtractors.stringFromIndex(areaIndex);
        this.partySizeExtractor = LineExtractors.intFromIndex(partySizeIndex);
        this.completeExtractor = LineExtractors.booleanFromIndex(completeIndex);
        return new ComputedMappings<String[]>(new SightingsImporter.TaxonFieldMapper(this.nameExtractor), new SightingsImporter.LocationMapper(this.locationIdExtractor), mappers);
    }

    @Override
    protected Charset getCharset() {
        return StandardCharsets.UTF_8;
    }

    @Override
    protected void lookForVisitInfo(ReportSet reportSet, String[] line, Sighting newSighting, VisitInfoKey visitInfoKey) {
        VisitInfo visitInfo;
        Integer partySize;
        Area area;
        Distance distance;
        VisitInfo.Builder builder = VisitInfo.builder();
        builder.withObservationType(EBird.observationType((String)this.observationTypeExtractor.extract((String)line)));
        Duration duration = EBird.durationHrsMins((String)this.durationExtractor.extract((String)line));
        if (duration != null) {
            builder.withDuration(duration);
        }
        if ((distance = EBird.distanceMilesOrKilometers((String)this.distanceExtractor.extract((String)line))) != null) {
            builder.withDistance(distance);
        }
        if ((area = EBird.areaHectaresOrAcres((String)this.areaExtractor.extract((String)line))) != null) {
            builder.withArea(area);
        }
        if ((partySize = (Integer)this.partySizeExtractor.extract((Integer)line)) != null && partySize > 0) {
            builder.withPartySize(partySize);
        }
        if (((Boolean)this.completeExtractor.extract((Boolean)line)).booleanValue()) {
            builder.withCompleteChecklist(true);
        }
        try {
            visitInfo = builder.build();
        }
        catch (IllegalStateException e) {
            builder.withObservationType(VisitInfo.ObservationType.HISTORICAL);
            visitInfo = builder.build();
        }
        if (visitInfo.hasData()) {
            this.visitInfoMap.put(visitInfoKey, visitInfo);
        }
    }

    @Override
    public Map<VisitInfoKey, VisitInfo> getAccumulatedVisitInfoMap() {
        return this.visitInfoMap;
    }

    static {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        URL resource = Resources.getResource(EBirdChecklistImporter.class, "ebird-checklist-headers.csv");
        try (ImportLines headers = CsvImportLines.fromUrl(resource, StandardCharsets.UTF_8);){
            String[] line;
            String[] englishLine;
            for (String english : englishLine = headers.nextLine()) {
                builder.put(english, english);
            }
            while ((line = headers.nextLine()) != null) {
                Preconditions.checkState(line.length == englishLine.length);
                for (int i = 0; i < line.length; ++i) {
                    builder.put(englishLine[i], line[i]);
                }
            }
            HEADER_NAMES = builder.build();
        }
        catch (IOException e) {
            throw new AssertionError((Object)"Could not load EBird headers files");
        }
    }
}

