/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.inject.Inject;
import com.scythebill.birdlist.ui.guice.EBirdApiKey;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;

class EBirdChecklistApi {
    private final String eBirdApiKey;
    private final CloseableHttpClient httpClient;
    private Gson gson;

    @Inject
    public EBirdChecklistApi(Gson gson, CloseableHttpClient httpClient, @EBirdApiKey String eBirdApiKey) {
        this.gson = gson;
        this.httpClient = httpClient;
        this.eBirdApiKey = eBirdApiKey;
    }

    public ChecklistInfo resolveChecklist(String checklistId) throws IOException {
        ChecklistInfo checklistInfo;
        block33: {
            List<String> codes;
            ChecklistApiResult result;
            URI uri;
            try {
                uri = new URIBuilder("https://api.ebird.org/v2/product/checklist/view/" + checklistId).build();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            try (CloseableHttpResponse get = this.httpClient.execute(this.newHttpGet(uri));){
                HttpEntity entity = get.getEntity();
                try (InputStreamReader reader = new InputStreamReader((InputStream)new BufferedInputStream(entity.getContent()), StandardCharsets.UTF_8);){
                    result = this.gson.fromJson((Reader)reader, ChecklistApiResult.class);
                }
            }
            checklistInfo = new ChecklistInfo();
            if (!Strings.isNullOrEmpty(result.subnational1Code) && (codes = Splitter.on('-').omitEmptyStrings().splitToList(result.subnational1Code)).size() >= 1) {
                checklistInfo.countryCode = codes.get(0);
                if (codes.size() >= 2) {
                    checklistInfo.stateCode = codes.get(1);
                }
            }
            if (!Strings.isNullOrEmpty(result.locId)) {
                URI hotspotApiUri;
                try {
                    hotspotApiUri = new URIBuilder("https://api.ebird.org/v2/ref/hotspot/info/" + result.locId).build();
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
                try (CloseableHttpResponse get = this.httpClient.execute(this.newHttpGet(hotspotApiUri));){
                    if (get.getStatusLine().getStatusCode() != 200) break block33;
                    HttpEntity entity = get.getEntity();
                    try (InputStreamReader reader = new InputStreamReader((InputStream)new BufferedInputStream(entity.getContent()), StandardCharsets.UTF_8);){
                        List<String> codes2;
                        HotspotApiResult hotspot = this.gson.fromJson((Reader)reader, HotspotApiResult.class);
                        if (!Strings.isNullOrEmpty(hotspot.subnational2Name)) {
                            checklistInfo.countyName = hotspot.subnational2Name;
                        }
                        if (!Strings.isNullOrEmpty(hotspot.subnational1Code) && (codes2 = Splitter.on('-').omitEmptyStrings().splitToList(hotspot.subnational1Code)).size() >= 1) {
                            checklistInfo.countryCode = codes2.get(0);
                            if (codes2.size() >= 2) {
                                checklistInfo.stateCode = codes2.get(1);
                            }
                        }
                    }
                }
            }
        }
        return checklistInfo;
    }

    private HttpGet newHttpGet(URI uri) {
        HttpGet httpGet = new HttpGet(uri);
        httpGet.setConfig(RequestConfig.custom().setConnectionRequestTimeout(5000).setConnectTimeout(5000).setSocketTimeout(5000).build());
        httpGet.addHeader("X-eBirdApiToken", this.eBirdApiKey);
        return httpGet;
    }

    static class ChecklistApiResult {
        public String subnational1Code;
        public String locId;

        ChecklistApiResult() {
        }
    }

    public static class ChecklistInfo {
        public String countryCode;
        public String stateCode;
        public String countyName;
    }

    static class HotspotApiResult {
        public String subnational1Code;
        public String subnational2Name;

        HotspotApiResult() {
        }
    }
}

