/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.io.CsvImportLines;
import com.scythebill.birdlist.model.io.ImportLines;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingInfo;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.imports.ComputedMappings;
import com.scythebill.birdlist.ui.imports.CountFieldMapper;
import com.scythebill.birdlist.ui.imports.CsvSightingsImporter;
import com.scythebill.birdlist.ui.imports.EBird;
import com.scythebill.birdlist.ui.imports.FieldMapper;
import com.scythebill.birdlist.ui.imports.FieldTaxonImporter;
import com.scythebill.birdlist.ui.imports.ImportedLocation;
import com.scythebill.birdlist.ui.imports.LineExtractor;
import com.scythebill.birdlist.ui.imports.LineExtractors;
import com.scythebill.birdlist.ui.imports.MultiFormatDateFromStringFieldMapper;
import com.scythebill.birdlist.ui.imports.SightingsImporter;
import com.scythebill.birdlist.ui.imports.TaxonImporter;
import com.scythebill.birdlist.ui.imports.TaxonResolver;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Locale;

public class EBird2023LifeListImporter
extends CsvSightingsImporter {
    private LineExtractor<String> locationIdExtractor;
    private LineExtractor<String> taxonomyIdExtractor;
    private LineExtractor<String> commonNameExtractor;
    private LineExtractor<String> sciNameExtractor;
    private LineExtractor<String> countryAndStateExtractor;
    private LineExtractor<String> locationExtractor;

    public EBird2023LifeListImporter(ReportSet reportSet, Taxonomy taxonomy, Checklists checklists, PredefinedLocations predefinedLocations, File file) {
        super(reportSet, taxonomy, checklists, predefinedLocations, file, file);
    }

    protected LineExtractor<? extends Object> taxonomyIdExtractor() {
        return this.taxonomyIdExtractor;
    }

    @Override
    protected TaxonImporter<String[]> newTaxonImporter(Taxonomy taxonomy) {
        TaxonResolver taxonResolver = new TaxonResolver(taxonomy);
        taxonResolver.setMaximumNameDistance(1);
        return new FieldTaxonImporter<String[]>(taxonResolver, this.commonNameExtractor, this.sciNameExtractor);
    }

    @Override
    protected void parseLocationIds(LocationSet locations, PredefinedLocations predefinedLocations) throws IOException {
        try (ImportLines lines = CsvImportLines.fromFile(this.locationsFile, this.getCharset());){
            String[] line;
            this.computeMappings(lines);
            while ((line = lines.nextLine()) != null) {
                String id = (String)this.locationIdExtractor.extract((String)line);
                if (this.locationIds.hasBeenParsed(id)) continue;
                ImportedLocation imported = new ImportedLocation();
                ArrayList<String> countryAndState = Lists.newArrayList(Splitter.on('-').split((CharSequence)this.countryAndStateExtractor.extract((String)line)));
                if (countryAndState.size() != 2) {
                    throw new IllegalArgumentException("Doesn't look like an EBird file.  Location contains " + line[5]);
                }
                imported.countryCode = (String)countryAndState.get(0);
                imported.stateCode = (String)countryAndState.get(1);
                String location = (String)this.locationExtractor.extract((String)line);
                if (!Strings.isNullOrEmpty(location)) {
                    EBird.NameAndLatLong nameAndLatLong = EBird.extractLatLongFromName(location);
                    imported.locationNames.add(nameAndLatLong.name);
                    if (nameAndLatLong.latLong != null) {
                        imported.latitude = nameAndLatLong.latLong.latitudeAsCanonicalString();
                        imported.longitude = nameAndLatLong.latLong.longitudeAsCanonicalString();
                    }
                }
                String locationId = imported.addToLocationSet(this.reportSet, locations, this.locationShortcuts, predefinedLocations);
                this.locationIds.put((Object)id, locationId);
            }
        }
    }

    @Override
    protected ComputedMappings<String[]> computeMappings(ImportLines lines) throws IOException {
        String[] header = lines.nextLine();
        LinkedHashMap<String, Integer> headersByIndex = new LinkedHashMap<String, Integer>();
        for (int i = 0; i < header.length; ++i) {
            headersByIndex.put(header[i].toLowerCase(), i);
        }
        int commonIndex = this.getRequiredHeader(headersByIndex, "Common Name", String::toLowerCase);
        int sciIndex = this.getRequiredHeader(headersByIndex, "Scientific Name", String::toLowerCase);
        int countIndex = this.getRequiredHeader(headersByIndex, "Count", String::toLowerCase);
        int locationIndex = this.getRequiredHeader(headersByIndex, "Location", String::toLowerCase);
        int dateIndex = this.getRequiredHeader(headersByIndex, "Date", String::toLowerCase);
        int countryAndStateIndex = this.getRequiredHeader(headersByIndex, "S/P", String::toLowerCase);
        int exoticIndex = this.getRequiredHeader(headersByIndex, "Exotic", String::toLowerCase);
        ArrayList mappers = Lists.newArrayList();
        mappers.add(new MultiFormatDateFromStringFieldMapper(LineExtractors.stringFromIndex(dateIndex), Locale.US, "dd MMM yy", "dd-MMM-yy"));
        mappers.add(new CountFieldMapper(LineExtractors.stringFromIndex(countIndex)));
        this.commonNameExtractor = LineExtractors.stringFromIndex(commonIndex);
        this.sciNameExtractor = LineExtractors.stringFromIndex(sciIndex);
        this.taxonomyIdExtractor = LineExtractors.joined(Joiner.on('|').useForNull(""), this.commonNameExtractor, this.sciNameExtractor);
        this.countryAndStateExtractor = LineExtractors.stringFromIndex(countryAndStateIndex);
        this.locationExtractor = LineExtractors.stringFromIndex(locationIndex);
        this.locationIdExtractor = LineExtractors.joined(Joiner.on('|').useForNull(""), this.countryAndStateExtractor, this.locationExtractor);
        final LineExtractor<Boolean> exoticExtractor = LineExtractors.booleanFromIndex(exoticIndex);
        mappers.add(new FieldMapper<String[]>(){

            @Override
            public void map(String[] line, Sighting.Builder sighting) {
                if (Boolean.TRUE.equals(exoticExtractor.extract(line))) {
                    sighting.getSightingInfo().setSightingStatus(SightingInfo.SightingStatus.INTRODUCED_NOT_ESTABLISHED);
                }
            }
        });
        return new ComputedMappings<String[]>(new SightingsImporter.TaxonFieldMapper(this.taxonomyIdExtractor), new SightingsImporter.LocationMapper(this.locationIdExtractor), mappers);
    }
}

