/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.io.CsvImportLines;
import com.scythebill.birdlist.model.io.ImportLines;
import com.scythebill.birdlist.model.sighting.Area;
import com.scythebill.birdlist.model.sighting.Distance;
import com.scythebill.birdlist.model.sighting.LatLongCoordinates;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.VisitInfo;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.imports.AlwaysFailImporter;
import com.scythebill.birdlist.ui.imports.CsvSightingsImporter;
import com.scythebill.birdlist.ui.imports.EBird2023LifeListImporter;
import com.scythebill.birdlist.ui.imports.EBirdChecklistApi;
import com.scythebill.birdlist.ui.imports.EBirdChecklistImporter;
import com.scythebill.birdlist.ui.imports.EBirdImportImporter;
import com.scythebill.birdlist.ui.imports.EBirdLifeListImporter;
import com.scythebill.birdlist.ui.imports.EBirdMyDataImporter;
import com.scythebill.birdlist.ui.imports.LineExtractor;
import com.scythebill.birdlist.ui.imports.TaxonPossibilities;
import com.scythebill.birdlist.ui.imports.TaxonResolver;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.Duration;

class EBird {
    private static final Logger logger = Logger.getLogger(EBird.class.getName());
    private final EBirdChecklistApi ebirdChecklistApi;
    private static Pattern COMMON_AND_SCIENTIFIC_IN_PARENS = Pattern.compile("^(.+) \\((.+)\\)$");
    private static Pattern COMMON_AND_SCIENTIFIC_HYPHENATED = Pattern.compile("^(.+) - (.+)$");
    private static final Pattern SCIENTIFIC = Pattern.compile("^\\(?[A-Z][a-z]+ [a-z]+\\)?");
    private static final CharMatcher PARENS = CharMatcher.anyOf("()");
    private static final List<Pattern> HOURS_AND_MINUTES = ImmutableList.of(Pattern.compile("(\\d+) hour.*?(\\d+) minute.*"), Pattern.compile("(\\d+) hodin.*?(\\d+) minut.*"), Pattern.compile("(\\d+) Stunde.*?(\\d+) Minute.*"), Pattern.compile("(\\d+) ordu.*?(\\d+) minutu.*"), Pattern.compile("(\\d+) heure.*?(\\d+) minute.*"), Pattern.compile("(\\d+) ora.*?(\\d+) minute.*"), Pattern.compile("(\\d+) \u05e9\u05e2\u05d5\u05ea, (\\d+) \u05d3\u05e7\u05d5\u05ea"), Pattern.compile("(\\d+) \u6642\u9593.*?(\\d+) \u5206"), Pattern.compile("(\\d+) time.*?(\\d+) minutt.*"), Pattern.compile("(\\d+) hora.*?(\\d+) minuto.*"), Pattern.compile("(\\d+) \u0447\u0430\u0441.*?(\\d+) \u043c\u0438\u043d\u0443\u0442\u0430.*"), Pattern.compile("(\\d+) saat, (\\d+) dakika"), new Pattern[]{Pattern.compile("(\\d+) \u0433\u043e\u0434\u0438\u043d.*?(\\d+) \u0445\u0432\u0438\u043b\u0438\u043d.*"), Pattern.compile("(\\d+) \u5c0f\u65f6, (\\d+) \u5206\u949f"), Pattern.compile("(\\d+) \u5c0f\u6642.*?(\\d+) \u5206.*")});
    private static final List<Pattern> HOURS = ImmutableList.of(Pattern.compile("(\\d+) hour.*"), Pattern.compile("(\\d+) hodin.*"), Pattern.compile("(\\d+) Stunde.*"), Pattern.compile("(\\d+) ordu.*"), Pattern.compile("(\\d+) heure.*"), Pattern.compile("(\\d+) ora.*"), Pattern.compile("(\\d+) \u05e9\u05e2\u05d5\u05ea"), Pattern.compile("(\\d+) \u6642\u9593.*?"), Pattern.compile("(\\d+) time.*"), Pattern.compile("(\\d+) hora.*"), Pattern.compile("(\\d+) \u0447\u0430\u0441.*"), Pattern.compile("(\\d+) saat"), new Pattern[]{Pattern.compile("(\\d+) \u0433\u043e\u0434\u0438\u043d.*"), Pattern.compile("(\\d+) \u5c0f\u6642.*"), Pattern.compile("(\\d+) \u5c0f\u65f6")});
    private static final List<Pattern> MINUTES = ImmutableList.of(Pattern.compile("(\\d+) minut.*"), Pattern.compile("(\\d+) Minute.*"), Pattern.compile("(\\d+) \u05d3\u05e7\u05d5\u05ea"), Pattern.compile("(\\d+) \u5206"), Pattern.compile("(\\d+) \u043c\u0438\u043d\u0443\u0442\u0430.*"), Pattern.compile("(\\d+) dakika"), Pattern.compile("(\\d+) \u0445\u0432\u0438\u043b\u0438\u043d.*"), Pattern.compile("(\\d+) \u5206.*"), Pattern.compile("(\\d+) \u5206\u949f"));
    private static CharMatcher ONLY_DECIMAL = CharMatcher.inRange('0', '9').or(CharMatcher.is('.'));
    private static final ImmutableList<String> MILES_STRINGS = ImmutableList.of("mil", "Meile", "miglio", "\u05de\u05d9\u05d9\u05dc", "\u30de\u30a4\u30eb", "\u043c\u0438\u043b\u044f", "\u043c\u0438\u043b\u044c", "\u82f1\u91cc");
    private static final ImmutableList<String> KILOMETER_STRINGS = ImmutableList.of("kilo", "Kilo", "kil\u00f3", "chilo", "quil\u00f3", "km", "\u043a\u0438\u043b\u043e", "\u043a\u0456\u043b\u043e", "\u5343\u7c73", "\u516c\u91cc", "\u05e7\u05d9\u05dc\u05d5", "\u30ad\u30ed\u30e1\u30fc\u30c8\u30eb", new String[0]);
    private static final Pattern PAREN_PATTERN = Pattern.compile("(.*?) \\((-?\\d+\\.\\d+), (-?\\d+\\.\\d+)\\)");
    private static final Pattern X_PATTERN = Pattern.compile("(.*?) - (-?\\d+\\.\\d+)x(-?\\d+\\.\\d+)");
    private static final Pattern COMMA_PATTERN = Pattern.compile("(.*?)\\s*(-?\\d+\\.\\d+),\\s*(-?\\d+\\.\\d+)");

    @Inject
    EBird(EBirdChecklistApi ebirdChecklistApi) {
        this.ebirdChecklistApi = ebirdChecklistApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CsvSightingsImporter chooseImporter(File openFile, ReportSet reportSet, Taxonomy clements, Checklists checklists, PredefinedLocations predefinedLocations) {
        ImportLines importLines = null;
        try {
            importLines = CsvImportLines.fromFile(openFile, StandardCharsets.UTF_8);
            List<String> nextLine = Arrays.asList(importLines.nextLine());
            if (!nextLine.isEmpty() && EBirdChecklistImporter.matchesLocalizedHeader("Species", nextLine.get(0))) {
                EBirdChecklistImporter eBirdChecklistImporter = new EBirdChecklistImporter(reportSet, clements, checklists, predefinedLocations, openFile, this.ebirdChecklistApi);
                return eBirdChecklistImporter;
            }
            if (nextLine.contains("Checklist Comments")) {
                EBirdMyDataImporter eBirdMyDataImporter = new EBirdMyDataImporter(reportSet, clements, checklists, predefinedLocations, openFile);
                return eBirdMyDataImporter;
            }
            if (nextLine.get(0).equalsIgnoreCase("Row #") && nextLine.contains("S/P") && nextLine.contains("LocID")) {
                if (nextLine.contains("Countable")) {
                    EBird2023LifeListImporter eBird2023LifeListImporter = new EBird2023LifeListImporter(reportSet, clements, checklists, predefinedLocations, openFile);
                    return eBird2023LifeListImporter;
                }
                EBirdLifeListImporter eBirdLifeListImporter = new EBirdLifeListImporter(reportSet, clements, checklists, predefinedLocations, openFile);
                return eBirdLifeListImporter;
            }
            EBirdImportImporter eBirdImportImporter = new EBirdImportImporter(reportSet, clements, checklists, predefinedLocations, openFile);
            return eBirdImportImporter;
        }
        catch (IOException e) {
            AlwaysFailImporter alwaysFailImporter = new AlwaysFailImporter(reportSet, clements, checklists, predefinedLocations, openFile, e.getMessage());
            return alwaysFailImporter;
        }
        finally {
            try {
                if (importLines != null) {
                    importLines.close();
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Could not close", e);
            }
        }
    }

    private static boolean mightBeScientificName(String name, TaxonResolver taxonResolver) {
        if (!SCIENTIFIC.matcher(name).find()) {
            return false;
        }
        TaxonPossibilities mapCommonName = taxonResolver.map(name, null, null);
        TaxonPossibilities mapScientificName = taxonResolver.map(null, name, null);
        return mapCommonName == null && mapScientificName != null;
    }

    public static VisitInfo.ObservationType observationType(String extracted) {
        if (Strings.isNullOrEmpty(extracted)) {
            return VisitInfo.ObservationType.HISTORICAL;
        }
        VisitInfo.ObservationType type = VisitInfo.ObservationType.fromName(extracted);
        if (type == null) {
            type = VisitInfo.ObservationType.HISTORICAL;
        }
        return type;
    }

    public static Duration durationHrsMins(String extracted) {
        Matcher matcher;
        if (Strings.isNullOrEmpty(extracted)) {
            return null;
        }
        for (Pattern hoursAndMinutes : HOURS_AND_MINUTES) {
            matcher = hoursAndMinutes.matcher(extracted);
            if (!matcher.matches()) continue;
            String hours = matcher.group(1);
            String minutes = matcher.group(2);
            return Duration.standardHours(Integer.parseInt(hours)).plus(Duration.standardMinutes(Integer.parseInt(minutes)));
        }
        for (Pattern hoursPattern : HOURS) {
            matcher = hoursPattern.matcher(extracted);
            if (!matcher.matches()) continue;
            String hours = matcher.group(1);
            return Duration.standardHours(Integer.parseInt(hours));
        }
        for (Pattern minutesPattern : MINUTES) {
            matcher = minutesPattern.matcher(extracted);
            if (!matcher.matches()) continue;
            String minutes = matcher.group(1);
            return Duration.standardMinutes(Integer.parseInt(minutes));
        }
        return null;
    }

    public static Distance distanceMilesOrKilometers(String extracted) {
        if (extracted == null) {
            return null;
        }
        String justDecimal = ONLY_DECIMAL.retainFrom(extracted);
        if (justDecimal.isEmpty()) {
            return null;
        }
        for (String milesString : MILES_STRINGS) {
            if (!extracted.contains(milesString)) continue;
            return Distance.inMiles(Float.parseFloat(justDecimal));
        }
        for (String milesString : KILOMETER_STRINGS) {
            if (!extracted.contains(milesString)) continue;
            return Distance.inKilometers(Float.parseFloat(justDecimal));
        }
        return null;
    }

    public static Area areaHectaresOrAcres(String extracted) {
        if (extracted == null) {
            return null;
        }
        String justDecimal = ONLY_DECIMAL.retainFrom(extracted);
        if (justDecimal.isEmpty()) {
            return null;
        }
        if (extracted.contains("ac")) {
            return Area.inAcres(Float.parseFloat(justDecimal));
        }
        if (extracted.contains("ha")) {
            return Area.inHectares(Float.parseFloat(justDecimal));
        }
        return null;
    }

    public static NameAndLatLong extractLatLongFromName(String name) {
        NameAndLatLong nameAndLatLong = new NameAndLatLong();
        nameAndLatLong.name = name;
        Matcher matcher = PAREN_PATTERN.matcher(name);
        if (!matcher.matches()) {
            matcher = X_PATTERN.matcher(name);
        }
        if (!matcher.matches()) {
            matcher = COMMA_PATTERN.matcher(name);
        }
        if (matcher.matches()) {
            try {
                nameAndLatLong.latLong = LatLongCoordinates.withLatAndLong(matcher.group(2), matcher.group(3));
                nameAndLatLong.name = matcher.group(1);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return nameAndLatLong;
    }

    static class NameAndLatLong {
        String name;
        LatLongCoordinates latLong;

        NameAndLatLong() {
        }
    }

    static class ScientificNameExtractor
    implements LineExtractor<String> {
        private final LineExtractor<String> extractor;
        private final TaxonResolver taxonResolver;

        ScientificNameExtractor(LineExtractor<String> extractor, TaxonResolver taxonResolver) {
            this.extractor = Preconditions.checkNotNull(extractor);
            this.taxonResolver = taxonResolver;
        }

        @Override
        public String extract(String[] line) {
            String name = (String)this.extractor.extract((String)line);
            if (name == null) {
                return null;
            }
            Matcher matcher = COMMON_AND_SCIENTIFIC_IN_PARENS.matcher(name);
            if (matcher.matches()) {
                int middle;
                if (name.endsWith("))") && (middle = name.indexOf(") (")) > 0) {
                    return name.substring(middle + 3, name.length() - 1);
                }
                if (EBird.mightBeScientificName(matcher.group(2), this.taxonResolver)) {
                    return matcher.group(2);
                }
            }
            if ((matcher = COMMON_AND_SCIENTIFIC_HYPHENATED.matcher(name)).matches() && EBird.mightBeScientificName(matcher.group(2), this.taxonResolver)) {
                return matcher.group(2);
            }
            if (EBird.mightBeScientificName(name, this.taxonResolver)) {
                return PARENS.trimFrom(name);
            }
            return null;
        }
    }

    static class CommonNameExtractor
    implements LineExtractor<String> {
        private final LineExtractor<String> extractor;
        private final TaxonResolver taxonResolver;

        CommonNameExtractor(LineExtractor<String> extractor, TaxonResolver taxonResolver) {
            this.extractor = Preconditions.checkNotNull(extractor);
            this.taxonResolver = taxonResolver;
        }

        @Override
        public String extract(String[] line) {
            String name = (String)this.extractor.extract((String)line);
            if (name == null) {
                return null;
            }
            Matcher matcher = COMMON_AND_SCIENTIFIC_IN_PARENS.matcher(name);
            if (matcher.matches()) {
                int firstRightParen;
                if (name.endsWith("))") && (firstRightParen = name.indexOf(41)) > 0) {
                    return name.substring(0, firstRightParen + 1);
                }
                if (EBird.mightBeScientificName(matcher.group(2), this.taxonResolver)) {
                    return matcher.group(1);
                }
            }
            if ((matcher = COMMON_AND_SCIENTIFIC_HYPHENATED.matcher(name)).matches() && EBird.mightBeScientificName(matcher.group(2), this.taxonResolver)) {
                return matcher.group(1);
            }
            if (EBird.mightBeScientificName(name, this.taxonResolver)) {
                return null;
            }
            return name;
        }
    }
}

