/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.ui.imports.FieldMapper;
import com.scythebill.birdlist.ui.imports.RowExtractor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.joda.time.DateTimeFieldType;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.Partial;
import org.joda.time.chrono.GJChronology;

public class DateFromYearMonthDayFieldMapper<T>
implements FieldMapper<T> {
    private final RowExtractor<T, Integer> yearExtractor;
    private final RowExtractor<T, Integer> monthExtractor;
    private final RowExtractor<T, Integer> dayExtractor;

    public DateFromYearMonthDayFieldMapper(RowExtractor<T, Integer> yearExtractor, RowExtractor<T, Integer> monthExtractor, RowExtractor<T, Integer> dayExtractor) {
        this.yearExtractor = yearExtractor;
        this.monthExtractor = monthExtractor;
        this.dayExtractor = dayExtractor;
    }

    @Override
    public void map(T line, Sighting.Builder sighting) {
        Partial p = new Partial(GJChronology.getInstance());
        p = this.with(p, DateTimeFieldType.year(), this.yearExtractor.extract(line));
        p = this.with(p, DateTimeFieldType.monthOfYear(), this.monthExtractor.extract(line));
        p = this.with(p, DateTimeFieldType.dayOfMonth(), this.dayExtractor.extract(line));
        sighting.setDate(p);
    }

    private Partial with(Partial p, DateTimeFieldType type, Integer extracted) {
        if (extracted == null || extracted == 0) {
            return p;
        }
        try {
            return p.with(type, extracted);
        }
        catch (IllegalFieldValueException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Failed to parse field {0} with value {1}", new Object[]{type, extracted});
            return p;
        }
    }
}

