/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.Strings;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.ui.imports.DateParseException;
import com.scythebill.birdlist.ui.imports.FieldMapper;
import com.scythebill.birdlist.ui.imports.RowExtractor;
import org.joda.time.chrono.GJChronology;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateFromStringFieldMapper<T>
implements FieldMapper<T> {
    private DateTimeFormatter dateTimeFormatter;
    private RowExtractor<T, String> extractor;

    public DateFromStringFieldMapper(String pattern, RowExtractor<T, String> extractor) {
        this.extractor = extractor;
        this.dateTimeFormatter = DateTimeFormat.forPattern(pattern).withChronology(GJChronology.getInstance()).withPivotYear(2000);
    }

    @Override
    public void map(T line, Sighting.Builder sighting) {
        String date = Strings.emptyToNull(this.extractor.extract(line));
        if (date != null) {
            try {
                sighting.setDate(this.dateTimeFormatter.parseLocalDate(date));
            }
            catch (IllegalArgumentException e) {
                throw new DateParseException(e);
            }
        }
    }
}

