/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.io.CsvExportLines;
import com.scythebill.birdlist.model.io.CsvImportLines;
import com.scythebill.birdlist.model.io.ExportLines;
import com.scythebill.birdlist.model.io.ImportLines;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.imports.ComputedMappings;
import com.scythebill.birdlist.ui.imports.DateParseException;
import com.scythebill.birdlist.ui.imports.ImportException;
import com.scythebill.birdlist.ui.imports.RowExtractor;
import com.scythebill.birdlist.ui.imports.SightingsImporter;
import com.scythebill.birdlist.ui.messages.Messages;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class CsvSightingsImporter
extends SightingsImporter<String[]> {
    private static final Logger logger = Logger.getLogger(CsvSightingsImporter.class.getName());
    private final List<String[]> failedLines = Lists.newArrayList();
    protected final File sightingsFile;
    protected final File locationsFile;

    protected CsvSightingsImporter(ReportSet reportSet, Taxonomy taxonomy, Checklists checklists, PredefinedLocations predefinedLocations, File sightingsFile, File locationsFile) {
        super(reportSet, taxonomy, checklists, predefinedLocations);
        this.sightingsFile = sightingsFile;
        this.locationsFile = locationsFile;
    }

    public List<Sighting> runImport() throws IOException {
        this.parseLocationIds();
        return this.parseSightings();
    }

    public void writeFailedLines(ExportLines writer) throws IOException {
        for (String[] failedLine : this.failedLines) {
            writer.nextLine(failedLine);
        }
    }

    protected Charset getCharset() {
        return StandardCharsets.UTF_8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<String> initialCheck() throws IOException {
        ImportLines lines = this.importLines(this.sightingsFile);
        int i = 0;
        int dateFailures = 0;
        try {
            String[] line;
            this.beforeParseTaxonomyIds();
            ComputedMappings<String[]> computedMappings = this.computeMappings(lines);
            this.computeExtendedMappings();
            while ((line = lines.nextLine()) != null) {
                if (this.skipLine(line)) continue;
                try {
                    Sighting.Builder newBuilder = Sighting.newBuilder();
                    computedMappings.skipLocationAndTaxonAndUser(line, newBuilder);
                    Optional<String> optional = Optional.absent();
                    return optional;
                }
                catch (RuntimeException e) {
                    if (i++ < 10) {
                        logger.log(Level.WARNING, "Failed to parse line", e);
                    }
                    if (!(e instanceof DateParseException)) continue;
                    ++dateFailures;
                    continue;
                }
                break;
            }
        }
        finally {
            lines.close();
        }
        return Optional.of(this.getFailedParseFormat(dateFailures == i));
    }

    protected String getFailedParseFormat(boolean allDateFailures) {
        return Messages.getMessage(Messages.Name.COULD_NOT_EXTRACT_ANY_DATA_FORMAT);
    }

    protected void computeExtendedMappings() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void operateOnAllRows(SightingsImporter.RowOperator<String[]> operator2) throws IOException {
        try (ImportLines lines = this.importLines(this.sightingsFile);){
            String[] line;
            this.computeMappings(lines);
            while ((line = lines.nextLine()) != null) {
                if (this.skipLine(line)) continue;
                operator2.operate(line);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Sighting> parseSightings() throws IOException {
        this.beforeParseSightings();
        try (ImportLines lines = this.importLines(this.sightingsFile);){
            String[] line;
            ComputedMappings<String[]> computedMappings = this.computeMappings(lines);
            this.computeExtendedMappings();
            RowExtractor taxonomyIdExtractor = this.taxonomyIdExtractor();
            ArrayList<Sighting> sightings = Lists.newArrayList();
            while ((line = lines.nextLine()) != null) {
                if (this.skipLine(line)) continue;
                this.parseSighting(line, computedMappings::mapAll, taxonomyIdExtractor::extract, sightings, computedMappings::skipLocationAndTaxonAndUser);
            }
            this.allSightingsFinished();
            ArrayList<Sighting> arrayList = sightings;
            return arrayList;
        }
    }

    protected void beforeParseSightings() throws IOException {
    }

    protected void allSightingsFinished() {
    }

    protected abstract ComputedMappings<String[]> computeMappings(ImportLines var1) throws IOException;

    protected ImportLines importLines(File file) throws IOException {
        return CsvImportLines.fromFile(file, this.getCharset());
    }

    protected boolean skipLine(String[] line) {
        return false;
    }

    protected int getRequiredHeader(Map<String, Integer> indexMap, String key) throws IOException {
        return this.getRequiredHeader(indexMap, key, String::toLowerCase);
    }

    protected int getRequiredHeader(Map<String, Integer> indexMap, String key, Function<String, String> transform) throws IOException {
        Integer index = indexMap.get(transform.apply(key));
        if (index == null) {
            throw new ImportException(Messages.getFormattedMessage(Messages.Name.IMPORT_REQUIRED_HEADER_MISSING_FORMAT, key));
        }
        return index;
    }

    protected int getRequiredHeader(Map<String, Integer> indexMap, Function<String, String> transform, String ... keys) throws IOException {
        Preconditions.checkArgument(keys.length > 0);
        for (String key : keys) {
            Integer index = indexMap.get(transform.apply(key));
            if (index == null) continue;
            return index;
        }
        throw new ImportException(Messages.getFormattedMessage(Messages.Name.IMPORT_REQUIRED_HEADER_MISSING_FORMAT, keys[0]));
    }

    protected int getRequiredHeader(Map<String, Integer> indexMap, Function<String, String> transform, Iterable<String> keys) throws IOException {
        Preconditions.checkArgument(!Iterables.isEmpty(keys));
        for (String key : keys) {
            Integer index = indexMap.get(transform.apply(key));
            if (index == null) continue;
            return index;
        }
        throw new ImportException(Messages.getFormattedMessage(Messages.Name.IMPORT_REQUIRED_HEADER_MISSING_FORMAT, keys.iterator().next()));
    }

    protected String[] getHeaderRow(ImportLines lines) throws IOException {
        return null;
    }

    @Override
    protected void importRowFailed(String[] line) {
        this.failedLines.add(line);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File writeFailedLines() {
        File file;
        File failedLinesFile = null;
        for (int i = 0; i < 50 && (failedLinesFile = this.failedFile(this.sightingsFile, i)).exists(); ++i) {
        }
        if (failedLinesFile == null || failedLinesFile.exists()) {
            return null;
        }
        if (!failedLinesFile.createNewFile()) {
            return null;
        }
        ExportLines writer = CsvExportLines.fromWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(failedLinesFile), StandardCharsets.UTF_8)));
        try {
            try (ImportLines importLines = this.importLines(this.sightingsFile);){
                String[] headerRow = this.getHeaderRow(importLines);
                if (headerRow != null) {
                    writer.nextLine(headerRow);
                }
            }
            this.writeFailedLines(writer);
            file = failedLinesFile;
        }
        catch (Throwable throwable) {
            try {
                writer.close();
                throw throwable;
            }
            catch (Exception e) {
                return null;
            }
        }
        writer.close();
        return file;
    }

    private File failedFile(File openFile, int index) {
        Object failedLinesFileName = openFile.getName();
        if (((String)failedLinesFileName).indexOf(46) >= 0) {
            failedLinesFileName = ((String)failedLinesFileName).substring(0, ((String)failedLinesFileName).lastIndexOf(46));
        }
        failedLinesFileName = index == 0 ? (String)failedLinesFileName + "-failed.csv" : (String)failedLinesFileName + "-" + index + "-failed.csv";
        return new File(openFile.getParentFile(), (String)failedLinesFileName);
    }

    @Override
    public String importFileName() {
        return this.sightingsFile.getName();
    }
}

