/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.scythebill.birdlist.model.sighting.ApproximateNumber;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingInfo;
import com.scythebill.birdlist.ui.imports.FieldMapper;
import com.scythebill.birdlist.ui.imports.RowExtractor;

public class CountFieldMapper<T>
implements FieldMapper<T> {
    private final RowExtractor<T, String> countExtractor;

    public CountFieldMapper(RowExtractor<T, String> countExtractor) {
        this.countExtractor = countExtractor;
    }

    @Override
    public void map(T line, Sighting.Builder sighting) {
        ApproximateNumber number;
        String count = this.countExtractor.extract(line);
        if (count != null && (number = ApproximateNumber.tryParse(count)) != null) {
            if (number.getNumber() == 0) {
                if (sighting.getSightingInfo().getSightingStatus() == SightingInfo.SightingStatus.NONE) {
                    sighting.getSightingInfo().setSightingStatus(SightingInfo.SightingStatus.NOT_BY_ME);
                }
            } else {
                sighting.getSightingInfo().setNumber(number);
            }
        }
    }
}

