/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.ui.imports.FieldMapper;
import com.scythebill.birdlist.ui.imports.SightingsImporter;
import com.scythebill.birdlist.ui.imports.UserFieldMapper;
import javax.annotation.Nullable;

public class ComputedMappings<T> {
    private final SightingsImporter.TaxonFieldMapper taxonFieldMapper;
    private final SightingsImporter.LocationMapper locationMapper;
    private final ImmutableList<FieldMapper<T>> otherMappers;

    public ComputedMappings(SightingsImporter.TaxonFieldMapper taxonFieldMapper, @Nullable SightingsImporter.LocationMapper locationMapper, Iterable<FieldMapper<T>> otherMappers) {
        this.taxonFieldMapper = Preconditions.checkNotNull(taxonFieldMapper);
        this.locationMapper = locationMapper;
        this.otherMappers = ImmutableList.copyOf(otherMappers);
    }

    public void mapAll(T importRow, Sighting.Builder sighting) {
        if (this.locationMapper != null) {
            this.locationMapper.map(importRow, sighting);
        }
        this.taxonFieldMapper.map(importRow, sighting);
        for (FieldMapper fieldMapper : this.otherMappers) {
            fieldMapper.map(importRow, sighting);
        }
    }

    public void skipLocationAndTaxonAndUser(T importRow, Sighting.Builder sighting) {
        for (FieldMapper fieldMapper : this.otherMappers) {
            if (fieldMapper instanceof UserFieldMapper) continue;
            fieldMapper.map(importRow, sighting);
        }
    }
}

