/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingInfo;
import com.scythebill.birdlist.ui.imports.FieldMapper;
import com.scythebill.birdlist.ui.imports.RowExtractor;

class BreedingBirdCodeFieldMapper<T>
implements FieldMapper<T> {
    private RowExtractor<T, String> extractor;

    public BreedingBirdCodeFieldMapper(RowExtractor<T, String> extractor) {
        this.extractor = extractor;
    }

    @Override
    public void map(T row, Sighting.Builder sighting) {
        String codeText = this.extractor.extract(row);
        if (!Strings.isNullOrEmpty(codeText)) {
            int firstWhitespace;
            SightingInfo.BreedingBirdCode code = SightingInfo.BreedingBirdCode.forId(codeText);
            if (code == null && (firstWhitespace = CharMatcher.whitespace().indexIn(codeText)) > 0) {
                codeText = codeText.substring(0, firstWhitespace);
                code = SightingInfo.BreedingBirdCode.forId(codeText);
            }
            if (code != null) {
                sighting.getSightingInfo().setBreedingBirdCode(code);
            }
        }
    }
}

