/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.io.ImportLines;
import com.scythebill.birdlist.model.io.MergingImportLines;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.imports.ComputedMappings;
import com.scythebill.birdlist.ui.imports.CsvSightingsImporter;
import com.scythebill.birdlist.ui.imports.DateFromStringFieldMapper;
import com.scythebill.birdlist.ui.imports.DescriptionFieldMapper;
import com.scythebill.birdlist.ui.imports.FieldTaxonImporter;
import com.scythebill.birdlist.ui.imports.LineExtractor;
import com.scythebill.birdlist.ui.imports.LineExtractors;
import com.scythebill.birdlist.ui.imports.ParsedLocationIds;
import com.scythebill.birdlist.ui.imports.SightingsImporter;
import com.scythebill.birdlist.ui.imports.TaxonImporter;
import com.scythebill.birdlist.ui.imports.UserFieldMapper;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Set;

public class BirdersDiaryImporter
extends CsvSightingsImporter {
    private LineExtractor<String> commonExtractor;
    private LineExtractor<String> sciExtractor;
    private LineExtractor<String> dateExtractor;
    private LineExtractor<String> locationExtractor;
    private LineExtractor<String> commentsExtractor;
    private LineExtractor<String> tripExtractor;
    private Integer observerIndex;
    private LineExtractor<String> observerExtractor;
    private LineExtractor<String> locationIdExtractor;
    private LineExtractor<String> taxonomyIdExtractor;
    private Set<String> observerSet = new HashSet<String>();
    private boolean multipleObservers = false;

    public BirdersDiaryImporter(ReportSet reportSet, Taxonomy taxonomy, Checklists checklists, PredefinedLocations predefinedLocations, File file) {
        super(reportSet, taxonomy, checklists, predefinedLocations, file, file);
    }

    protected LineExtractor<? extends Object> taxonomyIdExtractor() {
        return this.taxonomyIdExtractor;
    }

    @Override
    protected TaxonImporter<String[]> newTaxonImporter(Taxonomy taxonomy) {
        FieldTaxonImporter.JustGenusAndSpecies species = new FieldTaxonImporter.JustGenusAndSpecies(this.sciExtractor);
        final FieldTaxonImporter.SubspeciesIfPresent subspecies = new FieldTaxonImporter.SubspeciesIfPresent(this.sciExtractor);
        LineExtractor<String> commonNameMinusSubspecies = new LineExtractor<String>(){

            @Override
            public String extract(String[] line) {
                String common = (String)BirdersDiaryImporter.this.commonExtractor.extract((String)line);
                String ssp = (String)subspecies.extract(line);
                if (Strings.isNullOrEmpty(common) || Strings.isNullOrEmpty(ssp)) {
                    return common;
                }
                if (common.endsWith(ssp)) {
                    return common.substring(0, common.length() - (ssp.length() + 1));
                }
                return common;
            }
        };
        return new FieldTaxonImporter<String[]>(taxonomy, commonNameMinusSubspecies, species, subspecies);
    }

    @Override
    protected ComputedMappings<String[]> computeMappings(ImportLines lines) throws IOException {
        String[] header = lines.nextLine();
        LinkedHashMap<String, Integer> headersByIndex = new LinkedHashMap<String, Integer>();
        for (int i = 0; i < header.length; ++i) {
            headersByIndex.put(header[i].toLowerCase(), i);
        }
        int commonIndex = this.getRequiredHeader(headersByIndex, "Name");
        int scientificIndex = this.getRequiredHeader(headersByIndex, "Scientific Name");
        int dateIndex = this.getRequiredHeader(headersByIndex, "When Seen");
        int locationIndex = this.getRequiredHeader(headersByIndex, "Location");
        Integer tripIndex = (Integer)headersByIndex.get("trip");
        this.observerIndex = (Integer)headersByIndex.get("observer");
        Integer commentsIndex = (Integer)headersByIndex.get("comments");
        this.commonExtractor = LineExtractors.stringFromIndex(commonIndex);
        this.sciExtractor = LineExtractors.stringFromIndex(scientificIndex);
        this.dateExtractor = LineExtractors.stringFromIndex(dateIndex);
        this.locationExtractor = LineExtractors.stringFromIndex(locationIndex);
        this.tripExtractor = tripIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(tripIndex);
        this.commentsExtractor = commentsIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(commentsIndex);
        this.observerExtractor = this.observerIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(this.observerIndex);
        ArrayList mappers = Lists.newArrayList();
        mappers.add(new DateFromStringFieldMapper("dd/MM/yy", this.dateExtractor));
        mappers.add(new DescriptionFieldMapper(this.commentsExtractor));
        this.locationIdExtractor = LineExtractors.joined(Joiner.on('|'), this.locationExtractor, this.tripExtractor);
        this.taxonomyIdExtractor = LineExtractors.joined(Joiner.on('|'), this.commonExtractor, this.sciExtractor);
        if (this.observerSet.size() != 1 || this.multipleObservers || this.reportSet.getUserSet() != null) {
            mappers.add(new UserFieldMapper(this.reportSet, LineExtractors.alwaysNull(), this.observerExtractor));
        }
        return new ComputedMappings<String[]>(new SightingsImporter.TaxonFieldMapper(this, this.taxonomyIdExtractor), new SightingsImporter.LocationMapper(this, this.locationIdExtractor), mappers);
    }

    @Override
    protected void parseLocationIds(LocationSet locations, PredefinedLocations predefinedLocations) throws IOException {
        try (ImportLines lines = this.importLines(this.locationsFile);){
            String[] line;
            lines.nextLine();
            while ((line = lines.nextLine()) != null) {
                String id = (String)this.locationIdExtractor.extract((String)line);
                if (this.locationIds.hasBeenParsed(id)) continue;
                String location = (String)this.locationExtractor.extract((String)line);
                String trip = (String)this.tripExtractor.extract((String)line);
                ParsedLocationIds.ToBeDecided toBeDecided = new ParsedLocationIds.ToBeDecided(location, null, trip, ParsedLocationIds.ToBeDecided.HintType.location);
                this.locationIds.addToBeResolvedLocationName(id, toBeDecided);
            }
        }
    }

    @Override
    protected String[] getHeaderRow(ImportLines lines) throws IOException {
        return lines.nextLine();
    }

    @Override
    protected Charset getCharset() {
        return StandardCharsets.ISO_8859_1;
    }

    @Override
    protected ImportLines importLines(File file) throws IOException {
        ImportLines importLines = super.importLines(file);
        return new MergeObserversImportLines(importLines);
    }

    @Override
    protected void preSightingAnalysis(String[] line) {
        String observers;
        if (this.observerExtractor != null && !Strings.isNullOrEmpty(observers = (String)this.observerExtractor.extract((String)line))) {
            this.observerSet.add(observers);
            if (observers.contains("\n")) {
                this.multipleObservers = true;
            }
        }
    }

    @Override
    public boolean importContainedUserInformation() {
        return this.observerIndex != null;
    }

    class MergeObserversImportLines
    extends MergingImportLines {
        MergeObserversImportLines(ImportLines importLines) {
            super(importLines);
        }

        @Override
        protected boolean merge(String[] mergedLine, String[] nextLine) {
            if (nextLine.length < 5 || mergedLine.length < 5) {
                return false;
            }
            if (BirdersDiaryImporter.this.observerIndex == null || BirdersDiaryImporter.this.commonExtractor == null || BirdersDiaryImporter.this.sciExtractor == null || BirdersDiaryImporter.this.dateExtractor == null || BirdersDiaryImporter.this.locationExtractor == null) {
                return false;
            }
            if (!(Objects.equals(BirdersDiaryImporter.this.commonExtractor.extract((String)nextLine), BirdersDiaryImporter.this.commonExtractor.extract((String)mergedLine)) && Objects.equals(BirdersDiaryImporter.this.sciExtractor.extract((String)nextLine), BirdersDiaryImporter.this.sciExtractor.extract((String)mergedLine)) && Objects.equals(BirdersDiaryImporter.this.dateExtractor.extract((String)nextLine), BirdersDiaryImporter.this.dateExtractor.extract((String)mergedLine)) && Objects.equals(BirdersDiaryImporter.this.locationExtractor.extract((String)nextLine), BirdersDiaryImporter.this.locationExtractor.extract((String)mergedLine)))) {
                return false;
            }
            String nextWho = (String)BirdersDiaryImporter.this.observerExtractor.extract((String)nextLine);
            if (!Strings.isNullOrEmpty(nextWho)) {
                mergedLine[BirdersDiaryImporter.this.observerIndex.intValue()] = mergedLine[BirdersDiaryImporter.this.observerIndex] + "\n" + nextWho;
            }
            return true;
        }
    }
}

