/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.io.CsvImportLines;
import com.scythebill.birdlist.model.io.ImportLines;
import com.scythebill.birdlist.model.io.MergingImportLines;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.imports.ComputedMappings;
import com.scythebill.birdlist.ui.imports.CountFieldMapper;
import com.scythebill.birdlist.ui.imports.CsvSightingsImporter;
import com.scythebill.birdlist.ui.imports.DescriptionFieldMapper;
import com.scythebill.birdlist.ui.imports.FieldTaxonImporter;
import com.scythebill.birdlist.ui.imports.ImportedLocation;
import com.scythebill.birdlist.ui.imports.LineExtractor;
import com.scythebill.birdlist.ui.imports.LineExtractors;
import com.scythebill.birdlist.ui.imports.MultiFormatDateFromStringFieldMapper;
import com.scythebill.birdlist.ui.imports.ParsedLocationIds;
import com.scythebill.birdlist.ui.imports.SightingsImporter;
import com.scythebill.birdlist.ui.imports.TaxonImporter;
import com.scythebill.birdlist.ui.imports.UserFieldMapper;
import com.sigpwned.chardet4j.Chardet;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.joda.time.chrono.GJChronology;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class BirdersDiary5Importer
extends CsvSightingsImporter {
    private LineExtractor<String> commonOrSciExtractor;
    private LineExtractor<String> dateExtractor;
    private LineExtractor<String> locationExtractor;
    private LineExtractor<String> parentLocationExtractor;
    private LineExtractor<String> observerNameExtractor;
    private LineExtractor<String> mergedObserverNameExtractor;
    private Integer firstNameIndex;
    private LineExtractor<String> observerInitialsExtractor;
    private LineExtractor<String> locationIdExtractor;
    private LineExtractor<String> taxonomyIdExtractor;
    private Set<String> observerSet = new HashSet<String>();
    private boolean multipleObservers = false;
    private boolean hadObservers;
    private Integer observerInitialsIndex;
    private LineExtractor<String> tripExtractor;
    private List<DateTimeFormatter> chosenFormatters;
    private static final Splitter PARENT_LOCATION_SPLITTER = Splitter.on('>');
    private static final ImmutableMap<String, String> PARENT_LOCATION_REPLACE = ImmutableMap.builder().put("CONTINENTAL UNITED STATES>LOWER 48 UNITED STATES", "United States").put("CONTINENTAL UNITED STATES", "United States").put("UNITED STATES OF AMERICA", "United States").put("SOUTH POLAR", "South Polar Region").put("ABA LOCATIONS>ABA NORTH AMERICAN REGION>ABA WEST INDIES AND CARIBBEAN", "North America>West Indies").build();
    private static final ImmutableMap<String, String> ANY_LOCATION_REPLACE = ImmutableMap.builder().put("United States>HAWAII", "Pacific Ocean>United States>Hawaii").put("NETHERLANDS ANTILLES", "Caribbean Netherlands").put("DEMOCRATIC REP. OF THE CONGO", "Democratic Republic of the Congo").put("SPANISH NORTH AFRICA", "Ceuta and Melilla").put("UNITED REPUBLIC OF TANZANIA", "Tanzania").put("SVALBARD AND JAN MAYEN ISLANDS", "Svalbard").put("CHINA>HONG KONG", "Hong Kong").put("SOUTH AMERICA>ECUADOR>GALAPAGOS ISLANDS", "Pacific Ocean>Galapagos Islands").put("REPUBLIC OF GEORGIA", "Georgia").put("REPUBLIC OF KOREA (SOUTH KOREA)", "South Korea").put("DEMOCRATIC PEOPLE'S REPUBLIC OF KOREA (NORTH KOREA)", "North Korea").put("BOUVET", "Bouvet Island").put("REPUBLIC OF MOLDOVA", "Moldova").put("KOSOVA", "Kosovo").put("COMORO ISLANDS", "Comoros").put("RODRIGUES ISLAND", "Mauritius>Rodrigues Island").put("VIRGIN ISLANDS, BRITISH", "British Virgin Islands").put("VIRGIN ISLANDS, USA", "United States>Virgin Islands (U.S.)").put("PUERTO RICO", "United States>Puerto Rico").put("FED. STATES OF MICRONESIA", "Micronesia").put("NORTHERN MARINA IS.", "Northern Mariana Islands").put("IRIAN JAYA", "Papua").put("MALUKU ISLANDS", "Maluku").put("JAVA", "Jawa").put("SUMATRA", "Sumatera").put("LESSER SUNDAS", "Nusa Tenggara").put("SULAWESI (CELEBES)", "Sulawesi").put("RUSSIA (Europe)", "Russia").put("RUSSIA (Asia)", "Russia").put("TURKEY (Europe)", "Turkey").put("TURKEY (Asia)", "Turkey").put("EGYPT (Africa)", "Egypt").put("EGYPT (Asia)", "Egypt").put("INDONESIA (Asia)", "Indonesia").put("INDONESIA (Australasia)", "Indonesia").put("MYANMAR (Burma)", "Myanmar").put("SOUTH GEORGIA ISLAND", "South Georgia and South Sandwich Islands>South Georgia Island").put("SOUTH SANDWICH ISLANDS", "South Georgia and South Sandwich Islands>South Sandwich Islands").put("ANDAMAN ISLANDS", "India>Andaman and Nicobar Islands>Andaman Islands").put("NICOBAR ISLANDS", "India>Andaman and Nicobar Islands>Nicobar Islands").put("IRELAND>NORTHERN IRELAND", "United Kingdom>Northern Ireland").put("IRELAND>REPUBLIC OF IRELAND", "Ireland").build();
    private static final CharMatcher CAPS = CharMatcher.inRange('A', 'Z');
    private static final CharMatcher ALL_CAPS_NAMES = CAPS.or(CharMatcher.anyOf(" .,()"));

    public BirdersDiary5Importer(ReportSet reportSet, Taxonomy taxonomy, Checklists checklists, PredefinedLocations predefinedLocations, File file) {
        super(reportSet, taxonomy, checklists, predefinedLocations, file, file);
    }

    protected LineExtractor<? extends Object> taxonomyIdExtractor() {
        return this.taxonomyIdExtractor;
    }

    @Override
    protected TaxonImporter<String[]> newTaxonImporter(Taxonomy taxonomy) {
        return new FieldTaxonImporter<String[]>(taxonomy, this.commonOrSciExtractor);
    }

    @Override
    protected ComputedMappings<String[]> computeMappings(ImportLines lines) throws IOException {
        LineExtractor commentsExtractor;
        String[] header = lines.nextLine();
        LinkedHashMap<String, Integer> headersByIndex = new LinkedHashMap<String, Integer>();
        for (int i = 0; i < header.length; ++i) {
            headersByIndex.put(header[i].toLowerCase(), i);
        }
        int commonOrSciIndex = this.getRequiredHeader(headersByIndex, "SciOrCommonName");
        int dateIndex = this.getRequiredHeader(headersByIndex, "DateAndTime");
        int locationIndex = this.getRequiredHeader(headersByIndex, "Location");
        int parentLocationIndex = this.getRequiredHeader(headersByIndex, "ParentLocation");
        this.firstNameIndex = (Integer)headersByIndex.get("firstname");
        Integer middleInitialIndex = (Integer)headersByIndex.get("mi");
        Integer lastNameIndex = (Integer)headersByIndex.get("lastname");
        this.observerInitialsIndex = (Integer)headersByIndex.get("initials");
        Integer commentsIndex = (Integer)headersByIndex.get("sightingcomments");
        Integer tripIndex = (Integer)headersByIndex.get("trip");
        Integer countIndex = (Integer)headersByIndex.get("maxobserved");
        this.commonOrSciExtractor = LineExtractors.stringFromIndex(commonOrSciIndex);
        this.dateExtractor = LineExtractors.stringFromIndex(dateIndex);
        this.locationExtractor = LineExtractors.stringFromIndex(locationIndex);
        this.parentLocationExtractor = LineExtractors.stringFromIndex(parentLocationIndex);
        this.tripExtractor = tripIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(tripIndex);
        LineExtractor<Object> lineExtractor = commentsExtractor = commentsIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(commentsIndex);
        if (this.firstNameIndex == null || lastNameIndex == null) {
            this.mergedObserverNameExtractor = LineExtractors.alwaysNull();
        } else {
            this.observerNameExtractor = LineExtractors.joined(Joiner.on(' ').skipNulls(), LineExtractors.stringFromIndex(this.firstNameIndex), middleInitialIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(middleInitialIndex), LineExtractors.stringFromIndex(lastNameIndex));
            this.mergedObserverNameExtractor = LineExtractors.stringFromIndex(this.firstNameIndex);
        }
        this.observerInitialsExtractor = this.observerInitialsIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(this.observerInitialsIndex);
        ArrayList mappers = Lists.newArrayList();
        mappers.add(new MultiFormatDateFromStringFieldMapper(this.dateExtractor, () -> this.chosenFormatters));
        LineExtractor<String> descriptionExtractor = new LineExtractor<String>(){

            @Override
            public String extract(String[] line) {
                String comment;
                StringBuilder builder = new StringBuilder();
                String trip = (String)BirdersDiary5Importer.this.tripExtractor.extract((String)line);
                if (!Strings.isNullOrEmpty(trip)) {
                    builder.append(trip);
                }
                if (!Strings.isNullOrEmpty(comment = (String)commentsExtractor.extract(line)) && !comment.startsWith("{\\rtf1")) {
                    if (builder.length() > 0) {
                        builder.append('\n');
                    }
                    builder.append(comment);
                }
                return builder.toString();
            }
        };
        mappers.add(new DescriptionFieldMapper<String[]>(descriptionExtractor));
        this.locationIdExtractor = LineExtractors.joined(Joiner.on('|'), this.locationExtractor, this.parentLocationExtractor);
        this.taxonomyIdExtractor = this.commonOrSciExtractor;
        if (this.observerSet.size() != 1 || this.multipleObservers || this.reportSet.getUserSet() != null) {
            this.hadObservers = true;
            mappers.add(new UserFieldMapper(this.reportSet, this.observerInitialsExtractor, this.mergedObserverNameExtractor));
        }
        if (countIndex > 0) {
            mappers.add(new CountFieldMapper(LineExtractors.stringFromIndex(countIndex)));
        }
        return new ComputedMappings<String[]>(new SightingsImporter.TaxonFieldMapper(this.taxonomyIdExtractor), new SightingsImporter.LocationMapper(this.locationIdExtractor), mappers);
    }

    @Override
    protected void parseLocationIds(LocationSet locations, PredefinedLocations predefinedLocations) throws IOException {
        try (ImportLines lines = this.importLines(this.locationsFile);){
            String[] line;
            lines.nextLine();
            while ((line = lines.nextLine()) != null) {
                Object entry2;
                String id = (String)this.locationIdExtractor.extract((String)line);
                if (this.locationIds.hasBeenParsed(id)) continue;
                String leafLocation = (String)this.locationExtractor.extract((String)line);
                String parentLocation = (String)this.parentLocationExtractor.extract((String)line);
                if (Strings.isNullOrEmpty(parentLocation)) {
                    ParsedLocationIds.ToBeDecided toBeDecided = new ParsedLocationIds.ToBeDecided(leafLocation, null, (String)this.tripExtractor.extract((String)line), ParsedLocationIds.ToBeDecided.HintType.location);
                    this.locationIds.addToBeResolvedLocationName(id, toBeDecided);
                    continue;
                }
                for (Object entry2 : PARENT_LOCATION_REPLACE.entrySet()) {
                    parentLocation = parentLocation.replace((CharSequence)entry2.getKey(), (CharSequence)entry2.getValue());
                }
                Object wholeLocation = parentLocation + ">" + leafLocation;
                entry2 = ((ImmutableSet)ANY_LOCATION_REPLACE.entrySet()).iterator();
                while (entry2.hasNext()) {
                    Map.Entry entry3 = (Map.Entry)entry2.next();
                    wholeLocation = ((String)wholeLocation).replace((CharSequence)entry3.getKey(), (CharSequence)entry3.getValue());
                }
                List<String> locationNames = PARENT_LOCATION_SPLITTER.splitToList((CharSequence)wholeLocation);
                ImportedLocation imported = new ImportedLocation();
                boolean foundNonRegion = false;
                for (String location : locationNames) {
                    location = BirdersDiary5Importer.toInitialCaps(location);
                    if (!foundNonRegion) {
                        if (this.locationShortcuts.getRegion(location) == null) {
                            foundNonRegion = true;
                        } else {
                            imported.region = location;
                            continue;
                        }
                    }
                    if (imported.country == null) {
                        imported.country = location;
                        continue;
                    }
                    imported.locationNames.add(location);
                }
                String locationId = imported.addToLocationSet(this.reportSet, this.reportSet.getLocations(), this.locationShortcuts, predefinedLocations);
                this.locationIds.put((Object)id, locationId);
            }
        }
    }

    @Override
    protected String[] getHeaderRow(ImportLines lines) throws IOException {
        return lines.nextLine();
    }

    @Override
    protected Charset getCharset() {
        throw new UnsupportedOperationException("Need to use per-file detection");
    }

    @Override
    protected ImportLines importLines(File file) throws IOException {
        ImportLines importLines = CsvImportLines.fromReader(Chardet.decode(new FileInputStream(file), StandardCharsets.ISO_8859_1));
        return new MergeObserversImportLines(importLines);
    }

    @Override
    protected void preSightingAnalysis(String[] line) {
        String observers;
        if (this.observerNameExtractor != null && !Strings.isNullOrEmpty(observers = (String)this.observerNameExtractor.extract((String)line))) {
            this.observerSet.add(observers);
            if (observers.contains("\n")) {
                this.multipleObservers = true;
            }
        }
    }

    @Override
    public boolean importContainedUserInformation() {
        return this.hadObservers;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void computeExtendedMappings() throws IOException {
        class PossibleFormat {
            int successCount;
            final DateTimeFormatter formatter;

            PossibleFormat(String pattern) {
                this.formatter = DateTimeFormat.forPattern(pattern).withPivotYear(2000).withLocale(Locale.getDefault()).withChronology(GJChronology.getInstance());
            }

            void tryDate(String date) {
                try {
                    this.formatter.parseLocalDate(date);
                    ++this.successCount;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        if (this.chosenFormatters != null) {
            return;
        }
        LinkedHashSet<String> patterns = new LinkedHashSet<String>();
        patterns.add(DateTimeFormat.patternForStyle("S-", Locale.getDefault()));
        patterns.add(DateTimeFormat.patternForStyle("SS", Locale.getDefault()));
        patterns.add("M/d/yy");
        patterns.add("M/d/yy h:mm:ss a");
        patterns.add("M/d/yy H:mm:ss");
        patterns.add("d/M/yy");
        patterns.add("d/M/yy h:mm:ss a");
        patterns.add("d/M/yy H:mm:ss");
        ArrayList formats = new ArrayList();
        patterns.forEach(p -> formats.add(new PossibleFormat((String)p)));
        try (ImportLines lines = this.importLines(this.sightingsFile);){
            String[] line;
            lines.nextLine();
            while ((line = lines.nextLine()) != null) {
                String date = (String)this.dateExtractor.extract((String)line);
                if (Strings.isNullOrEmpty(date)) continue;
                for (int i = 0; i < formats.size(); ++i) {
                    ((PossibleFormat)formats.get(i)).tryDate(date);
                }
            }
        }
        this.chosenFormatters = formats.stream().sorted(Comparator.comparingInt(f -> f.successCount).reversed()).map(f -> f.formatter).collect(ImmutableList.toImmutableList());
    }

    private static String toInitialCaps(String in) {
        if (!ALL_CAPS_NAMES.matchesAllOf(in) || in.length() <= 2) {
            return in;
        }
        StringBuilder builder = new StringBuilder(in);
        for (int i = builder.length() - 1; i > 0; --i) {
            if (!CAPS.matches(builder.charAt(i)) || !CAPS.matches(builder.charAt(i - 1))) continue;
            builder.setCharAt(i, Character.toLowerCase(builder.charAt(i)));
        }
        return builder.toString();
    }

    class MergeObserversImportLines
    extends MergingImportLines {
        MergeObserversImportLines(ImportLines importLines) {
            super(importLines);
        }

        @Override
        protected String[] nextLineInternal() throws IOException {
            String[] line = super.nextLineInternal();
            if (line != null && BirdersDiary5Importer.this.firstNameIndex != null && BirdersDiary5Importer.this.observerNameExtractor != null) {
                line[BirdersDiary5Importer.this.firstNameIndex.intValue()] = (String)BirdersDiary5Importer.this.observerNameExtractor.extract((String)line);
            }
            return line;
        }

        @Override
        protected boolean merge(String[] mergedLine, String[] nextLine) {
            String nextInitials;
            if (BirdersDiary5Importer.this.firstNameIndex == null || BirdersDiary5Importer.this.mergedObserverNameExtractor == null) {
                return false;
            }
            if (nextLine.length <= BirdersDiary5Importer.this.firstNameIndex || mergedLine.length <= BirdersDiary5Importer.this.firstNameIndex) {
                return false;
            }
            if (BirdersDiary5Importer.this.commonOrSciExtractor == null || BirdersDiary5Importer.this.dateExtractor == null || BirdersDiary5Importer.this.locationIdExtractor == null) {
                return false;
            }
            if (!(Objects.equals(BirdersDiary5Importer.this.commonOrSciExtractor.extract((String)nextLine), BirdersDiary5Importer.this.commonOrSciExtractor.extract((String)mergedLine)) && Objects.equals(BirdersDiary5Importer.this.dateExtractor.extract((String)nextLine), BirdersDiary5Importer.this.dateExtractor.extract((String)mergedLine)) && Objects.equals(BirdersDiary5Importer.this.locationIdExtractor.extract((String)nextLine), BirdersDiary5Importer.this.locationIdExtractor.extract((String)mergedLine)))) {
                return false;
            }
            String nextName = (String)BirdersDiary5Importer.this.mergedObserverNameExtractor.extract((String)nextLine);
            if (!Strings.isNullOrEmpty(nextName)) {
                mergedLine[BirdersDiary5Importer.this.firstNameIndex.intValue()] = mergedLine[BirdersDiary5Importer.this.firstNameIndex] + "\n" + nextName;
            }
            if (BirdersDiary5Importer.this.observerInitialsExtractor != null && BirdersDiary5Importer.this.observerInitialsIndex != null && !Strings.isNullOrEmpty(nextInitials = (String)BirdersDiary5Importer.this.observerInitialsExtractor.extract((String)nextLine))) {
                mergedLine[BirdersDiary5Importer.this.observerInitialsIndex.intValue()] = mergedLine[BirdersDiary5Importer.this.observerInitialsIndex] + " " + nextInitials;
            }
            return true;
        }
    }
}

