/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.io.CsvImportLines;
import com.scythebill.birdlist.model.io.ImportLines;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.imports.BirdersDiary5Importer;
import com.scythebill.birdlist.ui.imports.BirdersDiaryImporter;
import com.scythebill.birdlist.ui.imports.CsvSightingsImporter;
import com.sigpwned.chardet4j.Chardet;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

final class BirdersDiary {
    BirdersDiary() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CsvSightingsImporter chooseImporter(File openFile, ReportSet reportSet, Taxonomy taxonomy, Checklists checklists, PredefinedLocations predefinedLocations) {
        try (ImportLines importLines = CsvImportLines.fromReader(Chardet.decode(new FileInputStream(openFile), StandardCharsets.ISO_8859_1));){
            List<String> nextLine = Arrays.asList(importLines.nextLine());
            if (!nextLine.isEmpty() && nextLine.contains("Name")) {
                BirdersDiaryImporter birdersDiaryImporter = new BirdersDiaryImporter(reportSet, taxonomy, checklists, predefinedLocations, openFile);
                return birdersDiaryImporter;
            }
            BirdersDiary5Importer birdersDiary5Importer = new BirdersDiary5Importer(reportSet, taxonomy, checklists, predefinedLocations, openFile);
            return birdersDiary5Importer;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

