/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.checklist.TransposedChecklistSynthesizer;
import com.scythebill.birdlist.model.io.CsvImportLines;
import com.scythebill.birdlist.model.io.ImportLines;
import com.scythebill.birdlist.model.io.MergingImportLines;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.imports.BirdbaseAndAvisysLocations;
import com.scythebill.birdlist.ui.imports.ComputedMappings;
import com.scythebill.birdlist.ui.imports.CountFieldMapper;
import com.scythebill.birdlist.ui.imports.CsvSightingsImporter;
import com.scythebill.birdlist.ui.imports.DateFromYearMonthDayFieldMapper;
import com.scythebill.birdlist.ui.imports.DescriptionFieldMapper;
import com.scythebill.birdlist.ui.imports.FieldTaxonImporter;
import com.scythebill.birdlist.ui.imports.ImportException;
import com.scythebill.birdlist.ui.imports.ImportedLocation;
import com.scythebill.birdlist.ui.imports.LineExtractor;
import com.scythebill.birdlist.ui.imports.LineExtractors;
import com.scythebill.birdlist.ui.imports.SightingsImporter;
import com.scythebill.birdlist.ui.imports.StatusFieldMapper;
import com.scythebill.birdlist.ui.imports.TaxonImporter;
import com.scythebill.birdlist.ui.messages.Messages;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;

public class BirdbaseImporter
extends CsvSightingsImporter {
    private static final int DESCRIPTION_COLUMN_INDEX = 23;
    private static final int NUMBER_COLUMN_INDEX = 24;
    private static final CharMatcher NULL = CharMatcher.is('\u0000');
    private final LineExtractor<String> idExtractor = LineExtractors.joined(Joiner.on('|').useForNull(""), LineExtractors.stringFromIndex(8), LineExtractors.stringFromIndex(9), LineExtractors.stringFromIndex(16), LineExtractors.stringFromIndex(17), LineExtractors.stringFromIndex(18));
    private final LineExtractor<String> taxonomyIdExtractor = LineExtractors.joined(Joiner.on('|').useForNull(""), new TrimCommonName(LineExtractors.stringFromIndex(0)), LineExtractors.stringFromIndex(1), LineExtractors.stringFromIndex(2), new SubspeciesExtractor(LineExtractors.stringFromIndex(23)));
    private final TransposedChecklistSynthesizer transposedChecklistSynthesizer;
    private final Checklists checklists;
    private static final ImmutableSet<String> CANADA_PROVINCES = ImmutableSet.of("ab", "bc", "mb", "nb", "nf", "nl", new String[]{"nn", "nt", "ns", "nu", "nw", "on", "pe", "qc", "qu", "sk", "yk"});

    public BirdbaseImporter(ReportSet reportSet, Taxonomy taxonomy, Checklists checklists, PredefinedLocations predefinedLocations, TransposedChecklistSynthesizer transposedChecklistSynthesizer, File file) {
        super(reportSet, taxonomy, checklists, predefinedLocations, file, file);
        this.checklists = checklists;
        this.transposedChecklistSynthesizer = transposedChecklistSynthesizer;
    }

    protected LineExtractor<? extends Object> taxonomyIdExtractor() {
        return this.taxonomyIdExtractor;
    }

    @Override
    protected TaxonImporter<String[]> newTaxonImporter(Taxonomy taxonomy) {
        return new FieldTaxonImporter<String[]>(taxonomy, new TrimCommonName(LineExtractors.stringFromIndex(0)), LineExtractors.joined(Joiner.on(' ').useForNull(""), LineExtractors.stringFromIndex(1), LineExtractors.stringFromIndex(2)), new SubspeciesExtractor(LineExtractors.stringFromIndex(23)));
    }

    @Override
    protected void parseLocationIds(LocationSet locations, PredefinedLocations predefinedLocations) throws IOException {
        ImportLines lines = this.importLines(this.locationsFile);
        LineExtractor<String> locationExtractor = LineExtractors.stringFromIndex(9);
        LineExtractor<String> birdbaseHomeExtractor = LineExtractors.stringFromIndex(18);
        LineExtractor<String> locationNamesExtractor = LineExtractors.stringFromIndex(8);
        LineExtractor<String> birdbaseRegionExtractor = LineExtractors.stringFromIndex(16);
        LineExtractor<String> birdbaseLocalExtractor = LineExtractors.stringFromIndex(17);
        try {
            String[] line;
            while ((line = lines.nextLine()) != null) {
                String id = (String)this.idExtractor.extract((String)line);
                if (this.locationIds.hasBeenParsed(id)) continue;
                ImportedLocation imported = new ImportedLocation();
                String location = Strings.emptyToNull((String)locationExtractor.extract((String)line));
                if (location != null) {
                    if (CharMatcher.inRange('a', 'z').matchesAllOf(location)) {
                        if (CANADA_PROVINCES.contains(location)) {
                            imported.countryCode = "CA";
                            imported.stateCode = location.equals("nn") ? "NU" : (location.equals("nf") ? "NL" : (location.equals("nw") ? "NT" : (location.equals("qu") ? "QC" : location.toUpperCase())));
                        } else {
                            imported.countryCode = "US";
                            imported.stateCode = location.toUpperCase();
                        }
                    } else {
                        BirdbaseAndAvisysLocations.updateImportedLocation(imported, location);
                    }
                }
                if ("1".equals(birdbaseHomeExtractor.extract((String)line))) {
                    imported.locationNames.add("BirdBase Home");
                }
                if (!Strings.isNullOrEmpty((String)locationNamesExtractor.extract((String)line))) {
                    imported.locationNames.add((String)locationNamesExtractor.extract((String)line));
                }
                if (imported.locationNames.isEmpty()) {
                    if ("1".equals(birdbaseRegionExtractor.extract((String)line))) {
                        imported.locationNames.add("BirdBase Region");
                    } else if ("1".equals(birdbaseLocalExtractor.extract((String)line))) {
                        imported.locationNames.add("BirdBase Local");
                    }
                }
                String locationId = imported.addToLocationSet(this.reportSet, locations, this.locationShortcuts, predefinedLocations);
                this.locationIds.put((Object)id, locationId);
            }
        }
        catch (IOException | RuntimeException e) {
            throw new ImportException(Messages.getFormattedMessage(Messages.Name.FAILED_IMPORT_ON_LINE_FORMAT, lines.lineNumber()), e);
        }
        finally {
            lines.close();
        }
    }

    @Override
    protected ComputedMappings<String[]> computeMappings(ImportLines lines) throws IOException {
        ArrayList mappers = Lists.newArrayList();
        mappers.add(new DateFromYearMonthDayFieldMapper(LineExtractors.intFromIndex(11), LineExtractors.intFromIndex(12), LineExtractors.intFromIndex(13)));
        mappers.add(new DescriptionFieldMapper(LineExtractors.joined(Joiner.on(' ').skipNulls(), new DropIfMatchesCount(LineExtractors.stringFromIndex(23), LineExtractors.stringFromIndex(24)), new CustomBitExtractor(19, "S1"), new CustomBitExtractor(20, "S2"), new CustomBitExtractor(21, "S3"), new CustomBitExtractor(22, "S4"))));
        mappers.add(new StatusFieldMapper<String[]>(new StatusExtractor(LineExtractors.intFromIndex(3))));
        mappers.add(new CountFieldMapper(LineExtractors.stringFromIndex(24)));
        return new ComputedMappings<String[]>(new SightingsImporter.TaxonFieldMapper(this.taxonomyIdExtractor), new SightingsImporter.LocationMapper(this.idExtractor), mappers);
    }

    @Override
    protected Charset getCharset() {
        return StandardCharsets.ISO_8859_1;
    }

    @Override
    protected Checklist getBuiltInChecklist(Location location) {
        ImmutableCollection<String> locations;
        String locationCode = this.checklists.getLocationWithNearestBuiltInChecklist(location);
        if (locationCode != null && (locations = BirdbaseAndAvisysLocations.getMergedLocations(locationCode)) != null && !locations.isEmpty()) {
            return this.transposedChecklistSynthesizer.synthesizeChecklistInternal(this.reportSet, locations);
        }
        return super.getBuiltInChecklist(location);
    }

    @Override
    protected ImportLines importLines(File file) throws IOException {
        ImportLines importLines = CsvImportLines.fromFileNoMultiIgnoringQuotesNotFollowedBySeparators(file, this.getCharset());
        return new MergeDescriptionLines(importLines);
    }

    static class TrimCommonName
    implements LineExtractor<String> {
        private final CharMatcher ASTERISK = CharMatcher.is('*');
        private final LineExtractor<String> extractor;

        TrimCommonName(LineExtractor<String> extractor) {
            this.extractor = extractor;
        }

        @Override
        public String extract(String[] line) {
            Object extract = (String)this.extractor.extract((String)line);
            if (Strings.isNullOrEmpty((String)extract)) {
                return extract;
            }
            extract = this.ASTERISK.removeFrom((CharSequence)extract);
            while (((String)extract).indexOf(40) >= 0) {
                int leftParen = ((String)extract).indexOf(40);
                int rightParen = ((String)extract).indexOf(41, leftParen);
                extract = ((String)extract).substring(0, leftParen) + ((String)extract).substring(rightParen + 1);
            }
            extract = CharMatcher.whitespace().collapseFrom((CharSequence)extract, ' ');
            return extract;
        }
    }

    static class SubspeciesExtractor
    implements LineExtractor<String> {
        private final LineExtractor<String> extractor;

        SubspeciesExtractor(LineExtractor<String> extractor) {
            this.extractor = extractor;
        }

        @Override
        public String extract(String[] line) {
            String extract = (String)this.extractor.extract((String)line);
            if (Strings.isNullOrEmpty(extract)) {
                return null;
            }
            int period = extract.indexOf(46);
            if (period < 0) {
                return null;
            }
            String maybeSubspecies = extract.substring(0, period);
            if (!CharMatcher.inRange('a', 'z').matchesAllOf(maybeSubspecies)) {
                return null;
            }
            return maybeSubspecies;
        }
    }

    static class DropIfMatchesCount
    implements LineExtractor<String> {
        private final LineExtractor<String> mainExtractor;
        private final LineExtractor<String> countExtractor;

        DropIfMatchesCount(LineExtractor<String> main, LineExtractor<String> count) {
            this.mainExtractor = main;
            this.countExtractor = count;
        }

        @Override
        public String extract(String[] line) {
            String main = (String)this.mainExtractor.extract((String)line);
            if (main == null) {
                return null;
            }
            String count = (String)this.countExtractor.extract((String)line);
            if (main.equals(count)) {
                return null;
            }
            return main;
        }
    }

    static class CustomBitExtractor
    implements LineExtractor<String> {
        private final int index;
        private final String ifPresent;

        CustomBitExtractor(int index, String ifPresent) {
            this.index = index;
            this.ifPresent = ifPresent;
        }

        @Override
        public String extract(String[] line) {
            if (line.length < this.index + 1) {
                return null;
            }
            if ("1".equals(line[this.index])) {
                return this.ifPresent;
            }
            return null;
        }
    }

    static class StatusExtractor
    implements LineExtractor<String> {
        private final LineExtractor<Integer> uncertainExtractor;

        StatusExtractor(LineExtractor<Integer> uncertainExtractor) {
            this.uncertainExtractor = uncertainExtractor;
        }

        @Override
        public String extract(String[] line) {
            Integer uncertain = (Integer)this.uncertainExtractor.extract((Integer)line);
            if (uncertain != null && uncertain == 2) {
                return "uncertain";
            }
            return null;
        }
    }

    static class MergeDescriptionLines
    extends MergingImportLines {
        MergeDescriptionLines(ImportLines importLines) {
            super(importLines);
        }

        @Override
        protected boolean merge(String[] mergedLine, String[] nextLine) {
            if (!this.containsOnlyADescription(nextLine)) {
                return false;
            }
            mergedLine[23] = mergedLine[23] + " " + nextLine[23];
            return true;
        }

        private boolean containsOnlyADescription(String[] line) {
            if (line.length <= 23) {
                return false;
            }
            for (int i = 0; i < 23; ++i) {
                if (Strings.isNullOrEmpty(line[i])) continue;
                return false;
            }
            Object description = line[23];
            for (int i = 24; i < line.length; ++i) {
                if (Strings.isNullOrEmpty(line[i])) continue;
                description = (String)description + "," + line[1];
            }
            line[23] = description;
            return true;
        }

        @Override
        protected String[] nextLineInternal() throws IOException {
            String[] line = super.nextLineInternal();
            if (line != null) {
                for (int i = 0; i < line.length; ++i) {
                    line[i] = NULL.removeFrom(line[i]);
                }
            }
            return line;
        }

        @Override
        protected boolean neverMergeFirstLine() {
            return false;
        }
    }
}

