/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.scythebill.birdlist.ui.imports.ImportedLocation;
import java.util.List;

class BirdbaseAndAvisysLocations {
    private static final ImmutableMap<String, String> BIRDBASE_LOCATION_ABBREVIATIONS = ImmutableMap.builder().put("BU", "Myanmar").put("EN", "Estonia").put("CS", "Indonesia-Maluku").put("IC", "Canary Islands").put("SW", "Indonesia-Sulawesi").put("YU", "Serbia").put("GS", "Galapagos Islands").put("RS", "Russia").put("RSE", "Russia").put("RSW", "Russia").put("RA", "Socotra").put("HV", "Burkina Faso").put("ZR", "Democratic Republic of the Congo").put("TS", "Australia-Tasmania").put("TP", "East Timor").put("DB", "Seychelles-Aldabra").put("RZ", "Mauritius-Rodrigues Island").put("MXN", "Mexico").put("MXS", "Mexico").put("USM", "United States").put("RL", "Papua New Guinea-Manus").put("MK", "Papua New Guinea-West New Britain").put("CT", "Kiribati-Phoenix Islands").put("RM", "Marshall Islands").put("IP", "Easter Island").put("JT", "United States Minor Outlying Islands-Johnston Atoll").put("MI", "United States Minor Outlying Islands-Midway Islands").put("WK", "United States Minor Outlying Islands-Wake Island").put("PU", "Palau").put("AI", "India-Andaman and Nicobar Islands").put("IB", "Malaysia-Sabah").put("CNS", "China").put("CNN", "China").put("SS", "Indonesia-Nusa Tenggara").put("ID", "Indonesia-Jawa").put("TA", "Indonesia-Sumatera").put("BL", "Belarus").put("RT", "Croatia").put("GG", "Georgia").put("GZ", "Kyrgyzstan").put("LN", "Lithuania").put("ME", "Macedonia").put("AZ", "Azores").put("MD", "Madeira").put("DV", "Moldova").put("ZS", "Tajikistan").put("UR", "Ukraine").put("BK", "Uzbekistan").put("UH", "United States").put("ZH", "Saint Helena, Ascension, and Tristan da Cunha-Saint Helena").put("ZC", "Saint Helena, Ascension, and Tristan da Cunha-Tristan da Cunha").put("AA", "Antarctica").put("AN", "Caribbean Netherlands").build();
    private static final ImmutableMultimap<String, String> LOCATION_TO_CHECKLIST_LOCATIONS = ImmutableMultimap.builder().putAll("MS", "MS", "AG", "KN", "AI", "BL", "BQ").putAll("PG", (String[])new String[]{"PG", "ID-IJ"}).putAll("RS", (String[])new String[]{"RS", "ME", "XK"}).putAll("SH-SH", (String[])new String[]{"SH-SH", "SH-AC"}).putAll("PU", (String[])new String[]{"PU", "FM"}).putAll("TP", (String[])new String[]{"TP", "ID-NU"}).putAll("ID-JW", (String[])new String[]{"ID-JW", "ID-NU"}).putAll("ID-NU", (String[])new String[]{"ID-NU", "ID-MA"}).build();
    private static final ImmutableMap<String, String> BIRDBASE_REGION_ABBREVIATIONS = ImmutableMap.builder().put("ZT", "Atlantic Ocean").put("ZI", "Indian Ocean").put("ZP", "Pacific Ocean").put("ZO", "South Polar Region").put("YF", "Africa").put("YA", "Australasia").put("YM", "Indian Ocean").put("YN", "North America").put("YT", "South America").put("YI", "Pacific Ocean").put("YO", "Asia").put("YP", "Eurasia").build();

    BirdbaseAndAvisysLocations() {
    }

    static ImmutableCollection<String> getMergedLocations(String locationCode) {
        return LOCATION_TO_CHECKLIST_LOCATIONS.get((Object)locationCode);
    }

    static void updateImportedLocation(ImportedLocation imported, String countryCode) {
        if (BIRDBASE_REGION_ABBREVIATIONS.containsKey(countryCode)) {
            imported.region = BIRDBASE_REGION_ABBREVIATIONS.get(countryCode);
        } else if (BIRDBASE_LOCATION_ABBREVIATIONS.containsKey(countryCode)) {
            String countryAndMaybeState = BIRDBASE_LOCATION_ABBREVIATIONS.get(countryCode);
            List<String> split = Splitter.on('-').splitToList(countryAndMaybeState);
            imported.country = split.get(0);
            if (split.size() > 1) {
                imported.state = split.get(1);
            }
            if ("CS".equals(countryCode)) {
                imported.region = "Australasia";
            } else if ("RSW".equals(countryCode)) {
                imported.region = "Europe";
            } else if ("RSE".equals(countryCode)) {
                imported.region = "Asia";
            } else if ("UH".equals(countryCode)) {
                imported.region = "Pacific Ocean";
            }
        } else {
            imported.countryCode = countryCode;
        }
    }
}

