/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.TreeMultimap;
import com.google.common.primitives.Doubles;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.io.CsvImportLines;
import com.scythebill.birdlist.model.io.ImportLines;
import com.scythebill.birdlist.model.io.TimeIO;
import com.scythebill.birdlist.model.mapdata.TimezoneMapper;
import com.scythebill.birdlist.model.sighting.Distance;
import com.scythebill.birdlist.model.sighting.LatLongCoordinates;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.VisitInfo;
import com.scythebill.birdlist.model.sighting.VisitInfoKey;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.imports.ComputedMappings;
import com.scythebill.birdlist.ui.imports.CountFieldMapper;
import com.scythebill.birdlist.ui.imports.CsvSightingsImporter;
import com.scythebill.birdlist.ui.imports.DescriptionFieldMapper;
import com.scythebill.birdlist.ui.imports.FieldMapper;
import com.scythebill.birdlist.ui.imports.FieldTaxonImporter;
import com.scythebill.birdlist.ui.imports.LineExtractor;
import com.scythebill.birdlist.ui.imports.LineExtractors;
import com.scythebill.birdlist.ui.imports.OnlyIncludeRowsMatchingDates;
import com.scythebill.birdlist.ui.imports.ParsedLocationIds;
import com.scythebill.birdlist.ui.imports.SightingsImporter;
import com.scythebill.birdlist.ui.imports.TaxonImporter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.Minutes;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.GJChronology;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class BirdaImporter
extends CsvSightingsImporter {
    private static final DateTimeFormatter ISO_DATE_TIME_FORMATTER = ISODateTimeFormat.dateTime().withChronology(GJChronology.getInstance());
    private static final double ASSUME_SAME_LOCATION_DISTANCE_KM = 2.0;
    private LineExtractor<String> commonNameExtractor;
    private LineExtractor<String> sciNameExtractor;
    private LineExtractor<String> isoDateExtractor;
    private LineExtractor<String> latitudeExtractor;
    private LineExtractor<String> longitudeExtractor;
    private LineExtractor<String> locationIdExtractor;
    private LineExtractor<String> sessionIdExtractor;
    private LineExtractor<String> sessionTitleExtractor;
    private Map<String, String> directLocationIdToCanonicalLocationId;
    private Map<VisitInfoKey, VisitInfo> visitInfoMap;
    private LineExtractor<LocalTime> timeExtractor;
    private LineExtractor<LocalDateTime> localDateTimeExtractor;
    private String lastLocationId;
    private LocalTime lastStartTime;
    private ReadablePartial lastDate;
    private VisitInfoKey lastVisitInfoKey = null;
    private LocalDateTime firstDateTime;
    private LocalDateTime lastDateTime;
    private LatLongCoordinates lastLatLong;
    private float accumulatedDistanceKm;
    private String sessionTitle;
    private ImmutableSet<ReadablePartial> onlyImportDatesIn = null;

    public BirdaImporter(ReportSet reportSet, Taxonomy taxonomy, Checklists checklists, PredefinedLocations predefinedLocations, File file) {
        super(reportSet, taxonomy, checklists, predefinedLocations, file, file);
    }

    protected LineExtractor<? extends Object> taxonomyIdExtractor() {
        return LineExtractors.joined(Joiner.on('|'), this.commonNameExtractor, this.sciNameExtractor);
    }

    @Override
    protected TaxonImporter<String[]> newTaxonImporter(Taxonomy taxonomy) {
        return new FieldTaxonImporter<String[]>(taxonomy, this.commonNameExtractor, this.sciNameExtractor);
    }

    @Override
    protected void parseLocationIds(LocationSet locations, PredefinedLocations predefinedLocations) throws IOException {
        this.directLocationIdToCanonicalLocationId = Maps.newHashMap();
        try (ImportLines lines = this.importLines(this.locationsFile);){
            String[] line;
            this.computeMappings(lines);
            String previousLocationId = null;
            String previousSessionId = null;
            ArrayList<String> allLocationIds = new ArrayList<String>();
            ArrayList<LatLongCoordinates> allLatLongs = new ArrayList<LatLongCoordinates>();
            while ((line = lines.nextLine()) != null) {
                String id = (String)this.locationIdExtractor.extract((String)line);
                if (this.locationIds.hasBeenParsed(id)) continue;
                String sessionId = (String)this.sessionIdExtractor.extract((String)line);
                String latitude = (String)this.latitudeExtractor.extract((String)line);
                String longitude = (String)this.longitudeExtractor.extract((String)line);
                LatLongCoordinates latLong = Strings.isNullOrEmpty(latitude) || Strings.isNullOrEmpty(longitude) ? null : LatLongCoordinates.withLatAndLong(latitude, longitude);
                if (Objects.equal(sessionId, previousSessionId)) {
                    this.directLocationIdToCanonicalLocationId.put(id, previousLocationId);
                    continue;
                }
                if (latLong != null) {
                    String closeEnoughLocationId = null;
                    for (int i = allLatLongs.size() - 1; i >= 0; --i) {
                        LatLongCoordinates previousLatLong = (LatLongCoordinates)allLatLongs.get(i);
                        double kmDistance = previousLatLong.kmDistance(latLong);
                        if (!(kmDistance < 2.0)) continue;
                        closeEnoughLocationId = (String)allLocationIds.get(i);
                        break;
                    }
                    if (closeEnoughLocationId != null) {
                        this.directLocationIdToCanonicalLocationId.put(id, closeEnoughLocationId);
                        continue;
                    }
                }
                this.directLocationIdToCanonicalLocationId.put(id, id);
                previousLocationId = id;
                previousSessionId = sessionId;
                allLocationIds.add(id);
                allLatLongs.add(latLong);
                ParsedLocationIds.ToBeDecided tbd = new ParsedLocationIds.ToBeDecided("", latLong, (String)this.sessionTitleExtractor.extract((String)line), ParsedLocationIds.ToBeDecided.HintType.other);
                this.locationIds.addToBeResolvedLocationName(id, tbd);
            }
        }
    }

    @Override
    protected ComputedMappings<String[]> computeMappings(ImportLines lines) throws IOException {
        String[] header = lines.nextLine();
        HashMap<String, Integer> headersByIndex = Maps.newHashMap();
        Function<String, String> headerFunc = s -> CharMatcher.whitespace().removeFrom((CharSequence)s).toLowerCase();
        for (int i = 0; i < header.length; ++i) {
            headersByIndex.put(headerFunc.apply(header[i]), i);
        }
        int commonIndex = this.getRequiredHeader(headersByIndex, headerFunc, "commonName");
        int sciIndex = this.getRequiredHeader(headersByIndex, headerFunc, "scientificName");
        int isoDateIndex = this.getRequiredHeader(headersByIndex, headerFunc, "date");
        int latitudeIndex = this.getRequiredHeader(headersByIndex, headerFunc, "latitude");
        int longitudeIndex = this.getRequiredHeader(headersByIndex, headerFunc, "longitude");
        int sessionIdIndex = this.getRequiredHeader(headersByIndex, headerFunc, "sessionId");
        int sessionTitleIndex = this.getRequiredHeader(headersByIndex, headerFunc, "sessionTitle");
        Integer countIndex = (Integer)headersByIndex.get("count");
        Integer countTypeIndex = (Integer)headersByIndex.get("countType");
        Integer commentIndex = (Integer)headersByIndex.get("note");
        ArrayList mappers = Lists.newArrayList();
        this.commonNameExtractor = LineExtractors.stringFromIndex(commonIndex);
        this.sciNameExtractor = LineExtractors.stringFromIndex(sciIndex);
        this.isoDateExtractor = LineExtractors.stringFromIndex(isoDateIndex);
        this.latitudeExtractor = LineExtractors.stringFromIndex(latitudeIndex);
        this.longitudeExtractor = LineExtractors.stringFromIndex(longitudeIndex);
        this.isoDateExtractor = LineExtractors.stringFromIndex(isoDateIndex);
        this.sessionIdExtractor = LineExtractors.stringFromIndex(sessionIdIndex);
        this.sessionTitleExtractor = LineExtractors.stringFromIndex(sessionTitleIndex);
        this.locationIdExtractor = this.sessionIdExtractor;
        this.localDateTimeExtractor = new LineExtractor<LocalDateTime>(){

            @Override
            public LocalDateTime extract(String[] row) {
                String isoDateTime = (String)BirdaImporter.this.isoDateExtractor.extract((String)row);
                DateTime dateTime = ISO_DATE_TIME_FORMATTER.parseDateTime(isoDateTime);
                Double longitude = Doubles.tryParse((String)BirdaImporter.this.longitudeExtractor.extract((String)row));
                Double latitude = Doubles.tryParse((String)BirdaImporter.this.latitudeExtractor.extract((String)row));
                if (longitude == null || latitude == null) {
                    return dateTime.toLocalDateTime();
                }
                String timezoneId = TimezoneMapper.latLngToTimezoneString(latitude, longitude);
                if (timezoneId == null) {
                    return dateTime.toLocalDateTime();
                }
                try {
                    DateTimeZone zone = DateTimeZone.forID(timezoneId);
                    return dateTime.toDateTime(zone).toLocalDateTime();
                }
                catch (IllegalArgumentException e) {
                    return dateTime.toLocalDateTime();
                }
            }
        };
        mappers.add(new FieldMapper<String[]>(){

            @Override
            public void map(String[] row, Sighting.Builder builder) {
                LocalDateTime localDateTime = (LocalDateTime)BirdaImporter.this.localDateTimeExtractor.extract((LocalDateTime)row);
                if (localDateTime != null) {
                    builder.setDate(localDateTime.toLocalDate());
                }
            }
        });
        this.timeExtractor = new LineExtractor<LocalTime>(){

            @Override
            public LocalTime extract(String[] row) {
                LocalDateTime localDateTime = (LocalDateTime)BirdaImporter.this.localDateTimeExtractor.extract((LocalDateTime)row);
                if (localDateTime == null) {
                    return null;
                }
                return localDateTime.toLocalTime();
            }
        };
        if (countIndex != null) {
            LineExtractor<String> modifiedCountExtractor;
            final LineExtractor<String> countExtractor = LineExtractors.stringFromIndex(countIndex);
            if (countTypeIndex != null) {
                final LineExtractor<String> countTypeExtractor = LineExtractors.stringFromIndex(countTypeIndex);
                modifiedCountExtractor = new LineExtractor<String>(){

                    @Override
                    public String extract(String[] row) {
                        if ("UNKNOWN".equalsIgnoreCase((String)countTypeExtractor.extract(row))) {
                            return null;
                        }
                        return (String)countExtractor.extract(row);
                    }
                };
            } else {
                modifiedCountExtractor = countExtractor;
            }
            mappers.add(new CountFieldMapper(modifiedCountExtractor));
        }
        LineExtractor<String> commentExtractor = commentIndex == null ? LineExtractors.constant("") : LineExtractors.stringFromIndex(commentIndex);
        mappers.add(new DescriptionFieldMapper(LineExtractors.appendingLatitudeAndLongitude(commentExtractor, this.latitudeExtractor, this.longitudeExtractor)));
        this.visitInfoMap = Maps.newLinkedHashMap();
        return new ComputedMappings<String[]>(new SightingsImporter.TaxonFieldMapper(this, this.taxonomyIdExtractor()), new SightingsImporter.LocationMapper(this, new LineExtractor<Object>(){

            @Override
            public Object extract(String[] line) {
                String extracted = (String)BirdaImporter.this.locationIdExtractor.extract((String)line);
                String canonicalId = BirdaImporter.this.directLocationIdToCanonicalLocationId.get(extracted);
                return canonicalId;
            }
        }), mappers);
    }

    @Override
    protected ImportLines importLines(File file) throws IOException {
        SortedByTimeImporter importLines = new SortedByTimeImporter(CsvImportLines.fromFile(file, this.getCharset()));
        if (this.onlyImportDatesIn == null) {
            return importLines;
        }
        LineExtractor<ReadablePartial> dateExtractor = new LineExtractor<ReadablePartial>(){

            @Override
            public ReadablePartial extract(String[] row) {
                LocalDateTime localDateTime = (LocalDateTime)BirdaImporter.this.localDateTimeExtractor.extract((LocalDateTime)row);
                if (localDateTime == null) {
                    return null;
                }
                return localDateTime.toLocalDate();
            }
        };
        return new OnlyIncludeRowsMatchingDates(importLines, this.onlyImportDatesIn, dateExtractor);
    }

    @Override
    protected void finishSighting(Sighting.Builder newSighting, String[] line) {
        String locationId = newSighting.getLocationId();
        if (locationId == null) {
            return;
        }
        try {
            LocalTime localTime;
            LocalTime startTimeToSet = localTime = (LocalTime)this.timeExtractor.extract((LocalTime)line);
            boolean resetVisit = false;
            if (this.lastLocationId == null) {
                resetVisit = true;
            } else if (this.lastLocationId.equals(newSighting.getLocationId()) && this.lastDate.equals(newSighting.getDate())) {
                startTimeToSet = this.lastStartTime;
            } else {
                resetVisit = true;
            }
            newSighting.setTime(TimeIO.normalize(startTimeToSet));
            if (resetVisit) {
                this.lastLocationId = locationId;
                this.lastStartTime = startTimeToSet;
                this.lastDate = newSighting.getDate();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    protected void lookForVisitInfo(ReportSet reportSet, String[] line, Sighting newSighting, VisitInfoKey visitInfoKey) {
        LatLongCoordinates latLong = LatLongCoordinates.withLatAndLong((String)this.latitudeExtractor.extract((String)line), (String)this.longitudeExtractor.extract((String)line));
        String isoDate = (String)this.isoDateExtractor.extract((String)line);
        LocalDateTime dateTime = ISO_DATE_TIME_FORMATTER.parseLocalDateTime(isoDate);
        boolean resetVisitInfo = false;
        if (this.lastVisitInfoKey == null) {
            resetVisitInfo = true;
        } else if (this.lastVisitInfoKey.equals(visitInfoKey)) {
            this.accumulatedDistanceKm = (float)((double)this.accumulatedDistanceKm + latLong.kmDistance(this.lastLatLong));
        } else {
            this.allSightingsFinished();
            resetVisitInfo = true;
        }
        this.lastLatLong = latLong;
        this.lastDateTime = dateTime;
        if (resetVisitInfo) {
            this.lastVisitInfoKey = visitInfoKey;
            this.accumulatedDistanceKm = 0.0f;
            this.firstDateTime = dateTime;
            this.sessionTitle = (String)this.sessionTitleExtractor.extract((String)line);
        }
    }

    @Override
    protected void allSightingsFinished() {
        Duration duration;
        VisitInfo.Builder visitInfo = VisitInfo.builder().withObservationType(VisitInfo.ObservationType.HISTORICAL);
        if ((double)this.accumulatedDistanceKm > 0.01) {
            visitInfo.withDistance(Distance.inKilometers(this.accumulatedDistanceKm));
        }
        if ((duration = Minutes.minutesBetween(this.firstDateTime, this.lastDateTime).toStandardDuration()).isLongerThan(Duration.standardMinutes(5L))) {
            visitInfo.withDuration(duration);
        }
        if (!Strings.isNullOrEmpty(this.sessionTitle)) {
            visitInfo.withComments(this.sessionTitle);
        }
        this.visitInfoMap.put(this.lastVisitInfoKey, visitInfo.build());
    }

    @Override
    public Map<VisitInfoKey, VisitInfo> getAccumulatedVisitInfoMap() {
        return this.visitInfoMap;
    }

    @Override
    public boolean isMassExport() {
        return true;
    }

    @Override
    public Collection<ReadablePartial> getAllDates() throws IOException {
        try (ImportLines lines = this.importLines(this.locationsFile);){
            String[] line;
            this.computeMappings(lines);
            LinkedHashSet<ReadablePartial> allDates = new LinkedHashSet<ReadablePartial>();
            while ((line = lines.nextLine()) != null) {
                LocalDateTime localDateTime = (LocalDateTime)this.localDateTimeExtractor.extract((LocalDateTime)line);
                if (localDateTime == null) continue;
                allDates.add(localDateTime.toLocalDate());
            }
            LinkedHashSet<ReadablePartial> linkedHashSet = allDates;
            return linkedHashSet;
        }
    }

    @Override
    public void onlyImportDatesIn(Set<ReadablePartial> newDates) {
        this.onlyImportDatesIn = ImmutableSet.copyOf(newDates);
    }

    static class SortedByTimeImporter
    implements ImportLines {
        private ImportLines root;
        private Iterator<LineAndRowNumber> remainingLines;
        private int currentRow;

        SortedByTimeImporter(ImportLines root) {
            this.root = root;
        }

        @Override
        public void close() throws IOException {
            this.root.close();
        }

        @Override
        public ImportLines withoutTrimming() {
            this.root = this.root.withoutTrimming();
            return this;
        }

        @Override
        public String[] nextLine() throws IOException {
            if (this.remainingLines == null) {
                String[] line;
                String[] header = this.root.nextLine();
                if (header == null) {
                    throw new IllegalStateException("File is empty");
                }
                int foundIndex = -1;
                for (int i = 0; i < header.length; ++i) {
                    if (!"date".equals(CharMatcher.whitespace().removeFrom(header[i]).toLowerCase())) continue;
                    foundIndex = i;
                    break;
                }
                if (foundIndex < 0) {
                    throw new IllegalStateException("Could not find date column in Birda export.");
                }
                TreeMultimap sortedLines = TreeMultimap.create();
                int row = 0;
                while ((line = this.root.nextLine()) != null) {
                    if (line.length <= foundIndex) continue;
                    sortedLines.put(line[foundIndex], new LineAndRowNumber(line, ++row));
                }
                this.remainingLines = sortedLines.values().iterator();
                return header;
            }
            if (!this.remainingLines.hasNext()) {
                return null;
            }
            LineAndRowNumber next = this.remainingLines.next();
            this.currentRow = next.row;
            return next.line;
        }

        @Override
        public int lineNumber() {
            return this.currentRow;
        }
    }

    static class LineAndRowNumber
    implements Comparable<LineAndRowNumber> {
        final String[] line;
        final int row;

        LineAndRowNumber(String[] line, int row) {
            this.line = line;
            this.row = row;
        }

        @Override
        public int compareTo(LineAndRowNumber that) {
            return this.row - that.row;
        }
    }
}

