/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.io.ImportLines;
import com.scythebill.birdlist.model.io.TimeIO;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingInfo;
import com.scythebill.birdlist.model.sighting.VisitInfo;
import com.scythebill.birdlist.model.sighting.VisitInfoKey;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.imports.BirdTrackImportLines;
import com.scythebill.birdlist.ui.imports.ComputedMappings;
import com.scythebill.birdlist.ui.imports.CountFieldMapper;
import com.scythebill.birdlist.ui.imports.CsvSightingsImporter;
import com.scythebill.birdlist.ui.imports.DateFromStringFieldMapper;
import com.scythebill.birdlist.ui.imports.DescriptionFieldMapper;
import com.scythebill.birdlist.ui.imports.FieldMapper;
import com.scythebill.birdlist.ui.imports.FieldTaxonImporter;
import com.scythebill.birdlist.ui.imports.ImportedLocation;
import com.scythebill.birdlist.ui.imports.LineExtractor;
import com.scythebill.birdlist.ui.imports.LineExtractors;
import com.scythebill.birdlist.ui.imports.ParsedLocationIds;
import com.scythebill.birdlist.ui.imports.SightingsImporter;
import com.scythebill.birdlist.ui.imports.TaxonImporter;
import com.scythebill.birdlist.ui.imports.TimeMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.joda.time.Duration;
import org.joda.time.LocalTime;
import org.joda.time.Minutes;

class BirdTrackImporter
extends CsvSightingsImporter {
    private static final Logger logger = Logger.getLogger(BirdTrackImporter.class.getName());
    private Map<VisitInfoKey, VisitInfo.Builder> visitInfoMap;
    private LineExtractor<String> taxonomyIdExtractor;
    private LineExtractor<String> commonNameExtractor;
    private LineExtractor<String> scientificExtractor;
    private LineExtractor<String> placeExtractor;
    private LineExtractor<String> longitudeExtractor;
    private LineExtractor<String> latitudeExtractor;
    private LineExtractor<String> locationIdExtractor;
    private LineExtractor<String> dateExtractor;
    private LineExtractor<String> startTimeExtractor;
    private LineExtractor<String> endTimeExtractor;
    private LineExtractor<String> countExtractor;
    private LineExtractor<String> commentsExtractor;
    private LineExtractor<String> habitatNotesExtractor;
    private LineExtractor<String> visitCommentExtractor;
    private LineExtractor<Boolean> completeListExtractor;

    protected BirdTrackImporter(ReportSet reportSet, Taxonomy taxonomy, Checklists checklists, PredefinedLocations predefinedLocations, File file) {
        super(reportSet, taxonomy, checklists, predefinedLocations, file, file);
    }

    protected LineExtractor<? extends Object> taxonomyIdExtractor() {
        return this.taxonomyIdExtractor;
    }

    @Override
    protected TaxonImporter<String[]> newTaxonImporter(Taxonomy taxonomy) {
        return new FieldTaxonImporter<String[]>(taxonomy, this.commonNameExtractor, this.scientificExtractor);
    }

    @Override
    protected ComputedMappings<String[]> computeMappings(ImportLines lines) throws IOException {
        String[] header = lines.nextLine();
        HashMap<String, Integer> headersByIndex = Maps.newHashMap();
        CharMatcher trimmer = CharMatcher.whitespace().or(CharMatcher.anyOf("-_?"));
        Function<String, String> transform = s -> trimmer.removeFrom((CharSequence)s).toLowerCase();
        for (int i = 0; i < header.length; ++i) {
            headersByIndex.put(transform.apply(header[i]), i);
        }
        this.visitInfoMap = new LinkedHashMap<VisitInfoKey, VisitInfo.Builder>();
        ArrayList mappers = Lists.newArrayList();
        int commonIndex = this.getRequiredHeader(headersByIndex, "Species", transform);
        int sciIndex = this.getRequiredHeader(headersByIndex, "Scientific name", transform);
        int placeIndex = this.getRequiredHeader(headersByIndex, "Place", transform);
        int dateIndex = this.getRequiredHeader(headersByIndex, "Date", transform);
        Integer latitudeIndex = (Integer)headersByIndex.get("lat");
        Integer longitudeIndex = (Integer)headersByIndex.get("long");
        Integer startTimeIndex = (Integer)headersByIndex.get("starttime");
        Integer endTimeIndex = (Integer)headersByIndex.get("endtime");
        Integer countIndex = (Integer)headersByIndex.get("count");
        Integer commentsIndex = (Integer)headersByIndex.get("comment");
        Integer habitatNotesIndex = (Integer)headersByIndex.get("habitatnotes");
        Integer visitCommentIndex = (Integer)headersByIndex.get("visitcomments");
        Integer visitWeatherCommentIndex = (Integer)headersByIndex.get("visitweathercomments");
        Integer completeListIndex = (Integer)headersByIndex.get("partofcompletelist");
        Integer breedingStatusIndex = (Integer)headersByIndex.get("breedingstatus");
        Integer plumageIndex = (Integer)headersByIndex.get("plumage");
        LineExtractor<String> rawCommonExtractor = LineExtractors.stringFromIndex(commonIndex);
        this.commonNameExtractor = row -> {
            String rawCommon = (String)rawCommonExtractor.extract((String)row);
            int parenthesisIndex = rawCommon.indexOf(" (");
            if (parenthesisIndex > 0) {
                rawCommon = rawCommon.substring(0, parenthesisIndex);
            }
            return rawCommon;
        };
        this.scientificExtractor = LineExtractors.stringFromIndex(sciIndex);
        this.taxonomyIdExtractor = LineExtractors.joined(Joiner.on('|').useForNull(""), ImmutableList.of(this.commonNameExtractor, this.scientificExtractor));
        this.placeExtractor = LineExtractors.stringFromIndex(placeIndex);
        this.locationIdExtractor = LineExtractors.joined(Joiner.on('|').useForNull(""), this.placeExtractor);
        this.dateExtractor = LineExtractors.stringFromIndex(dateIndex);
        mappers.add(new DateFromStringFieldMapper("dd/MM/yyyy", this.dateExtractor));
        this.latitudeExtractor = latitudeIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(latitudeIndex);
        this.longitudeExtractor = longitudeIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(longitudeIndex);
        this.commentsExtractor = commentsIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(commentsIndex);
        this.habitatNotesExtractor = habitatNotesIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(habitatNotesIndex);
        mappers.add(new DescriptionFieldMapper(LineExtractors.joined(Joiner.on('\n').skipNulls(), this.commentsExtractor, this.habitatNotesExtractor)));
        if (breedingStatusIndex != null) {
            mappers.add(new BreedingStatusMapper(LineExtractors.stringFromIndex(breedingStatusIndex)));
        }
        if (plumageIndex != null) {
            mappers.add(new PlumageMapper(LineExtractors.stringFromIndex(plumageIndex)));
        }
        if (countIndex != null) {
            this.countExtractor = LineExtractors.stringFromIndex(countIndex);
            Pattern characterAtStart = Pattern.compile(".?[0-9]+");
            Pattern characterAtEnd = Pattern.compile("[0-9]+.");
            mappers.add(new CountFieldMapper<String[]>(line -> {
                String count = (String)this.countExtractor.extract((String)line);
                if (count == null) {
                    return null;
                }
                if (characterAtStart.matcher(count).matches()) {
                    return count;
                }
                if (characterAtEnd.matcher(count).matches()) {
                    char charAtEnd = count.charAt(count.length() - 1);
                    return charAtEnd + count.substring(0, count.length() - 1);
                }
                return count;
            }));
        }
        this.completeListExtractor = completeListIndex == null ? LineExtractors.constant(false) : LineExtractors.booleanFromIndex(completeListIndex);
        this.startTimeExtractor = startTimeIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(startTimeIndex);
        mappers.add(new TimeMapper(this.startTimeExtractor));
        this.endTimeExtractor = endTimeIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(endTimeIndex);
        this.visitCommentExtractor = LineExtractors.joined(Joiner.on('\n').skipNulls(), visitCommentIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(visitCommentIndex), visitWeatherCommentIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(visitWeatherCommentIndex));
        return new ComputedMappings<String[]>(new SightingsImporter.TaxonFieldMapper(this.taxonomyIdExtractor), new SightingsImporter.LocationMapper(this.locationIdExtractor), mappers);
    }

    @Override
    protected void parseLocationIds(LocationSet locations, PredefinedLocations predefinedLocations) throws IOException {
        try (ImportLines lines = this.importLines(this.locationsFile);){
            String[] line;
            this.computeMappings(lines);
            while ((line = lines.nextLine()) != null) {
                String id;
                if (this.skipLine(line) || this.locationIds.hasBeenParsed(id = (String)this.locationIdExtractor.extract((String)line))) continue;
                String place = (String)this.placeExtractor.extract((String)line);
                ImportedLocation importedLocation = new ImportedLocation();
                importedLocation.locationNames.add(place);
                importedLocation.longitude = Strings.emptyToNull((String)this.longitudeExtractor.extract((String)line));
                importedLocation.latitude = Strings.emptyToNull((String)this.latitudeExtractor.extract((String)line));
                String locationId = importedLocation.tryAddToLocationSetWithLatLong(this.reportSet, locations, this.locationShortcuts, predefinedLocations);
                if (locationId != null) {
                    this.locationIds.put((Object)id, locationId);
                    continue;
                }
                this.locationIds.addToBeResolvedLocationName(id, new ParsedLocationIds.ToBeDecided(place, importedLocation.getLatLong()));
            }
        }
    }

    @Override
    protected void lookForVisitInfo(ReportSet reportSet, String[] line, Sighting newSighting, VisitInfoKey visitInfoKey) {
        String visitComments;
        String endTimeString;
        VisitInfo.Builder builder = this.visitInfoMap.get(visitInfoKey);
        if (builder == null) {
            builder = VisitInfo.builder().withObservationType(VisitInfo.ObservationType.HISTORICAL);
            this.visitInfoMap.put(visitInfoKey, builder);
        }
        if (visitInfoKey.startTime().isPresent() && !Strings.isNullOrEmpty(endTimeString = (String)this.endTimeExtractor.extract((String)line))) {
            try {
                LocalTime endTime = TimeIO.fromExternalString(endTimeString);
                Duration duration = Minutes.minutesBetween(visitInfoKey.startTime().get(), endTime).toStandardDuration();
                if (duration.isLongerThan(Duration.standardMinutes(5L))) {
                    builder = builder.withDuration(duration);
                }
            }
            catch (IllegalArgumentException e) {
                logger.log(Level.WARNING, "Failed to parse time " + endTimeString, e);
            }
        }
        if (!Strings.isNullOrEmpty(visitComments = (String)this.visitCommentExtractor.extract((String)line))) {
            builder.withComments(visitComments);
        }
        if (((Boolean)this.completeListExtractor.extract((Boolean)line)).booleanValue()) {
            builder.withCompleteChecklist(true);
        }
    }

    @Override
    public Map<VisitInfoKey, VisitInfo> getAccumulatedVisitInfoMap() {
        LinkedHashMap<VisitInfoKey, VisitInfo> accumulated = new LinkedHashMap<VisitInfoKey, VisitInfo>();
        for (Map.Entry<VisitInfoKey, VisitInfo.Builder> entry : this.visitInfoMap.entrySet()) {
            VisitInfo.Builder builder = entry.getValue();
            VisitInfo visitInfo = builder.build();
            if (!visitInfo.hasData()) continue;
            accumulated.put(entry.getKey(), visitInfo);
        }
        return accumulated;
    }

    @Override
    protected ImportLines importLines(File file) throws IOException {
        return BirdTrackImportLines.importBirdTrackXlsx(Files.asByteSource(file));
    }

    static class BreedingStatusMapper
    implements FieldMapper<String[]> {
        private static final ImmutableMap<String, SightingInfo.BreedingBirdCode> STATUS_TO_BREEDING_BIRD_CODE = ImmutableMap.builder().put("01", SightingInfo.BreedingBirdCode.IN_APPROPRIATE_HABITAT).put("02", SightingInfo.BreedingBirdCode.SINGING_BIRD).put("03", SightingInfo.BreedingBirdCode.PAIR_IN_SUITABLE_HABITAT).put("05", SightingInfo.BreedingBirdCode.COURTSHIP_DISPLAY_OR_COPULATION).put("06", SightingInfo.BreedingBirdCode.VISITING_PROBABLE_NEST_SITE).put("07", SightingInfo.BreedingBirdCode.AGITATED_BEHAVIOR).put("08", SightingInfo.BreedingBirdCode.PHYSIOLOGICAL_EVIDENCE).put("09", SightingInfo.BreedingBirdCode.NEST_BUILDING).put("10", SightingInfo.BreedingBirdCode.DISTRACTION_DISPLAY).put("11", SightingInfo.BreedingBirdCode.USED_NEST).put("12", SightingInfo.BreedingBirdCode.RECENTLY_FLEDGED).put("13", SightingInfo.BreedingBirdCode.OCCUPIED_NEST).put("14", SightingInfo.BreedingBirdCode.CARRYING_FOOD).put("15", SightingInfo.BreedingBirdCode.NEST_WITH_EGGS).put("16", SightingInfo.BreedingBirdCode.NEST_WITH_YOUNG).build();
        private final LineExtractor<String> extractor;

        public BreedingStatusMapper(LineExtractor<String> extractor) {
            this.extractor = extractor;
        }

        @Override
        public void map(String[] line, Sighting.Builder sighting) {
            SightingInfo.BreedingBirdCode code = STATUS_TO_BREEDING_BIRD_CODE.get(this.extractor.extract((String)line));
            if (code != null) {
                sighting.getSightingInfo().setBreedingBirdCode(code);
            }
        }
    }

    static class PlumageMapper
    implements FieldMapper<String[]> {
        private final LineExtractor<String> extractor;

        public PlumageMapper(LineExtractor<String> extractor) {
            this.extractor = extractor;
        }

        @Override
        public void map(String[] line, Sighting.Builder sighting) {
            String plumages = (String)this.extractor.extract((String)line);
            if (Strings.isNullOrEmpty(plumages)) {
                return;
            }
            if ((plumages = plumages.toLowerCase()).contains("male")) {
                sighting.getSightingInfo().setMale(true);
            }
            if (plumages.contains("female")) {
                sighting.getSightingInfo().setFemale(true);
            }
        }
    }
}

