/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteSource;
import com.scythebill.birdlist.model.io.ImportLines;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.xml.sax.SAXParseException;

class BirdTrackImportLines {
    BirdTrackImportLines() {
    }

    public static ImportLines importBirdTrackXlsx(ByteSource byteSource) throws IOException {
        try (InputStream inputStream = byteSource.openBufferedStream();){
            BirdTrackXlsxImportLines birdTrackXlsxImportLines;
            XSSFWorkbook workbook = new XSSFWorkbook(byteSource.openStream());
            try {
                ArrayList<XSSFSheet> sheets = new ArrayList<XSSFSheet>();
                for (int i = 1; i < workbook.getNumberOfSheets(); ++i) {
                    sheets.add(workbook.getSheetAt(i));
                }
                birdTrackXlsxImportLines = new BirdTrackXlsxImportLines(sheets);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        workbook.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (SAXParseException e) {
                    throw new IOException("Could not parse BirdTrack XSLX file", e);
                }
            }
            workbook.close();
            return birdTrackXlsxImportLines;
        }
    }

    static class BirdTrackXlsxImportLines
    implements ImportLines {
        private final boolean trim;
        private final DataFormatter df = new DataFormatter();
        private final ImmutableList<XSSFSheet> sheets;
        private XSSFSheet sheet;
        private int sheetIndex = 0;
        private int rowNum;

        BirdTrackXlsxImportLines(List<XSSFSheet> sheets) throws SAXParseException {
            this(sheets, true);
        }

        public BirdTrackXlsxImportLines(List<XSSFSheet> sheets, boolean trim) {
            this.sheets = ImmutableList.copyOf(sheets);
            if (!this.sheets.isEmpty()) {
                this.sheet = (XSSFSheet)this.sheets.get(0);
                this.rowNum = this.sheet.getFirstRowNum();
            }
            this.trim = trim;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public String[] nextLine() throws IOException {
            if (this.sheet == null) {
                return null;
            }
            XSSFRow row = null;
            while (row == null) {
                if (this.rowNum > this.sheet.getLastRowNum() && !this.nextSheet()) {
                    return null;
                }
                if ((row = this.sheet.getRow(this.rowNum++)) != null) continue;
            }
            String[] line = new String[row.getLastCellNum() - row.getFirstCellNum()];
            for (int i = row.getFirstCellNum(); i < row.getLastCellNum(); ++i) {
                XSSFCell cell = row.getCell(i);
                if (cell == null) continue;
                String cellValue = this.df.formatCellValue(cell);
                if (this.trim) {
                    cellValue = cellValue.trim();
                }
                line[i - row.getFirstCellNum()] = cellValue;
            }
            for (String cell : line) {
                if (Strings.isNullOrEmpty(cell)) continue;
                return line;
            }
            return null;
        }

        private boolean nextSheet() {
            ++this.sheetIndex;
            if (this.sheetIndex >= this.sheets.size()) {
                return false;
            }
            this.sheet = (XSSFSheet)this.sheets.get(this.sheetIndex);
            this.rowNum = this.sheet.getFirstRowNum() + 1;
            return true;
        }

        @Override
        public int lineNumber() {
            return this.rowNum;
        }

        @Override
        public ImportLines withoutTrimming() {
            return new BirdTrackXlsxImportLines(this.sheets, false);
        }
    }
}

