/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multisets;
import com.google.common.collect.TreeMultimap;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.io.CsvImportLines;
import com.scythebill.birdlist.model.io.ImportLines;
import com.scythebill.birdlist.model.io.TimeIO;
import com.scythebill.birdlist.model.sighting.Distance;
import com.scythebill.birdlist.model.sighting.LatLongCoordinates;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingInfo;
import com.scythebill.birdlist.model.sighting.VisitInfo;
import com.scythebill.birdlist.model.sighting.VisitInfoKey;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.imports.ComputedMappings;
import com.scythebill.birdlist.ui.imports.CountFieldMapper;
import com.scythebill.birdlist.ui.imports.CsvSightingsImporter;
import com.scythebill.birdlist.ui.imports.DescriptionFieldMapper;
import com.scythebill.birdlist.ui.imports.FieldMapper;
import com.scythebill.birdlist.ui.imports.FieldTaxonImporter;
import com.scythebill.birdlist.ui.imports.HeardOnlyFieldMapper;
import com.scythebill.birdlist.ui.imports.LineExtractor;
import com.scythebill.birdlist.ui.imports.LineExtractors;
import com.scythebill.birdlist.ui.imports.MultiFormatDateFromStringFieldMapper;
import com.scythebill.birdlist.ui.imports.ParsedLocationIds;
import com.scythebill.birdlist.ui.imports.PhotographedFieldMapper;
import com.scythebill.birdlist.ui.imports.SightingsImporter;
import com.scythebill.birdlist.ui.imports.TaxonImporter;
import com.scythebill.birdlist.ui.imports.TaxonResolver;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import org.joda.time.Duration;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.Minutes;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.GJChronology;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class BirdLasserImporter
extends CsvSightingsImporter {
    private static final DateTimeFormatter ISO_DATE_TIME_FORMATTER = ISODateTimeFormat.dateTime().withChronology(GJChronology.getInstance());
    private static final double ASSUME_SAME_LOCATION_DISTANCE_KM = 2.0;
    private static final ReadableDuration ASSUME_SAME_LOCATION_DURATION = Duration.standardMinutes(30L);
    private LineExtractor<String> commonNameExtractor;
    private LineExtractor<String> sciNameExtractor;
    private LineExtractor<String> dateExtractor;
    private LineExtractor<String> timeExtractor;
    private LineExtractor<String> isoDateExtractor;
    private LineExtractor<String> latitudeExtractor;
    private LineExtractor<String> longitudeExtractor;
    private LineExtractor<String> locationExtractor;
    private LineExtractor<String> locationIdExtractor;
    private Map<String, String> directLocationIdToCanonicalLocationId;
    private Map<VisitInfoKey, VisitInfo> visitInfoMap;
    private static final ImmutableMap<String, SightingInfo.BreedingBirdCode> BREEDING_BIRD_CODES;
    private String lastLocationId;
    private Integer sciNameColumnIndex;
    private LocalTime lastStartTime;
    private ReadablePartial lastDate;
    private VisitInfoKey lastVisitInfoKey = null;
    private LocalDateTime firstDateTime;
    private LocalDateTime lastDateTime;
    private LatLongCoordinates lastLatLong;
    private float accumulatedDistanceKm;

    public BirdLasserImporter(ReportSet reportSet, Taxonomy taxonomy, Checklists checklists, PredefinedLocations predefinedLocations, File file) {
        super(reportSet, taxonomy, checklists, predefinedLocations, file, file);
    }

    protected LineExtractor<? extends Object> taxonomyIdExtractor() {
        return LineExtractors.joined(Joiner.on('|'), this.commonNameExtractor, this.sciNameExtractor);
    }

    @Override
    protected TaxonImporter<String[]> newTaxonImporter(Taxonomy taxonomy) {
        return new FieldTaxonImporter<String[]>(taxonomy, this.commonNameExtractor, this.sciNameExtractor);
    }

    @Override
    protected void parseLocationIds(LocationSet locations, PredefinedLocations predefinedLocations) throws IOException {
        this.directLocationIdToCanonicalLocationId = Maps.newHashMap();
        try (ImportLines lines = this.importLines(this.locationsFile);){
            String[] line;
            this.computeMappings(lines);
            LocalDateTime previousDateTime = null;
            String previousLocationId = null;
            String previousLocationName = null;
            LatLongCoordinates previousLatLong = null;
            while ((line = lines.nextLine()) != null) {
                LocalDateTime dateTime;
                String id = (String)this.locationIdExtractor.extract((String)line);
                if (this.locationIds.hasBeenParsed(id)) continue;
                String isoDate = (String)this.isoDateExtractor.extract((String)line);
                try {
                    dateTime = ISO_DATE_TIME_FORMATTER.parseLocalDateTime(isoDate);
                }
                catch (IllegalArgumentException e) {
                    continue;
                }
                String locationName = (String)this.locationExtractor.extract((String)line);
                String latitude = (String)this.latitudeExtractor.extract((String)line);
                String longitude = (String)this.longitudeExtractor.extract((String)line);
                LatLongCoordinates latLong = Strings.isNullOrEmpty(latitude) || Strings.isNullOrEmpty(longitude) ? null : LatLongCoordinates.withLatAndLong(latitude, longitude);
                if (Strings.isNullOrEmpty(locationName) || Objects.equal(locationName, previousLocationName)) {
                    double kmDistance;
                    if (previousDateTime != null && dateTime.isBefore(previousDateTime.plus(ASSUME_SAME_LOCATION_DURATION))) {
                        this.directLocationIdToCanonicalLocationId.put(id, previousLocationId);
                        continue;
                    }
                    if (previousLatLong != null && latLong != null && (kmDistance = previousLatLong.kmDistance(latLong)) < 2.0) {
                        this.directLocationIdToCanonicalLocationId.put(id, previousLocationId);
                        continue;
                    }
                }
                this.directLocationIdToCanonicalLocationId.put(id, id);
                previousDateTime = dateTime;
                previousLocationId = id;
                previousLocationName = locationName;
                previousLatLong = latLong;
                String date = (String)this.dateExtractor.extract((String)line);
                String time = (String)this.timeExtractor.extract((String)line);
                String hint = date + " " + time;
                ParsedLocationIds.ToBeDecided tbd = new ParsedLocationIds.ToBeDecided(locationName, latLong, hint, ParsedLocationIds.ToBeDecided.HintType.other);
                this.locationIds.addToBeResolvedLocationName(id, tbd);
            }
        }
    }

    @Override
    protected ComputedMappings<String[]> computeMappings(ImportLines lines) throws IOException {
        int commonIndex;
        int sciIndex;
        String[] header = lines.nextLine();
        HashMap<String, Integer> headersByIndex = Maps.newHashMap();
        Function<String, String> headerFunc = s -> CharMatcher.whitespace().removeFrom((CharSequence)s).toLowerCase();
        for (int i = 0; i < header.length; ++i) {
            headersByIndex.put(headerFunc.apply(header[i]), i);
        }
        if (this.sciNameColumnIndex != null) {
            sciIndex = this.sciNameColumnIndex;
            commonIndex = this.getRequiredHeader(headersByIndex, headerFunc, "Primary Language", "Species Primary Name");
            if (commonIndex == sciIndex) {
                commonIndex = this.getRequiredHeader(headersByIndex, headerFunc, "Secondary Language", "Species Secondary Name");
            }
        } else {
            commonIndex = this.getRequiredHeader(headersByIndex, headerFunc, "Primary Language", "Species Primary Name");
            sciIndex = this.getRequiredHeader(headersByIndex, headerFunc, "Tertiary Language", "Species Tertiary Name");
        }
        int dateIndex = this.getRequiredHeader(headersByIndex, headerFunc, "Date");
        int timeIndex = this.getRequiredHeader(headersByIndex, headerFunc, "Time");
        Integer seenHeardIndex = (Integer)headersByIndex.get("seen/heard");
        int latitudeIndex = this.getRequiredHeader(headersByIndex, headerFunc, "Latitude");
        int longitudeIndex = this.getRequiredHeader(headersByIndex, headerFunc, "Longitude");
        Integer countIndex = (Integer)headersByIndex.get("count");
        Integer locationNameIndex = (Integer)headersByIndex.get("locationname");
        Integer commentIndex = (Integer)headersByIndex.get("notes");
        int isoDateIndex = this.getRequiredHeader(headersByIndex, headerFunc, "ISO date");
        Integer breedingStatusIndex = (Integer)headersByIndex.get("breedingstatus");
        Integer aliveOrDeadIndex = (Integer)headersByIndex.get("dead/alive");
        Integer photographedIndex = (Integer)headersByIndex.get("photographed");
        ArrayList mappers = Lists.newArrayList();
        this.commonNameExtractor = LineExtractors.stringFromIndex(commonIndex);
        this.sciNameExtractor = LineExtractors.stringFromIndex(sciIndex);
        this.dateExtractor = LineExtractors.stringFromIndex(dateIndex);
        this.timeExtractor = LineExtractors.stringFromIndex(timeIndex);
        this.locationExtractor = locationNameIndex == null ? LineExtractors.constant("") : LineExtractors.stringFromIndex(locationNameIndex);
        this.latitudeExtractor = LineExtractors.stringFromIndex(latitudeIndex);
        this.longitudeExtractor = LineExtractors.stringFromIndex(longitudeIndex);
        this.isoDateExtractor = LineExtractors.stringFromIndex(isoDateIndex);
        this.locationIdExtractor = new LineExtractor<String>(){

            @Override
            public String extract(String[] line) {
                String name = (String)BirdLasserImporter.this.locationExtractor.extract((String)line);
                if (!Strings.isNullOrEmpty(name)) {
                    return name;
                }
                return String.format("%s|%s", BirdLasserImporter.this.latitudeExtractor.extract((String)line), BirdLasserImporter.this.longitudeExtractor.extract((String)line));
            }
        };
        mappers.add(new MultiFormatDateFromStringFieldMapper(this.dateExtractor, "yyyy-MM-dd", "yyyy/MM/dd"));
        if (countIndex != null) {
            mappers.add(new CountFieldMapper(LineExtractors.stringFromIndex(countIndex)));
        }
        LineExtractor<String> commentExtractor = commentIndex == null ? LineExtractors.constant("") : LineExtractors.stringFromIndex(commentIndex);
        mappers.add(new DescriptionFieldMapper(LineExtractors.appendingLatitudeAndLongitude(commentExtractor, this.latitudeExtractor, this.longitudeExtractor)));
        if (seenHeardIndex != null) {
            final LineExtractor<String> seenHeardExtractor = LineExtractors.stringFromIndex(seenHeardIndex);
            mappers.add(new HeardOnlyFieldMapper<String[]>(new LineExtractor<Boolean>(){

                @Override
                public Boolean extract(String[] line) {
                    String extracted = (String)seenHeardExtractor.extract(line);
                    return "heard".equalsIgnoreCase(extracted);
                }
            }));
        }
        if (breedingStatusIndex != null) {
            final LineExtractor<String> breedingStatusExtractor = LineExtractors.stringFromIndex(breedingStatusIndex);
            mappers.add(new FieldMapper<String[]>(){

                @Override
                public void map(String[] line, Sighting.Builder sighting) {
                    String extracted = (String)breedingStatusExtractor.extract(line);
                    SightingInfo.BreedingBirdCode code = BREEDING_BIRD_CODES.get(extracted);
                    if (code != null) {
                        sighting.getSightingInfo().setBreedingBirdCode(code);
                    }
                }
            });
        }
        if (aliveOrDeadIndex != null) {
            final LineExtractor<String> aliveOrDeadExtractor = LineExtractors.stringFromIndex(aliveOrDeadIndex);
            mappers.add(new FieldMapper<String[]>(){

                @Override
                public void map(String[] line, Sighting.Builder sighting) {
                    String extracted = (String)aliveOrDeadExtractor.extract(line);
                    if (extracted != null && extracted.toLowerCase().startsWith("dead")) {
                        sighting.getSightingInfo().setSightingStatus(SightingInfo.SightingStatus.DEAD);
                    }
                }
            });
        }
        if (photographedIndex != null) {
            LineExtractor<Boolean> photographedExtractor = LineExtractors.booleanFromIndex(photographedIndex);
            mappers.add(new PhotographedFieldMapper(photographedExtractor));
        }
        this.visitInfoMap = Maps.newLinkedHashMap();
        return new ComputedMappings<String[]>(new SightingsImporter.TaxonFieldMapper(this.taxonomyIdExtractor()), new SightingsImporter.LocationMapper(new LineExtractor<Object>(){

            @Override
            public Object extract(String[] line) {
                String extracted = (String)BirdLasserImporter.this.locationIdExtractor.extract((String)line);
                String canonicalId = BirdLasserImporter.this.directLocationIdToCanonicalLocationId.get(extracted);
                return canonicalId;
            }
        }), mappers);
    }

    @Override
    protected ImportLines importLines(File file) throws IOException {
        return new SortedByTimeImporter(CsvImportLines.fromFile(file, this.getCharset()));
    }

    @Override
    protected void finishSighting(Sighting.Builder newSighting, String[] line) {
        String locationId = newSighting.getLocationId();
        if (locationId == null) {
            return;
        }
        try {
            LocalTime localTime;
            LocalTime startTimeToSet = localTime = TimeIO.fromExternalString((String)this.timeExtractor.extract((String)line));
            boolean resetVisit = false;
            if (this.lastLocationId == null) {
                resetVisit = true;
            } else if (this.lastLocationId.equals(newSighting.getLocationId()) && this.lastDate.equals(newSighting.getDate())) {
                startTimeToSet = this.lastStartTime;
            } else {
                resetVisit = true;
            }
            newSighting.setTime(TimeIO.normalize(startTimeToSet));
            if (resetVisit) {
                this.lastLocationId = locationId;
                this.lastStartTime = startTimeToSet;
                this.lastDate = newSighting.getDate();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public void beforeParseTaxonomyIds() throws IOException {
        try (ImportLines lines = this.importLines(this.sightingsFile);){
            String[] line;
            String[] header = lines.nextLine();
            HashMap<String, Integer> headersByIndex = Maps.newHashMap();
            Function<String, String> headerFunc = s -> CharMatcher.whitespace().removeFrom((CharSequence)s).toLowerCase();
            for (int i = 0; i < header.length; ++i) {
                headersByIndex.put(headerFunc.apply(header[i]), i);
            }
            TaxonResolver resolver = new TaxonResolver(this.getTaxonomy());
            HashMultiset<Integer> headersWithSciNames = HashMultiset.create();
            block6: while (headersWithSciNames.size() <= 500 && (line = lines.nextLine()) != null) {
                if (this.skipLine(line)) continue;
                for (int i = 0; i < line.length; ++i) {
                    if (resolver.map(null, line[i], null) == null) continue;
                    headersWithSciNames.add(i);
                    continue block6;
                }
            }
            if (!headersWithSciNames.isEmpty()) {
                this.sciNameColumnIndex = (Integer)Multisets.copyHighestCountFirst(headersWithSciNames).iterator().next();
            }
        }
    }

    @Override
    protected void lookForVisitInfo(ReportSet reportSet, String[] line, Sighting newSighting, VisitInfoKey visitInfoKey) {
        LatLongCoordinates latLong = LatLongCoordinates.withLatAndLong((String)this.latitudeExtractor.extract((String)line), (String)this.longitudeExtractor.extract((String)line));
        String isoDate = (String)this.isoDateExtractor.extract((String)line);
        LocalDateTime dateTime = ISO_DATE_TIME_FORMATTER.parseLocalDateTime(isoDate);
        boolean resetVisitInfo = false;
        if (this.lastVisitInfoKey == null) {
            resetVisitInfo = true;
        } else if (this.lastVisitInfoKey.equals(visitInfoKey)) {
            this.accumulatedDistanceKm = (float)((double)this.accumulatedDistanceKm + latLong.kmDistance(this.lastLatLong));
        } else {
            this.allSightingsFinished();
            resetVisitInfo = true;
        }
        this.lastLatLong = latLong;
        this.lastDateTime = dateTime;
        if (resetVisitInfo) {
            this.lastVisitInfoKey = visitInfoKey;
            this.accumulatedDistanceKm = 0.0f;
            this.firstDateTime = dateTime;
        }
    }

    @Override
    protected void allSightingsFinished() {
        Duration duration;
        VisitInfo.Builder visitInfo = VisitInfo.builder().withObservationType(VisitInfo.ObservationType.HISTORICAL);
        if ((double)this.accumulatedDistanceKm > 0.01) {
            visitInfo.withDistance(Distance.inKilometers(this.accumulatedDistanceKm));
        }
        if ((duration = Minutes.minutesBetween(this.firstDateTime, this.lastDateTime).toStandardDuration()).isLongerThan(Duration.standardMinutes(5L))) {
            visitInfo.withDuration(duration);
        }
        this.visitInfoMap.put(this.lastVisitInfoKey, visitInfo.build());
    }

    @Override
    public Map<VisitInfoKey, VisitInfo> getAccumulatedVisitInfoMap() {
        return this.visitInfoMap;
    }

    static {
        ImmutableMap.Builder<String, SightingInfo.BreedingBirdCode> builder = ImmutableMap.builder();
        builder.put("Courting display", SightingInfo.BreedingBirdCode.COURTSHIP_DISPLAY_OR_COPULATION);
        builder.put("Copulation", SightingInfo.BreedingBirdCode.COURTSHIP_DISPLAY_OR_COPULATION);
        builder.put("Carrying nesting material", SightingInfo.BreedingBirdCode.CARRYING_NESTING_MATERIAL);
        builder.put("Active nest building", SightingInfo.BreedingBirdCode.NEST_BUILDING);
        builder.put("Active nest building - excavating cavity", SightingInfo.BreedingBirdCode.NEST_BUILDING);
        builder.put("Newly completed nest", SightingInfo.BreedingBirdCode.OCCUPIED_NEST);
        builder.put("Nest with chicks", SightingInfo.BreedingBirdCode.NEST_WITH_YOUNG);
        builder.put("Nest with eggs", SightingInfo.BreedingBirdCode.NEST_WITH_EGGS);
        builder.put("Parents feeding young in nest", SightingInfo.BreedingBirdCode.FEEDING_YOUNG);
        builder.put("Parent with faecal sac", SightingInfo.BreedingBirdCode.CARRYING_FECAL_SAC);
        builder.put("Parents and young, not in nest", SightingInfo.BreedingBirdCode.RECENTLY_FLEDGED);
        builder.put("Nest present - status uncertain", SightingInfo.BreedingBirdCode.OCCUPIED_NEST);
        builder.put("In cavity", SightingInfo.BreedingBirdCode.OCCUPIED_NEST);
        BREEDING_BIRD_CODES = builder.build();
    }

    static class SortedByTimeImporter
    implements ImportLines {
        private final ImportLines root;
        private Iterator<LineAndRowNumber> remainingLines;
        private int currentRow;

        SortedByTimeImporter(ImportLines root) {
            this.root = root;
        }

        @Override
        public void close() throws IOException {
            this.root.close();
        }

        @Override
        public ImportLines withoutTrimming() {
            this.root.withoutTrimming();
            return this;
        }

        @Override
        public String[] nextLine() throws IOException {
            if (this.remainingLines == null) {
                String[] line;
                String[] header = this.root.nextLine();
                if (header == null) {
                    throw new IllegalStateException("File is empty");
                }
                int foundIndex = -1;
                for (int i = 0; i < header.length; ++i) {
                    if (!"isodate".equals(CharMatcher.whitespace().removeFrom(header[i]).toLowerCase())) continue;
                    foundIndex = i;
                    break;
                }
                if (foundIndex < 0) {
                    throw new IllegalStateException("Could not find ISO Date column in BirdLasser export.");
                }
                TreeMultimap sortedLines = TreeMultimap.create();
                int row = 0;
                while ((line = this.root.nextLine()) != null) {
                    if (line.length <= foundIndex) continue;
                    sortedLines.put(line[foundIndex], new LineAndRowNumber(line, ++row));
                }
                this.remainingLines = sortedLines.values().iterator();
                return header;
            }
            if (!this.remainingLines.hasNext()) {
                return null;
            }
            LineAndRowNumber next = this.remainingLines.next();
            this.currentRow = next.row;
            return next.line;
        }

        @Override
        public int lineNumber() {
            return this.currentRow;
        }
    }

    static class LineAndRowNumber
    implements Comparable<LineAndRowNumber> {
        final String[] line;
        final int row;

        LineAndRowNumber(String[] line, int row) {
            this.line = line;
            this.row = row;
        }

        @Override
        public int compareTo(LineAndRowNumber that) {
            return this.row - that.row;
        }
    }
}

