/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.io.CsvImportLines;
import com.scythebill.birdlist.model.io.ImportLines;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.imports.ComputedMappings;
import com.scythebill.birdlist.ui.imports.CountFieldMapper;
import com.scythebill.birdlist.ui.imports.CsvSightingsImporter;
import com.scythebill.birdlist.ui.imports.DescriptionFieldMapper;
import com.scythebill.birdlist.ui.imports.FieldTaxonImporter;
import com.scythebill.birdlist.ui.imports.HeardOnlyFieldMapper;
import com.scythebill.birdlist.ui.imports.ImportedLocation;
import com.scythebill.birdlist.ui.imports.LineExtractor;
import com.scythebill.birdlist.ui.imports.LineExtractors;
import com.scythebill.birdlist.ui.imports.MultiFormatDateFromStringFieldMapper;
import com.scythebill.birdlist.ui.imports.SightingsImporter;
import com.scythebill.birdlist.ui.imports.TaxonImporter;
import com.scythebill.birdlist.ui.imports.TaxonResolver;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Locale;

public class BirdBrainImporter
extends CsvSightingsImporter {
    private final LineExtractor<String> locationIdExtractor = LineExtractors.joined(Joiner.on('|').useForNull(""), LineExtractors.stringFromIndex(5), LineExtractors.stringFromIndex(6), LineExtractors.stringFromIndex(7), LineExtractors.stringFromIndex(8), LineExtractors.stringFromIndex(9));
    private final LineExtractor<String> taxonomyIdExtractor = LineExtractors.stringFromIndex(1);

    public BirdBrainImporter(ReportSet reportSet, Taxonomy taxonomy, Checklists checklists, PredefinedLocations predefinedLocations, File file) {
        super(reportSet, taxonomy, checklists, predefinedLocations, file, file);
    }

    protected LineExtractor<? extends Object> taxonomyIdExtractor() {
        return this.taxonomyIdExtractor;
    }

    @Override
    protected TaxonImporter<String[]> newTaxonImporter(Taxonomy taxonomy) {
        TaxonResolver taxonResolver = new TaxonResolver(taxonomy);
        return new FieldTaxonImporter<String[]>(taxonResolver, LineExtractors.stringFromIndex(1), LineExtractors.stringFromIndex(2));
    }

    @Override
    protected void parseLocationIds(LocationSet locations, PredefinedLocations predefinedLocations) throws IOException {
        try (ImportLines lines = CsvImportLines.fromFile(this.locationsFile, this.getCharset());){
            String[] line;
            this.computeMappings(lines);
            while ((line = lines.nextLine()) != null) {
                String latLong;
                int commaIndex;
                String id = (String)this.locationIdExtractor.extract((String)line);
                if (this.locationIds.hasBeenParsed(id)) continue;
                ImportedLocation imported = new ImportedLocation();
                imported.country = Strings.emptyToNull(line[5]);
                if (line[6] != null && line[6].length() == 2) {
                    imported.stateCode = line[6];
                } else {
                    imported.state = Strings.emptyToNull(line[6]);
                }
                imported.county = Strings.emptyToNull(line[7]);
                imported.city = Strings.emptyToNull(line[8]);
                if (!Strings.isNullOrEmpty(line[9])) {
                    imported.locationNames.add(line[9]);
                }
                imported.description = Strings.emptyToNull(line[10]);
                if (line.length > 16 && !Strings.isNullOrEmpty(line[16]) && (commaIndex = (latLong = line[16]).indexOf(44)) > 0) {
                    imported.latitude = latLong.substring(0, commaIndex).trim();
                    imported.longitude = latLong.substring(commaIndex + 1).trim();
                }
                String locationId = imported.addToLocationSet(this.reportSet, locations, this.locationShortcuts, predefinedLocations);
                this.locationIds.put((Object)id, locationId);
            }
        }
    }

    private static boolean isHeardOnly(String tag) {
        if (Strings.isNullOrEmpty(tag)) {
            return false;
        }
        return tag.toLowerCase().equals("heard only");
    }

    @Override
    protected ComputedMappings<String[]> computeMappings(ImportLines lines) throws IOException {
        ArrayList mappers = Lists.newArrayList();
        mappers.add(new MultiFormatDateFromStringFieldMapper(LineExtractors.stringFromIndex(4), Locale.US, "MM/dd/yy", "MM-dd-yy"));
        mappers.add(new DescriptionFieldMapper<String[]>(new DescriptionExtractor()));
        mappers.add(new CountFieldMapper(LineExtractors.stringFromIndex(3)));
        LineExtractor<String> tagExtractor = LineExtractors.stringFromIndex(11);
        mappers.add(new HeardOnlyFieldMapper<String[]>(line -> BirdBrainImporter.isHeardOnly((String)tagExtractor.extract((String)line))));
        return new ComputedMappings<String[]>(new SightingsImporter.TaxonFieldMapper(this.taxonomyIdExtractor), new SightingsImporter.LocationMapper(this.locationIdExtractor), mappers);
    }

    @Override
    protected Charset getCharset() {
        if (Charset.isSupported("x-MacRoman")) {
            return Charset.forName("x-MacRoman");
        }
        if (Charset.isSupported("MacRoman")) {
            return Charset.forName("MacRoman");
        }
        return StandardCharsets.ISO_8859_1;
    }

    static class DescriptionExtractor
    implements LineExtractor<String> {
        DescriptionExtractor() {
        }

        @Override
        public String extract(String[] line) {
            String flag2;
            String flag1;
            StringBuilder builder = new StringBuilder();
            String tag = this.entry(line, 11);
            if (!Strings.isNullOrEmpty(tag) && !BirdBrainImporter.isHeardOnly(tag)) {
                this.append(builder, "/" + tag, ' ');
            }
            if ("Yes".equals(flag1 = this.entry(line, 12))) {
                this.append(builder, "/f1", ' ');
            }
            if ("Yes".equals(flag2 = this.entry(line, 13))) {
                this.append(builder, "/f2", ' ');
            }
            String notes = this.entry(line, 14);
            this.append(builder, notes, ' ');
            String moreNotes = this.entry(line, 15);
            this.append(builder, moreNotes, '\n');
            return Strings.emptyToNull(builder.toString());
        }

        private void append(StringBuilder builder, String text, char separator) {
            if (!Strings.isNullOrEmpty(text)) {
                if (builder.length() > 0) {
                    builder.append(separator);
                }
                builder.append(text);
            }
        }

        private String entry(String[] line, int index) {
            if (line.length <= index) {
                return null;
            }
            return line[index];
        }
    }
}

