/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.common.io.LineReader;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.checklist.TransposedChecklistSynthesizer;
import com.scythebill.birdlist.model.io.CsvImportLines;
import com.scythebill.birdlist.model.io.ImportLines;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.imports.BirdbaseAndAvisysLocations;
import com.scythebill.birdlist.ui.imports.ComputedMappings;
import com.scythebill.birdlist.ui.imports.CountFieldMapper;
import com.scythebill.birdlist.ui.imports.CsvSightingsImporter;
import com.scythebill.birdlist.ui.imports.DateFromStringFieldMapper;
import com.scythebill.birdlist.ui.imports.DescriptionFieldMapper;
import com.scythebill.birdlist.ui.imports.FemaleFieldMapper;
import com.scythebill.birdlist.ui.imports.FieldTaxonImporter;
import com.scythebill.birdlist.ui.imports.HeardOnlyFieldMapper;
import com.scythebill.birdlist.ui.imports.ImmatureFieldMapper;
import com.scythebill.birdlist.ui.imports.ImportException;
import com.scythebill.birdlist.ui.imports.ImportedLocation;
import com.scythebill.birdlist.ui.imports.LineExtractor;
import com.scythebill.birdlist.ui.imports.LineExtractors;
import com.scythebill.birdlist.ui.imports.MaleFieldMapper;
import com.scythebill.birdlist.ui.imports.PhotographedFieldMapper;
import com.scythebill.birdlist.ui.imports.SightingsImporter;
import com.scythebill.birdlist.ui.imports.TaxonImporter;
import com.scythebill.birdlist.ui.messages.Messages;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;

public class AvisysImporter
extends CsvSightingsImporter {
    private static final int DESCRIPTION_FIELD_INDEX = 6;
    private final LineExtractor<String> idExtractor = LineExtractors.joined(Joiner.on('|').useForNull(""), LineExtractors.stringFromIndex(3), LineExtractors.stringFromIndex(11), LineExtractors.stringFromIndex(12), LineExtractors.stringFromIndex(13), LineExtractors.stringFromIndex(14), LineExtractors.stringFromIndex(15));
    private final LineExtractor<String> taxonomyIdExtractor = LineExtractors.joined(Joiner.on('|').useForNull(""), LineExtractors.stringFromIndex(0), LineExtractors.stringFromIndex(1), LineExtractors.stringFromIndex(2));
    private final TransposedChecklistSynthesizer transposedChecklistSynthesizer;
    private final Checklists checklists;
    private File fieldNotesFile;

    public AvisysImporter(ReportSet reportSet, Taxonomy taxonomy, Checklists checklists, TransposedChecklistSynthesizer transposedChecklistSynthesizer, PredefinedLocations predefinedLocations, File file) {
        super(reportSet, taxonomy, checklists, predefinedLocations, file, file);
        this.checklists = checklists;
        this.transposedChecklistSynthesizer = transposedChecklistSynthesizer;
    }

    public void attachFieldNotes(File file) {
        this.fieldNotesFile = file;
    }

    protected LineExtractor<? extends Object> taxonomyIdExtractor() {
        return this.taxonomyIdExtractor;
    }

    @Override
    protected TaxonImporter<String[]> newTaxonImporter(Taxonomy taxonomy) {
        return new FieldTaxonImporter<String[]>(taxonomy, LineExtractors.stringFromIndex(0), LineExtractors.joined(Joiner.on(' ').useForNull(""), LineExtractors.stringFromIndex(1), LineExtractors.stringFromIndex(2)), null);
    }

    @Override
    protected void parseLocationIds(LocationSet locations, PredefinedLocations predefinedLocations) throws IOException {
        try (ImportLines lines = this.importLines(this.locationsFile);){
            String[] line;
            while ((line = lines.nextLine()) != null) {
                String id = (String)this.idExtractor.extract((String)line);
                if (this.locationIds.hasBeenParsed(id)) continue;
                ImportedLocation imported = new ImportedLocation();
                imported.state = AvisysImporter.safeGet(line, 14);
                imported.stateCode = Strings.emptyToNull(line[7]);
                imported.county = AvisysImporter.safeGet(line, 13);
                String place = Strings.emptyToNull(line[3]);
                if (place != null && !place.equals(AvisysImporter.safeGet(line, 15))) {
                    imported.locationNames.add(place);
                }
                imported.locationNames.add(AvisysImporter.safeGet(line, 11));
                imported.city = AvisysImporter.safeGet(line, 12);
                String countryCode = Strings.emptyToNull(line[8]);
                if (countryCode != null) {
                    BirdbaseAndAvisysLocations.updateImportedLocation(imported, countryCode);
                }
                if (imported.country == null) {
                    imported.country = AvisysImporter.safeGet(line, 15);
                    if ("ID".equals(countryCode) && ("Java and Bali".equals(place) || "Java and Bali".equals(imported.country))) {
                        imported.state = "Jawa";
                        imported.stateCode = "JW";
                    }
                }
                if ("US-Hawaii".equalsIgnoreCase(imported.country)) {
                    imported.country = null;
                    imported.countryCode = "US";
                }
                if (imported.region == null) {
                    imported.region = AvisysImporter.safeGet(line, 16);
                }
                String locationId = imported.addToLocationSet(this.reportSet, locations, this.locationShortcuts, predefinedLocations);
                this.locationIds.put((Object)id, locationId);
            }
        }
    }

    private static String safeGet(String[] line, int index) {
        if (index >= line.length) {
            return null;
        }
        return Strings.emptyToNull(line[index]);
    }

    @Override
    protected ComputedMappings<String[]> computeMappings(ImportLines lines) throws IOException {
        ArrayList mappers = Lists.newArrayList();
        mappers.add(new DateFromStringFieldMapper("MM/dd/yy", LineExtractors.stringFromIndex(4)));
        mappers.add(new CountFieldMapper(LineExtractors.stringFromIndex(5)));
        LineExtractor<String> descriptionField = LineExtractors.stringFromIndex(6);
        mappers.add(new DescriptionFieldMapper(descriptionField));
        mappers.add(new FemaleFieldMapper<String[]>(new ExtractAvisysFlag(descriptionField, "f")));
        mappers.add(new MaleFieldMapper<String[]>(new ExtractAvisysFlag(descriptionField, "m")));
        mappers.add(new ImmatureFieldMapper<String[]>(new ExtractAvisysFlag(descriptionField, "i")));
        mappers.add(new HeardOnlyFieldMapper<String[]>(new ExtractAvisysFlag(descriptionField, "h")));
        mappers.add(new PhotographedFieldMapper<String[]>(new ExtractAvisysFlag(descriptionField, "p")));
        return new ComputedMappings<String[]>(new SightingsImporter.TaxonFieldMapper(this, this.taxonomyIdExtractor), new SightingsImporter.LocationMapper(this, this.idExtractor), mappers);
    }

    @Override
    protected ImportLines importLines(File file) throws IOException {
        final ImportLines mainFile = CsvImportLines.fromFileNoMulti(file, this.getCharset());
        if (this.fieldNotesFile == null) {
            return mainFile;
        }
        final BufferedReader fieldNotesReader = Files.newReader(this.fieldNotesFile, this.getCharset());
        final LineReader fieldNotesLines = new LineReader(fieldNotesReader);
        return new ImportLines(){
            private boolean foundFirstLine = false;
            private String pushBackFieldNotesLine = null;

            @Override
            public void close() throws IOException {
                try {
                    mainFile.close();
                }
                finally {
                    fieldNotesReader.close();
                }
            }

            @Override
            public ImportLines withoutTrimming() {
                mainFile.withoutTrimming();
                return this;
            }

            @Override
            public int lineNumber() {
                return mainFile.lineNumber();
            }

            @Override
            public String[] nextLine() throws IOException {
                String maybeFieldNotesLine;
                String speciesLine;
                String[] nextLine = mainFile.nextLine();
                if (nextLine == null || nextLine.length == 0) {
                    return nextLine;
                }
                String commonName = nextLine[0];
                if (this.foundFirstLine) {
                    speciesLine = this.nextFieldNotesLine();
                } else {
                    while ((speciesLine = this.nextFieldNotesLine()) != null) {
                        this.foundFirstLine = speciesLine.startsWith(commonName);
                        if (!this.foundFirstLine) continue;
                    }
                }
                if (speciesLine == null || !speciesLine.startsWith(commonName)) {
                    throw new ImportException(Messages.getMessage(Messages.Name.AVISYS_FIELD_NOTES_FILE_DOES_NOT_MATCH));
                }
                String metadataNotesLine = this.nextFieldNotesLine();
                if (metadataNotesLine == null || !metadataNotesLine.startsWith("  ")) {
                    throw new ImportException(Messages.getMessage(Messages.Name.AVISYS_FIELD_NOTES_FILE_NOT_EXPECTED_FORM));
                }
                while ((maybeFieldNotesLine = this.nextFieldNotesLine()) != null && maybeFieldNotesLine.startsWith("    ")) {
                    String fieldNotesLine = maybeFieldNotesLine.substring(4);
                    if (nextLine[6] == null || nextLine[6].isEmpty()) {
                        nextLine[6] = fieldNotesLine;
                        continue;
                    }
                    nextLine[6] = nextLine[6] + "\n" + fieldNotesLine;
                }
                this.pushBackFieldNotesLine = maybeFieldNotesLine;
                return nextLine;
            }

            private String nextFieldNotesLine() throws IOException {
                if (this.pushBackFieldNotesLine != null) {
                    String nextLine = this.pushBackFieldNotesLine;
                    this.pushBackFieldNotesLine = null;
                    return nextLine;
                }
                return fieldNotesLines.readLine();
            }
        };
    }

    @Override
    protected Checklist getBuiltInChecklist(Location location) {
        ImmutableCollection<String> locations;
        String locationCode = this.checklists.getLocationWithNearestBuiltInChecklist(location);
        if (locationCode != null && (locations = BirdbaseAndAvisysLocations.getMergedLocations(locationCode)) != null && !locations.isEmpty()) {
            return this.transposedChecklistSynthesizer.synthesizeChecklistInternal(this.reportSet, locations);
        }
        return super.getBuiltInChecklist(location);
    }

    @Override
    protected Charset getCharset() {
        return StandardCharsets.ISO_8859_1;
    }

    static class ExtractAvisysFlag
    implements LineExtractor<Boolean> {
        private final LineExtractor<String> descriptionField;
        private final String flagName;

        public ExtractAvisysFlag(LineExtractor<String> descriptionField, String flag) {
            this.descriptionField = descriptionField;
            this.flagName = "/" + flag;
        }

        @Override
        public Boolean extract(String[] line) {
            String extract = (String)this.descriptionField.extract((String)line);
            if (extract == null) {
                return false;
            }
            return extract.contains(this.flagName);
        }
    }
}

