/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.ClosestLocations;
import com.scythebill.birdlist.model.sighting.LatLongCoordinates;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.Locations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.ui.actions.locationapi.GeocoderResults;
import com.scythebill.birdlist.ui.actions.locationapi.ebird.EBirdGeocoder;
import com.scythebill.birdlist.ui.imports.ParsedLocationIds;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.apache.commons.text.similarity.LevenshteinDistance;

class AutoGeocodeLocations {
    private static final double KM_CLOSE_ENOUGH_FOR_EXISTING_LOCATION = 1.0;
    private static final Logger logger = Logger.getLogger(AutoGeocodeLocations.class.getName());
    private static final double KM_CLOSE_ENOUGH_FOR_EXACT_NAME_MATCH = 2.0;
    private static final double KM_CLOSE_ENOUGH_FOR_LESS_PRECISE_NAME_MATCH = 0.5;
    private static final double KM_CLOSE_ENOUGH_TO_TRUST_PARENT = 10.0;
    private static final double KM_CLOSE_ENOUGH_TO_PREFILL_PARENT = 50.0;
    private final EBirdGeocoder eBirdGeocoder;

    @Inject
    AutoGeocodeLocations(EBirdGeocoder eBirdGeocoder) {
        this.eBirdGeocoder = eBirdGeocoder;
    }

    public ListenableFuture<Void> autoGeocodeLocations(ParsedLocationIds parsedLocationIds, ReportSet reportSet) {
        ImmutableMap<Object, ParsedLocationIds.ToBeDecided> toBeResolvedNames = parsedLocationIds.toBeResolvedNames();
        ArrayList futures = new ArrayList();
        for (Map.Entry entry : toBeResolvedNames.entrySet()) {
            ParsedLocationIds.ToBeDecided toBeDecided = (ParsedLocationIds.ToBeDecided)entry.getValue();
            Object key = entry.getKey();
            if (toBeDecided.latLong == null || toBeDecided.name == null || toBeDecided.name.isEmpty()) continue;
            Location nearestLocation = ClosestLocations.nearestLocation(toBeDecided.latLong, reportSet.getLocations());
            if (nearestLocation != null) {
                double distanceToNearestLocation = nearestLocation.getLatLong().get().kmDistance(toBeDecided.latLong);
                if (distanceToNearestLocation < 1.0 && LevenshteinDistance.getDefaultInstance().apply(nearestLocation.getDisplayName(), toBeDecided.name) <= 2) {
                    parsedLocationIds.put(key, nearestLocation.getId());
                    continue;
                }
                if (distanceToNearestLocation < 10.0) {
                    Location nearestBuiltInParent = Locations.getBuiltInAncestor(nearestLocation);
                    this.fullyResolveLocationUsingGeocodedParent(parsedLocationIds, key, nearestBuiltInParent, toBeDecided, reportSet.getLocations());
                    continue;
                }
            }
            double searchCenterLat = Math.round(toBeDecided.latLong.latitudeAsDouble());
            double searchCenterLong = Math.round(toBeDecided.latLong.longitudeAsDouble());
            ListenableFuture<ImmutableList<GeocoderResults>> resultsFutures = this.eBirdGeocoder.reverseGeocode(reportSet.getLocations(), toBeDecided.latLong, LatLongCoordinates.withLatAndLong(searchCenterLat, searchCenterLong), 100);
            SettableFuture done = SettableFuture.create();
            resultsFutures.addListener(() -> this.geocodeResultsAvailable(parsedLocationIds, reportSet, toBeDecided, key, resultsFutures, done), MoreExecutors.directExecutor());
            futures.add(done);
        }
        if (futures.isEmpty()) {
            return Futures.immediateFuture(null);
        }
        return Futures.whenAllComplete(futures).call(() -> null, MoreExecutors.directExecutor());
    }

    private void geocodeResultsAvailable(ParsedLocationIds parsedLocationIds, ReportSet reportSet, ParsedLocationIds.ToBeDecided toBeDecided, Object key, ListenableFuture<ImmutableList<GeocoderResults>> resultsFutures, SettableFuture<Void> done) {
        try {
            ImmutableList results = (ImmutableList)resultsFutures.get();
            if (!results.isEmpty()) {
                for (GeocoderResults result : results) {
                    if (!result.preferredParent().isPresent() || !result.name().equals(toBeDecided.name) || !(result.coordinates().kmDistance(toBeDecided.latLong) < 2.0)) continue;
                    SwingUtilities.invokeLater(() -> {
                        this.fullyResolveLocationToGeocoderResult(parsedLocationIds, key, result, toBeDecided, reportSet.getLocations());
                        done.set(null);
                    });
                    return;
                }
                GeocoderResults closestResult = (GeocoderResults)results.get(0);
                if (closestResult.preferredParent().isPresent()) {
                    double distanceInKm = closestResult.coordinates().kmDistance(toBeDecided.latLong);
                    if (distanceInKm < 0.5 && (closestResult.name().contains(toBeDecided.name) || toBeDecided.name.contains(closestResult.name()))) {
                        SwingUtilities.invokeLater(() -> {
                            this.fullyResolveLocationToGeocoderResult(parsedLocationIds, key, closestResult, toBeDecided, reportSet.getLocations());
                            done.set(null);
                        });
                        return;
                    }
                    if (distanceInKm < 10.0) {
                        SwingUtilities.invokeLater(() -> {
                            this.fullyResolveLocationUsingGeocodedParent(parsedLocationIds, key, closestResult.preferredParent().get(), toBeDecided, reportSet.getLocations());
                            done.set(null);
                        });
                        return;
                    }
                    if (distanceInKm < 50.0) {
                        SwingUtilities.invokeLater(() -> {
                            this.prefillParentLocation(parsedLocationIds, key, closestResult, toBeDecided, reportSet.getLocations());
                            done.set(null);
                        });
                        return;
                    }
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to reverse geocode", e);
        }
        done.set(null);
    }

    private void fullyResolveLocationUsingGeocodedParent(ParsedLocationIds parsedLocationIds, Object key, Location preferredParent, ParsedLocationIds.ToBeDecided toBeDecided, LocationSet locationSet) {
        Location parent = Locations.normalizeLocation(preferredParent, locationSet);
        Location existingChild = parent.getContent(toBeDecided.name);
        if (existingChild != null) {
            parsedLocationIds.put(key, existingChild.getId());
        } else {
            Location child = new Location.Builder().setParent(parent).setName(toBeDecided.name).setLatLong(toBeDecided.latLong).build();
            locationSet.ensureAdded(child);
            parsedLocationIds.put(key, child.getId());
        }
    }

    private void fullyResolveLocationToGeocoderResult(ParsedLocationIds parsedLocationIds, Object key, GeocoderResults result, ParsedLocationIds.ToBeDecided toBeDecided, LocationSet locationSet) {
        Location parent = Locations.normalizeLocation(result.preferredParent().get(), locationSet);
        Location existingChild = parent.getContent(result.name());
        if (existingChild != null) {
            parsedLocationIds.put(key, existingChild.getId());
        } else {
            Location child = new Location.Builder().setParent(parent).setName(result.name()).setLatLong(toBeDecided.latLong).build();
            locationSet.ensureAdded(child);
            parsedLocationIds.put(key, child.getId());
        }
    }

    private void prefillParentLocation(ParsedLocationIds parsedLocationIds, Object key, GeocoderResults result, ParsedLocationIds.ToBeDecided toBeDecided, LocationSet locationSet) {
        Location parent = Locations.normalizeLocation(result.preferredParent().get(), locationSet);
        Location existingChild = parent.getContent(toBeDecided.name);
        if (existingChild != null) {
            parsedLocationIds.put(key, existingChild.getId());
        } else {
            locationSet.ensureAdded(parent);
            toBeDecided.preferredParent = parent;
        }
    }
}

