/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.Optional;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.io.ImportLines;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.imports.ComputedMappings;
import com.scythebill.birdlist.ui.imports.CsvSightingsImporter;
import com.scythebill.birdlist.ui.imports.LineExtractor;
import com.scythebill.birdlist.ui.imports.TaxonImporter;
import com.scythebill.birdlist.ui.messages.Messages;
import java.io.File;
import java.io.IOException;

final class AlwaysFailImporter
extends CsvSightingsImporter {
    private final String errorMessage;
    private final File file;

    AlwaysFailImporter(ReportSet reportSet, Taxonomy taxonomy, Checklists checklists, PredefinedLocations predefinedLocations, File file, String errorMessage) {
        super(reportSet, taxonomy, checklists, predefinedLocations, file, file);
        this.file = file;
        this.errorMessage = errorMessage;
    }

    @Override
    public Optional<String> initialCheck() throws IOException {
        return Optional.of(Messages.getFormattedMessage(Messages.Name.DOES_NOT_APPEAR_TO_BE_AN_ACTUAL_EBIRD_FILE, this.file.getName(), this.errorMessage));
    }

    protected LineExtractor<? extends Object> taxonomyIdExtractor() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void parseLocationIds(LocationSet locations, PredefinedLocations predefinedLocations) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected TaxonImporter<String[]> newTaxonImporter(Taxonomy taxonomy) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected ComputedMappings<String[]> computeMappings(ImportLines lines) throws IOException {
        throw new UnsupportedOperationException();
    }
}

