/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.scythebill.birdlist.model.sighting.SightingTaxons;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.ui.imports.RowExtractor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;

class AlternativeTaxonomicExtractors<T> {
    private RowExtractor<T, String> speciesIn;
    private RowExtractor<T, String> subspeciesIn;
    private RowExtractor<T, String> commonExtractor;
    private Multimap<String, Taxon> splits = ArrayListMultimap.create();

    public AlternativeTaxonomicExtractors(RowExtractor<T, String> speciesExtractor, RowExtractor<T, String> subspeciesExtractor, RowExtractor<T, String> commonExtractor) {
        this.speciesIn = speciesExtractor;
        this.subspeciesIn = subspeciesExtractor;
        this.commonExtractor = commonExtractor;
    }

    public AlternativeTaxonomicExtractors<T> splitting(String species, Taxon ... taxa) {
        this.splits.putAll(species, Arrays.asList(taxa));
        return this;
    }

    public RowExtractor<T, String> common() {
        return line -> {
            String species = this.speciesIn.extract(line);
            return this.splits.containsKey(species) ? null : this.commonExtractor.extract(line);
        };
    }

    public RowExtractor<T, String> species() {
        return line -> {
            Optional<Taxon> taxon;
            String extracted = this.speciesIn.extract(line);
            if (!this.splits.containsKey(extracted)) {
                return extracted;
            }
            Collection<Taxon> splitTaxa = this.splits.get(extracted);
            if (splitTaxa.size() == 1) {
                return TaxonUtils.getFullName(splitTaxa.iterator().next());
            }
            String subspecies = this.subspeciesIn.extract(line);
            if (!Strings.isNullOrEmpty(subspecies) && (taxon = splitTaxa.stream().filter(t -> this.hasOrIsSubspecies((Taxon)t, subspecies)).findAny()).isPresent()) {
                return TaxonUtils.getFullName(taxon.get());
            }
            return SightingTaxons.newSpResolved(ImmutableSet.copyOf(splitTaxa)).getFullName();
        };
    }

    private boolean hasOrIsSubspecies(Taxon taxon, String subspecies) {
        boolean[] found = new boolean[1];
        TaxonUtils.visitTaxa(taxon, t -> {
            if (t.getName().equals(subspecies)) {
                found[0] = true;
                return false;
            }
            return true;
        });
        return found[0];
    }
}

