/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.edits.ChosenUsers;
import com.scythebill.birdlist.model.sighting.edits.RecentEdits;
import com.scythebill.birdlist.ui.app.ReportSetSaver;
import com.scythebill.birdlist.ui.guice.InitialRun;
import com.scythebill.birdlist.ui.panels.location.LocationBrowsePreferences;
import com.scythebill.birdlist.ui.panels.reports.StoredReportSetQueriesPreferences;
import com.scythebill.birdlist.ui.prefs.ReportPreferencesManager;
import com.scythebill.birdlist.ui.prefs.ReportSetPreferencesModule;
import java.io.File;

public class ReportSetModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.bind(ReportSetSaver.class).in(Singleton.class);
        this.bind(ReportPreferencesManager.class).in(Singleton.class);
        this.bindConstant().annotatedWith(InitialRun.class).to(false);
        this.install(ReportSetPreferencesModule.forType(RecentEdits.class));
        this.install(ReportSetPreferencesModule.forType(ChosenUsers.class));
        this.install(ReportSetPreferencesModule.forType(StoredReportSetQueriesPreferences.class));
        this.install(ReportSetPreferencesModule.forType(LocationBrowsePreferences.class));
    }

    @Provides
    public File getReportSetFile(@Named(value="com.adamwiner.birdlist.ui.reportFile") String filename) {
        return new File(filename);
    }

    @Provides
    @Singleton
    public LocationSet providesLocations(ReportSet reportSet) {
        return reportSet.getLocations();
    }
}

