/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.name.Names;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.ReportSets;
import com.scythebill.birdlist.model.sighting.edits.ChosenUsers;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.actions.FinishImportToNewReportSetAction;
import com.scythebill.birdlist.ui.app.NavigableFrame;
import com.scythebill.birdlist.ui.guice.Clements;
import com.scythebill.birdlist.ui.guice.InitialRun;
import com.scythebill.birdlist.ui.imports.FinishedImport;
import com.scythebill.birdlist.ui.imports.ImportMenuPanel;
import com.scythebill.birdlist.ui.panels.OpenOrNewListFrame;
import com.scythebill.birdlist.ui.panels.OpenOrNewListPanel;
import com.scythebill.birdlist.ui.prefs.ReportSetPreference;
import java.io.File;
import java.lang.annotation.Annotation;
import javax.swing.Action;
import javax.swing.JPanel;

public class InitialRunWindowModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.bind(OpenOrNewListFrame.class).in(Scopes.SINGLETON);
        this.bind(NavigableFrame.class).to(OpenOrNewListFrame.class);
        this.bind(Key.get(JPanel.class, (Annotation)Names.named("main"))).to(OpenOrNewListPanel.class);
        this.bind(Key.get(JPanel.class, (Annotation)Names.named("importMenu"))).to(ImportMenuPanel.class);
        this.bind(Action.class).annotatedWith(FinishedImport.class).to(FinishImportToNewReportSetAction.class);
        this.bindConstant().annotatedWith(InitialRun.class).to(true);
    }

    @Provides
    File provideFile() {
        return null;
    }

    @Provides
    @Singleton
    ReportSet provideReportSet(@Clements Taxonomy taxonomy) {
        return ReportSets.newReportSet(taxonomy);
    }

    @Provides
    @Singleton
    LocationSet providesLocations(ReportSet reportSet) {
        return reportSet.getLocations();
    }

    @Provides
    ReportSetPreference<ChosenUsers> provideChosenUsers() {
        return ReportSetPreference.staticValue(new ChosenUsers());
    }
}

