/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.fonts;

import com.formdev.flatlaf.util.UIScale;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.scythebill.birdlist.ui.fonts.FontPreferences;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.text.JTextComponent;

@Singleton
public class FontManager {
    public static final String TEXT_SIZE_PROPERTY = "birdlist.textSize";
    public static final String PLAIN_LABEL = "birdlist.plainLabel";
    public static final String BUTTON_SIZE_PROPERTY = "birdlist.buttonSize";
    public static final Object BUTTON_TYPE = "birdlist.buttonType";
    private static final int[] fontSizes = new int[]{9, 10, 11, 12, 13, 15, 18};
    private final List<FontsUpdatedListener> listeners = Lists.newCopyOnWriteArrayList();
    private FontPreferences preferences;
    private int defaultFontSize;
    private String fontName;
    private float fontMultiplier;

    @Inject
    public FontManager(FontPreferences preferences) {
        this.preferences = preferences;
        preferences.fontSize = Math.max(preferences.fontSize, fontSizes[0]);
        preferences.fontSize = Math.min(preferences.fontSize, fontSizes[fontSizes.length - 1]);
        Font font = UIManager.getFont("defaultFont");
        this.fontName = font == null ? "SansSerif" : font.getName();
        this.defaultFontSize = FontManager.defaultFontSize();
        this.fontMultiplier = font == null ? 1.0f : font.getSize2D() / (float)this.defaultFontSize;
        UIManager.put("defaultFont", this.getTextFont());
    }

    public void addListener(FontsUpdatedListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(FontsUpdatedListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementFontSize() {
        boolean changed = false;
        FontManager fontManager = this;
        synchronized (fontManager) {
            for (int i = 0; i < fontSizes.length; ++i) {
                if (fontSizes[i] <= this.preferences.fontSize) continue;
                this.preferences.fontSize = fontSizes[i];
                changed = true;
                break;
            }
        }
        if (changed) {
            this.fontUpdated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementFontSize() {
        boolean changed = false;
        FontManager fontManager = this;
        synchronized (fontManager) {
            for (int i = fontSizes.length - 1; i >= 0; --i) {
                if (fontSizes[i] >= this.preferences.fontSize) continue;
                this.preferences.fontSize = fontSizes[i];
                changed = true;
                break;
            }
        }
        if (changed) {
            this.fontUpdated();
        }
    }

    private void fontUpdated() {
        UIManager.put("defaultFont", this.getTextFont());
        UIManager.put("TableHeader.font", this.getTableFont());
        UIManager.put("Table.font", this.getTableFont());
        this.notifyListeners();
    }

    private Font newFont(int style, int size) {
        return new Font(this.fontName, style, Math.max(Math.round(this.fontMultiplier * (float)size), 1));
    }

    public Font getTextFont() {
        return this.newFont(0, this.preferences.fontSize);
    }

    public Font getLabelFont() {
        return this.newFont(1, this.preferences.fontSize);
    }

    public Font getLargeLabelFont() {
        return this.newFont(1, this.preferences.fontSize + 2);
    }

    public Font getVeryLargeLabelFont() {
        return this.newFont(1, this.preferences.fontSize + 5);
    }

    public Font getSmallButtonFont() {
        return this.newFont(0, this.preferences.fontSize);
    }

    public Font getMediumButtonFont() {
        return this.newFont(0, this.preferences.fontSize + 2);
    }

    public Font getMediumBoldButtonFont() {
        return this.getMediumButtonFont();
    }

    public Font getLargeButtonFont() {
        return this.newFont(0, this.preferences.fontSize + 5).deriveFont(1);
    }

    public Font getLargeTextFont() {
        return this.newFont(0, this.preferences.fontSize + 2);
    }

    public Font getVeryLargeTextFont() {
        return this.newFont(0, this.preferences.fontSize + 5);
    }

    public int scale(int size) {
        return UIScale.scale((int)((double)size * (double)this.preferences.fontSize / (double)this.defaultFontSize));
    }

    public Dimension scale(Dimension dimension) {
        return new Dimension(this.scale(dimension.width), this.scale(dimension.height));
    }

    public void applyTo(Component component) {
        Container container;
        TextSize textSize;
        if (component instanceof FontsUpdatedListener) {
            ((FontsUpdatedListener)((Object)component)).fontsUpdated(this);
        }
        if (component instanceof JComponent) {
            textSize = (TextSize)((Object)((JComponent)component).getClientProperty(TEXT_SIZE_PROPERTY));
            if (textSize == null) {
                textSize = TextSize.NORMAL;
            }
        } else {
            textSize = TextSize.NORMAL;
        }
        if (component instanceof JTextComponent || component instanceof JComboBox || component instanceof JCheckBox || component instanceof JRadioButton) {
            switch (textSize) {
                case NORMAL: {
                    component.setFont(this.getTextFont());
                    break;
                }
                case LARGE: {
                    component.setFont(this.getLargeTextFont());
                    break;
                }
                case VERY_LARGE: {
                    component.setFont(this.getVeryLargeTextFont());
                }
            }
        } else if (component instanceof JLabel) {
            if (Boolean.TRUE.equals(((JLabel)component).getClientProperty(PLAIN_LABEL))) {
                switch (textSize) {
                    case NORMAL: {
                        component.setFont(this.getTextFont());
                        break;
                    }
                    case LARGE: {
                        component.setFont(this.getLargeTextFont());
                        break;
                    }
                    case VERY_LARGE: {
                        component.setFont(this.getVeryLargeTextFont());
                    }
                }
            } else {
                switch (textSize) {
                    case NORMAL: {
                        component.setFont(this.getLabelFont());
                        break;
                    }
                    case LARGE: {
                        component.setFont(this.getLargeLabelFont());
                        break;
                    }
                    case VERY_LARGE: {
                        component.setFont(this.getVeryLargeLabelFont());
                    }
                }
            }
        } else if (component instanceof JButton) {
            ButtonSize buttonSize = (ButtonSize)((Object)((JButton)component).getClientProperty(BUTTON_SIZE_PROPERTY));
            if (buttonSize == null) {
                buttonSize = ButtonSize.SMALL;
            }
            switch (buttonSize) {
                case SMALL: {
                    component.setFont(this.getSmallButtonFont());
                    break;
                }
                case MEDIUM: {
                    component.setFont(this.getMediumButtonFont());
                    break;
                }
                case MEDIUM_BOLD: {
                    component.setFont(this.getMediumBoldButtonFont());
                    break;
                }
                case LARGE: {
                    component.setFont(this.getLargeButtonFont());
                }
            }
        } else if (component instanceof JTableHeader || component instanceof JTable || component instanceof JTree || component instanceof JList) {
            component.setFont(this.getTableFont());
        }
        if (component instanceof Container && (container = (Container)component).getComponentCount() > 0) {
            for (Component child : container.getComponents()) {
                this.applyTo(child);
            }
        }
    }

    public Font getTableFont() {
        return this.getTextFont();
    }

    boolean sizeIsAtMaximum() {
        return this.preferences.fontSize >= fontSizes[fontSizes.length - 1];
    }

    boolean sizeIsAtMinimum() {
        return this.preferences.fontSize <= fontSizes[0];
    }

    private void notifyListeners() {
        for (FontsUpdatedListener listener : this.listeners) {
            listener.fontsUpdated(this);
        }
    }

    public static String getFontName() {
        Font font = UIManager.getFont("defaultFont");
        return font == null ? "SansSerif" : font.getName();
    }

    public static int defaultFontSize() {
        return 11;
    }

    public static interface FontsUpdatedListener {
        public void fontsUpdated(FontManager var1);
    }

    public static enum TextSize {
        NORMAL,
        LARGE,
        VERY_LARGE;

    }

    public static enum ButtonSize {
        SMALL,
        MEDIUM,
        MEDIUM_BOLD,
        LARGE;

    }

    public static enum ButtonType {
        MENU;

    }
}

