/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.events;

import com.google.common.eventbus.EventBus;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.taxa.MappedTaxonomy;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.events.TaxonomyChangedEvent;
import com.scythebill.birdlist.ui.events.TaxonomyPreferences;
import com.scythebill.birdlist.ui.guice.Clements;
import com.scythebill.birdlist.ui.guice.IOC;
import com.scythebill.birdlist.ui.prefs.ReportSetPreference;

@Singleton
public class TaxonomyStore {
    private final EventBus eventBus;
    private volatile Taxonomy taxonomy;
    private final TaxonomyPreferences taxonomyPreferences;
    private final Taxonomy clements;
    private final ReportSetPreference<TaxonomyPreferences.PerReportSet> perReportSetPreferences;
    private MappedTaxonomy ioc;
    private Taxonomy rememberedTaxonomy;

    @Inject
    public TaxonomyStore(EventBus eventBus, @Clements Taxonomy clements, @IOC MappedTaxonomy ioc, TaxonomyPreferences taxonomyPreferences, ReportSet reportSet, ReportSetPreference<TaxonomyPreferences.PerReportSet> perReportSetPreferences) {
        this.eventBus = eventBus;
        this.clements = clements;
        this.ioc = ioc;
        this.taxonomyPreferences = taxonomyPreferences;
        this.perReportSetPreferences = perReportSetPreferences;
        String taxonomyId = perReportSetPreferences.get().lastTaxonomyId();
        this.taxonomy = taxonomyId != null && reportSet.getExtendedTaxonomy(taxonomyId) != null ? reportSet.getExtendedTaxonomy(taxonomyId) : (taxonomyPreferences.taxonomyType == TaxonomyPreferences.TaxonomyType.clements ? clements : ioc);
        this.updatePerReportSetPreferences();
    }

    public void setTaxonomy(Taxonomy taxonomy) {
        if (this.taxonomy != taxonomy) {
            this.taxonomy = taxonomy;
            this.eventBus.post(new TaxonomyChangedEvent(taxonomy));
            if (taxonomy == this.clements || taxonomy == this.ioc) {
                this.taxonomyPreferences.taxonomyType = taxonomy == this.clements ? TaxonomyPreferences.TaxonomyType.clements : TaxonomyPreferences.TaxonomyType.ioc;
            }
            this.updatePerReportSetPreferences();
        }
    }

    void updatePerReportSetPreferences() {
        this.perReportSetPreferences.get().updateForLatestTaxonomy(this.taxonomy);
        this.perReportSetPreferences.save(false);
    }

    public Taxonomy getTaxonomy() {
        return this.taxonomy;
    }

    public Taxonomy getClements() {
        return this.clements;
    }

    public Taxonomy getIoc() {
        return this.ioc;
    }

    public boolean isBirdTaxonomy() {
        return this.taxonomy == this.clements || this.taxonomy == this.ioc;
    }

    public TaxonomyStore switchToPreferredBirdTaxonomy() {
        if (!this.isBirdTaxonomy()) {
            this.setTaxonomy(this.taxonomyPreferences.taxonomyType == TaxonomyPreferences.TaxonomyType.clements ? this.clements : this.ioc);
        }
        return this;
    }

    public void rememberCurrentTaxonomy() {
        this.rememberedTaxonomy = this.taxonomy;
    }

    public Taxonomy restoreRememberedTaxonomy() {
        if (this.rememberedTaxonomy == null) {
            return null;
        }
        if (this.taxonomy == this.rememberedTaxonomy) {
            this.rememberedTaxonomy = null;
            return null;
        }
        this.setTaxonomy(this.rememberedTaxonomy);
        this.rememberedTaxonomy = null;
        return this.taxonomy;
    }

    public void extendedTaxonomiesChanged() {
        this.eventBus.post(new TaxonomyChangedEvent(this.taxonomy));
    }

    public void extendedTaxonomyRemoved() {
        this.switchToPreferredBirdTaxonomy();
    }
}

