/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.events;

import com.scythebill.birdlist.model.annotations.Preference;
import com.scythebill.birdlist.model.annotations.SerializeAsJson;
import com.scythebill.birdlist.model.taxa.MappedTaxonomy;
import com.scythebill.birdlist.model.taxa.Taxonomy;

public class TaxonomyPreferences {
    @Preference
    TaxonomyType taxonomyType = TaxonomyType.clements;

    public static enum TaxonomyType {
        clements,
        ioc;

    }

    @SerializeAsJson
    public static class PerReportSet {
        private String lastTaxonomyId;
        private String lastIocVersion;

        public void updateForLatestTaxonomy(Taxonomy taxonomy) {
            this.lastTaxonomyId = taxonomy.getId();
            if (taxonomy.isBuiltIn() && taxonomy.getId().startsWith("ioc")) {
                this.lastIocVersion = taxonomy.getId();
            }
        }

        public String lastTaxonomyId() {
            return this.lastTaxonomyId;
        }

        public String lastIocVersion() {
            return this.lastIocVersion;
        }

        public void setLastIocVersion(MappedTaxonomy iocTaxonomy) {
            this.lastIocVersion = iocTaxonomy.getId();
        }
    }
}

