/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.events;

import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.SubscriberExceptionContext;
import com.google.common.eventbus.SubscriberExceptionHandler;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.scythebill.birdlist.ui.events.DefaultUserStore;
import com.scythebill.birdlist.ui.events.TaxonomyPreferences;
import com.scythebill.birdlist.ui.events.TaxonomyStore;
import com.scythebill.birdlist.ui.events.UserPreferences;
import com.scythebill.birdlist.ui.prefs.PreferencesManager;
import com.scythebill.birdlist.ui.prefs.ReportSetPreferencesModule;
import com.scythebill.birdlist.ui.util.Alerts;
import javax.swing.SwingUtilities;

public class EventsModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.bind(TaxonomyStore.class);
        this.bind(DefaultUserStore.class);
        this.install(ReportSetPreferencesModule.forType(TaxonomyPreferences.PerReportSet.class));
        this.install(ReportSetPreferencesModule.forType(UserPreferences.PerReportSet.class));
    }

    @Provides
    @Singleton
    EventBus provideEventBus(final Alerts alerts) {
        return new AsyncEventBus(SwingUtilities::invokeLater, new SubscriberExceptionHandler(){

            @Override
            public void handleException(Throwable exception, SubscriberExceptionContext context) {
                alerts.reportError(exception);
            }
        });
    }

    @Provides
    public TaxonomyPreferences provideTaxonomyPreferences(PreferencesManager manager) {
        return manager.getPreference(TaxonomyPreferences.class);
    }
}

