/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.events;

import com.google.common.base.Strings;
import com.google.common.eventbus.EventBus;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.user.User;
import com.scythebill.birdlist.ui.events.DefaultUserChangedEvent;
import com.scythebill.birdlist.ui.events.UserPreferences;
import com.scythebill.birdlist.ui.prefs.ReportSetPreference;
import com.scythebill.birdlist.ui.uptodate.UpToDatePreferences;

@Singleton
public class DefaultUserStore {
    private final EventBus eventBus;
    private final ReportSetPreference<UserPreferences.PerReportSet> perReportSetPreferences;
    private volatile User user;
    private final UpToDatePreferences upToDatePreferences;
    private final ReportSet reportSet;

    @Inject
    public DefaultUserStore(EventBus eventBus, ReportSet reportSet, ReportSetPreference<UserPreferences.PerReportSet> perReportSetPreferences, UpToDatePreferences upToDatePreferences) {
        this.eventBus = eventBus;
        this.reportSet = reportSet;
        this.perReportSetPreferences = perReportSetPreferences;
        this.upToDatePreferences = upToDatePreferences;
        String userId = perReportSetPreferences.get().userId;
        if (!Strings.isNullOrEmpty(userId) && reportSet.getUserSet() != null) {
            try {
                this.user = reportSet.getUserSet().userById(userId);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public void setUser(User user) {
        if (this.user != user) {
            this.user = user;
            this.upToDatePreferences.multipleUsers = this.reportSet.getUserSet() != null;
            this.eventBus.post(new DefaultUserChangedEvent(user));
            this.updatePerReportSetPreferences();
        }
    }

    void updatePerReportSetPreferences() {
        this.perReportSetPreferences.get().userId = this.user == null ? null : this.user.id();
        this.perReportSetPreferences.save(false);
    }

    public User getUser() {
        return this.user;
    }

    public void userSetChanged() {
        this.upToDatePreferences.multipleUsers = this.reportSet.getUserSet() != null;
        this.eventBus.post(new DefaultUserChangedEvent(this.user));
    }
}

