/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.datatransfer;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.VisitInfo;
import com.scythebill.birdlist.model.sighting.VisitInfoKey;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.tree.TreePath;

public class SightingsGroup {
    public static final DataFlavor FLAVOR = new DataFlavor(SightingsGroup.class, "Sighting");
    private final ImmutableList<Sighting> sightings;
    private final TreePath commonParent;
    private final Taxon sourceTaxon;
    private final ImmutableList<Integer> originalIndices;
    private final ImmutableMap<VisitInfoKey, VisitInfo> visitInfoMap;

    public static SightingsGroup fromTransferable(Transferable data) {
        try {
            return (SightingsGroup)data.getTransferData(FLAVOR);
        }
        catch (UnsupportedFlavorException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public SightingsGroup(ImmutableList<Sighting> sightings, ImmutableMap<VisitInfoKey, VisitInfo> visitInfoMap, ImmutableList<Integer> originalIndices, TreePath commonParent) {
        this.sightings = sightings;
        this.visitInfoMap = visitInfoMap;
        this.originalIndices = originalIndices;
        this.commonParent = commonParent;
        this.sourceTaxon = commonParent.getLastPathComponent() instanceof Taxon ? (Taxon)commonParent.getLastPathComponent() : null;
    }

    public ImmutableList<Sighting.Builder> sightingBuilders() {
        ImmutableList.Builder sightingBuilders = ImmutableList.builder();
        for (Sighting sighting : this.sightings) {
            sightingBuilders.add(sighting.asBuilder());
        }
        return sightingBuilders.build();
    }

    public ImmutableList<Sighting> getSightings() {
        return this.sightings;
    }

    public ImmutableMap<VisitInfoKey, VisitInfo> getVisitInfoMap() {
        return this.visitInfoMap;
    }

    public ImmutableList<Integer> getOriginalIndices() {
        return this.originalIndices;
    }

    public TreePath getParentPath() {
        return this.commonParent;
    }

    public Taxon getSourceTaxon() {
        return this.sourceTaxon;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("sightings", this.sightings).add("visitInfo", this.visitInfoMap).add("parentPath", this.commonParent).add("sourceTaxon", this.sourceTaxon == null ? "null" : TaxonUtils.getCommonName(this.sourceTaxon)).toString();
    }
}

