/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.datatransfer;

import com.scythebill.birdlist.ui.datatransfer.SightingsGroup;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;

public class SightingTransferable
implements Transferable {
    private final SightingsGroup sightings;
    private final Transferable additional;

    public SightingTransferable(SightingsGroup sightings, @Nullable Transferable additional) {
        this.sightings = sightings;
        this.additional = additional;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (SightingsGroup.FLAVOR.equals(flavor)) {
            return this.sightings;
        }
        if (this.additional != null) {
            return this.additional.getTransferData(flavor);
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        if (this.additional == null) {
            return new DataFlavor[]{SightingsGroup.FLAVOR};
        }
        ArrayList<DataFlavor> flavors = new ArrayList<DataFlavor>();
        flavors.add(SightingsGroup.FLAVOR);
        flavors.addAll(Arrays.asList(this.additional.getTransferDataFlavors()));
        return flavors.toArray(new DataFlavor[0]);
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        if (SightingsGroup.FLAVOR.equals(flavor)) {
            return true;
        }
        if (this.additional == null) {
            return false;
        }
        return this.additional.isDataFlavorSupported(flavor);
    }
}

