/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.components.table;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.scythebill.birdlist.ui.components.table.TableRowsModel;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SomeRowsTableRowsModel
implements TableRowsModel {
    private Set<Integer> rows = Sets.newHashSet();
    private final List<TableRowsModel.Listener> listeners = Lists.newArrayList();

    @Override
    public boolean isIncluded(int row) {
        return this.rows.contains(row);
    }

    @Override
    public void intervalAdded(int rowStart, int rowEndInclusive) {
        HashSet<Integer> newRows = Sets.newHashSet();
        int rowCount = rowEndInclusive - rowStart + 1;
        for (int row : this.rows) {
            if (row < rowStart) {
                newRows.add(row);
                continue;
            }
            newRows.add(row + rowCount);
        }
        this.rows = newRows;
    }

    @Override
    public boolean intervalRemoved(int rowStart, int rowEndInclusive) {
        HashSet<Integer> newRows = Sets.newHashSet();
        int rowCount = rowEndInclusive - rowStart + 1;
        boolean foundAny = false;
        for (int row : this.rows) {
            if (row < rowStart) {
                newRows.add(row);
                continue;
            }
            if (row <= rowEndInclusive) {
                foundAny = true;
                continue;
            }
            newRows.add(row - rowCount);
        }
        this.rows = newRows;
        return foundAny;
    }

    @Override
    public void addListener(TableRowsModel.Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void includeRow(int row) {
        if (this.rows.add(row)) {
            for (TableRowsModel.Listener listener : this.listeners) {
                listener.rowIncluded(row);
            }
        }
    }

    @Override
    public void removeRow(int row) {
        if (this.rows.remove(row)) {
            for (TableRowsModel.Listener listener : this.listeners) {
                listener.rowRemoved(row);
            }
        }
    }
}

