/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.components.table;

import com.scythebill.birdlist.ui.components.table.ExpandableTable;
import java.awt.Component;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class LabelColumn<T>
implements ExpandableTable.Column<T> {
    private ExpandableTable.ColumnLayout width;
    private final String name;

    public LabelColumn(ExpandableTable.ColumnLayout width, String name) {
        this.width = width;
        this.name = name;
    }

    @Override
    public JComponent createComponent(T value, Set<ExpandableTable.RowState> states) {
        JLabel label = new JLabel(){

            @Override
            protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
                if (!"parent".equals(propertyName) && !"ancestor".equals(propertyName)) {
                    super.firePropertyChange(propertyName, oldValue, newValue);
                }
            }
        };
        label.setOpaque(false);
        label.setFocusable(false);
        label.setBorder(new EmptyBorder(0, 3, 0, 0));
        label.putClientProperty("birdlist.plainLabel", true);
        this.updateComponentValue(label, value);
        this.updateComponentState(label, value, states);
        return label;
    }

    @Override
    public final ExpandableTable.ColumnLayout getWidth() {
        return this.width;
    }

    @Override
    public boolean sizeComponentsToFit() {
        return false;
    }

    protected String getText(T value) {
        return value == null ? "" : value.toString();
    }

    @Override
    public void updateComponentValue(Component component, T value) {
        ((JLabel)component).setText(this.getText(value));
    }

    @Override
    public void updateComponentState(Component component, T value, Set<ExpandableTable.RowState> states) {
        component.setForeground(UIManager.getColor(states.contains((Object)ExpandableTable.RowState.SELECTED) ? "Table.selectionForeground" : "Table.foreground"));
    }

    @Override
    public final String getName() {
        return this.name;
    }
}

