/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.components.table;

import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.util.ColorFunctions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.scythebill.birdlist.ui.components.table.AllRowsTableRowsModel;
import com.scythebill.birdlist.ui.components.table.DelayedUI;
import com.scythebill.birdlist.ui.components.table.ExpandColumn;
import com.scythebill.birdlist.ui.components.table.TableRowsModel;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.util.FocusTracker;
import com.scythebill.birdlist.ui.util.UIUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.ContainerOrderFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.FocusManager;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class ExpandableTable<T>
extends JComponent
implements Scrollable {
    public static final int NO_ROW = -1;
    private static final int EXPANDED_ROW_INDENT = 35;
    private ListModel<T> model;
    private int lineHeight = 20;
    private int visibleRowCount = 10;
    private boolean componentsCreated = false;
    private boolean showVerticalGridLines = false;
    private final List<Column<T>> columns = Lists.newArrayList();
    private final ListDataListener dataListener = new ModelEvents();
    private final MouseListener mouseListener = new MouseEvents();
    private final KeyListener keyListener = new KeyEvents();
    private int selectedIndex = -1;
    private int[] columnWidths;
    private int expandedIndex = -1;
    private DetailView<T> expandedRowView;
    private JComponent expandedRowComponent;
    private final Class<T> type;
    private JTableHeader tableHeader;
    private boolean hasExpandColumn;
    private FontManager fontManager;
    private TableRowsModel enabledRowsModel;
    private boolean highlightEnabledRows;
    private final JButton focusStartHoneypot = new JButton("");
    private final JButton focusEndHoneypot = new JButton("");
    private Component focusableComponentAfterTable;
    private Component focusableComponentBeforeTable;
    private Color alternateBackground;
    private static final Set<RowState> STATE_NONE = ImmutableSet.of();
    private static final Set<RowState> STATE_SELECTED = ImmutableSet.of(RowState.SELECTED);
    private static final Set<RowState> STATE_EXPANDED = ImmutableSet.of(RowState.EXPANDED);
    private static final Set<RowState> STATE_SELECTED_AND_EXPANDED = ImmutableSet.of(RowState.SELECTED, RowState.EXPANDED);
    private static final Set<RowState> STATE_ENABLED = ImmutableSet.of(RowState.ENABLED);
    private static final Set<RowState> STATE_ENABLED_SELECTED = ImmutableSet.of(RowState.ENABLED, RowState.SELECTED);
    private static final Set<RowState> STATE_ENABLED_EXPANDED = ImmutableSet.of(RowState.ENABLED, RowState.EXPANDED);
    private static final Set<RowState> STATE_ENABLED_SELECTED_AND_EXPANDED = ImmutableSet.of(RowState.ENABLED, RowState.SELECTED, RowState.EXPANDED);

    public ExpandableTable(Class<T> type, FontManager fontManager) {
        this.type = type;
        this.fontManager = fontManager;
        this.enabledRowsModel = new AllRowsTableRowsModel();
        this.setLayout(new LayoutImpl());
        this.addMouseListener(this.mouseListener);
        this.addKeyListener(this.keyListener);
        this.setFocusable(true);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new ExpandableTableFocusTraversalPolicy());
        new TableFocusTracker();
        this.updateColors();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.updateColors();
        if (this.tableHeader != null) {
            this.tableHeader.getTable().updateUI();
            this.tableHeader.updateUI();
        }
    }

    private void updateColors() {
        Color background = UIManager.getColor("Table.background");
        this.setBackground(background);
        this.setForeground(UIManager.getColor("Table.foreground"));
        this.alternateBackground = FlatLaf.isLafDark() ? ColorFunctions.lighten(background, 0.05f) : ColorFunctions.darken(background, 0.05f);
    }

    public TableRowsModel getEnabledRowsModel() {
        return this.enabledRowsModel;
    }

    public void setEnabledRowsModel(TableRowsModel rowsModel) {
        this.enabledRowsModel = rowsModel;
        rowsModel.addListener(new TableRowsModel.Listener(){

            @Override
            public void rowRemoved(int row) {
                if (ExpandableTable.this.getExpandedIndex() == row) {
                    ExpandableTable.this.setExpandedIndex(-1);
                } else {
                    ExpandableTable.this.updateRowState(row);
                }
            }

            @Override
            public void rowIncluded(int row) {
                ExpandableTable.this.updateRowState(row);
            }
        });
    }

    public void addColumn(Column<T> column) {
        if (column instanceof ExpandColumn) {
            this.hasExpandColumn = true;
        }
        this.columns.add(column);
        if (this.tableHeader != null) {
            this.addHeaderColumn(column);
        }
    }

    public void setModel(ListModel<T> model) {
        if (this.model != null) {
            this.model.removeListDataListener(this.dataListener);
        }
        this.model = model;
        if (model != null) {
            model.addListDataListener(this.dataListener);
        }
        this.componentsCreated = false;
        this.removeAll();
        this.setSelectedIndex(-1);
        this.revalidate();
    }

    public ListModel<T> getModel() {
        return this.model;
    }

    public JTableHeader getColumnHeader() {
        if (this.tableHeader == null) {
            this.tableHeader = new JTableHeader();
            JTable dummyTable = new JTable();
            this.tableHeader.setTable(dummyTable);
            this.tableHeader.setResizingAllowed(false);
            this.tableHeader.setReorderingAllowed(false);
            for (Column<T> column : this.columns) {
                this.addHeaderColumn(column);
            }
        }
        return this.tableHeader;
    }

    private void addHeaderColumn(Column<?> column) {
        TableColumn headerColumn = new TableColumn();
        headerColumn.setHeaderValue(column.getName());
        headerColumn.setHeaderRenderer(new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = ExpandableTable.this.tableHeader.getDefaultRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                c.setFont(ExpandableTable.this.fontManager.getTableFont());
                return c;
            }
        });
        this.tableHeader.getColumnModel().addColumn(headerColumn);
    }

    public int getLineHeight() {
        return this.lineHeight;
    }

    public void setLineHeight(int lineHeight) {
        this.lineHeight = lineHeight;
        this.revalidate();
    }

    public int getVisibleRowCount() {
        return this.visibleRowCount;
    }

    public void setVisibleRowCount(int visibleRowCount) {
        this.visibleRowCount = visibleRowCount;
        this.revalidate();
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int selectedIndex) {
        this.setSelectedIndex(selectedIndex, true, true);
    }

    public void setSelectedIndexWithVisibleContext(int selectedIndex) {
        this.setSelectedIndex(selectedIndex, true, false);
        int startRow = Math.max(0, selectedIndex - this.getContextRows());
        int endRow = Math.min(this.getModel().getSize() - 1, selectedIndex + this.getContextRows());
        this.scrollRectToVisible(this.getRowBounds(startRow, endRow));
    }

    private void setSelectedIndex(int selectedIndex, boolean updateRowState, boolean scrollToVisible) {
        if (this.selectedIndex == selectedIndex) {
            return;
        }
        if (this.selectedIndex != -1) {
            this.repaint(this.getRowBounds(this.selectedIndex));
            if (updateRowState) {
                Sets.SetView<RowState> rowState = Sets.difference(this.getRowState(this.selectedIndex), STATE_SELECTED);
                this.updateRowState(this.selectedIndex, rowState);
            }
        }
        int oldSelectedIndex = this.selectedIndex;
        this.selectedIndex = selectedIndex;
        if (selectedIndex != -1) {
            Rectangle rowBounds = this.getRowBounds(selectedIndex);
            this.repaint(rowBounds);
            if (scrollToVisible) {
                this.scrollRectToVisible(rowBounds);
            }
            if (updateRowState) {
                this.updateRowState(selectedIndex);
            }
        }
        this.firePropertyChange("selectedIndex", oldSelectedIndex, selectedIndex);
    }

    public Object getSelectedValue() {
        if (this.selectedIndex == -1) {
            return null;
        }
        return this.model.getElementAt(this.selectedIndex);
    }

    public int getExpandedIndex() {
        return this.expandedIndex;
    }

    public void setExpandedIndex(int expandedIndex) {
        this.setExpandedIndex(expandedIndex, true);
    }

    private void setExpandedIndex(int expandedIndex, boolean updateRowState) {
        if (this.expandedIndex == expandedIndex) {
            return;
        }
        if (this.expandedIndex != -1) {
            this.expandedRowView.onClose(this.expandedRowComponent);
            Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (focusOwner != null && SwingUtilities.isDescendingFrom(focusOwner, this.expandedRowComponent)) {
                SwingUtilities.invokeLater(this::requestFocusInWindow);
            }
            if (updateRowState) {
                Sets.SetView<RowState> rowState = Sets.difference(this.getRowState(this.expandedIndex), STATE_EXPANDED);
                this.updateRowState(this.expandedIndex, rowState);
            }
            this.remove(this.expandedRowComponent);
            this.expandedRowComponent = null;
        }
        int oldExpandedIndex = this.expandedIndex;
        this.expandedIndex = expandedIndex;
        if (expandedIndex != -1) {
            this.expandedRowComponent = Preconditions.checkNotNull(this.expandedRowView.createComponent(this.type.cast(this.model.getElementAt(expandedIndex))));
            int mask = UIUtils.isMacOS() ? 768 : 576;
            KeyStroke nextExpandedRowKeyStroke = KeyStroke.getKeyStroke(40, mask);
            Object nextExpandedRowKey = new Object();
            this.expandedRowComponent.getInputMap(1).put(nextExpandedRowKeyStroke, nextExpandedRowKey);
            this.expandedRowComponent.getActionMap().put(nextExpandedRowKey, new MoveToNextExpandedRow(true));
            KeyStroke previousExpandedRowKeyStroke = KeyStroke.getKeyStroke(38, mask);
            Object previousExpandedRowKey = new Object();
            this.expandedRowComponent.getInputMap(1).put(previousExpandedRowKeyStroke, previousExpandedRowKey);
            this.expandedRowComponent.getActionMap().put(previousExpandedRowKey, new MoveToNextExpandedRow(false));
            this.expandedRowComponent.setBorder(new CompoundBorder(BorderFactory.createLoweredBevelBorder(), new EmptyBorder(2, 37, 2, 2)));
            this.add((Component)this.expandedRowComponent, 1);
            if (updateRowState) {
                this.updateRowState(expandedIndex);
            }
        }
        int topOfOldAndNewIndices = oldExpandedIndex == -1 || expandedIndex < oldExpandedIndex ? expandedIndex : oldExpandedIndex;
        this.repaintStartingAt(topOfOldAndNewIndices);
        if (expandedIndex != -1) {
            this.scrollRectToVisible(this.getExpandedRowBounds());
        }
    }

    public boolean isShowVerticalGridLines() {
        return this.showVerticalGridLines;
    }

    public void setShowVerticalGridLines(boolean showVerticalGridLines) {
        if (showVerticalGridLines != this.showVerticalGridLines) {
            this.showVerticalGridLines = showVerticalGridLines;
            this.revalidate();
        }
    }

    public boolean isHighlightEnabledRows() {
        return this.highlightEnabledRows;
    }

    public void setHighlightEnabledRows(boolean highlightEnabledRows) {
        this.highlightEnabledRows = highlightEnabledRows;
    }

    public void setExpandedRowView(DetailView<T> expandedRowView) {
        if (this.expandedRowView != null && this.expandedRowComponent != null) {
            this.setExpandedIndex(-1);
        }
        this.expandedRowView = expandedRowView;
    }

    public DetailView<T> getExpandedRowView() {
        return this.expandedRowView;
    }

    public void focusOnExpandedIndex() {
        if (this.expandedRowComponent != null) {
            this.expandedRowComponent.transferFocus();
        } else {
            this.requestFocusInWindow();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        Rectangle rowBounds;
        Rectangle clipBounds = g.getClipBounds();
        int row = this.getBoundedRow(clipBounds.y);
        while ((rowBounds = this.getRowBounds(row)).intersects(clipBounds)) {
            Color color = null;
            if (row == this.selectedIndex) {
                color = UIManager.getColor("Table.selectionBackground");
            } else {
                boolean useAlternateBackground;
                if (this.isHighlightEnabledRows()) {
                    useAlternateBackground = this.getEnabledRowsModel().isIncluded(row);
                } else {
                    boolean bl = useAlternateBackground = row % 2 != 0;
                }
                if (useAlternateBackground) {
                    color = this.alternateBackground;
                }
            }
            if (color == null) {
                color = UIManager.getColor("Table.background");
            }
            g.setColor(color);
            g.fillRect(rowBounds.x, rowBounds.y, rowBounds.width, rowBounds.height);
            ++row;
        }
        if (this.showVerticalGridLines && this.columnWidths != null) {
            Rectangle expandedRowBounds = this.getExpandedRowBounds();
            g.setColor(UIManager.getColor("Table.gridColor"));
            int gridX = 0;
            for (int columnWidth : this.columnWidths) {
                if (gridX != 0) {
                    if (expandedRowBounds == null || !clipBounds.intersects(expandedRowBounds)) {
                        g.drawLine(gridX, clipBounds.y, gridX, clipBounds.y + clipBounds.height);
                    } else {
                        g.drawLine(gridX, clipBounds.y, gridX, expandedRowBounds.y);
                        g.drawLine(gridX, expandedRowBounds.y + expandedRowBounds.height, gridX, clipBounds.y + clipBounds.height);
                    }
                }
                gridX += columnWidth + 1;
            }
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(200, this.visibleRowCount * this.lineHeight);
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 0) {
            return visibleRect.width;
        }
        return visibleRect.height;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return this.getParent() instanceof JViewport && this.getPreferredSize().height < this.getParent().getHeight();
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 0) {
            return 1;
        }
        return this.lineHeight;
    }

    private int getVerticalBlockIncrement() {
        if (!(this.getParent() instanceof JViewport)) {
            return 1;
        }
        JViewport viewport = (JViewport)this.getParent();
        return viewport.getSize().height / this.lineHeight;
    }

    private void repaintStartingAt(int row) {
        this.revalidate();
        Rectangle bounds = this.getRowBounds(row);
        bounds.height = this.getHeight() - bounds.y;
        this.repaint(bounds);
    }

    private Rectangle getRowBounds(int row) {
        int y = this.getRowY(row);
        return new Rectangle(0, y, this.getWidth(), this.lineHeight);
    }

    private int getRowY(int row) {
        int y = this.lineHeight * row;
        if (this.expandedIndex != -1 && row > this.expandedIndex) {
            y += this.expandedRowView.getHeight();
        }
        return y;
    }

    private Rectangle getRowBounds(int startRow, int endRow) {
        int startY = this.getRowY(startRow);
        int endY = this.getRowY(endRow) + this.lineHeight;
        return new Rectangle(0, startY, this.getWidth(), endY - startY);
    }

    private Rectangle getExpandedRowBounds() {
        if (this.expandedIndex == -1) {
            return null;
        }
        return new Rectangle(0, this.lineHeight * (this.expandedIndex + 1), this.getWidth(), this.expandedRowView.getHeight());
    }

    private int getBoundedRow(int y) {
        int row;
        Rectangle expandedRowBounds = this.getExpandedRowBounds();
        if (expandedRowBounds != null && y >= expandedRowBounds.y) {
            if (y < expandedRowBounds.y + expandedRowBounds.height) {
                return this.expandedIndex;
            }
            y -= expandedRowBounds.height;
        }
        row = (row = y / this.lineHeight) < 0 ? 0 : Math.min(row, this.model.getSize() - 1);
        return row;
    }

    public int getRow(int y) {
        int row;
        Rectangle expandedRowBounds = this.getExpandedRowBounds();
        if (expandedRowBounds != null && y >= expandedRowBounds.y) {
            if (y < expandedRowBounds.y + expandedRowBounds.height) {
                return this.getExpandedIndex();
            }
            y -= expandedRowBounds.height;
        }
        if ((row = y / this.lineHeight) < 0) {
            return -1;
        }
        if (row >= this.model.getSize()) {
            return -1;
        }
        return row;
    }

    public void forceComponentCreation() {
        this.createComponents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createComponents() {
        if (this.componentsCreated) {
            return;
        }
        this.componentsCreated = true;
        DelayedUI.instance().enableDelay();
        try {
            this.removeAll();
            this.add(this.focusStartHoneypot);
            if (this.expandedRowComponent != null) {
                this.add(this.expandedRowComponent);
                this.fontManager.applyTo(this.expandedRowComponent);
            }
            if (this.model != null) {
                int modelSize = this.model.getSize();
                for (int row = 0; row < modelSize; ++row) {
                    T value = this.type.cast(this.model.getElementAt(row));
                    Set<RowState> rowState = this.getRowState(row);
                    for (Column<T> column : this.columns) {
                        JComponent created = column.createComponent(value, rowState);
                        this.fontManager.applyTo(created);
                        this.add(created);
                    }
                }
                this.add(this.focusEndHoneypot);
            }
        }
        finally {
            DelayedUI.instance().liftDelay();
        }
    }

    private Set<RowState> getRowState(int row) {
        if (this.getEnabledRowsModel().isIncluded(row)) {
            if (row == this.getSelectedIndex()) {
                if (row == this.getExpandedIndex()) {
                    return STATE_ENABLED_SELECTED_AND_EXPANDED;
                }
                return STATE_ENABLED_SELECTED;
            }
            if (row == this.getExpandedIndex()) {
                return STATE_ENABLED_EXPANDED;
            }
            return STATE_ENABLED;
        }
        if (row == this.getSelectedIndex()) {
            if (row == this.getExpandedIndex()) {
                return STATE_SELECTED_AND_EXPANDED;
            }
            return STATE_SELECTED;
        }
        if (row == this.getExpandedIndex()) {
            return STATE_EXPANDED;
        }
        return STATE_NONE;
    }

    private void updateRowState(int row) {
        this.updateRowState(row, this.getRowState(row));
    }

    private void updateRowState(int row, Set<RowState> rowState) {
        if (this.componentsCreated) {
            int offset = this.expandedIndex == -1 ? 1 : 2;
            int componentIndex = offset + row * this.columns.size();
            for (Column<T> column : this.columns) {
                T value = this.type.cast(this.model.getElementAt(row));
                column.updateComponentState(this.getComponent(componentIndex++), value, rowState);
            }
        }
    }

    @Override
    public synchronized void addComponentListener(ComponentListener l) {
        if (l.getClass().getName().contains("AncestorNotifier")) {
            return;
        }
        super.addComponentListener(l);
    }

    public Component getComponent(int row, Column<T> column) {
        int columnIndex = this.columns.indexOf(column);
        Preconditions.checkArgument(columnIndex >= 0);
        int componentIndex = this.getComponentOffset() + row * this.columns.size() + columnIndex;
        return this.getComponent(componentIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetColumnValues(Column<T> column) {
        if (!this.componentsCreated) {
            return;
        }
        int columnIndex = this.columns.indexOf(column);
        Preconditions.checkArgument(columnIndex >= 0);
        DelayedUI.instance().enableDelay();
        try {
            for (int i = 0; i < this.model.getSize(); ++i) {
                int componentIndex = this.getComponentOffset() + i * this.columns.size() + columnIndex;
                Component component = this.getComponent(componentIndex);
                T value = this.type.cast(this.model.getElementAt(i));
                column.updateComponentValue(component, value);
            }
        }
        finally {
            DelayedUI.instance().liftDelay();
        }
    }

    private int getComponentOffset() {
        int offset = this.expandedIndex == -1 ? 1 : 2;
        return offset;
    }

    public Component getFocusableComponentAfterTable() {
        return this.focusableComponentAfterTable;
    }

    public void setFocusableComponentAfterTable(Component focusableComponentAfterTable) {
        this.focusableComponentAfterTable = focusableComponentAfterTable;
    }

    public Component getFocusableComponentBeforeTable() {
        return this.focusableComponentBeforeTable;
    }

    public void setFocusableComponentBeforeTable(Component focusableComponentBeforeTable) {
        this.focusableComponentBeforeTable = focusableComponentBeforeTable;
    }

    public JComponent getExpandedRowComponent() {
        return this.expandedRowComponent;
    }

    private int getContextRows() {
        return 3;
    }

    private class ModelEvents
    implements ListDataListener {
        private ModelEvents() {
        }

        @Override
        public void contentsChanged(ListDataEvent event) {
            ExpandableTable.this.createComponents();
            int offset = ExpandableTable.this.getComponentOffset();
            int componentIndex = offset + event.getIndex0() * ExpandableTable.this.columns.size();
            for (int row = event.getIndex0(); row <= event.getIndex1(); ++row) {
                Object value = ExpandableTable.this.type.cast(ExpandableTable.this.model.getElementAt(row));
                for (Column column : ExpandableTable.this.columns) {
                    column.updateComponentValue(ExpandableTable.this.getComponent(componentIndex++), value);
                }
            }
            Rectangle bounds0 = ExpandableTable.this.getRowBounds(event.getIndex0());
            Rectangle bounds1 = ExpandableTable.this.getRowBounds(event.getIndex1());
            ExpandableTable.this.repaint(bounds0.x, bounds0.y, bounds0.width, bounds1.y + bounds1.height - bounds0.y);
        }

        @Override
        public void intervalAdded(ListDataEvent event) {
            Set<RowState> rowState;
            boolean allRowsAreEnabled = ExpandableTable.this.getEnabledRowsModel() instanceof AllRowsTableRowsModel;
            Set<RowState> set = rowState = allRowsAreEnabled ? STATE_ENABLED : STATE_NONE;
            if (ExpandableTable.this.componentsCreated) {
                int offset = ExpandableTable.this.getComponentOffset();
                int componentIndex = offset + event.getIndex0() * ExpandableTable.this.columns.size();
                for (int row = event.getIndex0(); row <= event.getIndex1(); ++row) {
                    Object value = ExpandableTable.this.type.cast(ExpandableTable.this.model.getElementAt(row));
                    for (Column column : ExpandableTable.this.columns) {
                        JComponent component = column.createComponent(value, rowState);
                        ExpandableTable.this.fontManager.applyTo(component);
                        ExpandableTable.this.add((Component)component, componentIndex++);
                    }
                }
            }
            ExpandableTable.this.getEnabledRowsModel().intervalAdded(event.getIndex0(), event.getIndex1());
            if (ExpandableTable.this.selectedIndex != -1 && ExpandableTable.this.selectedIndex >= event.getIndex0()) {
                ExpandableTable.this.setSelectedIndex(ExpandableTable.this.selectedIndex + (event.getIndex1() - event.getIndex0() + 1), false, true);
            }
            if (ExpandableTable.this.expandedIndex != -1 && ExpandableTable.this.expandedIndex >= event.getIndex0()) {
                ExpandableTable.this.setExpandedIndex(ExpandableTable.this.expandedIndex + (event.getIndex1() - event.getIndex0() + 1), false);
            }
            this.redrawFromStartOfEvent(event);
        }

        @Override
        public void intervalRemoved(ListDataEvent event) {
            if (ExpandableTable.this.componentsCreated) {
                int offset = ExpandableTable.this.getComponentOffset();
                int componentIndex = offset + event.getIndex0() * ExpandableTable.this.columns.size();
                for (int row = event.getIndex0(); row <= event.getIndex1(); ++row) {
                    for (Column ignored : ExpandableTable.this.columns) {
                        ExpandableTable.this.remove(componentIndex);
                    }
                }
            }
            if (ExpandableTable.this.expandedIndex != -1 && ExpandableTable.this.expandedIndex >= event.getIndex0()) {
                ExpandableTable.this.setExpandedIndex(this.adjustRowForDeletion(event, ExpandableTable.this.expandedIndex), false);
            }
            if (ExpandableTable.this.selectedIndex != -1 && ExpandableTable.this.selectedIndex >= event.getIndex0()) {
                ExpandableTable.this.setSelectedIndex(this.adjustRowForDeletion(event, ExpandableTable.this.selectedIndex), false, true);
            }
            ExpandableTable.this.getEnabledRowsModel().intervalRemoved(event.getIndex0(), event.getIndex1());
            this.redrawFromStartOfEvent(event);
        }

        private void redrawFromStartOfEvent(ListDataEvent event) {
            int row = event.getIndex0();
            ExpandableTable.this.repaintStartingAt(row);
        }

        private int adjustRowForDeletion(ListDataEvent event, int row) {
            if (row <= event.getIndex1()) {
                return -1;
            }
            return row - (event.getIndex1() - event.getIndex0() + 1);
        }
    }

    private class MouseEvents
    extends MouseAdapter {
        private MouseEvents() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int row = ExpandableTable.this.getRow(e.getY());
            if ((e.getModifiersEx() & 0x100) != 0 && row == ExpandableTable.this.selectedIndex) {
                ExpandableTable.this.setSelectedIndex(-1);
            } else {
                ExpandableTable.this.setSelectedIndex(row);
            }
            ExpandableTable.this.requestFocusInWindow();
        }
    }

    private class KeyEvents
    extends KeyAdapter {
        private KeyEvents() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            switch (e.getKeyCode()) {
                case 38: {
                    if (ExpandableTable.this.selectedIndex > 0) {
                        ExpandableTable.this.setSelectedIndex(ExpandableTable.this.selectedIndex - 1, true, false);
                        ExpandableTable.this.scrollRectToVisible(ExpandableTable.this.getRowBounds(Math.max(0, ExpandableTable.this.selectedIndex - ExpandableTable.this.getContextRows()), ExpandableTable.this.selectedIndex - 1));
                    } else {
                        ExpandableTable.this.setSelectedIndex(0);
                    }
                    e.consume();
                    break;
                }
                case 40: {
                    if (ExpandableTable.this.selectedIndex != -1) {
                        int maxRow = ExpandableTable.this.model.getSize() - 1;
                        int newRow = Math.min(maxRow, ExpandableTable.this.selectedIndex + 1);
                        ExpandableTable.this.setSelectedIndex(newRow, true, false);
                        ExpandableTable.this.scrollRectToVisible(ExpandableTable.this.getRowBounds(newRow, Math.min(maxRow, ExpandableTable.this.selectedIndex + ExpandableTable.this.getContextRows())));
                    } else {
                        ExpandableTable.this.setSelectedIndex(0);
                    }
                    e.consume();
                    break;
                }
                case 33: {
                    ExpandableTable.this.setSelectedIndex(Math.max(0, ExpandableTable.this.selectedIndex - ExpandableTable.this.getVerticalBlockIncrement()));
                    e.consume();
                    break;
                }
                case 34: {
                    ExpandableTable.this.setSelectedIndex(Math.min(ExpandableTable.this.model.getSize() - 1, ExpandableTable.this.selectedIndex + ExpandableTable.this.getVerticalBlockIncrement()));
                    e.consume();
                    break;
                }
                case 36: {
                    ExpandableTable.this.setSelectedIndex(0);
                    e.consume();
                    break;
                }
                case 35: {
                    ExpandableTable.this.setSelectedIndex(ExpandableTable.this.model.getSize() - 1);
                    e.consume();
                    break;
                }
                case 39: {
                    if (ExpandableTable.this.selectedIndex == -1 || !ExpandableTable.this.hasExpandColumn || !ExpandableTable.this.getEnabledRowsModel().isIncluded(ExpandableTable.this.selectedIndex)) break;
                    ExpandableTable.this.setExpandedIndex(ExpandableTable.this.selectedIndex);
                    e.consume();
                    break;
                }
                case 37: {
                    if (ExpandableTable.this.selectedIndex == -1 || ExpandableTable.this.expandedIndex != ExpandableTable.this.selectedIndex || !ExpandableTable.this.hasExpandColumn) break;
                    ExpandableTable.this.setExpandedIndex(-1);
                    e.consume();
                }
            }
        }
    }

    private class LayoutImpl
    implements LayoutManager {
        private LayoutImpl() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void layoutContainer(Container container) {
            ExpandableTable.this.createComponents();
            Insets insets = UIManager.getInsets("TableHeader.cellMargins");
            if (insets == null) {
                insets = new Insets(0, 0, 0, 0);
            }
            int leftInset = ExpandableTable.this.fontManager.scale(insets.left);
            int widthInset = leftInset + ExpandableTable.this.fontManager.scale(insets.right);
            ExpandableTable.this.focusStartHoneypot.setBounds(-100, -100, 1, 1);
            ExpandableTable.this.focusEndHoneypot.setBounds(-100, -100, 1, 1);
            int expandedRowViewCount = ExpandableTable.this.expandedRowComponent == null ? 0 : 1;
            int focusHoneypotCount = 2;
            int expectedComponentCount = (ExpandableTable.this.model == null ? 0 : ExpandableTable.this.model.getSize()) * ExpandableTable.this.columns.size() + expandedRowViewCount + focusHoneypotCount;
            Preconditions.checkState(ExpandableTable.this.getComponentCount() == expectedComponentCount, "Invalid component count.  Expected %s, was %s", expectedComponentCount, ExpandableTable.this.getComponentCount());
            ExpandableTable.this.columnWidths = new int[ExpandableTable.this.columns.size()];
            int totalFixedWidth = 0;
            if (ExpandableTable.this.showVerticalGridLines) {
                totalFixedWidth += ExpandableTable.this.columns.size() - 1;
            }
            float totalWeightedWidth = 0.0f;
            for (Column column : ExpandableTable.this.columns) {
                ColumnLayout columnLayout = column.getWidth();
                if (columnLayout.isFixed) {
                    totalFixedWidth += columnLayout.fixedWidth(ExpandableTable.this.fontManager) + widthInset;
                    continue;
                }
                totalWeightedWidth += columnLayout.widthWeight;
            }
            int columnIndex = 0;
            for (Column column : ExpandableTable.this.columns) {
                ColumnLayout width = column.getWidth();
                int pixels = width.isFixed ? width.fixedWidth(ExpandableTable.this.fontManager) + widthInset : (int)((float)(container.getWidth() - totalFixedWidth) * (width.widthWeight / totalWeightedWidth));
                if (ExpandableTable.this.tableHeader != null) {
                    int columnHeaderWidth = pixels;
                    ExpandableTable.this.tableHeader.getColumnModel().getColumn(columnIndex).setWidth(columnHeaderWidth);
                }
                ExpandableTable.this.columnWidths[columnIndex++] = pixels;
            }
            if (ExpandableTable.this.model != null) {
                boolean bl = false;
                boolean bl2 = false;
                for (int componentOffset = expandedRowViewCount + 1; componentOffset < ExpandableTable.this.getComponentCount() - 1; componentOffset += ExpandableTable.this.columns.size()) {
                    void var12_20;
                    int xPosition = 0;
                    for (int column = 0; column < ExpandableTable.this.columns.size(); ++column) {
                        int width = ExpandableTable.this.columnWidths[column];
                        Component cellComponent = ExpandableTable.this.getComponent(componentOffset + column);
                        if (ExpandableTable.this.columns.get(column).sizeComponentsToFit()) {
                            Dimension maxSize = cellComponent.getPreferredSize();
                            cellComponent.setBounds(xPosition + leftInset, (int)var11_15, Math.min(width - widthInset, maxSize.width), ExpandableTable.this.lineHeight);
                        } else {
                            cellComponent.setBounds(xPosition + leftInset, (int)var11_15, width - widthInset, ExpandableTable.this.lineHeight);
                        }
                        xPosition += width;
                        if (!ExpandableTable.this.showVerticalGridLines) continue;
                        ++xPosition;
                    }
                    var11_15 += ExpandableTable.this.lineHeight;
                    if (ExpandableTable.this.expandedRowComponent != null && var12_20 == ExpandableTable.this.expandedIndex) {
                        var11_15 += ExpandableTable.this.expandedRowView.getHeight();
                    }
                    ++var12_20;
                }
            }
            if (ExpandableTable.this.expandedRowComponent != null) {
                if (ExpandableTable.this.expandedIndex == -1) {
                    ExpandableTable.this.expandedRowComponent.setVisible(false);
                } else {
                    ExpandableTable.this.expandedRowComponent.setBounds(leftInset, ExpandableTable.this.lineHeight * (ExpandableTable.this.expandedIndex + 1), container.getWidth() - widthInset, ExpandableTable.this.expandedRowView.getHeight());
                    ExpandableTable.this.expandedRowComponent.setVisible(true);
                }
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return new Dimension(10, 10);
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            int rowCount = ExpandableTable.this.model == null ? 0 : ExpandableTable.this.model.getSize();
            int height = rowCount * ExpandableTable.this.lineHeight;
            if (ExpandableTable.this.expandedRowComponent != null && ExpandableTable.this.expandedIndex != -1) {
                height += ExpandableTable.this.expandedRowView.getHeight();
            }
            return new Dimension(200, height);
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }
    }

    class ExpandableTableFocusTraversalPolicy
    extends ContainerOrderFocusTraversalPolicy {
        private Component nextComponent;
        private Component previousComponent;

        ExpandableTableFocusTraversalPolicy() {
        }

        @Override
        public Component getComponentAfter(Container container, Component component) {
            Component componentAfter = super.getComponentAfter(container, component);
            if (componentAfter == ExpandableTable.this.focusStartHoneypot) {
                componentAfter = super.getComponentAfter(container, ExpandableTable.this.focusStartHoneypot);
            }
            if (componentAfter == ExpandableTable.this.focusEndHoneypot) {
                componentAfter = this.findComponentAfterTable(container);
            }
            return componentAfter;
        }

        @Override
        public Component getComponentBefore(Container container, Component component) {
            if (component == container) {
                return this.findComponentBeforeTable(container);
            }
            Component componentBefore = super.getComponentBefore(container, component);
            if (componentBefore == ExpandableTable.this.focusStartHoneypot) {
                componentBefore = container;
            }
            return componentBefore;
        }

        @Override
        public Component getDefaultComponent(Container container) {
            Component defaultComponent;
            boolean isBackwards = false;
            StackTraceElement[] stackTrace = new Throwable().getStackTrace();
            if (stackTrace.length > 3 && "getComponentBefore".equals(stackTrace[2].getMethodName())) {
                isBackwards = true;
            }
            Component component = defaultComponent = isBackwards ? this.getLastComponent(container) : super.getDefaultComponent(container);
            if (defaultComponent == ExpandableTable.this.focusStartHoneypot || defaultComponent == ExpandableTable.this.focusEndHoneypot || !SwingUtilities.isDescendingFrom(defaultComponent, ExpandableTable.this)) {
                if (isBackwards) {
                    defaultComponent = this.getComponentBefore(container, ExpandableTable.this.focusEndHoneypot);
                    if (defaultComponent == ExpandableTable.this.focusStartHoneypot) {
                        defaultComponent = container;
                    }
                } else {
                    defaultComponent = this.getComponentAfter(container, ExpandableTable.this.focusStartHoneypot);
                    if (defaultComponent == ExpandableTable.this.focusEndHoneypot) {
                        defaultComponent = container;
                    }
                }
            }
            return defaultComponent;
        }

        @Override
        public Component getFirstComponent(Container container) {
            Component firstComponent = this.getComponentAfter(container, ExpandableTable.this.focusStartHoneypot);
            if (firstComponent == container) {
                firstComponent = this.findComponentAfterTable(container);
            }
            return firstComponent;
        }

        Component findComponentAfterTable(Container container) {
            if (ExpandableTable.this.getFocusableComponentAfterTable() != null) {
                return ExpandableTable.this.getFocusableComponentAfterTable();
            }
            if (this.nextComponent == null) {
                Container rootAncestor = container.getParent().getFocusCycleRootAncestor();
                container.setFocusCycleRoot(false);
                ExpandableTable.this.focusEndHoneypot.setFocusable(false);
                ExpandableTable.this.focusStartHoneypot.setFocusable(false);
                this.nextComponent = rootAncestor.getFocusTraversalPolicy().getComponentAfter(rootAncestor, container);
                ExpandableTable.this.focusEndHoneypot.setFocusable(true);
                ExpandableTable.this.focusStartHoneypot.setFocusable(true);
                container.setFocusCycleRoot(true);
            }
            Component afterComponent = this.nextComponent;
            return afterComponent;
        }

        Component findComponentBeforeTable(Container container) {
            if (ExpandableTable.this.getFocusableComponentBeforeTable() != null) {
                return ExpandableTable.this.getFocusableComponentBeforeTable();
            }
            if (this.previousComponent == null) {
                Container rootAncestor = container.getParent().getFocusCycleRootAncestor();
                container.setFocusCycleRoot(false);
                ExpandableTable.this.focusEndHoneypot.setFocusable(false);
                ExpandableTable.this.focusStartHoneypot.setFocusable(false);
                this.previousComponent = rootAncestor.getFocusTraversalPolicy().getComponentBefore(rootAncestor, container);
                ExpandableTable.this.focusEndHoneypot.setFocusable(true);
                ExpandableTable.this.focusStartHoneypot.setFocusable(true);
                container.setFocusCycleRoot(true);
            }
            Component beforeComponent = this.previousComponent;
            return beforeComponent;
        }

        @Override
        public Component getLastComponent(Container container) {
            Component lastComponent = this.getComponentBefore(container, ExpandableTable.this.focusEndHoneypot);
            return lastComponent;
        }

        @Override
        protected boolean accept(Component candidate) {
            InputMap whenFocusedMap;
            if (!candidate.isEnabled() || !candidate.isFocusable()) {
                return false;
            }
            if (candidate instanceof JComboBox) {
                return ((JComboBox)candidate).getUI().isFocusTraversable((JComboBox)candidate);
            }
            if (candidate instanceof JComponent && ((whenFocusedMap = ((JComponent)candidate).getInputMap(0)) == null || whenFocusedMap.allKeys() == null || whenFocusedMap.allKeys().length == 0)) {
                return false;
            }
            return super.accept(candidate);
        }
    }

    class TableFocusTracker
    extends FocusTracker {
        protected TableFocusTracker() {
            super(ExpandableTable.this);
        }

        @Override
        protected boolean includeTextComponents() {
            return true;
        }

        @Override
        protected void focusGained(Component child) {
            if (ExpandableTable.this.expandedRowComponent != null && SwingUtilities.isDescendingFrom(child, ExpandableTable.this.expandedRowComponent)) {
                Rectangle expandedRowBounds = ExpandableTable.this.expandedRowComponent.getBounds();
                if (ExpandableTable.this.selectedIndex == ExpandableTable.this.expandedIndex) {
                    expandedRowBounds = expandedRowBounds.union(ExpandableTable.this.getRowBounds(ExpandableTable.this.selectedIndex));
                }
                ExpandableTable.this.scrollRectToVisible(expandedRowBounds);
            } else if (child == ExpandableTable.this) {
                if (ExpandableTable.this.selectedIndex != -1) {
                    Rectangle rowBounds = ExpandableTable.this.getRowBounds(ExpandableTable.this.selectedIndex);
                    if (ExpandableTable.this.selectedIndex == ExpandableTable.this.expandedIndex) {
                        Rectangle expandedRowBounds = ExpandableTable.this.expandedRowComponent.getBounds();
                        rowBounds = rowBounds.union(expandedRowBounds);
                    }
                    ExpandableTable.this.scrollRectToVisible(rowBounds);
                }
            } else {
                Rectangle bounds = child.getBounds();
                if (child.getParent() != ExpandableTable.this) {
                    bounds = SwingUtilities.convertRectangle(child.getParent(), bounds, ExpandableTable.this);
                }
                ExpandableTable.this.scrollRectToVisible(bounds);
            }
        }

        @Override
        protected void focusLost(Component child) {
        }
    }

    public static interface Column<T> {
        public JComponent createComponent(T var1, Set<RowState> var2);

        public ColumnLayout getWidth();

        public boolean sizeComponentsToFit();

        public void updateComponentValue(Component var1, T var2);

        public void updateComponentState(Component var1, T var2, Set<RowState> var3);

        public String getName();
    }

    public static interface DetailView<T> {
        public JComponent createComponent(T var1);

        public void onClose(JComponent var1);

        public int getHeight();
    }

    class MoveToNextExpandedRow
    extends AbstractAction {
        private final boolean next;

        MoveToNextExpandedRow(boolean next) {
            this.next = next;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ExpandableTable.this.expandedIndex == -1 || ExpandableTable.this.expandedRowComponent == null) {
                return;
            }
            int newExpandedIndex = ExpandableTable.this.expandedIndex + (this.next ? 1 : -1);
            if (newExpandedIndex < 0 || newExpandedIndex >= ExpandableTable.this.getModel().getSize()) {
                return;
            }
            Component focusOwner = FocusManager.getCurrentManager().getFocusOwner();
            if (focusOwner == null) {
                return;
            }
            LinkedList<Integer> childIndices = new LinkedList<Integer>();
            while (focusOwner != ExpandableTable.this.expandedRowComponent) {
                if (focusOwner == null) {
                    return;
                }
                Container parent = focusOwner.getParent();
                for (int i = 0; i < parent.getComponentCount(); ++i) {
                    if (focusOwner != parent.getComponent(i)) continue;
                    childIndices.add(0, i);
                    break;
                }
                focusOwner = parent;
            }
            if (childIndices.isEmpty()) {
                return;
            }
            ExpandableTable.this.setExpandedIndex(newExpandedIndex);
            Component component = ExpandableTable.this.expandedRowComponent;
            Iterator i = childIndices.iterator();
            while (i.hasNext()) {
                int childIndex = (Integer)i.next();
                if (!(component instanceof Container)) {
                    return;
                }
                Container parent = component;
                if (childIndex >= parent.getComponentCount()) {
                    return;
                }
                component = parent.getComponent(childIndex);
            }
            JComponent finalComponent = component;
            SwingUtilities.invokeLater(() -> finalComponent.requestFocusInWindow());
        }
    }

    public static enum RowState {
        ENABLED,
        EXPANDED,
        SELECTED;

    }

    public static class ColumnLayout {
        private final boolean isFixed;
        private final int widthFixed;
        private final float widthWeight;
        private final boolean scaling;

        public static ColumnLayout fixedWidth(int pixels) {
            return new ColumnLayout(pixels, 0.0f, true, false);
        }

        public static ColumnLayout scalableFixedWidth(int pixels) {
            return new ColumnLayout(pixels, 0.0f, true, true);
        }

        public static ColumnLayout weightedWidth(float weight) {
            return new ColumnLayout(0, weight, false, false);
        }

        int fixedWidth(FontManager fontManager) {
            return this.scaling ? fontManager.scale(this.widthFixed) : this.widthFixed;
        }

        private ColumnLayout(int widthAbsolute, float widthWeight, boolean isAbsolute, boolean scaling) {
            this.widthFixed = widthAbsolute;
            this.widthWeight = widthWeight;
            this.isFixed = isAbsolute;
            this.scaling = scaling;
        }
    }
}

