/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.components.table;

import com.scythebill.birdlist.ui.components.table.ExpandableTable;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class ExpandColumn<T>
implements ExpandableTable.Column<T> {
    private final MouseListener listener;
    private ExpandableTable.ColumnLayout width = ExpandableTable.ColumnLayout.fixedWidth(UIManager.getIcon("Tree.expandedIcon").getIconWidth() + 4);
    private final ExpandableTable<T> table;
    private final String title;

    public ExpandColumn(ExpandableTable<T> table, String title) {
        this.table = table;
        this.title = title;
        this.listener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point tablePoint = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), ExpandColumn.this.table);
                int row = ExpandColumn.this.table.getRow(tablePoint.y);
                if (ExpandColumn.this.table.getExpandedIndex() == row) {
                    row = -1;
                }
                ExpandColumn.this.table.setExpandedIndex(row);
                e.consume();
            }
        };
    }

    @Override
    public JComponent createComponent(T value, Set<ExpandableTable.RowState> states) {
        JLabel label = new JLabel();
        label.setBorder(new EmptyBorder(0, 2, 0, 2));
        label.setOpaque(false);
        label.addMouseListener(this.listener);
        this.updateComponentState(label, value, states);
        if (this.title != null) {
            label.setToolTipText(this.title);
        }
        return label;
    }

    @Override
    public ExpandableTable.ColumnLayout getWidth() {
        return this.width;
    }

    @Override
    public boolean sizeComponentsToFit() {
        return false;
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public void updateComponentValue(Component component, T value) {
    }

    @Override
    public void updateComponentState(Component component, T value, Set<ExpandableTable.RowState> states) {
        Icon icon = UIManager.getIcon(states.contains((Object)ExpandableTable.RowState.EXPANDED) ? "Tree.expandedIcon" : "Tree.collapsedIcon");
        ((JLabel)component).setIcon(icon);
        component.setVisible(states.contains((Object)ExpandableTable.RowState.ENABLED));
    }
}

