/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.components.table;

import com.scythebill.birdlist.ui.components.table.ExpandableTable;
import com.scythebill.birdlist.ui.messages.Messages;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public abstract class DeleteColumn<T>
implements ExpandableTable.Column<T> {
    private final MouseListener listener;
    private ExpandableTable.ColumnLayout width;
    private final ExpandableTable<T> table;

    public static JLabel createDeleteLabel() {
        JLabel label = new JLabel();
        label.setIcon(DeleteColumn.deleteIcon());
        label.setOpaque(false);
        label.setToolTipText(Messages.getMessage(Messages.Name.DELETE_ACTION));
        return label;
    }

    public static ImageIcon deleteIcon() {
        return new ImageIcon(DeleteColumn.class.getResource("action_delete.png"));
    }

    public DeleteColumn(ExpandableTable.ColumnLayout width, ExpandableTable<T> table) {
        this.width = width;
        this.table = table;
        this.listener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point tablePoint = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), DeleteColumn.this.table);
                int row = DeleteColumn.this.table.getRow(tablePoint.y);
                DeleteColumn.this.deleteRow(row);
                e.consume();
            }
        };
    }

    @Override
    public JComponent createComponent(T value, Set<ExpandableTable.RowState> states) {
        JLabel label = DeleteColumn.createDeleteLabel();
        label.addMouseListener(this.listener);
        return label;
    }

    @Override
    public ExpandableTable.ColumnLayout getWidth() {
        return this.width;
    }

    @Override
    public boolean sizeComponentsToFit() {
        return false;
    }

    @Override
    public void updateComponentValue(Component component, T value) {
    }

    @Override
    public void updateComponentState(Component component, T value, Set<ExpandableTable.RowState> states) {
    }

    protected abstract void deleteRow(int var1);
}

