/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.components.table;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import javax.swing.Timer;

public class DelayedUI {
    private static final int COMPONENTS_TO_CREATE_AT_A_TIME = 100;
    private static final int UI_CREATION_DELAY = 100;
    private static final DelayedUI instance = new DelayedUI();
    private final AtomicBoolean delay = new AtomicBoolean();
    private final AtomicInteger initialAllowance = new AtomicInteger();
    private final BlockingQueue<JComponent> delayedComponents = new LinkedBlockingQueue<JComponent>();
    private Timer timer;

    public static DelayedUI instance() {
        return instance;
    }

    private DelayedUI() {
    }

    public void enableDelay() {
        if (!this.delay.compareAndSet(false, true)) {
            throw new IllegalStateException("Already delayed");
        }
        this.initialAllowance.set(100);
    }

    public void liftDelay() {
        if (!this.delay.compareAndSet(true, false)) {
            throw new IllegalStateException("Was not delayed");
        }
    }

    public boolean requestUICreation(JComponent component) {
        if (this.delay.get()) {
            if (this.initialAllowance.getAndDecrement() > 0) {
                return true;
            }
            this.delayedComponents.add(component);
            this.startTimer();
            return false;
        }
        return true;
    }

    private void startTimer() {
        if (this.timer == null) {
            this.timer = new Timer(100, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ArrayList componentsToCreate = new ArrayList(100);
                    DelayedUI.this.delayedComponents.drainTo(componentsToCreate, 100);
                    if (DelayedUI.this.delayedComponents.isEmpty()) {
                        DelayedUI.this.timer.stop();
                        DelayedUI.this.timer = null;
                    }
                    for (JComponent component : componentsToCreate) {
                        component.updateUI();
                    }
                }
            });
            this.timer.setDelay(0);
            this.timer.setRepeats(true);
            this.timer.start();
        }
    }
}

