/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.components.photos;

import com.formdev.flatlaf.FlatLightLaf;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Resources;
import com.scythebill.birdlist.model.sighting.Photo;
import com.scythebill.birdlist.ui.components.ChipsTextPanel;
import com.scythebill.birdlist.ui.components.links.LinkDrops;
import com.scythebill.birdlist.ui.components.links.LinksListPanel;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.fonts.FontPreferences;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.FilePreferences;
import com.scythebill.birdlist.ui.util.FileDialogs;
import com.scythebill.birdlist.ui.util.Icons;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class PhotosListPanel
extends LinksListPanel<Photo> {
    public static void main(String[] args) {
        FlatLightLaf.setup();
        JFrame frame = new JFrame();
        FontManager fontManager = new FontManager(new FontPreferences());
        FileDialogs fileDialogs = new FileDialogs(new FilePreferences(), new FileDialogs.Flags(){

            @Override
            public boolean useNativeSaveDialog() {
                return true;
            }

            @Override
            public boolean useNativeOpenDialog() {
                return true;
            }
        }, null);
        PhotosListPanel photosListPanel = new PhotosListPanel(fontManager, fileDialogs, null);
        photosListPanel.setLinks(ImmutableList.of(new Photo(new File("/Users/awiner/Desktop/SokokeScopsOwl.jpg")), new Photo(URI.create("http://ibc.lynxeds.com/files/imagecache/photo_940/pictures/DSC_8592__675x900_Sokoke_Scops-owl_z_podpisem.jpg"))));
        photosListPanel.getDirty().addDirtyListener(e -> SwingUtilities.invokeLater(() -> frame.pack()));
        fontManager.applyTo(photosListPanel);
        frame.setContentPane(photosListPanel);
        frame.setVisible(true);
        frame.pack();
        frame.setSize(250, 500);
    }

    public PhotosListPanel(FontManager fontManager, FileDialogs fileDialogs, LinksListPanel.LinkClickedListener<Photo> photoClickedListener) {
        super(fontManager, fileDialogs, photoClickedListener);
    }

    @Override
    protected Photo newLink(URI uri) {
        return new Photo(uri);
    }

    @Override
    protected Photo newLink(File file) {
        return new Photo(file);
    }

    @Override
    protected ChipsTextPanel<Photo> newChipsTextPanel() {
        ChipsTextPanel<Photo> panel = super.newChipsTextPanel();
        if (this.withFavorite()) {
            Icon favoriteOff = Icons.getWhiteIconIfDark(this, new ImageIcon(Resources.getResource("com/scythebill/birdlist/ui/icons/unfilled_star.png")));
            Icon favoriteOn = Icons.getWhiteIconIfDark(this, new ImageIcon(Resources.getResource("com/scythebill/birdlist/ui/icons/filled_star.png")));
            panel.addToggleFeature(favoriteOff, favoriteOn, Photo::isFavorite, Messages.Name.SET_AS_FAVORITE_FORMAT, Messages.Name.REMOVE_AS_FAVORITE_FORMAT);
            panel.addChipToggledListener(new ChipsTextPanel.ChipToggledListener<Photo>(){

                @Override
                public void chipToggled(Photo photo, boolean newValue) {
                    photo.setFavorite(newValue);
                    PhotosListPanel.this.dirty.setDirty(true);
                }
            });
        }
        if (this.withDrag()) {
            panel.addDragFeature(new GripIcon(), photo -> new Transferable(){
                final /* synthetic */ Photo val$photo;
                {
                    this.val$photo = photo;
                }

                @Override
                public boolean isDataFlavorSupported(DataFlavor flavor) {
                    return flavor.match(LinkDrops.URI_LIST_FLAVOR);
                }

                @Override
                public DataFlavor[] getTransferDataFlavors() {
                    return new DataFlavor[]{LinkDrops.URI_LIST_FLAVOR};
                }

                @Override
                public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                    if (!flavor.match(LinkDrops.URI_LIST_FLAVOR)) {
                        throw new UnsupportedFlavorException(flavor);
                    }
                    return this.val$photo.getUri().toASCIIString();
                }
            });
        }
        return panel;
    }

    protected boolean withFavorite() {
        return true;
    }

    protected boolean withDrag() {
        return false;
    }

    @Override
    protected Messages.Name dragLinkName() {
        return Messages.Name.DRAG_PHOTO_OR_CLICK;
    }

    @Override
    protected Messages.Name chooseLinkName() {
        return Messages.Name.CHOOSE_A_PHOTO;
    }

    @Override
    protected Messages.Name linkFileName() {
        return Messages.Name.IMAGE_FILE;
    }

    static class GripIcon
    implements Icon {
        private int gripDotCount = UIManager.getInt("SplitPaneDivider.gripDotCount");
        private int gripDotSize = UIManager.getInt("SplitPaneDivider.gripDotSize");
        private int gripGap = UIManager.getInt("SplitPaneDivider.gripGap");
        private static final int WIDTH = 11;
        private static final int HEIGHT = 22;

        GripIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(UIManager.getColor("ScrollBar.track"));
            g.fillRect(x, y, 11, 22);
            Object[] oldRenderingHints = FlatUIUtils.setRenderingHints(g);
            g.setColor(UIManager.getColor("SplitPaneDivider.gripColor"));
            FlatUIUtils.resetRenderingHints(g, oldRenderingHints);
            FlatUIUtils.paintGrip(g, x, y, 11, 22, false, this.gripDotCount, this.gripDotSize, this.gripGap, true);
        }

        @Override
        public int getIconWidth() {
            return 11;
        }

        @Override
        public int getIconHeight() {
            return 22;
        }
    }

    public static interface PhotoClickedListener {
        public void photoClicked(Photo var1);

        public boolean isSupported(Photo var1);
    }
}

